/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.util;

import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.util.Environment;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ConfigClass {
    private static final Logger logger = Logger.getLogger(ConfigClass.class);
    private static ConfigClass instance;
    public static final String LINUX_FILE_PATH = "/usr/bin/serverConfig.properties";
    public static final String WIN_FILE_PATH = "serverConfig.properties";
    public static String file_path;

    private ConfigClass() {
        file_path = Environment.getEnvironment() == 1 ? WIN_FILE_PATH : (Environment.getEnvironment() == 2 ? LINUX_FILE_PATH : WIN_FILE_PATH);
        logger.debug("file_path of properties= " + file_path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConfigClass getInstance() {
        if (instance != null) return instance;
        Class<ConfigClass> clazz = ConfigClass.class;
        synchronized (ConfigClass.class) {
            instance = new ConfigClass();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readConfigName(String para_name) {
        FileInputStream input = null;
        Properties prop = null;
        try {
            input = new FileInputStream(file_path);
            prop = new Properties();
            prop.load(input);
            if (prop.getProperty(para_name) != null) {
                String string = prop.getProperty(para_name);
                return string;
            }
            logger.error("Property not found in Config file:>>" + para_name);
            FileBasedLogger.error("Application", "Property not found in Config file:>>" + para_name, "system");
            String string = null;
            return string;
        }
        catch (Exception e) {
            logger.error("ConfigClass", e);
            FileBasedLogger.error("Application", "Erroe while reading config class : " + e.getLocalizedMessage(), "system");
        }
        finally {
            try {
                ((InputStream)input).close();
                prop.clear();
            }
            catch (IOException e) {
                logger.error("ConfigClass", e);
                FileBasedLogger.error("Application", "Erroe while reading config class : " + e.getLocalizedMessage(), "system");
            }
        }
        return null;
    }
}

