/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.user_token;

import com.tas.wp500.fileLogSetting.FileBasedLogger;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Date;
import javax.crypto.spec.SecretKeySpec;

public class TokenManager {
    private static final Key SECRET_KEY = TokenManager.generateKey();
    private static final long EXPIRATION_TIME = 86400000L;

    private static Key generateKey() {
        try {
            SecureRandom random = new SecureRandom();
            byte[] keyBytes = new byte[32];
            random.nextBytes(keyBytes);
            return new SecretKeySpec(keyBytes, SignatureAlgorithm.HS256.getJcaName());
        }
        catch (Exception e) {
            FileBasedLogger.error("Application", "Error while genrating key : " + e.getLocalizedMessage(), "system");
            throw new RuntimeException("Error generating secret key", e);
        }
    }

    public static String generateToken(String userId) {
        Date now = new Date();
        Date expiration = new Date(now.getTime() + 86400000L);
        return Jwts.builder().setSubject(userId + System.currentTimeMillis()).setIssuedAt(now).setExpiration(expiration).signWith(SECRET_KEY).compact();
    }

    public static String getUserIdFromToken(String token) {
        return ((Claims)Jwts.parserBuilder().setSigningKey(SECRET_KEY).build().parseClaimsJws(token).getBody()).getSubject();
    }

    public static boolean validateToken(String token) {
        try {
            Jwts.parserBuilder().setSigningKey(SECRET_KEY).build().parseClaimsJws(token);
            return true;
        }
        catch (JwtException e) {
            FileBasedLogger.error("Application", "Error while checking token : " + e.getLocalizedMessage(), "system");
            return false;
        }
    }
}

