/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.totpSetting;

import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.passwordSetting.PasswordPolicyDbOperation;
import com.tas.wp500.services.Service;
import com.tas.wp500.sql_lite_db.SQLiteConnector;
import com.tas.wp500.totpSetting.QRCodeGenerator;
import com.tas.wp500.user_token.TokenManager;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base32;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class TOTPAuthenticator {
    private static TOTPAuthenticator instance = null;
    private static Logger logger = Logger.getLogger(TOTPAuthenticator.class);

    public static TOTPAuthenticator getInstance() {
        if (instance == null) {
            instance = new TOTPAuthenticator();
        }
        return instance;
    }

    public JSONObject checkTotpAuthenticator(JSONObject json) {
        JSONObject resultObject = new JSONObject();
        String user = json.getString("user");
        try {
            int OTP_LENGTH = 6;
            int TIME_STEP = 30;
            JSONObject result2fa = QRCodeGenerator.getTOTPKeyByUsername(json, user);
            String totpUserKey = result2fa.getString("totp_key");
            String otp = json.getString("otp");
            boolean isValid = TOTPAuthenticator.validateOTP(totpUserKey, 30L, 6, otp);
            logger.debug(user + " : OTP Validation Result - " + isValid);
            if (isValid) {
                String token = TokenManager.generateToken(user);
                Service.USER_WISE_TOKEN.put(user, token);
                resultObject.put("status", "success");
                resultObject.put("session_timeout", PasswordPolicyDbOperation.getInstance().getSessionTimeout(SQLiteConnector.getConnection(), user));
                resultObject.put("msg", "OTP is valid.");
                resultObject.put("token", token);
                resultObject.put("token_status", "success");
                logger.info("OTP validation result for user: " + user + " -  is Valid.");
                FileBasedLogger.info("Security", "OTP validation result for user: " + user + " -  is Valid.", user);
            } else {
                resultObject.put("status", "fail");
                resultObject.put("msg", "OTP is invalid.");
                resultObject.put("token_status", "fail");
                logger.info("OTP validation result for user: " + user + " -  is Invalid.");
                FileBasedLogger.info("Security", "OTP validation result for user: " + user + " -  is InValid.", user);
            }
        }
        catch (JSONException e) {
            resultObject.put("status", "fail");
            resultObject.put("msg", "Error occurred while checking otp.");
        }
        catch (Exception e) {
            logger.error("Error occurred : ", e);
            FileBasedLogger.error("Security", "Error while validating 2fa otp :", user);
            resultObject.put("status", "fail");
            resultObject.put("msg", "Error occurred while checking otp.");
        }
        return resultObject;
    }

    public JSONObject testTotpAuthenticator(JSONObject json, String user) {
        JSONObject resultObject = new JSONObject();
        try {
            int OTP_LENGTH = 6;
            int TIME_STEP = 30;
            JSONObject result2fa = QRCodeGenerator.getTOTPKeyByUsername(json, user);
            String totpUserKey = result2fa.getString("totp_key");
            String otp = json.getString("otp");
            boolean isValid = TOTPAuthenticator.validateOTP(totpUserKey, 30L, 6, otp);
            if (isValid) {
                resultObject.put("status", "success");
                resultObject.put("msg", "OTP is valid.");
                logger.info("Test OTP is Valid.");
                FileBasedLogger.info("Security", "test OTP validation result for user: " + user + " -  is Valid.", user);
            } else {
                resultObject.put("status", "fail");
                resultObject.put("msg", "Test OTP is invalid.");
                resultObject.put("token_status", "fail");
                logger.warn("Test OTP is invalid.");
                FileBasedLogger.info("Security", "test OTP validation result for user: " + user + " -  is InValid.", user);
            }
        }
        catch (JSONException e) {
            resultObject.put("status", "fail");
            resultObject.put("msg", "Error occurred while checking otp.");
        }
        catch (Exception e) {
            logger.error("Error occurred : " + e);
            FileBasedLogger.error("Security", "Error while validating 2fa otp :", user);
            resultObject.put("status", "fail");
            resultObject.put("msg", "Error occurred while checking otp.");
        }
        return resultObject;
    }

    public static String generateOTP(String secretKey, long timeStep, int otpLength) {
        long currentTime = Instant.now().getEpochSecond();
        long timeCounter = currentTime / timeStep;
        Base32 base32 = new Base32();
        byte[] keyBytes = base32.decode(secretKey);
        SecretKeySpec keySpec = new SecretKeySpec(keyBytes, "HmacSHA1");
        try {
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(keySpec);
            byte[] timeCounterBytes = new byte[8];
            for (int i = 7; i >= 0; --i) {
                timeCounterBytes[i] = (byte)(timeCounter & 0xFFL);
                timeCounter >>= 8;
            }
            byte[] hash = mac.doFinal(timeCounterBytes);
            int offset = hash[hash.length - 1] & 0xF;
            int binary = (hash[offset] & 0x7F) << 24 | (hash[offset + 1] & 0xFF) << 16 | (hash[offset + 2] & 0xFF) << 8 | hash[offset + 3] & 0xFF;
            int otpValue = binary % (int)Math.pow(10.0, otpLength);
            String otp = Integer.toString(otpValue);
            while (otp.length() < otpLength) {
                otp = "0" + otp;
            }
            return otp;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean validateOTP(String secretKey, long timeStep, int otpLength, String userOTP) {
        try {
            String serverOTP = TOTPAuthenticator.generateOTP(secretKey, timeStep, otpLength);
            logger.debug("Server OTP : " + serverOTP + ", User OTP : " + userOTP);
            return serverOTP != null && serverOTP.equals(userOTP);
        }
        catch (Exception e) {
            logger.error("Error occurred during OTP validation : ", e);
            FileBasedLogger.error("Security", "Error occurred during OTP validation : " + e, "system'");
            return false;
        }
    }
}

