/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.totpSetting;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.security.Security;
import com.tas.wp500.sql_lite_db.SQLiteConnector;
import com.tas.wp500.totpSetting.Base32;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import javax.xml.bind.DatatypeConverter;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class QRCodeGenerator
extends Security {
    private static Logger logger = Logger.getLogger(QRCodeGenerator.class);
    private static QRCodeGenerator instance = null;
    static String qrCodeFilePath = "/usr/bin/qr_files/qrcode.png";
    static String qrCodeFolderPath = "/usr/bin/qr_files";

    public static QRCodeGenerator getInstance() {
        if (instance == null) {
            instance = new QRCodeGenerator();
        }
        return instance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JSONObject qrCodeGenerator(JSONObject json, String user) throws JSONException {
        JSONObject userResult;
        String userStatus;
        JSONObject resultObj = new JSONObject();
        File folder = new File(qrCodeFolderPath);
        if (!folder.exists()) {
            boolean bl = folder.mkdir();
        }
        if (!(userStatus = (userResult = QRCodeGenerator.updateUserSecretKey(json)).getString("status")).equalsIgnoreCase("success")) return userResult;
        JSONObject userSecretKey = QRCodeGenerator.getTOTPKeyByUsername(json, user);
        String userSecretKeyStatus = userSecretKey.getString("status");
        if (!userSecretKeyStatus.equalsIgnoreCase("success")) return userSecretKey;
        String username = json.getString("username");
        String userTotpKey = userSecretKey.getString("totp_key");
        String otpAuthURL = QRCodeGenerator.generateOTPAuthURL(username, "WP500@rtu.com", userTotpKey);
        QRCodeGenerator.generateQRCode(otpAuthURL, qrCodeFilePath, user);
        logger.debug("QR code generated for user:");
        String base64Image = QRCodeGenerator.convertImageToBase64(qrCodeFilePath);
        try {
            resultObj.put("qr_image", base64Image);
            resultObj.put("user_secret_key", userTotpKey);
            logger.info("QR code generation process completed successfully for user: " + username);
            FileBasedLogger.info("Security", "QR code generation process completed successfully for user: " + username, user);
            return resultObj;
        }
        catch (JSONException e) {
            e.printStackTrace();
            logger.error(" Error occurred while generating QR code : " + e);
            FileBasedLogger.error("security", " Error occurred while generating QR code : " + e, user);
        }
        return resultObj;
    }

    public JSONObject getUserQrCode(JSONObject json, String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        JSONObject userSecretKey = QRCodeGenerator.getTOTPKeyByUsername(json, user);
        String userSecretKeyStatus = userSecretKey.getString("status");
        if (userSecretKeyStatus.equalsIgnoreCase("success")) {
            String username = json.getString("username");
            String userTotpKey = userSecretKey.getString("totp_key");
            String otpAuthURL = QRCodeGenerator.generateOTPAuthURL(username, "WP500@rtu.com", userTotpKey);
            QRCodeGenerator.generateQRCode(otpAuthURL, qrCodeFilePath, user);
            logger.debug("QR code Generated.");
            String base64Image = QRCodeGenerator.convertImageToBase64(qrCodeFilePath);
            try {
                resultObj.put("qr_image", base64Image);
                resultObj.put("user_secret_key", userTotpKey);
                resultObj.put("qr_status", "true");
            }
            catch (JSONException e) {
                e.printStackTrace();
                logger.error("Error occurred while generating QR code : " + e);
                FileBasedLogger.error("Audit", "Error occurred while generating QR code : " + e, user);
            }
        } else {
            return userSecretKey;
        }
        return resultObj;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JSONObject updateQrCode(JSONObject json, String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        boolean validateUserKey = QRCodeGenerator.verifyTOTPKey(json);
        if (validateUserKey) {
            JSONObject userResult = QRCodeGenerator.updateUserSecretKey(json);
            String userStatus = userResult.getString("status");
            if (!userStatus.equalsIgnoreCase("success")) return userResult;
            JSONObject userSecretKey = QRCodeGenerator.getTOTPKeyByUsername(json, user);
            String userSecretKeyStatus = userSecretKey.getString("status");
            if (!userSecretKeyStatus.equalsIgnoreCase("success")) return userSecretKey;
            String userTotpKey = userSecretKey.getString("totp_key");
            String otpAuthURL = QRCodeGenerator.generateOTPAuthURL("WP500", "WP500@rtu.com", userTotpKey);
            QRCodeGenerator.generateQRCode(otpAuthURL, qrCodeFilePath, user);
            logger.debug("Generated QR code.");
            String base64Image = QRCodeGenerator.convertImageToBase64(qrCodeFilePath);
            try {
                resultObj.put("status", "success");
                resultObj.put("qr_image", base64Image);
                resultObj.put("user_secret_key", userTotpKey);
                logger.info("Update QR code generation process completed successfully for user: " + user);
                FileBasedLogger.info("Security", "Update QR code generation process completed successfully for user: " + user, user);
                return resultObj;
            }
            catch (JSONException e) {
                e.printStackTrace();
                logger.error(" Error occurred while Generating QR Code : " + e);
                FileBasedLogger.error("Security", " Error occurred while updating QR Code : " + e, user);
            }
            return resultObj;
        } else {
            resultObj.put("status", "error");
            resultObj.put("message", "Invalid user key");
            logger.info("Having invalid user key. ");
        }
        return resultObj;
    }

    public static String generateSecretKey() {
        String secret = UUID.randomUUID().toString().replace("-", "");
        String encoding = Base32.encodeAsString(secret.getBytes());
        String encodingWithoutPadding = encoding.replace("=", "");
        int multiplies = encodingWithoutPadding.length() / 8;
        return encodingWithoutPadding.substring(0, 8 * multiplies);
    }

    public static String generateOTPAuthURL(String issuer, String account, String secretKey) {
        return "otpauth://totp/" + issuer + ":" + account + "?secret=" + secretKey + "&issuer=" + issuer;
    }

    public static void generateQRCode(String otpAuthURL, String filePath, String user) {
        try {
            BitMatrix matrix = new MultiFormatWriter().encode(otpAuthURL, BarcodeFormat.QR_CODE, 200, 200);
            try (FileOutputStream out = new FileOutputStream(filePath);){
                MatrixToImageWriter.writeToStream(matrix, "png", out);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error("Error while genrating qr code : " + e);
            FileBasedLogger.error("Audit", "Error while genrating qr code : " + e, user);
        }
        catch (WriterException e) {
            e.printStackTrace();
        }
    }

    public static String convertImageToBase64(String imagePath) {
        try {
            File imageFile = new File(imagePath);
            byte[] imageBytes = Files.readAllBytes(imageFile.toPath());
            return DatatypeConverter.printBase64Binary(imageBytes);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JSONObject updateUserSecretKey(JSONObject json) {
        Connection connection = null;
        JSONObject resultObj = new JSONObject();
        String username = json.getString("username");
        try {
            connection = SQLiteConnector.getConnection();
            String secretKey = QRCodeGenerator.generateSecretKey();
            String checkQuery = "SELECT * FROM user WHERE username = ?";
            PreparedStatement checkStatement = connection.prepareStatement(checkQuery);
            checkStatement.setString(1, QRCodeGenerator.encrypt(username));
            ResultSet resultSet = checkStatement.executeQuery();
            if (resultSet.next()) {
                String totpAuthenticatorStatus = QRCodeGenerator.decrypt(resultSet.getString("totp_authenticator"));
                if ("enable".equals(totpAuthenticatorStatus)) {
                    String updateQuery = "UPDATE user SET totp_key = ? WHERE username = ?";
                    PreparedStatement statement = connection.prepareStatement(updateQuery);
                    statement.setString(1, secretKey);
                    statement.setString(2, QRCodeGenerator.encrypt(username));
                    statement.executeUpdate();
                    statement.close();
                    resultObj.put("status", "success");
                } else if ("disable".equals(totpAuthenticatorStatus)) {
                    resultObj.put("status", "error");
                    resultObj.put("message", "TOTP authenticator is disable for user : " + username);
                }
            } else {
                resultObj.put("status", "error");
                resultObj.put("message", "Username not found.");
            }
            resultSet.close();
            checkStatement.close();
        }
        catch (SQLException | JSONException e) {
            e.printStackTrace();
            logger.error("Error while updating user key : " + e);
            FileBasedLogger.error("Security", "Error while updating user key : " + e, username);
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject getTOTPKeyByUsername(JSONObject json, String username) {
        Connection connection = null;
        String totpKey = null;
        JSONObject resultObj = new JSONObject();
        try {
            connection = SQLiteConnector.getConnection();
            String checkQuery = "SELECT totp_key, totp_authenticator FROM user WHERE username = ?";
            PreparedStatement checkStatement = connection.prepareStatement(checkQuery);
            checkStatement.setString(1, QRCodeGenerator.encrypt(username));
            ResultSet resultSet = checkStatement.executeQuery();
            if (resultSet.next()) {
                String totpAuthenticatorStatus = QRCodeGenerator.decrypt(resultSet.getString("totp_authenticator"));
                if ("enable".equals(totpAuthenticatorStatus)) {
                    totpKey = resultSet.getString("totp_key");
                    resultObj.put("status", "success");
                    resultObj.put("totp_key", totpKey);
                } else if ("disable".equals(totpAuthenticatorStatus)) {
                    resultObj.put("status", "fail");
                    resultObj.put("msg", "TOTP authenticator is disable for user : " + username);
                    resultObj.put("qr_status", "false");
                    logger.debug("Disable the authenticator of TOTP.");
                }
            } else {
                resultObj.put("status", "fail");
                resultObj.put("msg", "Username does not exist for user : " + username);
                resultObj.put("qr_status", "false");
                logger.debug(username + " - Does not exist.");
            }
            resultSet.close();
            checkStatement.close();
        }
        catch (SQLException | JSONException e) {
            e.printStackTrace();
            logger.error(" Error occurred whilecheck TOTP authenticator.");
            FileBasedLogger.error("Security", "Error occurred whilecheck TOTP authenticator.", username);
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean verifyTOTPKey(JSONObject json) {
        Connection connection = null;
        boolean isValid = false;
        String username = json.getString("username");
        try {
            String storedTOTPKey;
            String totpAuthenticatorStatus;
            connection = SQLiteConnector.getConnection();
            String inputTOTPKey = json.getString("totp_key");
            String checkQuery = "SELECT totp_key, totp_authenticator FROM user WHERE username = ?";
            PreparedStatement checkStatement = connection.prepareStatement(checkQuery);
            checkStatement.setString(1, QRCodeGenerator.encrypt(username));
            ResultSet resultSet = checkStatement.executeQuery();
            if (resultSet.next() && "enable".equals(totpAuthenticatorStatus = QRCodeGenerator.decrypt(resultSet.getString("totp_authenticator"))) && (storedTOTPKey = resultSet.getString("totp_key")).equals(inputTOTPKey)) {
                isValid = true;
            }
            resultSet.close();
            checkStatement.close();
        }
        catch (SQLException | JSONException e) {
            e.printStackTrace();
            FileBasedLogger.error("Audit", "Error while verify the otp : " + e, username);
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return isValid;
    }
}

