/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.tag;

import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.security.Security;
import com.tas.wp500.sql_lite_db.SQLiteConnector;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TagValueSettingsOperations
extends Security {
    private static Logger logger = Logger.getLogger(TagValueSettingsOperations.class);
    private static TagValueSettingsOperations instance = null;
    private static final int SQLITE_BUSY = 5;
    private static final int RETRY_COUNT = 5;
    private static final int RETRY_DELAY = 10000;

    private TagValueSettingsOperations() {
        this.createTagTable();
    }

    public static TagValueSettingsOperations getInstance() {
        if (instance == null) {
            instance = new TagValueSettingsOperations();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTagTable() {
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = SQLiteConnector.getConnection();
            try {
                Statement statement = connection.createStatement();
                String sql = "CREATE TABLE IF NOT EXISTS tag (tag_name TEXT PRIMARY KEY, pv_address TEXT)";
                statement.execute(sql);
                statement.close();
                continue;
            }
            catch (SQLException e) {
                if (e.getErrorCode() != 5 || attempt == 4) {
                    logger.error("Error while creating tag table : " + e);
                    FileBasedLogger.error("Application", "Error while creating tag table : " + e, "system");
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject insertTag(JSONObject tag, String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = null;
            Statement statement = null;
            try {
                connection = SQLiteConnector.getConnection();
                String tagName = tag.getString("tag_name");
                String pvAddress = tag.getString("pv_address");
                if (this.isTagExists(connection, tagName)) {
                    resultObj.put("status", "Fail");
                    resultObj.put("msg", "Tag with the same name already exists.");
                    logger.info("Got Tag with the same name already exists. ");
                    FileBasedLogger.info("Application", "Got Tag with the same name already exists. ", user);
                    JSONObject jSONObject = resultObj;
                    return jSONObject;
                }
                String sql = "INSERT INTO tag (tag_name, pv_address) VALUES (?, ?)";
                statement = connection.prepareStatement(sql);
                statement.setString(1, TagValueSettingsOperations.encrypt(tagName));
                statement.setString(2, TagValueSettingsOperations.encrypt(pvAddress));
                statement.executeUpdate();
                resultObj.put("msg", "Tag inserted successfully.");
                resultObj.put("status", "Success");
                break;
            }
            catch (Exception e) {
                logger.error("Error occurred while inserting tag : " + e);
                FileBasedLogger.error("Application", "Error occurred while inserting tag : " + e, user);
                resultObj.put("status", "Fail");
                resultObj.put("msg", "Failed to insert tag.");
                e.printStackTrace();
                if (((SQLException)e).getErrorCode() != 5 || attempt == 4) {
                    logger.error("Error occurred while inserting tag : " + e);
                    FileBasedLogger.error("Application", "Error occurred while inserting tag : " + e, user);
                    resultObj.put("status", "Fail");
                    resultObj.put("msg", "Failed to insert tag.");
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        logger.error("Error while inserting tag : " + e);
                        FileBasedLogger.error("Application", "Error occurred while inserting tag : " + e, user);
                    }
                }
            }
        }
        return resultObj;
    }

    private boolean isTagExists(Connection connection, String tagName) throws SQLException {
        String sql = "SELECT COUNT(*) FROM tag WHERE tag_name = ?";
        PreparedStatement statement = connection.prepareStatement(sql);
        statement.setString(1, TagValueSettingsOperations.encrypt(tagName));
        ResultSet resultSet = statement.executeQuery();
        resultSet.next();
        int count = resultSet.getInt(1);
        return count > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject updateTag(String tagName, String newPvAddress, String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = null;
            try {
                connection = SQLiteConnector.getConnection();
                String sql = "UPDATE tag SET pv_address = ? WHERE tag_name = ?";
                PreparedStatement statement = connection.prepareStatement(sql);
                statement.setString(1, TagValueSettingsOperations.encrypt(newPvAddress));
                statement.setString(2, TagValueSettingsOperations.encrypt(tagName));
                int rowsAffected = statement.executeUpdate();
                statement.close();
                if (rowsAffected > 0) {
                    resultObj.put("msg", "Tag updated successfully.");
                    resultObj.put("status", "Success");
                    logger.info("Updated tag Successfully.");
                    FileBasedLogger.info("Application", "Updated tag Successfully.", user);
                    break;
                }
                resultObj.put("msg", "No tag found for the given tag_name.");
                resultObj.put("status", "Fail");
                logger.info("Not found any tag for the given tag_name.");
                FileBasedLogger.info("Application", "Not found any tag for the given tag_name.", user);
                break;
            }
            catch (Exception e) {
                if (((SQLException)e).getErrorCode() != 5 || attempt == 4) {
                    logger.error("Error occurred while updating tag : " + e);
                    FileBasedLogger.error("Application", "Error occurred while updating tag : " + e, user);
                    resultObj.put("status", "Fail");
                    resultObj.put("msg", "Failed to update tag.");
                    e.printStackTrace();
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject deleteTag(String tagName, String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        Connection connection = null;
        try {
            connection = SQLiteConnector.getConnection();
            String sql = "DELETE FROM tag WHERE tag_name = ?";
            PreparedStatement statement = connection.prepareStatement(sql);
            statement.setString(1, TagValueSettingsOperations.encrypt(tagName));
            int rowsAffected = statement.executeUpdate();
            statement.close();
            if (rowsAffected > 0) {
                resultObj.put("msg", "Tag deleted successfully.");
                resultObj.put("status", "Success");
                logger.info("Deleted Tag successfully.");
                FileBasedLogger.info("Application", "Deleted Tag successfully.", user);
            } else {
                resultObj.put("msg", "No tag found for the given tag name.");
                resultObj.put("status", "Fail");
                logger.info("Not found any tag for the given tag name.");
                FileBasedLogger.info("Application", "Not found any tag for the given tag name.", user);
            }
        }
        catch (Exception e) {
            logger.error("Error occurred while deleting tag : " + e);
            FileBasedLogger.error("Application", "Error occurred while deleting tag : " + e, user);
            resultObj.put("status", "Fail");
            resultObj.put("msg", "Failed to delete tag.");
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getAllTags(String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        for (int attempt = 0; attempt < 5; ++attempt) {
            JSONArray tagsArray = new JSONArray();
            Connection connection = null;
            try {
                connection = SQLiteConnector.getConnection();
                String sql = "SELECT * FROM tag";
                PreparedStatement statement = connection.prepareStatement(sql);
                ResultSet resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    JSONObject tag = new JSONObject();
                    tag.put("tag_name", TagValueSettingsOperations.decrypt(resultSet.getString("tag_name")));
                    tag.put("pv_address", TagValueSettingsOperations.decrypt(resultSet.getString("pv_address")));
                    tagsArray.put(tag);
                }
                resultObj.put("data", tagsArray);
                resultObj.put("status", "Success");
                resultObj.put("msg", "Successfully fetched tags.");
                resultSet.close();
                statement.close();
                break;
            }
            catch (SQLException | JSONException e) {
                e.printStackTrace();
                if (((SQLException)e).getErrorCode() != 5 || attempt == 4) {
                    e.printStackTrace();
                    resultObj.put("data", tagsArray);
                    resultObj.put("status", "Fail");
                    resultObj.put("msg", "Failed to fetch tags.");
                    logger.error("Error occurred while fetching tags: " + e);
                    FileBasedLogger.error("Application", "Error occurred while fetching tags: " + e, user);
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject saveBulkTags(JSONObject data, String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = null;
            try {
                connection = SQLiteConnector.getConnection();
                if (!data.has("bulk_data")) break;
                JSONArray bulk_data = data.getJSONArray("bulk_data");
                for (int i = 0; i < bulk_data.length(); ++i) {
                    try {
                        JSONObject tag = bulk_data.getJSONObject(i);
                        String tagName = tag.getString("tag_name");
                        String pvAddress = tag.getString("pv_address");
                        if (this.isTagExists(connection, tagName)) {
                            this.updateTag(connection, tagName, pvAddress);
                            continue;
                        }
                        this.insertTag(connection, tagName, pvAddress);
                        continue;
                    }
                    catch (JSONException e) {
                        logger.error("Error occurred while processing JSON data : ", e);
                        FileBasedLogger.error("Application", "Error occurred while inserting bulk tag : " + e, user);
                        continue;
                    }
                    catch (SQLException e) {
                        logger.error("SQL error : ", e);
                        FileBasedLogger.error("Application", "Error occurred while inserting bulk tag : " + e, user);
                        continue;
                    }
                    catch (Exception e) {
                        logger.error("Unexpected error : ", e);
                        FileBasedLogger.error("Application", "Error occurred while inserting bulk tag : " + e, user);
                    }
                }
                resultObj.put("status", "success");
                resultObj.put("msg", "Successfully inserted/updated all bulk data.");
                logger.info("Successfully inserted/updated all bulk data.");
                FileBasedLogger.info("Audit", "Successfully inserted/updated all bulk data.", user);
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
                if (((SQLException)e).getErrorCode() != 5 || attempt == 4) {
                    logger.error("Failed to connect to the database : ", e);
                    FileBasedLogger.error("Application", "Error occurred while inserting bulk tag : " + e, user);
                    resultObj.put("status", "fail");
                    resultObj.put("msg", "Failed to insert/update bulk data. ");
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
        return resultObj;
    }

    private void updateTag(Connection connection, String tagName, String pvAddress) throws SQLException {
        String sql = "UPDATE tag SET pv_address = ? WHERE tag_name = ?";
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setString(1, TagValueSettingsOperations.encrypt(pvAddress));
            statement.setString(2, TagValueSettingsOperations.encrypt(tagName));
            int rowsAffected = statement.executeUpdate();
            if (rowsAffected > 0) {
                logger.info("Tag updated successfully for tag name : " + tagName);
            } else {
                logger.info("No rows updated. Tag with the given tag_name not found.");
            }
        }
    }

    private void insertTag(Connection connection, String tagName, String pvAddress) throws SQLException {
        String sql = "INSERT INTO tag (tag_name, pv_address) VALUES (?, ?)";
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setString(1, TagValueSettingsOperations.encrypt(tagName));
            statement.setString(2, TagValueSettingsOperations.encrypt(pvAddress));
            statement.executeUpdate();
        }
    }
}

