/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.tag;

import com.tas.wp500.App;
import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.opc_ua_client.ClientClass;
import com.tas.wp500.opc_ua_client.OpcClientExecutorClass;
import com.tas.wp500.protocol.startan.Tag;
import com.tas.wp500.services.Service;
import com.tas.wp500.tag.TagValueSettingsOperations;
import java.util.Map;
import java.util.TimerTask;
import org.apache.log4j.Logger;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.json.JSONArray;
import org.json.JSONObject;

public class TagMappingTimer
extends TimerTask {
    private static Logger logger = Logger.getLogger(TagMappingTimer.class);

    public NodeId getNodeId(String nodeId) {
        String[] node_name = nodeId.split("\\$");
        NodeId node_id = null;
        try {
            node_id = new NodeId(Integer.parseInt(node_name[0]), Integer.parseInt(node_name[1]));
        }
        catch (Exception e) {
            node_id = new NodeId(Integer.parseInt(node_name[0]), node_name[1]);
        }
        return node_id;
    }

    @Override
    public void run() {
        block9: {
            try {
                JSONObject allTags = TagValueSettingsOperations.getInstance().getAllTags("wp500");
                JSONArray tagArray = allTags.getJSONArray("data");
                if (tagArray.length() <= 0) break block9;
                for (int i = 0; i < tagArray.length(); ++i) {
                    JSONObject tagObject = tagArray.getJSONObject(i);
                    if (!tagObject.has("tag_name") || !tagObject.has("pv_address")) continue;
                    String tag_name = tagObject.getString("tag_name");
                    String pv_address = tagObject.getString("pv_address");
                    for (Map.Entry<String, ClientClass> entry : OpcClientExecutorClass.connections.entrySet()) {
                        String key = entry.getKey();
                        OpcUaClient opc = entry.getValue().getClient();
                        if (opc == null || pv_address == null || pv_address.isEmpty()) continue;
                        try {
                            Object value;
                            if (!App.simpleServer.getName_space().isNodeAvil(pv_address)) continue;
                            NodeId node_id = this.getNodeId(pv_address);
                            try {
                                opc.connect().get();
                            }
                            catch (Exception e) {
                                logger.error("Error while connecting opc : " + e);
                                FileBasedLogger.error("Application", "Error while connecting opc : " + e, "system");
                            }
                            DataValue dataValue = opc.getAddressSpace().getVariableNode(node_id).readValue();
                            if (dataValue.getStatusCode().isGood()) {
                                value = dataValue.getValue().getValue();
                                Service.variableTagMap.put(tag_name, new Tag(tag_name, value, 0, 200, 0));
                                continue;
                            }
                            value = dataValue.getValue().getValue();
                            Service.variableTagMap.put(tag_name, new Tag(tag_name, value, 0, 504, 0));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            logger.error("Error while reading value from opc node  : " + e);
                            FileBasedLogger.error("Application", "Error while reading value from opc node  : " + e, "system");
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("Error while tag initalization : " + e);
                FileBasedLogger.error("Application", "Error while tag initalization : " + e, "sytem");
            }
        }
    }
}

