/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.store_and_forword;

import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.protocol.mqtt.MqttExecutor;
import com.tas.wp500.store_and_forword.StoreAndForwordDbOperations;
import com.tas.wp500.store_and_forword.StoreAndForwordExecutor;
import com.tas.wp500.store_and_forword.StoreForword;
import java.util.List;
import java.util.TimerTask;
import org.apache.log4j.Logger;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;

public class StoreAndForwordTimer
extends TimerTask {
    private Logger logger = Logger.getLogger(StoreAndForwordTimer.class);
    private StoreAndForwordDbOperations saf = StoreAndForwordDbOperations.getInstance();

    @Override
    public void run() {
        try {
            List<StoreForword> storeList = this.saf.fetchLatestEvents();
            if (!storeList.isEmpty()) {
                for (int i = 0; i < storeList.size(); ++i) {
                    StoreForword storeForword = storeList.get(i);
                    String broker_ip_address = storeForword.getBroker_ip_address();
                    String publish_topic = storeForword.getPublish_topic();
                    String data_string = storeForword.getData_string();
                    String date_time = storeForword.getDate_time();
                    int id = storeForword.getId();
                    if (MqttExecutor.serverlistMap.containsKey(broker_ip_address) && MqttExecutor.serverlistMap.get(broker_ip_address).isConnected()) {
                        this.publish(MqttExecutor.serverlistMap.get(broker_ip_address), publish_topic, data_string, id, broker_ip_address, date_time);
                    }
                    Thread.sleep(2000L);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("Error while Publishing Store and forword data : " + e);
            FileBasedLogger.error("Application", "Error while Publishing Store and forword data : " + e, "system");
        }
    }

    private void publish(MqttClient client, String topic, String content, int id, String ip, String date_time) {
        MqttMessage message = new MqttMessage();
        message.setPayload(content.getBytes());
        message.setQos(2);
        try {
            if (client.isConnected()) {
                client.publish(topic, message);
                this.logger.info("Store forword data published successfully id : " + id + " time : " + date_time);
                if (!StoreAndForwordExecutor.storeForwardPublishedFlag) {
                    String message1 = "StoreForward data publishing process initiated at " + date_time + ".";
                    this.logger.info(message1);
                    FileBasedLogger.info("Application", message1, "system");
                    StoreAndForwordExecutor.storeForwardPublishedFlag = true;
                }
                this.saf.deleteEventById(id);
            }
        }
        catch (MqttPersistenceException e) {
            e.printStackTrace();
            this.logger.error("Error while publishing Store forword data : " + e);
            FileBasedLogger.error("Application", "Error while publishing Store forword data : " + e, "system");
        }
        catch (MqttException e) {
            e.printStackTrace();
            FileBasedLogger.error("Application", "Error while publishing Store forword data : " + e, "system");
            this.logger.error("Error while publishing Store forword data : " + e);
        }
        catch (Exception e) {
            e.printStackTrace();
            FileBasedLogger.error("Application", "Error while publishing Store forword data : " + e, "system");
            this.logger.error("Error while publishing Store forword data : " + e);
        }
    }
}

