/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.store_and_forword;

import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.sql_lite_db.SQLiteConnector;
import com.tas.wp500.store_and_forword.StoreForword;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class StoreAndForwordDbOperations {
    private static Logger logger = Logger.getLogger(StoreAndForwordDbOperations.class);
    private static StoreAndForwordDbOperations instance;
    private static SimpleDateFormat inputFormat;
    private static final int SQLITE_BUSY = 5;
    private static final int RETRY_COUNT = 10;
    private static final int RETRY_DELAY = 10000;
    public static volatile boolean storeForwardDataFlag;

    private StoreAndForwordDbOperations() {
        this.createTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StoreAndForwordDbOperations getInstance() {
        if (instance != null) return instance;
        Class<StoreAndForwordDbOperations> clazz = StoreAndForwordDbOperations.class;
        synchronized (StoreAndForwordDbOperations.class) {
            if (instance != null) return instance;
            instance = new StoreAndForwordDbOperations();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTable() {
        for (int attempt = 0; attempt < 10; ++attempt) {
            Connection connection = null;
            try {
                connection = SQLiteConnector.getConnection();
                Statement statement = connection.createStatement();
                String sql = "CREATE TABLE IF NOT EXISTS storeandforword (id INTEGER PRIMARY KEY AUTOINCREMENT, date_time TEXT, data_string TEXT, broker_ip TEXT, publish_topic TEXT)";
                statement.execute(sql);
                statement.close();
                break;
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (e.getErrorCode() != 5 || attempt == 9) {
                    e.printStackTrace();
                    logger.error("Error while creating store and forword table : " + e);
                    FileBasedLogger.error("Application", "Error while creating store and forword table : " + e, "system");
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStoreForwordData(StoreForword event) {
        for (int attempt = 0; attempt < 10; ++attempt) {
            Connection connection = null;
            try {
                if (!storeForwardDataFlag) {
                    String message = "StoreForward data insertion process initiated at " + event.getDate_time() + ".";
                    logger.info(message);
                    FileBasedLogger.info("Application", message, "system");
                    storeForwardDataFlag = true;
                }
                connection = SQLiteConnector.getConnection();
                String sql = "INSERT INTO storeandforword (date_time, data_string, broker_ip, publish_topic) VALUES (?, ?, ?, ?)";
                PreparedStatement statement = connection.prepareStatement(sql);
                statement.setString(1, event.getDate_time());
                statement.setString(2, event.getData_string());
                statement.setString(3, event.getBroker_ip_address());
                statement.setString(4, event.getPublish_topic());
                statement.executeUpdate();
                statement.close();
                logger.info("StoreForword data inserted successfully : " + event.getDate_time());
                break;
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (e.getErrorCode() != 5 || attempt == 9) {
                    e.printStackTrace();
                    logger.error("Error while inserting event : " + e);
                    FileBasedLogger.error("Application", "Error while inserting event : " + e, "system");
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StoreForword> fetchLatestEvents() {
        ArrayList<StoreForword> storeList = new ArrayList<StoreForword>();
        for (int attempt = 0; attempt < 10; ++attempt) {
            Connection connection = null;
            try {
                connection = SQLiteConnector.getConnection();
                String sql = "SELECT * FROM storeandforword ORDER BY date_time DESC LIMIT 25";
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery(sql);
                while (resultSet.next()) {
                    int id = resultSet.getInt("id");
                    String dateTime = resultSet.getString("date_time");
                    String dataString = resultSet.getString("data_string");
                    String brokerIp = resultSet.getString("broker_ip");
                    String publishTopic = resultSet.getString("publish_topic");
                    StoreForword event = new StoreForword(id, dateTime, dataString, brokerIp, publishTopic);
                    storeList.add(event);
                }
                statement.close();
                break;
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (e.getErrorCode() != 5 || attempt == 9) {
                    e.printStackTrace();
                    logger.error("Error while fetching latest events : " + e);
                    FileBasedLogger.error("Application", "Error while fetching latest events : " + e, "system");
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
        return storeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteEventById(int id) {
        block12: {
            int attempt = 0;
            if (attempt < 10) {
                Connection connection = null;
                try {
                    connection = SQLiteConnector.getConnection();
                    String sql = "DELETE FROM storeandforword WHERE id = ?";
                    PreparedStatement statement = connection.prepareStatement(sql);
                    statement.setInt(1, id);
                    int rowsAffected = statement.executeUpdate();
                    statement.close();
                    if (rowsAffected > 0) {
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                catch (SQLException e) {
                    if (e.getErrorCode() != 5 || attempt == 9) {
                        e.printStackTrace();
                        logger.error("Error while deleting Store and forword : " + e);
                        FileBasedLogger.error("Application", "Error while deleting Store and forword : " + e, "system");
                        break block12;
                    }
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                    boolean bl = false;
                    return bl;
                }
                finally {
                    SQLiteConnector.closeConnection(connection);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getStoreForwordData(JSONObject json) {
        Connection connection = null;
        try {
            connection = SQLiteConnector.getConnection();
            String sql = "SELECT * FROM storeandforword";
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(sql);
            JSONArray dataArray = new JSONArray();
            while (resultSet.next()) {
                JSONObject json1 = new JSONObject();
                String dateTime = resultSet.getString("date_time");
                json1.put("date_time", dateTime);
                String dataString = resultSet.getString("data_string");
                json1.put("data_string", dataString);
                String broker_ip = resultSet.getString("broker_ip");
                json1.put("broker_ip", broker_ip);
                String publish_topic = resultSet.getString("publish_topic");
                json1.put("publish_topic", publish_topic);
                dataArray.put(json1);
            }
            statement.close();
            json.put("result", dataArray);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while getting store and forword data from db : " + e);
            FileBasedLogger.error("Application", "Error while getting store and forword data from db : " + e, "system");
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getMultipleStoreForwordData(JSONObject json) throws JSONException {
        Connection connection = null;
        for (int attempt = 0; attempt < 10; ++attempt) {
            try {
                String pageNo = json.getString("page_no");
                int itemsPerPage = 100;
                int requestedPage = Integer.parseInt(pageNo) + 1;
                connection = SQLiteConnector.getConnection();
                String countQuery = "SELECT COUNT(*) AS total FROM storeandforword";
                Statement countStatement = connection.createStatement();
                ResultSet countResult = countStatement.executeQuery(countQuery);
                countResult.next();
                int totalRecords = countResult.getInt("total");
                countStatement.close();
                int totalPages = (int)Math.ceil((double)totalRecords / (double)itemsPerPage);
                requestedPage = Math.max(1, Math.min(requestedPage, totalPages));
                int startRow = (requestedPage - 1) * itemsPerPage;
                int endRow = Math.min(startRow + itemsPerPage, totalRecords);
                String sql = "SELECT * FROM storeandforword LIMIT ?, ?";
                PreparedStatement statement = connection.prepareStatement(sql);
                statement.setInt(1, startRow);
                statement.setInt(2, endRow - startRow);
                ResultSet resultSet = statement.executeQuery();
                JSONArray dataArray = new JSONArray();
                while (resultSet.next()) {
                    JSONObject json1 = new JSONObject();
                    String dateTime = resultSet.getString("date_time");
                    json1.put("date_time", dateTime);
                    String dataString = resultSet.getString("data_string");
                    json1.put("data_string", dataString);
                    String broker_ip = resultSet.getString("broker_ip");
                    json1.put("broker_ip", broker_ip);
                    String publish_topic = resultSet.getString("publish_topic");
                    json1.put("publish_topic", publish_topic);
                    dataArray.put(json1);
                }
                statement.close();
                json.put("result", dataArray);
                json.put("total_pages", totalPages);
                json.put("status", "success");
                json.put("msg", "Successfully retrieved store forward data.");
            }
            catch (Exception e) {
                block9: {
                    try {
                        e.printStackTrace();
                        if (((SQLException)e).getErrorCode() == 5 && attempt != 9) break block9;
                        e.printStackTrace();
                        json.put("status", "fail");
                        json.put("msg", "Failed to retrieved store forward data.");
                        logger.error("Error occurred while getting store forward data from db : " + e);
                        FileBasedLogger.error("Application", "Error occurred while getting store forward data from db : " + e, "system");
                    }
                    catch (Throwable throwable) {
                        SQLiteConnector.closeConnection(connection);
                        throw throwable;
                    }
                    SQLiteConnector.closeConnection(connection);
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                SQLiteConnector.closeConnection(connection);
                continue;
            }
            SQLiteConnector.closeConnection(connection);
            break;
        }
        return json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject addMultipleRecord(JSONObject json) {
        Connection connection = null;
        String brokerIp = "iot.ioagpl.com";
        String publishTopic = "IOAGPL/DEMO";
        String dataString = "[{\"read_ver\": {\"unit_id\": \"C02025\", \"asset_id\": \"C02025_D1\", \"A_B_STATUS\": \"16448\", \"A_LASTFILLQTY\": \"8.23\", \"A_LASTFILLPRICE\": \"723.42\", \"A_FM_MASSTOTAL\": \"1608327.50\", \"A_DISPMETEREDTOTAL\": \"608304.69\", \"A_GASRATE\": \"87.90\", \"A_CURRENTFILLQTY\": \"8.23\", \"A_CURRENTFILLPRICE\": \"723.54\", \"A_PRESS_1\": \"196.63\", \"A_PRESS_2\": \"0.00\", \"A_GASFLORATE\": \"0.00\", \"B_LASTFILLQTY\": \"3.03\", \"B_LASTFILLPRICE\": \"266.34\", \"B_FM_MASSTOTAL\": \"2713765.75\", \"B_DISPMETEREDTOTAL\": \"712669.56\", \"B_GASRATE\": \"87.90\", \"B_CURRENTFILLQTY\": \"3.03\", \"B_CURRENTFILLPRICE\": \"266.26\", \"B_PRESS_1\": \"204.90\", \"B_PRESS_2\": \"0.00\", \"B_GASFLORATE\": \"0.00\", \"A_TRG\": \"0\", \"B_TRG\": \"0\", \"COMMSTS\": \"1\", \"date_time\": \"19-07-2023 12:37:26\"}}, {\"read_ver\": {\"unit_id\": \"C02025\", \"asset_id\": \"C02025_D2\", \"A_B_STATUS\": \"16448\", \"A_LASTFILLQTY\": \"2.80\", \"A_LASTFILLPRICE\": \"246.12\", \"A_FM_MASSTOTAL\": \"1689351.25\", \"A_DISPMETEREDTOTAL\": \"825247.62\", \"A_GASRATE\": \"87.90\", \"A_CURRENTFILLQTY\": \"2.80\", \"A_CURRENTFILLPRICE\": \"246.12\", \"A_PRESS_1\": \"153.02\", \"A_PRESS_2\": \"0.00\", \"A_GASFLORATE\": \"0.00\", \"B_LASTFILLQTY\": \"2.37\", \"B_LASTFILLPRICE\": \"208.32\", \"B_FM_MASSTOTAL\": \"1045032.50\", \"B_DISPMETEREDTOTAL\": \"542095.25\", \"B_GASRATE\": \"87.90\", \"B_CURRENTFILLQTY\": \"2.37\", \"B_CURRENTFILLPRICE\": \"208.32\", \"B_PRESS_1\": \"224.96\", \"B_PRESS_2\": \"0.00\", \"B_GASFLORATE\": \"0.00\", \"A_TRG\": \"0\", \"B_TRG\": \"0\", \"COMSTS\": \"1\", \"date_time\": \"19-07-2023 12:37:26\"}}, {\"read_ver\": {\"unit_id\": \"C02025\", \"asset_id\": \"C02025_C1\", \"PTSUC\": \"27.60\", \"TTS1IN\": \"29.69\", \"PTS1OUT1\": \"27.50\", \"TTS1OUT2\": \"101.86\", \"PTS2OUT\": \"27.34\", \"TTS2OUT\": \"115.31\", \"PTS3OUT\": \"208.78\", \"TTS3OUT\": \"77.65\", \"TTAFTCLR\": \"38.28\", \"PTCPOIL\": \"1.10\", \"TTCPOIL\": \"74.17\", \"ENGOILPT\": \"0.04\", \"ENGOILSPTT\": \"8.34\", \"ENGSUCGASPT\": \"1.40\", \"PTHIGBAN\": \"218.19\", \"PTMEDBAN\": \"219.64\", \"PTLOWBAN\": \"218.95\", \"ENGEXHTTT\": \"340.64\", \"FMCNGSUC\": \"0.00\", \"FZCNGSUC\": \"893525.62\", \"FMCNGDIS\": \"0.00\", \"FZCNGDIS\": \"7080116.50\", \"FMCNG\": \"0.00\", \"FZCNG\": \"362490.44\", \"COMPGD01\": \"4.97\", \"COMPGD02\": \"12.35\", \"RUNMIN\": \"0\", \"RUNSEC\": \"0\", \"CTRLAIRPT\": \"8.09\", \"DISPPT\": \"-0.09\", \"BUSCASPT\": \"3.81\", \"BUSDISPPT\": \"-1.30\", \"MOBBNKPT\": \"-1.64\", \"ENGJKTWTRTT\": \"90.13\", \"ENGLTAWTRTT\": \"45.95\", \"PCKGINTT\": \"-62.43\", \"TRUNHR\": \"12133\", \"TRUNMIN\": \"19\", \"TRUNSEC\": \"4\", \"Comp_Digitalbits0\": \"32770\", \"Comp_Digitalbits1\": \"63445\", \"Comp_Digitalbits2\": \"4098\", \"Comp_Digitalbits3\": \"17464\", \"CPCOMMST\": \"1\", \"date_time\": \"19-07-2023 12:37:26\"}}, {\"read_ver\": {\"unit_id\": \"C02025\", \"asset_id\": \"C02025_M\", \"MDMSGNLSTG\": \"-71\", \"date_time\": \"19-07-2023 12:37:26\"}}]";
        try {
            connection = SQLiteConnector.getConnection();
            if (connection != null) {
                for (int i = 0; i < 570; ++i) {
                    String sql = "INSERT INTO storeandforword (date_time, data_string, broker_ip, publish_topic) VALUES (?, ?, ?, ?)";
                    PreparedStatement statement = connection.prepareStatement(sql);
                    statement.setString(1, inputFormat.format(new java.util.Date()));
                    statement.setString(2, dataString);
                    statement.setString(3, brokerIp);
                    statement.setString(4, publishTopic);
                    statement.executeUpdate();
                    statement.close();
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("Error while inserting event : " + e);
            FileBasedLogger.error("Application", "Error while inserting event : " + e, "system");
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maintainsOnly30DaysDataOld() {
        Connection connection = null;
        try {
            connection = SQLiteConnector.getConnection();
            String sql = "DELETE FROM storeandforword WHERE date_time < ?";
            PreparedStatement statement = connection.prepareStatement(sql);
            LocalDate currentDate = LocalDate.now();
            LocalDate sevenDaysAgo = currentDate.minusDays(30L);
            Date sevenDaysAgoDate = Date.valueOf(sevenDaysAgo);
            statement.setDate(1, sevenDaysAgoDate);
            int rowsAffected = statement.executeUpdate();
            statement.close();
            logger.info(rowsAffected + " old store forword(s) deleted.");
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("Error while deleting old store forword : " + e);
            FileBasedLogger.error("Application", "Error while deleting old store forword : " + e, "system");
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maintainsOnly30DaysData() {
        Connection connection = null;
        logger.debug("Starting 30-day data maintenance");
        try {
            connection = SQLiteConnector.getConnection();
            LocalDateTime cutoff = LocalDateTime.now().minusDays(30L).truncatedTo(ChronoUnit.DAYS);
            String formattedCutoff = cutoff.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            logger.info("Data retention cutoff : " + formattedCutoff);
            String checkSql = "SELECT COUNT(*) FROM storeandforword WHERE strftime('%s', (    substr(date_time, 7, 4) || '-' ||     substr(date_time, 4, 2) || '-' ||     substr(date_time, 1, 2) || ' ' ||     substr(date_time, 12, 8))) < strftime('%s', ?)";
            try (PreparedStatement checkStmt = connection.prepareStatement(checkSql);){
                checkStmt.setString(1, formattedCutoff);
                ResultSet rs = checkStmt.executeQuery();
                int oldCount = rs.getInt(1);
                rs.close();
                if (oldCount == 0) {
                    logger.info("No records older than 30 days found");
                    return;
                }
                logger.info("Identified records for deletion : " + oldCount);
            }
            String deleteSql = "DELETE FROM storeandforword WHERE strftime('%s', (    substr(date_time, 7, 4) || '-' ||     substr(date_time, 4, 2) || '-' ||     substr(date_time, 1, 2) || ' ' ||     substr(date_time, 12, 8))) < strftime('%s', ?)";
            try (PreparedStatement deleteStmt = connection.prepareStatement(deleteSql);){
                deleteStmt.setString(1, formattedCutoff);
                int deletedCount = deleteStmt.executeUpdate();
                logger.info("Successfully deleted records : " + deletedCount);
            }
        }
        catch (SQLException e) {
            logger.error("Database maintenance failed : " + e.getMessage() + e.getSQLState());
            FileBasedLogger.error("Database", "30-day cleanup error: " + e.getErrorCode(), "system");
        }
        finally {
            SQLiteConnector.closeConnection(connection);
            logger.debug("Maintenance completed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject deleteAllStoreForwordData() {
        Connection connection = null;
        JSONObject response = new JSONObject();
        try {
            connection = SQLiteConnector.getConnection();
            String sql = "DELETE FROM storeandforword";
            PreparedStatement statement = connection.prepareStatement(sql);
            int rowsDeleted = statement.executeUpdate();
            statement.close();
            response.put("status", "success");
            response.put("msg", rowsDeleted + " records deleted.");
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("Error while deleting records: " + e);
            FileBasedLogger.error("Application", "Error while deleting records: " + e, "system");
            response.put("status", "fail");
            response.put("msg", "Error while deleting records: " + e.getMessage());
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertOldTestData() {
        Connection connection = null;
        String METHOD_NAME = "insertOldTestData";
        logger.info("Inserting 1.5 months of test data for verification...");
        try {
            connection = SQLiteConnector.getConnection();
            String sql = "INSERT INTO storeandforword (date_time, data_string, broker_ip, publish_topic) VALUES (?, ?, ?, ?)";
            PreparedStatement statement = connection.prepareStatement(sql);
            LocalDateTime now = LocalDateTime.now();
            int totalDays = 45;
            int recordsInserted = 0;
            for (int daysOld = 1; daysOld <= totalDays; ++daysOld) {
                String dateTime = now.minusDays(daysOld).format(DateTimeFormatter.ofPattern("dd-MM-yyyy HH:mm:ss"));
                String jsonData = String.format("{\"test\":\"Day_%d_data\",\"value\":%d}", daysOld, daysOld * 100);
                statement.setString(1, dateTime);
                statement.setString(2, jsonData);
                statement.setString(3, "192.168.1." + daysOld);
                statement.setString(4, "test_topic_" + daysOld);
                statement.executeUpdate();
                ++recordsInserted;
                if (daysOld % 10 != 0) continue;
                logger.debug("Inserted record from " + dateTime + " (" + daysOld + " days old)");
            }
            statement.close();
            logger.info("Successfully inserted " + recordsInserted + " test records spanning " + totalDays + " days");
        }
        catch (SQLException e) {
            logger.error("DATABASE ERROR: Failed to insert test data", e);
            FileBasedLogger.error("Application", "Test Data Insertion Failed | " + e.getMessage(), "system");
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
    }

    public boolean verifyOldDataDeleted() throws SQLException {
        Connection conn = SQLiteConnector.getConnection();
        String sql = "SELECT COUNT(*) FROM storeandforword WHERE date_time < ?";
        PreparedStatement stmt = conn.prepareStatement(sql);
        stmt.setString(1, LocalDateTime.now().minusDays(30L).format(DateTimeFormatter.ofPattern("dd-MM-yyyy HH:mm:ss")));
        ResultSet rs = stmt.executeQuery();
        int count = rs.getInt(1);
        rs.close();
        stmt.close();
        conn.close();
        logger.info("Old records remaining: " + count);
        return count == 0;
    }

    static {
        inputFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        storeForwardDataFlag = false;
    }
}

