/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.ssl_certificate_manager;

import com.tas.wp500.fileLogSetting.FileBasedLogger;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServerXmlModifier {
    private static Logger logger = Logger.getLogger(ServerXmlModifier.class);
    public static final int ID = 1;
    private static ServerXmlModifier instance = null;
    public static final String CONFIG_PATH = "/etc/wp500cfg/config.ini";

    private ServerXmlModifier() {
        this.setWebIp();
    }

    public static ServerXmlModifier getInstance() {
        if (instance == null) {
            instance = new ServerXmlModifier();
        }
        return instance;
    }

    public void setWebIp() {
        String lanTypeIp;
        boolean resultBind;
        String serverXmlIp = this.getConnectorAddress();
        if (serverXmlIp == null && (resultBind = this.updateConnectorAddress(lanTypeIp = "0.0.0.0"))) {
            logger.info("Web server IP bind successfully.");
            FileBasedLogger.info("Application", "Web server IP bind successfully.", "system");
            this.rebootSystem1();
        }
    }

    public JSONObject setIpToXml(JSONObject json) {
        String serverXmlIp;
        JSONObject resultObj = new JSONObject();
        String lanType = json.getString("lan_type");
        String lanTypeIp = lanType.equalsIgnoreCase("Any") ? "0.0.0.0" : this.getEthernetIpByType(lanType);
        if (!lanTypeIp.equals(serverXmlIp = this.getConnectorAddress())) {
            boolean resultBind = this.updateConnectorAddress(lanTypeIp);
            if (resultBind) {
                resultObj.put("status", "success");
                resultObj.put("msg", "Web server IP bound successfully. You will need to log in again.");
                logger.info("Modification completed successfully in the server file.");
                this.rebootSystem1();
            } else {
                resultObj.put("status", "fail");
                resultObj.put("msg", "Error while binding web server ip.");
            }
        } else {
            resultObj.put("status", "success");
            resultObj.put("msg", "Web server IP is already bind.");
        }
        return resultObj;
    }

    public boolean updateConnectorAddress(String lanTypeIp) {
        boolean connectorFound = false;
        File serverXmlFile = new File("/opt/apache-tomcat-9.0.85/conf/server.xml");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(serverXmlFile);
            NodeList connectorNodes = document.getElementsByTagName("Connector");
            for (int i = 0; i < connectorNodes.getLength(); ++i) {
                Node connectorNode = connectorNodes.item(i);
                Node portAttr = connectorNode.getAttributes().getNamedItem("port");
                if (portAttr == null || !portAttr.getNodeValue().equals("443") || !connectorNode.getAttributes().getNamedItem("protocol").getNodeValue().equals("org.apache.coyote.http11.Http11NioProtocol")) continue;
                connectorFound = true;
                Node addressAttr = connectorNode.getAttributes().getNamedItem("address");
                if (addressAttr != null) {
                    addressAttr.setNodeValue(lanTypeIp);
                    continue;
                }
                Attr newAddressAttr = document.createAttribute("address");
                newAddressAttr.setNodeValue(lanTypeIp);
                connectorNode.getAttributes().setNamedItem(newAddressAttr);
            }
            if (!connectorFound) {
                // empty if block
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(serverXmlFile);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            logger.error("Error modifying the server file: " + e.getMessage());
            FileBasedLogger.error("Application", "Error modifying the server file: " + e.getMessage(), "system");
            e.printStackTrace();
        }
        return connectorFound;
    }

    public String getEthernetIpByType(String lanType) {
        String ipAddr = "";
        try (FileInputStream fileInputStream = new FileInputStream(CONFIG_PATH);){
            Properties properties = new Properties();
            properties.load(fileInputStream);
            switch (lanType) {
                case "lan0": {
                    ipAddr = properties.getProperty("lan0_ipaddr").trim();
                    break;
                }
                case "lan1": {
                    ipAddr = properties.getProperty("lan1_ipaddr").trim();
                    break;
                }
                case "lan2": {
                    ipAddr = properties.getProperty("lan2_ipaddr").trim();
                    break;
                }
                default: {
                    logger.error("Invalid LAN type provided: " + lanType);
                }
            }
            logger.debug("Ethernet settings fetched successfully for LAN type: " + lanType);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error occurred while getting ethernet details: " + e);
            logger.info("Failed to fetch ethernet settings for LAN type: " + lanType);
            FileBasedLogger.error("Application", "Error occurred while getting ethernet details: " + e, "system");
        }
        return ipAddr;
    }

    private String getEthernetTypeByIp(String address) {
        String lanType = "";
        try (FileInputStream fileInputStream = new FileInputStream(CONFIG_PATH);){
            Properties properties = new Properties();
            properties.load(fileInputStream);
            String lan0IpAddr = properties.getProperty("lan0_ipaddr").trim();
            String lan1IpAddr = properties.getProperty("lan1_ipaddr").trim();
            String lan2IpAddr = properties.getProperty("lan2_ipaddr").trim();
            if (address.equals(lan0IpAddr)) {
                lanType = "lan0";
            } else if (address.equals(lan1IpAddr)) {
                lanType = "lan1";
            } else if (address.equals(lan2IpAddr)) {
                lanType = "lan2";
            } else {
                FileBasedLogger.error("Application", "No matching LAN type found for address: " + address, "system");
                logger.error("No matching LAN type found for address: " + address);
            }
            if (!lanType.isEmpty()) {
                logger.info("LAN type fetched successfully for address: " + address + ", LAN type: " + lanType);
                FileBasedLogger.info("Application", "LAN type fetched successfully for address: " + address + ", LAN type: " + lanType, "system");
            }
        }
        catch (Exception e) {
            logger.error("Error occurred while getting LAN type for address: " + address + ", Error: " + e.getMessage());
            FileBasedLogger.error("Application", "Error occurred while getting LAN type for address: " + address + ", Error: " + e.getMessage(), "system");
            e.printStackTrace();
        }
        return lanType;
    }

    public String getConnectorAddress() {
        String addressValue = null;
        File serverXmlFile = new File("/opt/apache-tomcat-9.0.85/conf/server.xml");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(serverXmlFile);
            NodeList connectorNodes = document.getElementsByTagName("Connector");
            for (int i = 0; i < connectorNodes.getLength(); ++i) {
                Node connectorNode = connectorNodes.item(i);
                Node portAttr = connectorNode.getAttributes().getNamedItem("port");
                if (portAttr == null || !portAttr.getNodeValue().equals("443") || !connectorNode.getAttributes().getNamedItem("protocol").getNodeValue().equals("org.apache.coyote.http11.Http11NioProtocol")) continue;
                Node addressAttr = connectorNode.getAttributes().getNamedItem("address");
                if (addressAttr != null) {
                    addressValue = addressAttr.getNodeValue();
                }
                break;
            }
        }
        catch (Exception e) {
            logger.error("Error retrieving the address from the server file: " + e.getMessage());
            FileBasedLogger.error("Application", "Error retrieving the address from the server file: " + e.getMessage(), "system");
            e.printStackTrace();
            addressValue = null;
        }
        return addressValue;
    }

    public JSONObject getWebServerIp() {
        JSONObject resultObj = new JSONObject();
        try {
            String lanType = "";
            String address = this.getConnectorAddress();
            lanType = address.equals("0.0.0.0") ? "Any" : this.getEthernetTypeByIp(address);
            resultObj.put("status", "success");
            resultObj.put("message", "Successfully fetched web server configuration.");
            resultObj.put("lan_type", lanType);
            resultObj.put("ip_address", address);
        }
        catch (Exception e) {
            resultObj.put("status", "fail");
            resultObj.put("msg", "error while fetch web server configuration.");
        }
        return resultObj;
    }

    public JSONObject rebootSystem() throws JSONException {
        final JSONObject json = new JSONObject();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Process process = Runtime.getRuntime().exec("reboot");
                    int exitStatus = process.waitFor();
                    if (exitStatus == 0) {
                        logger.info("Rebooting the system.");
                        FileBasedLogger.info("Application", "Rebooting the system.", "system");
                    } else {
                        logger.error("Failed to reboot the system.");
                        FileBasedLogger.error("Application", "Failed to reboot the system.", "system");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error("Error occurred while rebooting the system." + e.getMessage());
                    FileBasedLogger.error("Application", "Error occurred while rebooting the system." + e.getMessage(), "system");
                    try {
                        json.put("status", "error");
                        json.put("msg", "Error occurred while rebooting the system.");
                    }
                    catch (JSONException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }).start();
        try {
            json.put("status", "success");
            json.put("msg", "Web server ip bind successfully.System is Rebooting. Please wait !!!");
        }
        catch (JSONException e) {
            logger.error("Error occurred while rebooting the system." + e.getMessage());
            FileBasedLogger.error("Application", "Error occurred while rebooting the system." + e.getMessage(), "system");
            json.put("status", "fail");
            json.put("msg", "Failed to reboot the system.");
        }
        return json;
    }

    public void rebootSystem1() {
        try {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        logger.info("Attempting to restart Apache Tomcat...");
                        Process restartTomcat = Runtime.getRuntime().exec("systemctl restart apache-tomcat.service");
                        int tomcatExitStatus = restartTomcat.waitFor();
                        if (tomcatExitStatus == 0) {
                            logger.info("Apache Tomcat restarted successfully.");
                        } else {
                            logger.error("Failed to restart Apache Tomcat. Exit status: " + tomcatExitStatus);
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error occurred while restarting Apache Tomcat: " + e.getMessage());
                    }
                }
            }).start();
        }
        catch (JSONException e) {
            logger.error("Error occurred while rebooting the system." + e.getMessage());
            FileBasedLogger.error("Application", "Error occurred while rebooting the system." + e.getMessage(), "system");
        }
    }
}

