/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.ssl_certificate_manager;

import com.tas.wp500.fileLogSetting.FileBasedLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SSLCertificateGenerator {
    private static Logger logger = Logger.getLogger(SSLCertificateGenerator.class);
    private static SSLCertificateGenerator instance = null;
    private static final String CERTIFICATE_DN = "CN=WP500, OU=TAS, O=TASM2M, L=Pune, ST=MH, C=IN";
    private static final String CERTIFICATE_ALIAS = "wp500";
    private static final String KEYSTORE_PASSWORD = "Wp500@https2023";
    private static final String VALIDITY = "36500";
    private static final String KEYSTORE_FILE = "/ssl-certificates/keystore.jks";
    private static final String CERTIFICATE_FILE = "/ssl-certificates/certificate.crt";
    private static final String PFX_FILE = "/ssl-certificates/keystore.pfx";
    private static final String PRIVATE_KEY_FILE = "/ssl-certificates/private.pem";
    private static final String CERTIFICATE_PEM_FILE = "/ssl-certificates/certificate.pem";
    private static final String serverXmlPath = "/opt/apache-tomcat-9.0.85/conf/server.xml";
    private static final String sslCertificateFileName = "/ssl-certificates";
    private static final String sourceDirectorySslCertificate = "/ssl-certificates";
    private static final String destinationDirectorySslCertificate = "/opt/apache-tomcat-9.0.85/conf";
    private static final String crtFileName = "certificate.crt";
    private static final String jksFileName = "keystore.jks";
    private static final String privateKeyFileNmae = "private.pem";
    private static final String pemCertificateFileName = "certificate.pem";
    private static final String tomcatHome = "/opt/apache-tomcat-9.0.85";

    public static SSLCertificateGenerator getInstance() {
        if (instance == null) {
            instance = new SSLCertificateGenerator();
        }
        return instance;
    }

    public JSONObject generate_ssl_certificte(JSONObject json, String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        try {
            boolean sslCertificateFileResult = SSLCertificateGenerator.createSslDirectory("/ssl-certificates");
            if (sslCertificateFileResult) {
                boolean keystoreAndCertificateGenerated = SSLCertificateGenerator.generateSSLKeystoreAndCertificate(json);
                resultObj.put("status-keystoreAndCertificateGenerated", keystoreAndCertificateGenerated);
                if (keystoreAndCertificateGenerated) {
                    resultObj.put("message", "certificate generated successfully.");
                    logger.info("Generated SSL certificate successsfully.");
                    FileBasedLogger.info("Application", "Generated SSL certificate successsfully.", user);
                } else {
                    resultObj.put("message", "Failed to generate certificate.");
                    logger.info("Failed to Generate SSL certificate.");
                    FileBasedLogger.info("Application", "Failed to Generate SSL certificate.", user);
                }
            } else {
                resultObj.put("message", "Failed to create SSL certificate.");
                logger.info("Failed to Generated SSL certificate directory.");
                FileBasedLogger.info("Application", "Failed to Generated SSL certificate directory.", user);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            resultObj.put("status", false);
            resultObj.put("message", "Error occurred while generating SSL keystore and certificate.");
            logger.error("Error occurred while generating SSL Keystore and certificate : " + e);
            FileBasedLogger.error("Application", "Error occurred while generating SSL Keystore and certificate : " + e, user);
        }
        return resultObj;
    }

    public JSONObject applySSLCertificate(String user) {
        JSONObject resultObj = new JSONObject();
        try {
            File crtFile = new File("/ssl-certificates", crtFileName);
            File jksFile = new File("/ssl-certificates", jksFileName);
            File privatePemFile = new File("/ssl-certificates", privateKeyFileNmae);
            File crtPemFile = new File("/ssl-certificates", pemCertificateFileName);
            if (crtFile.exists() && jksFile.exists() && privatePemFile.exists() && crtPemFile.exists()) {
                new Thread(() -> {
                    try {
                        boolean crtCopySuccess = SSLCertificateGenerator.moveFile("/ssl-certificates", destinationDirectorySslCertificate, crtFileName);
                        boolean jksCopySuccess = SSLCertificateGenerator.moveFile("/ssl-certificates", destinationDirectorySslCertificate, jksFileName);
                        boolean privateCopySuccess = SSLCertificateGenerator.moveFile("/ssl-certificates", destinationDirectorySslCertificate, privateKeyFileNmae);
                        boolean crtPemCopySuccess = SSLCertificateGenerator.moveFile("/ssl-certificates", destinationDirectorySslCertificate, pemCertificateFileName);
                        if (crtCopySuccess && jksCopySuccess && privateCopySuccess && crtPemCopySuccess) {
                            this.rebootService();
                        } else {
                            this.handleApplicationFailure(user, resultObj, "Error occurred while applying SSL certificate.");
                        }
                    }
                    catch (JSONException e) {
                        logger.error("Error occurred while copying CSK or JKS files: " + e);
                        FileBasedLogger.error("Application", "Error occurred while copying CSK or JKS files: " + e, user);
                        this.handleApplicationFailure(user, resultObj, "Error occurred while applying SSL certificate.");
                    }
                }).start();
            } else {
                logger.error("Files not exist. Regenerating the SSL certificate.");
                FileBasedLogger.error("Application", "Files not exist. Regenerating the SSL certificate.", user);
                resultObj.put("message", "Regenerating the SSL certificate 1st.");
                resultObj.put("status", "success");
            }
            resultObj.put("message", "Applying SSL certificate. The system is now rebooting. Please be wait !!");
            resultObj.put("status", "success");
        }
        catch (Exception e) {
            logger.error("Error during SSL certificate application: " + e.getMessage(), e);
            FileBasedLogger.error("Application", "Error during SSL certificate application: " + e.getMessage(), user);
            resultObj.put("message", "Error during SSL certificate application.");
        }
        return resultObj;
    }

    private void handleApplicationFailure(String user, JSONObject resultObj, String errorMessage) {
        logger.error(errorMessage);
        FileBasedLogger.error("Application", errorMessage, user);
        resultObj.put("message", errorMessage);
        resultObj.put("status", "fail");
    }

    private static boolean generateSSLKeystoreAndCertificate(JSONObject json) throws Exception {
        String generateKeystoreCommand;
        String certificateAlias = SSLCertificateGenerator.generateRandomAlias();
        int validity = json.getInt("validity");
        String commonName = json.getString("commonName");
        String organization = json.getString("organization");
        String organizationalUnit = json.getString("organizationalUnit");
        String location = json.getString("location");
        String state = json.getString("state");
        String country = json.getString("country");
        JSONArray dnsNames = null;
        JSONArray ipAddresses = null;
        if (json.has("dnsNames")) {
            dnsNames = json.getJSONArray("dnsNames");
        }
        if (json.has("ipAddresses")) {
            ipAddresses = json.getJSONArray("ipAddresses");
        }
        String sanOptions = "";
        if (dnsNames != null || ipAddresses != null) {
            int i;
            ArrayList<String> sanList = new ArrayList<String>();
            if (dnsNames != null) {
                for (i = 0; i < dnsNames.length(); ++i) {
                    sanList.add("dns:" + dnsNames.getString(i));
                }
            }
            if (ipAddresses != null) {
                for (i = 0; i < ipAddresses.length(); ++i) {
                    sanList.add("ip:" + ipAddresses.getString(i));
                }
            }
            sanOptions = "-ext san=" + String.join((CharSequence)",", sanList);
        }
        boolean keystoreGenerationSuccess = false;
        if (!sanOptions.isEmpty()) {
            generateKeystoreCommand = String.format("keytool -genkey -alias %s -validity %d -keyalg RSA -keystore %s -storepass %s -keypass %s -dname \"CN=%s, O=%s, OU=%s, L=%s, ST=%s, C=%s\" %s", certificateAlias, validity, KEYSTORE_FILE, KEYSTORE_PASSWORD, KEYSTORE_PASSWORD, commonName, organization, organizationalUnit, location, state, country, sanOptions);
            keystoreGenerationSuccess = SSLCertificateGenerator.executeCommand(generateKeystoreCommand);
        } else {
            generateKeystoreCommand = "keytool -genkey -alias " + certificateAlias + " -validity " + validity + " -keyalg RSA -keystore " + KEYSTORE_FILE + " -storepass " + KEYSTORE_PASSWORD + " -keypass " + KEYSTORE_PASSWORD + " -dname \"CN=" + commonName + ", O=" + organization + ", OU=" + organizationalUnit + ", L=" + location + ", ST=" + state + ", C=" + country + "\"";
            keystoreGenerationSuccess = SSLCertificateGenerator.executeCommand(generateKeystoreCommand);
        }
        String exportCertificateCommand = String.format("keytool -export -alias %s -validity %d -keystore %s -file %s -storepass %s", certificateAlias, validity, KEYSTORE_FILE, CERTIFICATE_FILE, KEYSTORE_PASSWORD);
        boolean certificateExportSuccess = SSLCertificateGenerator.executeCommand(exportCertificateCommand);
        String convertToPfxCommand = String.format("keytool -importkeystore -srckeystore %s -srcalias %s -destkeystore %s -deststoretype PKCS12 -srcstorepass %s -deststorepass %s", KEYSTORE_FILE, certificateAlias, PFX_FILE, KEYSTORE_PASSWORD, KEYSTORE_PASSWORD);
        boolean pfxGenerationSuccess = SSLCertificateGenerator.executeCommand(convertToPfxCommand);
        String extractPrivateKeyCommand = String.format("openssl pkcs12 -in %s -nocerts -out %s -nodes -passin pass:%s", PFX_FILE, PRIVATE_KEY_FILE, KEYSTORE_PASSWORD);
        boolean privateKeyExtractionSuccess = SSLCertificateGenerator.executeCommand(extractPrivateKeyCommand);
        String extractCertificateCommand = String.format("openssl pkcs12 -in %s -clcerts -nokeys -out %s -passin pass:%s", PFX_FILE, CERTIFICATE_PEM_FILE, KEYSTORE_PASSWORD);
        boolean certificateExtractionSuccess = SSLCertificateGenerator.executeCommand(extractCertificateCommand);
        return keystoreGenerationSuccess && pfxGenerationSuccess && privateKeyExtractionSuccess && certificateExtractionSuccess;
    }

    private static String generateRandomAlias() {
        int randomNum = (int)(Math.random() * 1000.0);
        return CERTIFICATE_ALIAS + randomNum;
    }

    private static boolean executeCommand(String command) {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder("/bin/bash", "-c", command);
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                }
            }
            try (BufferedReader errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
                String errorLine;
                while ((errorLine = errorReader.readLine()) != null) {
                    logger.debug("Error while execute command :" + errorLine);
                }
            }
            int exitCode = process.waitFor();
            if (exitCode == 0) {
                logger.debug("Command executed successfully.");
                return true;
            }
            FileBasedLogger.error("Application", "Command failed with error code : " + exitCode, "system");
            logger.error("Command failed with error code : " + exitCode);
            return false;
        }
        catch (IOException | InterruptedException e) {
            FileBasedLogger.error("Application", "Error while executing SSL certificate command : " + e.getMessage(), "system");
            logger.error("Error while executing SSL certificate command : " + e.getMessage());
            return false;
        }
    }

    private static boolean updateServerXml() {
        boolean updateSuccessful = false;
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            File file = new File(serverXmlPath);
            Document doc = dBuilder.parse(file);
            NodeList connectors = doc.getElementsByTagName("Connector");
            boolean connectorExists = false;
            for (int i = 0; i < connectors.getLength(); ++i) {
                Element connectorElement;
                Node connector = connectors.item(i);
                if (connector.getNodeType() != 1 || !SSLCertificateGenerator.checkAttributes(connectorElement = (Element)connector)) continue;
                connectorExists = true;
                break;
            }
            if (!connectorExists) {
                Node serviceNode = doc.getElementsByTagName("Service").item(0);
                Element newConnector = doc.createElement("Connector");
                newConnector.setAttribute("protocol", "org.apache.coyote.http11.Http11NioProtocol");
                newConnector.setAttribute("port", "443");
                newConnector.setAttribute("maxThreads", "200");
                newConnector.setAttribute("scheme", "https");
                newConnector.setAttribute("secure", "true");
                newConnector.setAttribute("SSLEnabled", "true");
                newConnector.setAttribute("keystoreFile", KEYSTORE_FILE);
                newConnector.setAttribute("keystorePass", KEYSTORE_PASSWORD);
                newConnector.setAttribute("certificateFile", CERTIFICATE_FILE);
                newConnector.setAttribute("clientAuth", "false");
                newConnector.setAttribute("sslProtocol", "TLS");
                serviceNode.insertBefore(newConnector, serviceNode.getFirstChild());
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                DOMSource source = new DOMSource(doc);
                StreamResult result = new StreamResult(file);
                transformer.transform(source, result);
                logger.debug("New SSL Connector added and configuration updated in server.xml file.");
                updateSuccessful = true;
            } else {
                FileBasedLogger.info("Application", "SSL Connector with specified attributes already exists. No changes made.", "system");
                logger.info("SSL Connector with specified attributes already exists. No changes made.");
            }
        }
        catch (Exception e) {
            FileBasedLogger.error("Application", "Error while updating server.xml : " + e.getMessage(), "system");
            logger.error("Error while updating server.xml : " + e.getMessage());
        }
        return updateSuccessful;
    }

    private static boolean checkAttributes(Element connectorElement) {
        return connectorElement.getAttribute("protocol").equals("org.apache.coyote.http11.Http11NioProtocol") && connectorElement.getAttribute("port").equals("443") && connectorElement.getAttribute("scheme").equals("https") && connectorElement.getAttribute("secure").equals("true") && connectorElement.getAttribute("SSLEnabled").equals("true") && connectorElement.getAttribute("keystoreFile").equals(KEYSTORE_FILE) && connectorElement.getAttribute("keystorePass").equals(KEYSTORE_PASSWORD) && connectorElement.getAttribute("certificateFile").equals(CERTIFICATE_FILE) && connectorElement.getAttribute("clientAuth").equals("false") && connectorElement.getAttribute("sslProtocol").equals("TLS");
    }

    public void restartTomcat() {
        try {
            String[] shutdownCommand = new String[]{"/bin/bash", "-c", "/opt/apache-tomcat-9.0.85/bin/shutdown.sh"};
            ProcessBuilder shutdownProcessBuilder = new ProcessBuilder(shutdownCommand);
            Process shutdownProcess = shutdownProcessBuilder.start();
            int shutdownExitCode = shutdownProcess.waitFor();
            if (shutdownExitCode == 0) {
                String[] startupCommand = new String[]{"/bin/bash", "-c", "/opt/apache-tomcat-9.0.85/bin/startup.sh"};
                ProcessBuilder startupProcessBuilder = new ProcessBuilder(startupCommand);
                Process startupProcess = startupProcessBuilder.start();
                int startupExitCode = startupProcess.waitFor();
                if (startupExitCode != 0) {
                    FileBasedLogger.error("Application", "Failed to start Tomcat server. Exit code: " + startupExitCode, "system");
                    logger.error("Failed to start Tomcat server. Exit code: " + startupExitCode);
                }
            } else {
                FileBasedLogger.error("Application", "Failed to shutdown Tomcat server. Exit code: " + shutdownExitCode, "system");
                logger.error("Failed to shutdown Tomcat server. Exit code: " + shutdownExitCode);
            }
        }
        catch (IOException | InterruptedException e) {
            FileBasedLogger.error("Application", "Error occurred while restarting Tomcat server : " + e.getMessage(), "system");
            logger.error("Error occurred while restarting Tomcat server : " + e.getMessage());
        }
    }

    private static boolean createSslDirectory(String sslcertificatefilename2) {
        try {
            Path path = Paths.get(sslcertificatefilename2, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path, new FileAttribute[0]);
                logger.debug("Folder is created for ssl certificate. ");
                return true;
            }
            FileBasedLogger.info("Application", "Folder is created for ssl certificate.", "system");
            logger.info("Folder is created for ssl certificate. ");
            return true;
        }
        catch (Exception e) {
            FileBasedLogger.error("Application", "Failed to create directory for ssl certificate : " + e, "system");
            logger.error("Failed to create directory for ssl certificate : " + e);
            return false;
        }
    }

    private static boolean moveFile(String sourceDirectory, String destinationDirectory, String fileName) {
        Path sourcePath = Paths.get(sourceDirectory, fileName);
        Path destinationPath = Paths.get(destinationDirectory, fileName);
        try {
            if (Files.exists(sourcePath, new LinkOption[0]) && Files.isRegularFile(sourcePath, new LinkOption[0])) {
                Files.copy(sourcePath, destinationPath, StandardCopyOption.REPLACE_EXISTING);
                return true;
            }
            FileBasedLogger.error("Application", "File not found in the source directory: " + fileName, "system");
            logger.error("File not found in the source directory: " + fileName);
            return false;
        }
        catch (IOException e) {
            FileBasedLogger.error("Application", "Error moving file " + fileName + ": " + e.getMessage(), "system");
            logger.error("Error moving file " + fileName + ": " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public void rebootService() {
        String serviceCommand = "reboot";
        try {
            SSLCertificateGenerator.executeCommand(serviceCommand);
            logger.info("Service reboot successfully :");
            FileBasedLogger.error("Application", "Service reboot successfully: ", "system");
        }
        catch (Exception e) {
            FileBasedLogger.error("Application", "Error reboot service: " + e.getMessage(), "system");
            logger.error("Error reboot service: " + e.getMessage());
        }
    }
}

