/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.sql_lite_db;

import com.tas.wp500.util.Environment;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class SQLiteRestoreBackupConnector {
    private static final Logger logger = Logger.getLogger(SQLiteRestoreBackupConnector.class);
    private static String DB_URL = "jdbc:sqlite:/data/wp500_backup/backup/wp_500DbFile.db";
    private static final int MAX_RETRIES = 5;

    public static Connection getConnection() {
        Connection connection = null;
        int retries = 0;
        while (retries < 5) {
            try {
                connection = DriverManager.getConnection(DB_URL);
                SQLiteRestoreBackupConnector.setWALMode(connection);
                break;
            }
            catch (SQLException e) {
                logger.error("Error while creating DB connection (Attempt " + (retries + 1) + "): " + e.getMessage());
                if (!e.getMessage().contains("database is locked")) break;
                ++retries;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        if (connection == null) {
            logger.error("Failed to establish a database connection after 5 attempts.");
        }
        return connection;
    }

    public static void closeConnection(Connection connection) {
        try {
            if (connection != null && !connection.isClosed()) {
                connection.close();
            }
        }
        catch (SQLException e) {
            logger.error("Error while closing DB connection: " + e.getMessage(), e);
        }
    }

    private static void setWALMode(Connection connection) {
        try (Statement stmt = connection.createStatement();){
            stmt.execute("PRAGMA journal_mode=WAL;");
            stmt.execute("PRAGMA synchronous=NORMAL;");
        }
        catch (SQLException e) {
            logger.error("Error while setting WAL mode: " + e.getMessage(), e);
        }
    }

    static {
        try {
            Class.forName("org.sqlite.JDBC");
            if (Environment.getEnvironment() == 1) {
                DB_URL = "jdbc:sqlite:wp_500DbFile.db";
            } else if (Environment.getEnvironment() == 2) {
                DB_URL = "jdbc:sqlite:/data/wp500_backup/backup/wp_500DbFile.db";
            }
        }
        catch (ClassNotFoundException e) {
            logger.error("Error while initializing SQLite JDBC driver: ", e);
        }
    }
}

