/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.sql_lite_db;

import com.tas.wp500.util.Environment;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.log4j.Logger;

public class SQLiteConnector {
    private static Logger logger = Logger.getLogger(SQLiteConnector.class);
    public static BasicDataSource ds = new BasicDataSource();

    public static Connection getConnection() {
        try {
            return ds.getConnection();
        }
        catch (SQLException e) {
            logger.error("Error while getting a connection from the pool: ", e);
            return null;
        }
    }

    public static void closeConnection(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException e) {
            logger.error("Error while closing a connection: ", e);
        }
    }

    static {
        try {
            Class.forName("org.sqlite.JDBC");
            if (Environment.getEnvironment() == 1) {
                ds.setUrl("jdbc:sqlite:wp_500DbFile.db");
            } else if (Environment.getEnvironment() == 2) {
                ds.setUrl("jdbc:sqlite:/usr/bin/wp_500DbFile.db");
            }
            ds.setDriverClassName("org.sqlite.JDBC");
            ds.setInitialSize(10);
            ds.setMaxTotal(50);
            ds.setMaxIdle(20);
            ds.setMinIdle(10);
        }
        catch (ClassNotFoundException e) {
            logger.error("Error while initializing data source: ", e);
        }
    }
}

