/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.sql_lite_db;

import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.passwordSetting.PasswordPolicyChecker;
import com.tas.wp500.security.Security;
import com.tas.wp500.sql_lite_db.SQLiteConnector;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Db_opertions
extends Security {
    private static Logger logger = Logger.getLogger(Db_opertions.class);
    private static Db_opertions instance = null;
    private static final int SQLITE_BUSY = 5;
    private static final int RETRY_COUNT = 5;
    private static final int RETRY_DELAY = 10000;

    private Db_opertions() {
        this.createUserTable();
    }

    public static Db_opertions getInstance() {
        if (instance == null) {
            instance = new Db_opertions();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createUserTable() {
        Connection connection = SQLiteConnector.getConnection();
        try {
            Statement statement = connection.createStatement();
            String sql = "CREATE TABLE IF NOT EXISTS user (id INTEGER PRIMARY KEY, username TEXT, password TEXT, first_name TEXT, last_name TEXT, role TEXT, first_login TEXT, totp_authenticator TEXT, totp_key TEXT, email TEXT)";
            statement.execute(sql);
            statement.close();
            logger.debug("User table created successfully.");
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.debug("Error while creating User table: " + e);
            FileBasedLogger.error("Application", "Error while creating User table: " + e, "system");
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertUserData(Connection connection, String username, String password, String first_name, String last_name, String role, String email, String user) {
        try {
            String sql = "INSERT INTO user (username, password, first_name, last_name, role, first_login, totp_authenticator, totp_key, email) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
            PreparedStatement statement = connection.prepareStatement(sql);
            statement.setString(1, Db_opertions.encrypt(username));
            statement.setString(2, Db_opertions.encrypt(password));
            statement.setString(3, Db_opertions.encrypt(first_name));
            statement.setString(4, Db_opertions.encrypt(last_name));
            statement.setString(5, Db_opertions.encrypt(role));
            statement.setString(6, Db_opertions.encrypt("true"));
            statement.setString(7, Db_opertions.encrypt("disable"));
            statement.setString(8, null);
            statement.setString(9, Db_opertions.encrypt(email));
            statement.executeUpdate();
            statement.close();
            logger.info("User data inserted successfully for username: " + username);
            FileBasedLogger.info("Audit", "User data inserted successfully for username: " + username, user);
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("Error while inserting data for user: " + username, e);
            FileBasedLogger.error("Audit", "Error while inserting data for user: " + username, user);
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateLogin(Connection connection, String username, String password) {
        try {
            String sql = "SELECT password FROM user WHERE username = ?";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setString(1, Db_opertions.encrypt(username));
                try (ResultSet resultSet = statement.executeQuery();){
                    if (resultSet.next()) {
                        String encryptedPasswordFromDb = resultSet.getString("password");
                        String decryptedPasswordFromDb = Db_opertions.decrypt(encryptedPasswordFromDb);
                        boolean bl = password.equals(decryptedPasswordFromDb);
                        return bl;
                    }
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("Error while validating login : " + e.getMessage());
            FileBasedLogger.info("Audit", "Error while validating login : " + e.getMessage(), username);
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getFirstLoginDetails(Connection connection, String username) {
        try {
            String sql = "SELECT first_login FROM user WHERE username = ?";
            PreparedStatement statement = connection.prepareStatement(sql);
            statement.setString(1, Db_opertions.encrypt(username));
            ResultSet resultSet = statement.executeQuery();
            if (resultSet.next()) {
                String first_login = Db_opertions.decrypt(resultSet.getString("first_login"));
                if (first_login.equalsIgnoreCase("true")) {
                    boolean bl = false;
                    return bl;
                }
                if (first_login.equalsIgnoreCase("false")) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("Error while validating first login parameter : " + e);
            FileBasedLogger.info("Audit", "Error while validating first login parameter : " + e.getLocalizedMessage(), username);
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTotpDetails(String username) {
        Connection connection = SQLiteConnector.getConnection();
        String totpAuthenticator = null;
        try {
            String sql = "SELECT totp_authenticator FROM user WHERE username=?";
            PreparedStatement statement = connection.prepareStatement(sql);
            statement.setString(1, Db_opertions.encrypt(username));
            ResultSet resultSet = statement.executeQuery();
            if (resultSet.next()) {
                totpAuthenticator = resultSet.getString("totp_authenticator");
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("Error while retrieving TOTP details : " + e);
            FileBasedLogger.info("Audit", "Error while retrieving 2fa details : " + e.getLocalizedMessage(), username);
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return Db_opertions.decrypt(totpAuthenticator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getTotpDetails(JSONObject json, String user) {
        Connection connection = SQLiteConnector.getConnection();
        JSONObject resultObj = new JSONObject();
        try {
            String sql = "SELECT totp_authenticator FROM user WHERE username=?";
            PreparedStatement statement = connection.prepareStatement(sql);
            statement.setString(1, Db_opertions.encrypt(json.getString("username")));
            ResultSet resultSet = statement.executeQuery();
            if (resultSet.next()) {
                String totpAuthenticator = resultSet.getString("totp_authenticator");
                resultObj.put("status", "success");
                resultObj.put("totp_authenticator", Db_opertions.decrypt(totpAuthenticator));
            } else {
                resultObj.put("status", "error");
                resultObj.put("msg", "User not found with the specified username.");
                logger.info("User not found.");
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException | JSONException e) {
            e.printStackTrace();
            logger.error("Error occurred while retrieving TOTP details : " + e);
            FileBasedLogger.error("Application", "Error occurred while retrieving TOTP details : " + e, user);
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject updateTotpDetails(JSONObject json, String user) {
        Connection connection = SQLiteConnector.getConnection();
        JSONObject resultObj = new JSONObject();
        try {
            String sql = "UPDATE user SET totp_authenticator = ? WHERE username = ?";
            PreparedStatement statement = connection.prepareStatement(sql);
            statement.setString(1, Db_opertions.encrypt(json.getString("totp_authenticator")));
            statement.setString(2, Db_opertions.encrypt(json.getString("username")));
            int rowsUpdated = statement.executeUpdate();
            statement.close();
            if (rowsUpdated > 0) {
                logger.info("TOTP details updated successfully.");
                FileBasedLogger.info("Application", "TOTP details updated successfully.", user);
                resultObj.put("status", "success");
                resultObj.put("msg", "TOTP details updated successfully.");
            } else {
                logger.info("Failed to update TOTP details.");
                FileBasedLogger.info("Application", "Failed to update TOTP details.", user);
                resultObj.put("status", "error");
                resultObj.put("msg", "No user found with the specified username.");
            }
        }
        catch (SQLException | JSONException e) {
            e.printStackTrace();
            FileBasedLogger.error("Application", "Error occurred while updating TOTP details : " + e, user);
            logger.error("Error occurred while updating TOTP details : " + e);
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return resultObj;
    }

    public int updateFirstLogin(Connection connection, String username) {
        int retries = 0;
        while (retries < 5) {
            int n;
            block16: {
                String sql = "UPDATE user SET first_login = ? WHERE username = ?";
                PreparedStatement pstmt = connection.prepareStatement(sql);
                try {
                    int executeUpdate;
                    pstmt.setString(1, Db_opertions.encrypt("false"));
                    pstmt.setString(2, Db_opertions.encrypt(username));
                    n = executeUpdate = pstmt.executeUpdate();
                    if (pstmt == null) break block16;
                }
                catch (Throwable executeUpdate) {
                    try {
                        try {
                            if (pstmt != null) {
                                try {
                                    pstmt.close();
                                }
                                catch (Throwable throwable) {
                                    executeUpdate.addSuppressed(throwable);
                                }
                            }
                            throw executeUpdate;
                        }
                        catch (SQLException e) {
                            if (e.getErrorCode() == 5) {
                                if (++retries < 5) {
                                    try {
                                        Thread.sleep(10000L);
                                    }
                                    catch (InterruptedException ie) {
                                        Thread.currentThread().interrupt();
                                    }
                                    continue;
                                }
                                e.printStackTrace();
                                logger.error("Error occurred while updating first login parameter : " + e);
                                FileBasedLogger.error("Application", "Error occurred while updating first login parameter : " + e, "system");
                                continue;
                            }
                            e.printStackTrace();
                            logger.error("Error occurred while updating first login parameter : " + e);
                            FileBasedLogger.error("Application", "Error occurred while updating first login parameter : " + e, "system");
                            continue;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        FileBasedLogger.error("Application", "Error occurred while updating first login parameter : " + e, "system");
                        logger.error("Error occurred while updating first login parameter : " + e);
                    }
                }
                pstmt.close();
            }
            return n;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserRole(String username, Connection connection) {
        try {
            String sql = "SELECT role FROM user WHERE username = ?";
            PreparedStatement statement = connection.prepareStatement(sql);
            statement.setString(1, Db_opertions.encrypt(username));
            ResultSet resultSet = statement.executeQuery();
            String role = resultSet.getString("role");
            String string = Db_opertions.decrypt(role);
            return string;
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("Error while getting role : " + e);
            FileBasedLogger.error("Audit", "Error while getting role : " + e.getMessage(), username);
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkIfUsernameExists(String username) {
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = SQLiteConnector.getConnection();
            try {
                String sql = "SELECT COUNT(*) as count FROM user WHERE username = ?";
                PreparedStatement statement = connection.prepareStatement(sql);
                statement.setString(1, Db_opertions.encrypt(username));
                ResultSet resultSet = statement.executeQuery();
                if (!resultSet.next()) continue;
                int count = resultSet.getInt("count");
                boolean bl = count > 0;
                return bl;
            }
            catch (SQLException e) {
                if (e.getErrorCode() != 5 || attempt == 4) {
                    e.printStackTrace();
                    logger.error("Error while checking user exits :" + e);
                    FileBasedLogger.error("Audit", "Error while checking user exits :" + e, username);
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSuperUserAvailable(String username) {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        boolean isAvailable = true;
        try {
            String encryptedRole;
            String decryptedRole;
            connection = SQLiteConnector.getConnection();
            String sql = "SELECT role FROM user WHERE username = ?";
            preparedStatement = connection.prepareStatement(sql);
            preparedStatement.setString(1, Db_opertions.encrypt(username));
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next() && "superuser".equalsIgnoreCase(decryptedRole = Db_opertions.decrypt(encryptedRole = resultSet.getString("role")))) {
                isAvailable = false;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("Error while checking");
            FileBasedLogger.info("Audit", "Error while checking superuser is exist :" + e.getLocalizedMessage(), username);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                SQLiteConnector.closeConnection(connection);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return isAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getPasswordList(Connection connection) {
        ArrayList<String> existingPasswords = new ArrayList<String>();
        try {
            String sql = "SELECT password FROM user";
            PreparedStatement statement = connection.prepareStatement(sql);
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                String password = Db_opertions.decrypt(resultSet.getString("password"));
                existingPasswords.add(password);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("Error while retrieving existing passwords: " + e);
            FileBasedLogger.error("Application", "Error while retrieving existing passwords: " + e, "system");
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return existingPasswords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getAllUsers(JSONObject json) {
        JSONObject resultObj = new JSONObject();
        Connection connection = SQLiteConnector.getConnection();
        try {
            JSONArray userArray = new JSONArray();
            String sql = "SELECT * FROM user";
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(sql);
            while (resultSet.next()) {
                try {
                    JSONObject obj = new JSONObject();
                    int id = resultSet.getInt("id");
                    String username = resultSet.getString("username");
                    String first_name = resultSet.getString("first_name");
                    String last_name = resultSet.getString("last_name");
                    String role = resultSet.getString("role");
                    String email = resultSet.getString("email");
                    obj.put("username", Db_opertions.decrypt(username));
                    obj.put("first_name", Db_opertions.decrypt(first_name));
                    obj.put("last_name", Db_opertions.decrypt(last_name));
                    obj.put("role", Db_opertions.decrypt(role));
                    obj.put("email", Db_opertions.decrypt(email));
                    userArray.put(obj);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            resultSet.close();
            statement.close();
            try {
                resultObj.put("status", "success");
                resultObj.put("msg", "Successfully fetched all users.");
                resultObj.put("result", userArray);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("Error while fetching all users : " + e);
                FileBasedLogger.error("Application", "Error while fetching all users : " + e, "system");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error occurred while fetching all users : " + e);
            FileBasedLogger.error("Application", "Error occurred while fetching all users : " + e, "system");
            try {
                resultObj.put("status", "fail");
                resultObj.put("msg", "Error while fetch all users. ");
            }
            catch (JSONException e1) {
                e1.printStackTrace();
            }
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject updateUser(JSONObject json, String user) {
        JSONObject resultObj = new JSONObject();
        Connection connection = SQLiteConnector.getConnection();
        try {
            String usernameToUpdate = json.getString("username");
            String newFirstName = json.getString("first_name");
            String newLastName = json.getString("last_name");
            String newRole = json.getString("user_role");
            String newEmail = json.getString("email");
            String sql = "UPDATE user SET first_name = ?, last_name = ?, role = ?, email = ? WHERE username = ?";
            PreparedStatement pstmt = connection.prepareStatement(sql);
            pstmt.setString(1, Db_opertions.encrypt(newFirstName));
            pstmt.setString(2, Db_opertions.encrypt(newLastName));
            pstmt.setString(3, Db_opertions.encrypt(newRole));
            pstmt.setString(4, Db_opertions.encrypt(newEmail));
            pstmt.setString(5, Db_opertions.encrypt(usernameToUpdate));
            int rowsAffected = pstmt.executeUpdate();
            pstmt.close();
            if (rowsAffected > 0) {
                String successMessage = "User '" + usernameToUpdate + "' has been updated successfully.";
                logger.info(successMessage);
                FileBasedLogger.info("Audit", successMessage, user);
                resultObj.put("status", "success");
                resultObj.put("msg", "User '" + usernameToUpdate + "' has been updated successfully.");
            } else {
                resultObj.put("status", "fail");
                resultObj.put("msg", "Failed to update user: " + usernameToUpdate);
                String failMessage = "Failed to update user: " + usernameToUpdate;
                logger.info(failMessage);
                FileBasedLogger.error("Audit", failMessage, user);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String errorMessage = "Error while updating user: " + e.getMessage();
            logger.error(errorMessage);
            FileBasedLogger.error("Audit", errorMessage, user);
            resultObj.put("status", "error");
            resultObj.put("msg", "Error while updating user: " + e.getMessage());
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject updateUserPassword(JSONObject json) {
        JSONObject resultObj = new JSONObject();
        Connection connection = SQLiteConnector.getConnection();
        try {
            String usernameToUpdate = json.getString("username");
            String newPassword = json.getString("password");
            String sql = "UPDATE user SET password = ? WHERE username = ?";
            PreparedStatement preparedStatement = connection.prepareStatement(sql);
            preparedStatement.setString(1, Db_opertions.encrypt(newPassword));
            preparedStatement.setString(2, Db_opertions.encrypt(usernameToUpdate));
            int rowsAffected = preparedStatement.executeUpdate();
            preparedStatement.close();
            if (rowsAffected > 0) {
                resultObj.put("status", "success");
                resultObj.put("msg", "Password changed successfully.");
                JSONObject jSONObject = resultObj;
                return jSONObject;
            }
            resultObj.put("status", "fail");
            resultObj.put("msg", "Failed to update password.");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while updating password : " + e);
            FileBasedLogger.error("Application", "Error while updating password : " + e, "system");
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject updateOldPassword(JSONObject json, String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        Connection connection = null;
        int retries = 0;
        if (retries < 5) {
            block21: {
                try {
                    connection = SQLiteConnector.getConnection();
                    if (!json.has("username") || !json.has("old_password") || !json.has("new_password")) break block21;
                    String username = json.getString("username");
                    String old_password = json.getString("old_password");
                    String new_password = json.getString("new_password");
                    String userQuery = "SELECT password FROM user WHERE username = ?";
                    PreparedStatement userStatement = connection.prepareStatement(userQuery);
                    userStatement.setString(1, Db_opertions.encrypt(username));
                    ResultSet userResultSet = userStatement.executeQuery();
                    if (userResultSet.next()) {
                        String encryptePasswordFromDB = userResultSet.getString("password");
                        String decryptedPassword = Db_opertions.decrypt(encryptePasswordFromDB);
                        if (decryptedPassword.equals(old_password)) {
                            JSONObject passwordPolicyCheck = PasswordPolicyChecker.passwordPolicyCheck(new_password, user);
                            if (passwordPolicyCheck.has("status") && passwordPolicyCheck.getString("status").equals("success")) {
                                if (!decryptedPassword.equals(new_password)) {
                                    try {
                                        ProcessBuilder changePasswordProcessBuilder = new ProcessBuilder("passwd", username);
                                        Process changePasswordProcess = changePasswordProcessBuilder.start();
                                        changePasswordProcess.getOutputStream().write((new_password + "\n").getBytes());
                                        changePasswordProcess.getOutputStream().flush();
                                        changePasswordProcess.getOutputStream().write((new_password + "\n").getBytes());
                                        changePasswordProcess.getOutputStream().flush();
                                        int exitCode = changePasswordProcess.waitFor();
                                        if (exitCode != 0) {
                                            logger.info("Error occurred while updating password for the user : " + user + " - " + username);
                                            FileBasedLogger.info("Audit", "Error occurred while updating password for the user : " + username, user);
                                            resultObj.put("status", "fail");
                                            resultObj.put("msg", "Error while changing password.");
                                            break block21;
                                        }
                                        String updateSql = "UPDATE user SET password = ? WHERE username = ?";
                                        PreparedStatement updateStatement = connection.prepareStatement(updateSql);
                                        updateStatement.setString(1, Db_opertions.encrypt(new_password));
                                        updateStatement.setString(2, Db_opertions.encrypt(username));
                                        updateStatement.executeUpdate();
                                        updateStatement.close();
                                        int updateFirstLogin = this.updateFirstLogin(connection, username);
                                        if (updateFirstLogin == 1) {
                                            logger.info("Password changed successfully for username : " + username);
                                            FileBasedLogger.info("Audit", "Password changed successfully for username : " + username, user);
                                            resultObj.put("status", "success");
                                            resultObj.put("msg", "Password changed successfully.");
                                            resultObj.put("first_login", "false");
                                            break block21;
                                        }
                                        resultObj.put("status", "fail");
                                        resultObj.put("msg", "Failed to update first_login password.");
                                        resultObj.put("first_login", "true");
                                        logger.info("Failed to change password for username : " + username);
                                        FileBasedLogger.error("Audit", "Failed to change password for username : " + username, user);
                                    }
                                    catch (IOException | InterruptedException e) {
                                        e.printStackTrace();
                                        logger.error("Error occurred while changing password : " + e);
                                        resultObj.put("status", "fail");
                                        resultObj.put("msg", "Error while changing password : " + e.getMessage());
                                        FileBasedLogger.error("Audit", "Error occurred while changing password : " + e.getMessage(), user);
                                    }
                                    break block21;
                                }
                                resultObj.put("status", "fail");
                                resultObj.put("msg", "New password is same as old password. Please try with new password.");
                                FileBasedLogger.info("Audit", "New password is same as old password. Please try with new password.", user);
                                break block21;
                            }
                            JSONObject jSONObject = passwordPolicyCheck;
                            return jSONObject;
                        }
                        resultObj.put("status", "fail");
                        resultObj.put("msg", "Old password does not match with existing password.");
                        FileBasedLogger.error("Audit", "Old password does not match with existing password.", user);
                        break block21;
                    }
                    resultObj.put("status", "fail");
                    resultObj.put("msg", "User not found.");
                }
                catch (SQLException | JSONException e) {
                    if (e instanceof SQLException && ((SQLException)e).getErrorCode() == 5) {
                        if (++retries < 5) {
                            try {
                                Thread.sleep(10000L);
                            }
                            catch (InterruptedException ie) {
                                Thread.currentThread().interrupt();
                            }
                        } else {
                            e.printStackTrace();
                            logger.error("Error occurred while updating password : " + e);
                            FileBasedLogger.error("Audit", "Error occurred while updating password : " + e.getLocalizedMessage(), user);
                            resultObj.put("status", "fail");
                            resultObj.put("msg", "Error while updating password : " + e.getMessage());
                        }
                    } else {
                        e.printStackTrace();
                        logger.error("Error occurred while updating password : " + e);
                        FileBasedLogger.error("Audit", "Error occurred while updating password : " + e.getLocalizedMessage(), user);
                        resultObj.put("status", "fail");
                        resultObj.put("msg", "Error while updating password : " + e.getMessage());
                    }
                }
                finally {
                    SQLiteConnector.closeConnection(connection);
                }
            }
            return resultObj;
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject deleteUser(Connection connection, String username, JSONObject json) {
        JSONObject resultObj = new JSONObject();
        try {
            String sql = "DELETE FROM user WHERE username = '" + Db_opertions.encrypt(username) + "'";
            Statement statement = connection.createStatement();
            int rowsAffected = statement.executeUpdate(sql);
            statement.close();
            if (rowsAffected > 0) {
                logger.info("User deleted successfully : " + username);
                resultObj.put("msg", "User " + username + " has been deleted successfully.");
                resultObj.put("status", "success");
            } else {
                resultObj.put("msg", username + " User not found.  ");
                resultObj.put("status", "fail");
            }
        }
        catch (Exception e) {
            logger.error("Error while deleting user : " + e);
            FileBasedLogger.error("Application", "Error while deleting user : " + e, "system");
            e.printStackTrace();
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEmailByUsername(String username) {
        Connection connection = SQLiteConnector.getConnection();
        String email = null;
        try {
            String sql = "SELECT email FROM user WHERE username = ?";
            PreparedStatement pstmt = connection.prepareStatement(sql);
            pstmt.setString(1, Db_opertions.encrypt(username));
            ResultSet resultSet = pstmt.executeQuery();
            if (resultSet.next()) {
                email = Db_opertions.decrypt(resultSet.getString("email"));
            }
            resultSet.close();
            pstmt.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("Error while fetching email for username " + username + ": " + e);
            FileBasedLogger.error("Application", "Error while fetching email for username " + username + ": " + e, "system");
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return email;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getUsersWithTOTPEnabled() {
        Connection connection = null;
        JSONArray usersArray = new JSONArray();
        JSONObject resultObj = new JSONObject();
        try {
            connection = SQLiteConnector.getConnection();
            String query = "SELECT username, totp_authenticator FROM user WHERE totp_authenticator = ?";
            PreparedStatement statement = connection.prepareStatement(query);
            statement.setString(1, Db_opertions.encrypt("enable"));
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                String username = Db_opertions.decrypt(resultSet.getString("username"));
                String totpAuthenticatorStatus = Db_opertions.decrypt(resultSet.getString("totp_authenticator"));
                JSONObject userObj = new JSONObject();
                userObj.put("username", username);
                userObj.put("totp_authenticator_status", totpAuthenticatorStatus);
                usersArray.put(userObj);
            }
            if (usersArray.length() > 0) {
                resultObj.put("status", "success");
                resultObj.put("data", usersArray);
            } else {
                resultObj.put("status", "fail");
                resultObj.put("msg", "No users with TOTP authenticator enabled.");
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException | JSONException e) {
            e.printStackTrace();
            resultObj.put("status", "error");
            resultObj.put("msg", "Error occurred while retrieving users with TOTP enabled.");
            logger.error("Error occurred while retrieving users with TOTP enabled: " + e.getMessage());
            FileBasedLogger.error("Application", "Error occurred while retrieving users with TOTP enabled: " + e.getMessage(), "system");
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return resultObj;
    }
}

