/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.snort.snortDBOperation;

import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.snort.ActiveThreats;
import com.tas.wp500.sql_lite_db.FileIntegrityAndSnortDBConnector;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Year;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SnortSettings {
    private static Logger logger = Logger.getLogger(SnortSettings.class);
    private static SnortSettings instance;
    private static final int SQLITE_BUSY = 5;
    private static final int RETRY_COUNT = 10;
    private static final int RETRY_DELAY = 10000;

    private SnortSettings() {
    }

    public static SnortSettings getInstance() {
        if (instance == null) {
            instance = new SnortSettings();
        }
        return instance;
    }

    public void createTableSnort() {
        this.createActiveThreatTable();
        this.createThreatLogTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createActiveThreatTable() {
        Connection connection = null;
        try {
            connection = FileIntegrityAndSnortDBConnector.getConnection();
            Statement statement = connection.createStatement();
            String sql1 = "CREATE TABLE IF NOT EXISTS active_threat (threat_id VARCHAR(255) NOT NULL, timeStamp DATETIME, priority VARCHAR(255), alertMessage VARCHAR(255), protocolType VARCHAR(255), srcIp VARCHAR(255), srcPort VARCHAR(255), destIp VARCHAR(255), destPort VARCHAR(255), ack_at DATETIME, ack_by VARCHAR(255))";
            String sql = "CREATE TABLE IF NOT EXISTS active_threat (threat_id VARCHAR(255) NOT NULL, timeStamp DATETIME, priority VARCHAR(255), alertMessage VARCHAR(255), protocolType VARCHAR(255), srcIp VARCHAR(255), srcPort VARCHAR(255), destIp VARCHAR(255), destPort VARCHAR(255), ack_at DATETIME, ack_by VARCHAR(255), classification VARCHAR(255) )";
            statement.execute(sql);
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("Error while creating ActiveSnortTable : " + e);
            FileBasedLogger.error("Security", "Error while creating ActiveSnortTable : " + e, "system");
        }
        finally {
            FileIntegrityAndSnortDBConnector.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieveActiveThreatData(String threatIdToRetrieve, String ack_at, String ack_by, String user) {
        Connection connection = null;
        try {
            connection = FileIntegrityAndSnortDBConnector.getConnection();
            String selectQuery = "SELECT * FROM active_threat WHERE threat_id = ?";
            PreparedStatement statement = connection.prepareStatement(selectQuery);
            statement.setString(1, threatIdToRetrieve);
            ResultSet resultSet = statement.executeQuery();
            String threatId = resultSet.getString("threat_id");
            String timeStamp = resultSet.getString("timeStamp");
            String priority = resultSet.getString("priority");
            String alertMessage = resultSet.getString("alertMessage");
            String protocolType = resultSet.getString("protocolType");
            String srcIp = resultSet.getString("srcIp");
            String srcPort = resultSet.getString("srcPort");
            String destIp = resultSet.getString("destIp");
            String destPort = resultSet.getString("destPort");
            String classification = resultSet.getString("classification");
            resultSet.close();
            statement.close();
            int insertThreatLogData = this.insertThreatLogData(threatIdToRetrieve, timeStamp, priority, alertMessage, protocolType, srcIp, srcPort, destIp, destPort, ack_at, ack_by, classification, connection, user);
            if (insertThreatLogData == 1) {
                logger.info("Successfully acknoleged Threats id : " + threatIdToRetrieve);
                FileBasedLogger.info("Audit", "Successfully acknoleged Threats id : " + threatIdToRetrieve, user);
                int deleteThreatById = this.deleteThreatById(threatIdToRetrieve, connection, user);
                if (deleteThreatById == 1) {
                    logger.info("Deleted Threats from Activee_threats table : " + threatIdToRetrieve);
                    FileBasedLogger.info("Audit", "Deleted Threats from Activee_threats table : " + threatIdToRetrieve, user);
                }
            } else {
                logger.info("Somthing wrong issue with inserting data into log threats : " + threatIdToRetrieve);
                FileBasedLogger.info("Audit", "Somthing wrong issue with inserting data into log threats : " + threatIdToRetrieve, user);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("Error while retrieving active threat data : " + e);
            FileBasedLogger.error("Security", "Error while retrieving active threat data : " + e, user);
        }
        finally {
            FileIntegrityAndSnortDBConnector.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createThreatLogTable() {
        Connection connection = null;
        try {
            connection = FileIntegrityAndSnortDBConnector.getConnection();
            Statement statement = connection.createStatement();
            String sql1 = "CREATE TABLE IF NOT EXISTS threat_logs (threat_id VARCHAR(255) NOT NULL, timeStamp DATETIME, priority VARCHAR(255), alertMessage VARCHAR(255), protocolType VARCHAR(255), srcIp VARCHAR(255), srcPort VARCHAR(255), destIp VARCHAR(255), destPort VARCHAR(255), ack_at DATETIME, ack_by VARCHAR(255))";
            String sql = "CREATE TABLE IF NOT EXISTS threat_logs (threat_id VARCHAR(255) NOT NULL, timeStamp DATETIME, priority VARCHAR(255), alertMessage VARCHAR(255), protocolType VARCHAR(255), srcIp VARCHAR(255), srcPort VARCHAR(255), destIp VARCHAR(255), destPort VARCHAR(255), ack_at DATETIME, ack_by VARCHAR(255), classification VARCHAR(255) )";
            statement.execute(sql);
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("Error while creating ActiveSnortTable : " + e);
            FileBasedLogger.error("Security", "Error while creating ActiveSnortTable : " + e, "system");
        }
        finally {
            FileIntegrityAndSnortDBConnector.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanOldThreatLogs() {
        Connection connection = null;
        try {
            connection = FileIntegrityAndSnortDBConnector.getConnection();
            String deleteQuery = "DELETE FROM threat_logs WHERE timeStamp < ?";
            LocalDate oneYearAgo = LocalDate.now().minusYears(1L);
            String formattedDate = oneYearAgo.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            PreparedStatement statement = connection.prepareStatement(deleteQuery);
            statement.setString(1, formattedDate);
            int deletedRows = statement.executeUpdate();
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("Error while cleaning old threat logs : " + e);
            FileBasedLogger.error("Security", "Error while cleaning old threat logs : " + e, "system");
        }
        finally {
            FileIntegrityAndSnortDBConnector.closeConnection(connection);
        }
    }

    public static String convertTimeFormat(String inputTime) {
        String inputFormat = "MM/dd-HH:mm:ss";
        String outputFormat = "MM-dd hh:mm:ss";
        SimpleDateFormat inputFormatter = new SimpleDateFormat(inputFormat);
        SimpleDateFormat outputFormatter = new SimpleDateFormat(outputFormat);
        try {
            Date date = inputFormatter.parse(inputTime.split("\\.")[0]);
            return Year.now().format(DateTimeFormatter.ofPattern("yyyy")) + "-" + outputFormatter.format(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            logger.error("Error while date time parsing : " + e);
            FileBasedLogger.error("Security", "Error while date time parsing : " + e, "system");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertOrUpdateData(String threat_id, String timeStamp, String priority, String alertMessage, String protocolType, String srcIp, String srcPort, String destIp, String destPort, String ack_at, String ack_by, String classification) {
        String selectSql = "SELECT COUNT(*) FROM active_threat WHERE threat_id = ?";
        String insertSql = "INSERT INTO active_threat (threat_id, timeStamp, priority, alertMessage, protocolType, srcIp, srcPort, destIp, destPort, ack_at, ack_by, classification) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        String updateSql = "UPDATE active_threat SET timeStamp = ?, priority = ?, alertMessage = ?, protocolType = ?, srcIp = ?, srcPort = ?, destIp = ?, destPort = ?, ack_at = ?, ack_by = ?, classification = ? WHERE threat_id = ?";
        for (int attempt = 0; attempt < 10; ++attempt) {
            Connection connection = null;
            try {
                connection = FileIntegrityAndSnortDBConnector.getConnection();
                PreparedStatement selectStatement = connection.prepareStatement(selectSql);
                PreparedStatement insertStatement = connection.prepareStatement(insertSql);
                PreparedStatement updateStatement = connection.prepareStatement(updateSql);
                selectStatement.setString(1, threat_id);
                ResultSet resultSet = selectStatement.executeQuery();
                resultSet.next();
                int rowCount = resultSet.getInt(1);
                if (rowCount > 0) {
                    updateStatement.setString(1, SnortSettings.convertTimeFormat(timeStamp));
                    updateStatement.setString(2, priority);
                    updateStatement.setString(3, alertMessage);
                    updateStatement.setString(4, protocolType);
                    updateStatement.setString(5, srcIp);
                    updateStatement.setString(6, srcPort);
                    updateStatement.setString(7, destIp);
                    updateStatement.setString(8, destPort);
                    updateStatement.setString(9, ack_at);
                    updateStatement.setString(10, ack_by);
                    updateStatement.setString(11, classification);
                    updateStatement.setString(12, threat_id);
                    int n = updateStatement.executeUpdate();
                    break;
                }
                insertStatement.setString(1, threat_id);
                insertStatement.setString(2, SnortSettings.convertTimeFormat(timeStamp));
                insertStatement.setString(3, priority);
                insertStatement.setString(4, alertMessage);
                insertStatement.setString(5, protocolType);
                insertStatement.setString(6, srcIp);
                insertStatement.setString(7, srcPort);
                insertStatement.setString(8, destIp);
                insertStatement.setString(9, destPort);
                insertStatement.setString(10, ack_at);
                insertStatement.setString(11, ack_by);
                insertStatement.setString(12, classification);
                insertStatement.executeUpdate();
                ActiveThreats insertThread = new ActiveThreats(threat_id, SnortSettings.convertTimeFormat(timeStamp), priority, alertMessage, protocolType, srcIp, srcPort, destIp, destPort, ack_at, ack_by);
                insertThread.start();
                break;
            }
            catch (SQLException e) {
                if (e.getErrorCode() != 5 || attempt == 9) {
                    e.printStackTrace();
                    logger.error("Error while inserting data : " + e);
                    FileBasedLogger.error("Security", "Error while inserting data : " + e, "system");
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                FileIntegrityAndSnortDBConnector.closeConnection(connection);
            }
        }
    }

    public int insertThreatLogData(String threatId, String timeStamp, String priority, String alertMessage, String protocolType, String srcIp, String srcPort, String destIp, String destPort, String ackAt, String ackBy, String classification, Connection connection, String user) {
        int executeUpdate = 0;
        try {
            String insertQuery1 = "INSERT INTO threat_logs (threat_id, timeStamp, priority, alertMessage, protocolType, srcIp, srcPort, destIp, destPort, ack_at, ack_by) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            String insertQuery = "INSERT INTO threat_logs (threat_id, timeStamp, priority, alertMessage, protocolType, srcIp, srcPort, destIp, destPort, ack_at, ack_by, classification) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            PreparedStatement statement = connection.prepareStatement(insertQuery);
            statement.setString(1, threatId);
            statement.setString(2, timeStamp);
            statement.setString(3, priority);
            statement.setString(4, alertMessage);
            statement.setString(5, protocolType);
            statement.setString(6, srcIp);
            statement.setString(7, srcPort);
            statement.setString(8, destIp);
            statement.setString(9, destPort);
            statement.setString(10, ackAt);
            statement.setString(11, ackBy);
            statement.setString(12, classification);
            executeUpdate = statement.executeUpdate();
            statement.close();
            logger.info("Data inserted into threat_logs table successfully. threat id : " + threatId);
            FileBasedLogger.info("Audit", "Data inserted into threat_logs table successfully. threat id : " + threatId, user);
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("Error while inserting data into threat_logs table : " + e);
            FileBasedLogger.error("Security", "Error while inserting data into threat_logs table : " + e, user);
        }
        return executeUpdate;
    }

    public JSONObject acknowlegeThreats(JSONObject json, String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        try {
            if (json.has("threats_ids") && json.has("ack_at") && json.has("ack_by")) {
                JSONArray threats_ids;
                String ack_at = json.getString("ack_at");
                String ack_by = json.getString("ack_by");
                try {
                    threats_ids = json.getJSONArray("threats_ids");
                }
                catch (Exception e) {
                    threats_ids = new JSONArray(json.getString("threats_ids"));
                }
                for (int i = 0; i < threats_ids.length(); ++i) {
                    String threats_id = threats_ids.get(i).toString();
                    this.retrieveActiveThreatData(threats_id, ack_at, ack_by, user);
                }
            } else {
                logger.error("Some input not found.");
                FileBasedLogger.error("Security", "Some input not found.", user);
            }
            resultObj.put("status", "success");
            resultObj.put("msg", "Successfully  acknowleged threats.");
            logger.info("Acknowleged threats successfully.");
            FileBasedLogger.info("Audit", "Acknowleged threats successfully.", user);
        }
        catch (Exception e) {
            e.printStackTrace();
            resultObj.put("status", "fail");
            resultObj.put("msg", "Failed to acknowleged threats.");
            logger.error("Failed to acknowledge threats : " + e);
            FileBasedLogger.error("Security", "Failed to acknowledge threats : " + e, user);
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getAllActiveThreatsList(String user) {
        JSONObject resultObj = new JSONObject();
        Connection connection = null;
        JSONArray resultArray = null;
        try {
            connection = FileIntegrityAndSnortDBConnector.getConnection();
            String selectSQL = "SELECT * FROM active_threat";
            PreparedStatement preparedStatement = connection.prepareStatement(selectSQL);
            ResultSet resultSet = preparedStatement.executeQuery();
            resultArray = new JSONArray();
            while (resultSet.next()) {
                JSONObject threat = new JSONObject();
                String threatId = resultSet.getString("threat_id");
                String timeStamp = resultSet.getString("timeStamp");
                String priority = resultSet.getString("priority");
                String alertMessage = resultSet.getString("alertMessage");
                String protocolType = resultSet.getString("protocolType");
                String srcIp = resultSet.getString("srcIp");
                String srcPort = resultSet.getString("srcPort");
                String destIp = resultSet.getString("destIp");
                String destPort = resultSet.getString("destPort");
                String ackAt = resultSet.getString("ack_at");
                String ackBy = resultSet.getString("ack_by");
                String classification = resultSet.getString("classification");
                threat.put("threat_id", threatId);
                threat.put("timestamp", timeStamp);
                threat.put("priority", priority);
                threat.put("alert_message", alertMessage);
                threat.put("protocol_type", protocolType);
                threat.put("src_ip", srcIp);
                threat.put("src_port", Integer.parseInt(srcPort));
                threat.put("dest_ip", destIp);
                threat.put("dest_port", Integer.parseInt(destPort));
                threat.put("ack_at", ackAt);
                threat.put("ack_by", ackBy);
                threat.put("classification", classification);
                resultArray.put(threat);
            }
            resultObj.put("status", "success");
            resultObj.put("data", resultArray);
            resultObj.put("msg", "Active threat successfully fetched.");
            logger.info("Active threat successfully fetched.");
            FileBasedLogger.info("Audit", "Active threat successfully fetched.", user);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error occurred while getting all threats records : " + e);
            FileBasedLogger.error("Security", "Error occurred while getting all threats records : " + e, user);
            resultObj.put("status", "fail");
            resultObj.put("data", resultArray);
            resultObj.put("msg", "Failed to fetch active threat list.");
        }
        finally {
            FileIntegrityAndSnortDBConnector.closeConnection(connection);
        }
        return resultObj;
    }

    public int deleteThreatById(String threatId, Connection connection, String user) {
        int executeUpdate = 0;
        try {
            String deleteQuery = "DELETE FROM active_threat WHERE threat_id = ?";
            PreparedStatement statement = connection.prepareStatement(deleteQuery);
            statement.setString(1, threatId);
            executeUpdate = statement.executeUpdate();
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            FileBasedLogger.error("Audit", "Error while deleting record from active_threat table : " + e, user);
            logger.error("Error while deleting record from active_threat table : " + e);
        }
        return executeUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getAllThreatLogs(String user) {
        JSONObject resultObj = new JSONObject();
        Connection connection = null;
        JSONArray resultArray = new JSONArray();
        try {
            connection = FileIntegrityAndSnortDBConnector.getConnection();
            String selectSQL = "SELECT * FROM threat_logs";
            PreparedStatement preparedStatement = connection.prepareStatement(selectSQL);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                JSONObject threatLog = new JSONObject();
                String threatId = resultSet.getString("threat_id");
                String timeStamp = resultSet.getString("timeStamp");
                String priority = resultSet.getString("priority");
                String alertMessage = resultSet.getString("alertMessage");
                String protocolType = resultSet.getString("protocolType");
                String srcIp = resultSet.getString("srcIp");
                String srcPort = resultSet.getString("srcPort");
                String destIp = resultSet.getString("destIp");
                String destPort = resultSet.getString("destPort");
                String ackAt = resultSet.getString("ack_at");
                String ackBy = resultSet.getString("ack_by");
                String classification = resultSet.getString("classification");
                threatLog.put("threat_id", threatId);
                threatLog.put("timestamp", timeStamp);
                threatLog.put("priority", priority);
                threatLog.put("alert_message", alertMessage);
                threatLog.put("protocol_type", protocolType);
                threatLog.put("src_ip", srcIp);
                threatLog.put("src_port", Integer.parseInt(srcPort));
                threatLog.put("dest_ip", destIp);
                threatLog.put("dest_port", Integer.parseInt(destPort));
                threatLog.put("ack_at", ackAt);
                threatLog.put("ack_by", ackBy);
                threatLog.put("classification", classification);
                resultArray.put(threatLog);
            }
            resultObj.put("status", "success");
            resultObj.put("data", resultArray);
            resultObj.put("msg", "Threat logs successfully fetched.");
            logger.info("Threat logs successfully fetched.");
            FileBasedLogger.info("Audit", "Threat logs successfully fetched.", user);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error occurred while getting threat logs records : " + e);
            FileBasedLogger.error("Security", "Error occurred while getting threat logs records : " + e, user);
            resultObj.put("status", "fail");
            resultObj.put("data", resultArray);
            resultObj.put("msg", "Error while fetching threat logs.");
        }
        finally {
            FileIntegrityAndSnortDBConnector.closeConnection(connection);
        }
        return resultObj;
    }

    public JSONObject getThreatsCount(String user) {
        JSONObject resultObj = new JSONObject();
        try {
            resultObj.put("active_threats_count", this.getActiveThreatsCount(user));
            resultObj.put("threats_log_count", this.getThreatLogsCount(user));
            resultObj.put("total_count", this.getActiveThreatsCount(user) + this.getThreatLogsCount(user));
            resultObj.put("last_update", this.getLatestActiveThreatTimestamp(user));
            resultObj.put("status_service", this.isServiceRunning(user));
            resultObj.put("status", "success");
            resultObj.put("msg", "Fetched threats count successfully.");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error occurred while getting count of Threats : " + e);
            FileBasedLogger.error("Security", "Error occurred while getting count of Threats : " + e, user);
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLatestActiveThreatTimestamp(String user) {
        Connection connection = null;
        try {
            connection = FileIntegrityAndSnortDBConnector.getConnection();
            String selectSQL = "SELECT timeStamp FROM active_threat ORDER BY timeStamp DESC LIMIT 1";
            PreparedStatement preparedStatement = connection.prepareStatement(selectSQL);
            ResultSet resultSet = preparedStatement.executeQuery();
            String string = resultSet.getString("timeStamp");
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while getting the latest active threat timestamp : " + e);
            FileBasedLogger.error("Security", "Error while getting the latest active threat timestamp : " + e, user);
        }
        finally {
            FileIntegrityAndSnortDBConnector.closeConnection(connection);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveThreatsCount(String user) {
        int count = 0;
        Connection connection = null;
        try {
            connection = FileIntegrityAndSnortDBConnector.getConnection();
            String countSQL = "SELECT COUNT(*) AS threat_count FROM active_threat";
            PreparedStatement preparedStatement = connection.prepareStatement(countSQL);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                count = resultSet.getInt("threat_count");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while getting count of active threats : " + e);
            FileBasedLogger.error("Security", "Error while getting count of active threats : " + e, user);
        }
        finally {
            FileIntegrityAndSnortDBConnector.closeConnection(connection);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getThreatLogsCount(String user) {
        int count = 0;
        Connection connection = null;
        try {
            connection = FileIntegrityAndSnortDBConnector.getConnection();
            String countSQL = "SELECT COUNT(*) AS log_count FROM threat_logs";
            PreparedStatement preparedStatement = connection.prepareStatement(countSQL);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                count = resultSet.getInt("log_count");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while getting count of threat logs : " + e);
            FileBasedLogger.error("Security", "Error while getting count of threat logs : " + e, user);
        }
        finally {
            FileIntegrityAndSnortDBConnector.closeConnection(connection);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getLatestFiveActiveThreats(String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        Connection connection = null;
        JSONArray resultArray = new JSONArray();
        try {
            connection = FileIntegrityAndSnortDBConnector.getConnection();
            String selectSQL = "SELECT * FROM active_threat ORDER BY timeStamp DESC LIMIT 5";
            PreparedStatement preparedStatement = connection.prepareStatement(selectSQL);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                JSONObject threat = new JSONObject();
                threat.put("threat_id", resultSet.getString("threat_id"));
                threat.put("timeStamp", resultSet.getString("timeStamp"));
                threat.put("priority", resultSet.getString("priority"));
                threat.put("alertMessage", resultSet.getString("alertMessage"));
                threat.put("protocolType", resultSet.getString("protocolType"));
                threat.put("srcIp", resultSet.getString("srcIp"));
                threat.put("srcPort", Integer.parseInt(resultSet.getString("srcPort")));
                threat.put("destIp", resultSet.getString("destIp"));
                threat.put("destPort", Integer.parseInt(resultSet.getString("destPort")));
                threat.put("ack_at", resultSet.getString("ack_at"));
                threat.put("ack_by", resultSet.getString("ack_by"));
                threat.put("classification", resultSet.getString("classification"));
                resultArray.put(threat);
            }
            resultObj.put("status", "success");
            resultObj.put("data", resultArray);
            resultObj.put("msg", " Fetched latest five threats successfully.");
            logger.info("Fetched latest five threats successfully.");
            FileBasedLogger.info("Audit", "Fetched latest five threats successfully.", user);
        }
        catch (Exception e) {
            e.printStackTrace();
            resultObj.put("status", "fail");
            resultObj.put("data", resultArray);
            resultObj.put("msg", "Failed to fetch latest five threats.");
            FileBasedLogger.error("Audit", "Error occurred while getting latest five active threats : " + e, user);
            logger.error("Error occurred while getting latest five active threats : " + e);
        }
        finally {
            FileIntegrityAndSnortDBConnector.closeConnection(connection);
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray getActiveThreatsBetweenTimestamps(String startTime, String endTime) {
        Connection connection = null;
        JSONArray resultArray = new JSONArray();
        try {
            connection = FileIntegrityAndSnortDBConnector.getConnection();
            String selectSQL = "SELECT * FROM active_threat WHERE timeStamp BETWEEN ? AND ?";
            PreparedStatement preparedStatement = connection.prepareStatement(selectSQL);
            preparedStatement.setString(1, startTime);
            preparedStatement.setString(2, endTime);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                JSONObject threat = new JSONObject();
                threat.put("threat_id", resultSet.getString("threat_id"));
                threat.put("timeStamp", resultSet.getString("timeStamp"));
                threat.put("priority", resultSet.getString("priority"));
                threat.put("alertMessage", resultSet.getString("alertMessage"));
                threat.put("protocolType", resultSet.getString("protocolType"));
                threat.put("srcIp", resultSet.getString("srcIp"));
                threat.put("srcPort", Integer.parseInt(resultSet.getString("srcPort")));
                threat.put("destIp", resultSet.getString("destIp"));
                threat.put("destPort", Integer.parseInt(resultSet.getString("destPort")));
                threat.put("ack_at", resultSet.getString("ack_at"));
                threat.put("ack_by", resultSet.getString("ack_by"));
                threat.put("classification", resultSet.getString("classification"));
                resultArray.put(threat);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while getting active threats between timestamps : " + e);
            FileBasedLogger.error("Security", "Error while getting active threats between timestamps : " + e, "system");
        }
        finally {
            FileIntegrityAndSnortDBConnector.closeConnection(connection);
        }
        return resultArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray getThreatLogsBetweenTimestamps(String startTime, String endTime) {
        JSONArray threatLogs = new JSONArray();
        Connection connection = null;
        try {
            connection = FileIntegrityAndSnortDBConnector.getConnection();
            String selectSQL = "SELECT * FROM threat_logs WHERE timeStamp BETWEEN ? AND ?";
            PreparedStatement preparedStatement = connection.prepareStatement(selectSQL);
            preparedStatement.setString(1, startTime);
            preparedStatement.setString(2, endTime);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                JSONObject threatLog = new JSONObject();
                threatLog.put("threat_id", resultSet.getString("threat_id"));
                threatLog.put("timeStamp", resultSet.getString("timeStamp"));
                threatLog.put("priority", resultSet.getString("priority"));
                threatLog.put("alertMessage", resultSet.getString("alertMessage"));
                threatLog.put("protocolType", resultSet.getString("protocolType"));
                threatLog.put("srcIp", resultSet.getString("srcIp"));
                threatLog.put("srcPort", Integer.parseInt(resultSet.getString("srcPort")));
                threatLog.put("destIp", resultSet.getString("destIp"));
                threatLog.put("destPort", Integer.parseInt(resultSet.getString("destPort")));
                threatLog.put("ack_at", resultSet.getString("ack_at"));
                threatLog.put("ack_by", resultSet.getString("ack_by"));
                threatLog.put("classification", resultSet.getString("classification"));
                threatLogs.put(threatLog);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while getting threat logs between timestamps : " + e);
            FileBasedLogger.error("Application", "Error while getting threat logs between timestamps : " + e, "system");
        }
        finally {
            FileIntegrityAndSnortDBConnector.closeConnection(connection);
        }
        return threatLogs;
    }

    public JSONObject getActiveThreatsBetweenTwoDate(JSONObject obj, String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        try {
            String startTime = obj.getString("start_time");
            String endTime = obj.getString("end_time");
            JSONArray activeThreats = this.getActiveThreatsBetweenTimestamps(startTime, endTime);
            resultObj.put("data", activeThreats);
            resultObj.put("status", "success");
            resultObj.put("msg", "Active threats fetched successfully.");
        }
        catch (Exception e) {
            logger.error("Error while fetcheing active threats between two dates : " + e);
            FileBasedLogger.error("Security", "Error while fetcheing active threats between two dates : " + e, user);
            e.printStackTrace();
            resultObj.put("status", "fail");
            resultObj.put("msg", "Failed to fetch active threats.");
            resultObj.put("data", new JSONArray());
        }
        return resultObj;
    }

    public JSONObject getThreatsLogsBetweenTwoDate(JSONObject obj, String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        try {
            String startTime = obj.getString("start_time");
            String endTime = obj.getString("end_time");
            JSONArray activeThreats = this.getThreatLogsBetweenTimestamps(startTime, endTime);
            resultObj.put("data", activeThreats);
            resultObj.put("status", "success");
            resultObj.put("msg", "Threats logs fetched successfully.");
        }
        catch (Exception e) {
            logger.error("Error while fetcheing active threats between two dates : " + e);
            FileBasedLogger.error("Security", "Error while fetcheing active threats between two dates : " + e, user);
            e.printStackTrace();
            resultObj.put("status", "fail");
            resultObj.put("msg", "Failed to fetch threats logs.");
            resultObj.put("data", new JSONArray());
        }
        return resultObj;
    }

    public JSONObject getThreatsDataBetweenTowDates(JSONObject json, String user) {
        JSONObject resultObj = new JSONObject();
        try {
            String threats_type = json.getString("threats_type");
            resultObj.put("status", "fail");
            resultObj.put("msg", "Failed to fetch threats.");
            resultObj.put("data", new JSONArray());
            if (threats_type.equalsIgnoreCase("active_threat")) {
                return this.getActiveThreatsBetweenTwoDate(json, user);
            }
            if (threats_type.equalsIgnoreCase("threat_logs")) {
                return this.getThreatsLogsBetweenTwoDate(json, user);
            }
            FileBasedLogger.info("Security", "Failed to fetch threats.", user);
        }
        catch (Exception e) {
            e.printStackTrace();
            FileBasedLogger.error("Security", "Error occurred while fetching threats : " + e, user);
            logger.error("Error occurred while fetching threats : " + e);
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Integer> countThreatsPerDayFromActiveThreats(String startTime, String endTime) {
        HashMap<String, Integer> threatCounts = new HashMap<String, Integer>();
        Connection connection = null;
        try {
            connection = FileIntegrityAndSnortDBConnector.getConnection();
            String selectSQL = "SELECT COUNT(*) FROM active_threat WHERE timeStamp BETWEEN ? AND ?";
            PreparedStatement preparedStatement = connection.prepareStatement(selectSQL);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            LocalDateTime startDateTime = LocalDateTime.parse(startTime, formatter);
            LocalDateTime endDateTime = LocalDateTime.parse(endTime, formatter);
            while (!startDateTime.isAfter(endDateTime)) {
                preparedStatement.setString(1, startDateTime.format(formatter));
                preparedStatement.setString(2, startDateTime.plusDays(1L).format(formatter));
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    threatCounts.put(startDateTime.toLocalDate().toString(), resultSet.getInt(1));
                }
                startDateTime = startDateTime.plusDays(1L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(" Error occurred while counting threats per day : " + e);
            FileBasedLogger.error("Security", " Error occurred while counting threats per day : " + e, "system");
        }
        finally {
            FileIntegrityAndSnortDBConnector.closeConnection(connection);
        }
        return threatCounts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Integer> countThreatsPerDayFromThreatsLog(String startTime, String endTime) {
        HashMap<String, Integer> threatCounts = new HashMap<String, Integer>();
        Connection connection = null;
        try {
            connection = FileIntegrityAndSnortDBConnector.getConnection();
            String selectSQL = "SELECT DATE(timeStamp) AS date, COUNT(*) AS count FROM threat_logs WHERE timeStamp BETWEEN ? AND ? GROUP BY date";
            PreparedStatement preparedStatement = connection.prepareStatement(selectSQL);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            LocalDateTime startDateTime = LocalDateTime.parse(startTime, formatter);
            LocalDateTime endDateTime = LocalDateTime.parse(endTime, formatter);
            while (!startDateTime.isAfter(endDateTime)) {
                preparedStatement.setString(1, startDateTime.format(formatter));
                preparedStatement.setString(2, startDateTime.plusDays(1L).format(formatter));
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    threatCounts.put(startDateTime.toLocalDate().toString(), resultSet.getInt("count"));
                }
                startDateTime = startDateTime.plusDays(1L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while counting threats per day : " + e);
            FileBasedLogger.error("Security", "Error while counting threats per day : " + e, "system");
        }
        finally {
            FileIntegrityAndSnortDBConnector.closeConnection(connection);
        }
        return threatCounts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedHashMap<String, Integer> countThreatsPerDayForBothTable(String startTime, String endTime, String user) {
        LinkedHashMap<String, Integer> threatCounts = new LinkedHashMap<String, Integer>();
        Connection connection = null;
        try {
            connection = FileIntegrityAndSnortDBConnector.getConnection();
            String selectActiveSQL = "SELECT DATE(timeStamp) AS date, COUNT(*) AS count FROM active_threat WHERE timeStamp BETWEEN ? AND ? GROUP BY date";
            PreparedStatement activeStatement = connection.prepareStatement(selectActiveSQL);
            String selectLogsSQL = "SELECT DATE(timeStamp) AS date, COUNT(*) AS count FROM threat_logs WHERE timeStamp BETWEEN ? AND ? GROUP BY date";
            PreparedStatement logsStatement = connection.prepareStatement(selectLogsSQL);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            LocalDateTime startDateTime = LocalDateTime.parse(startTime, formatter);
            LocalDateTime endDateTime = LocalDateTime.parse(endTime, formatter);
            while (!startDateTime.isAfter(endDateTime)) {
                String startDateStr = startDateTime.format(formatter);
                String endDateStr = startDateTime.plusDays(1L).format(formatter);
                activeStatement.setString(1, startDateStr);
                activeStatement.setString(2, endDateStr);
                logsStatement.setString(1, startDateStr);
                logsStatement.setString(2, endDateStr);
                ResultSet activeResultSet = activeStatement.executeQuery();
                ResultSet logsResultSet = logsStatement.executeQuery();
                int totalCount = 0;
                if (activeResultSet.next()) {
                    totalCount += activeResultSet.getInt("count");
                }
                if (logsResultSet.next()) {
                    totalCount += logsResultSet.getInt("count");
                }
                threatCounts.put(startDateTime.toLocalDate().toString(), totalCount);
                startDateTime = startDateTime.plusDays(1L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error occurred while counting threats per day : " + e);
            FileBasedLogger.error("Security", "Error occurred while counting threats per day : " + e, user);
        }
        finally {
            FileIntegrityAndSnortDBConnector.closeConnection(connection);
        }
        return threatCounts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void countPriorityThreatsByDay(String startTime, String endTime) {
        Connection connection = null;
        try {
            connection = FileIntegrityAndSnortDBConnector.getConnection();
            String selectSQL = "SELECT DATE(timeStamp) AS date, priority, COUNT(*) AS priority_count FROM active_threat WHERE timeStamp BETWEEN ? AND ? GROUP BY date, priority";
            PreparedStatement preparedStatement = connection.prepareStatement(selectSQL);
            preparedStatement.setString(1, startTime);
            preparedStatement.setString(2, endTime);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String date = resultSet.getString("date");
                int priority = resultSet.getInt("priority");
                int n = resultSet.getInt("priority_count");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("Error while counting priority threats : " + e);
            FileBasedLogger.error("Security", "Error while counting priority threats : " + e, "system");
        }
        finally {
            FileIntegrityAndSnortDBConnector.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Integer> countSrcIPOccurrences(String startTime, String endTime) {
        Connection connection = null;
        HashMap<String, Integer> srcIpCounts = new HashMap<String, Integer>();
        try {
            connection = FileIntegrityAndSnortDBConnector.getConnection();
            String selectSQL = "SELECT srcIp, COUNT(*) AS count FROM active_threat WHERE timeStamp BETWEEN ? AND ? GROUP BY srcIp";
            PreparedStatement preparedStatement = connection.prepareStatement(selectSQL);
            preparedStatement.setString(1, startTime);
            preparedStatement.setString(2, endTime);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String srcIp = resultSet.getString("srcIp");
                int count = resultSet.getInt("count");
                srcIpCounts.put(srcIp, count);
                System.out.println("src_ip = " + srcIp + " count = " + count);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("Error while counting src_ip occurrences : " + e);
            FileBasedLogger.error("Security", "Error while counting src_ip occurrences : " + e, "system");
        }
        finally {
            FileIntegrityAndSnortDBConnector.closeConnection(connection);
        }
        return srcIpCounts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Integer> countDestIPOccurrences(String startTime, String endTime) {
        Connection connection = null;
        HashMap<String, Integer> destIpCounts = new HashMap<String, Integer>();
        try {
            connection = FileIntegrityAndSnortDBConnector.getConnection();
            String selectSQL = "SELECT destIp, COUNT(*) AS count FROM active_threat WHERE timeStamp BETWEEN ? AND ? GROUP BY destIp";
            PreparedStatement preparedStatement = connection.prepareStatement(selectSQL);
            preparedStatement.setString(1, startTime);
            preparedStatement.setString(2, endTime);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String destIp = resultSet.getString("destIp");
                int count = resultSet.getInt("count");
                destIpCounts.put(destIp, count);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("Error while counting destIp occurrences : " + e);
            FileBasedLogger.error("Security", "Error while counting destIp occurrences : " + e, "system");
        }
        finally {
            FileIntegrityAndSnortDBConnector.closeConnection(connection);
        }
        return destIpCounts;
    }

    public JSONObject countThreatsPerDayForBothTable(JSONObject json, String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        try {
            LinkedHashMap<String, Integer> countThreatsPerDayForBothTable = this.countThreatsPerDayForBothTable(json.getString("start_time"), json.getString("end_time"), user);
            resultObj.put("data", countThreatsPerDayForBothTable);
            resultObj.put("status", "success");
            resultObj.put("msg", "Successfully fetched data. ");
        }
        catch (Exception e) {
            e.printStackTrace();
            resultObj.put("data", new HashMap());
            resultObj.put("status", "fail");
            resultObj.put("msg", "Failed to  fetched data. ");
            logger.error("Error occured during getting ip count from table : " + e);
            FileBasedLogger.error("Security", "Error occured during getting ip count from table : " + e, user);
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedHashMap<String, Map<Integer, Integer>> countThreatsPriorityPerDayForBothTable(String startTime, String endTime, String user) {
        LinkedHashMap<String, Map<Integer, Integer>> threatCounts = new LinkedHashMap<String, Map<Integer, Integer>>();
        Connection connection = null;
        try {
            connection = FileIntegrityAndSnortDBConnector.getConnection();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            LocalDateTime startDateTime = LocalDateTime.parse(startTime, formatter);
            LocalDateTime endDateTime = LocalDateTime.parse(endTime, formatter);
            while (!startDateTime.isAfter(endDateTime)) {
                String startDateStr = startDateTime.format(formatter);
                String endDateStr = startDateTime.plusDays(1L).format(formatter);
                HashMap<Integer, Integer> priorityCounts = new HashMap<Integer, Integer>();
                for (int priority = 1; priority <= 3; ++priority) {
                    String selectSQL = "SELECT COUNT(*) AS count FROM active_threat WHERE timeStamp BETWEEN ? AND ? AND priority = ?";
                    PreparedStatement preparedStatement = connection.prepareStatement(selectSQL);
                    preparedStatement.setString(1, startDateStr);
                    preparedStatement.setString(2, endDateStr);
                    preparedStatement.setInt(3, priority);
                    ResultSet resultSet = preparedStatement.executeQuery();
                    int totalCount = 0;
                    if (resultSet.next()) {
                        totalCount = resultSet.getInt("count");
                    }
                    String selectSQL_log = "SELECT COUNT(*) AS count FROM threat_logs WHERE timeStamp BETWEEN ? AND ? AND priority = ?";
                    PreparedStatement preparedStatement_log = connection.prepareStatement(selectSQL_log);
                    preparedStatement_log.setString(1, startDateStr);
                    preparedStatement_log.setString(2, endDateStr);
                    preparedStatement_log.setInt(3, priority);
                    ResultSet resultSet_log = preparedStatement_log.executeQuery();
                    if (resultSet_log.next()) {
                        totalCount += resultSet_log.getInt("count");
                    }
                    priorityCounts.put(priority, totalCount);
                }
                threatCounts.put(startDateTime.toLocalDate().toString(), priorityCounts);
                startDateTime = startDateTime.plusDays(1L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while counting threats per day : " + e);
            FileBasedLogger.error("Security", "Error while counting threats per day : " + e, user);
        }
        finally {
            FileIntegrityAndSnortDBConnector.closeConnection(connection);
        }
        return threatCounts;
    }

    public JSONObject countThreatsPriorityPerDayForBothTable(JSONObject json, String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        try {
            LinkedHashMap<String, Map<Integer, Integer>> countThreatsPriorityPerDayForBothTable = this.countThreatsPriorityPerDayForBothTable(json.getString("start_time"), json.getString("end_time"), user);
            resultObj.put("status", "success");
            resultObj.put("msg", "Priority count fetched successfully.");
            resultObj.put("data", countThreatsPriorityPerDayForBothTable);
            logger.info(user + " - Fetched priority count successfully.");
            FileBasedLogger.info("Audit", "Priority count fetched successfully.", user);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error occurred while getting priority ciount day wise : " + e);
            FileBasedLogger.error("Security", "Error occurred while getting priority ciount day wise : " + e, user);
            resultObj.put("status", "fail");
            resultObj.put("msg", "Failed to fetch priority count day wise. ");
            resultObj.put("data", new HashMap());
        }
        return resultObj;
    }

    private String isServiceRunning(String user) {
        try {
            String line;
            String serviceName = "snort_wp500.service";
            String command = "systemctl is-active " + serviceName;
            Process process = Runtime.getRuntime().exec(command);
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            StringBuilder output = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                output.append(line);
            }
            int exitCode = process.waitFor();
            if (exitCode == 0 && output.toString().trim().equals("active")) {
                return "success";
            }
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            FileBasedLogger.error("Security", "Error occured while checking snort service is running or not : " + e.getLocalizedMessage(), user);
        }
        return "fail";
    }
}

