/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.snort;

import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.snort.snortDBOperation.Threats;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class ThreatParser {
    private Logger logger = Logger.getLogger(ThreatParser.class);
    private static ThreatParser instance;

    private ThreatParser() {
    }

    public static ThreatParser getInstance() {
        if (instance == null) {
            instance = new ThreatParser();
        }
        return instance;
    }

    public ArrayList<Threats> executeTailCommandAndGetSnortResult() {
        ArrayList<Threats> threatList;
        block22: {
            threatList = new ArrayList<Threats>();
            try {
                String directory = "/var/log/snort/";
                String currentDateString = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
                String currentDateFilePath = directory + currentDateString + "/alert";
                Path dirPath = Paths.get(directory, new String[0]);
                if (Files.exists(dirPath, new LinkOption[0]) && Files.isDirectory(dirPath, new LinkOption[0])) {
                    Path latestFilePath = null;
                    LocalDate latestDate = LocalDate.MIN;
                    try (DirectoryStream<Path> stream = Files.newDirectoryStream(dirPath);){
                        for (Path subPath : stream) {
                            if (!Files.isDirectory(subPath, new LinkOption[0])) continue;
                            String subdirectoryName = subPath.getFileName().toString();
                            try {
                                LocalDate subdirectoryDate = LocalDate.parse(subdirectoryName, DateTimeFormatter.ofPattern("yyyyMMdd"));
                                if (!subdirectoryDate.isAfter(latestDate)) continue;
                                latestDate = subdirectoryDate;
                                latestFilePath = subPath.resolve("alert");
                            }
                            catch (DateTimeParseException e) {}
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        FileBasedLogger.error("Security", "Error while sorting snort file path : " + e.getLocalizedMessage(), "system");
                    }
                    Path currentDateFilePathObj = Paths.get(currentDateFilePath, new String[0]);
                    if (Files.exists(currentDateFilePathObj, new LinkOption[0]) && Files.isRegularFile(currentDateFilePathObj, new LinkOption[0])) {
                        latestFilePath = currentDateFilePathObj;
                    } else if (latestFilePath == null) {
                        this.logger.info("No valid Snort alert files found.");
                        FileBasedLogger.info("Security", "No valid Snort alert files found.", "system");
                    }
                    if (latestFilePath != null && Files.exists(latestFilePath, new LinkOption[0]) && Files.isRegularFile(latestFilePath, new LinkOption[0])) {
                        String line;
                        String[] command = System.getProperty("os.name").toLowerCase().contains("win") ? new String[]{"powershell", "-Command", "Get-Content -Tail 50 -Path " + latestFilePath.toString()} : new String[]{"tail", "-50", latestFilePath.toString()};
                        ProcessBuilder processBuilder = new ProcessBuilder(command);
                        processBuilder.redirectErrorStream(true);
                        Process process = processBuilder.start();
                        InputStream inputStream = process.getInputStream();
                        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                        while ((line = reader.readLine()) != null) {
                            this.processLogEntry(line, threatList);
                        }
                        int exitCode = process.waitFor();
                        if (exitCode != 0) {
                            this.logger.error("Process exited with code: " + exitCode);
                            FileBasedLogger.error("Security", "Process exited with code: " + exitCode, "system");
                        }
                    } else {
                        this.logger.info("File does not exist at the specified location: " + currentDateFilePath);
                        FileBasedLogger.info("Security", "File does not exist at the specified location: " + currentDateFilePath, "system");
                    }
                    break block22;
                }
                FileBasedLogger.info("Security", "Directory does not exist or is not a directory: " + directory, "system");
                this.logger.info("Directory does not exist or is not a directory: " + directory);
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
            }
        }
        return threatList;
    }

    public ArrayList<Threats> parseTodaysFile() {
        ArrayList<Threats> threatList = new ArrayList<Threats>();
        try {
            String alertFilePath = "alert";
            try (BufferedReader br = new BufferedReader(new FileReader(alertFilePath));){
                String line;
                while ((line = br.readLine()) != null) {
                    this.processLogEntry(line, threatList);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return threatList;
    }

    public static boolean isIPAddress(String input) {
        String ipAddressWithPortPattern = "^\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}:\\d+$";
        return Pattern.matches(ipAddressWithPortPattern, input);
    }

    public static boolean isMACAddress(String input) {
        String macAddressPattern = "^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$";
        return Pattern.matches(macAddressPattern, input);
    }

    private ArrayList<Threats> processLogEntry(String logEntry, ArrayList<Threats> threatList) {
        if (logEntry.contains("Classification")) {
            String[] components = logEntry.split("\\[\\*\\*\\]");
            Threats th = new Threats();
            for (int i = 0; i < components.length; ++i) {
                if (i == 0) {
                    th.setTimeStamp(components[i].trim());
                } else if (i == 1) {
                    String[] id_msg = components[i].trim().split(" ");
                    th.setThreat_id(id_msg[0].replace("[", "").replace("]", ""));
                    th.setAlertMessage(String.join((CharSequence)" ", Arrays.copyOfRange(id_msg, 1, id_msg.length)));
                } else if (i == 2) {
                    int classStartIndex = components[i].indexOf("[Classification:") + 15;
                    int classEndIndex = components[i].indexOf("]", classStartIndex);
                    String classification = components[i].substring(classStartIndex, classEndIndex).trim().replaceFirst("^: ", "").trim();
                    th.setClassification(classification);
                    int priorityStartIndex = components[i].indexOf("[Priority:") + 10;
                    int priorityEndIndex = components[i].indexOf("]", priorityStartIndex);
                    String priority = components[i].substring(priorityStartIndex, priorityEndIndex).trim();
                    th.setPriority(priority);
                    String[] pri_type_ips = components[i].trim().split(" ");
                    String protocolType = pri_type_ips[pri_type_ips.length - 4].replace("{", "").replace("}", "").trim();
                    th.setProtocolType(protocolType);
                    String srcIpPort = pri_type_ips[pri_type_ips.length - 3].trim();
                    String destIpPort = pri_type_ips[pri_type_ips.length - 1].trim();
                    if (ThreatParser.isIPAddress(srcIpPort) || ThreatParser.isMACAddress(srcIpPort)) {
                        if (srcIpPort.contains(":")) {
                            String[] srcParts = srcIpPort.split(":");
                            th.setSrcIp(srcParts[0].trim());
                            th.setSrcPort(Integer.parseInt(srcParts[1].trim()));
                        } else {
                            th.setSrcIp(srcIpPort);
                            th.setSrcPort(0);
                        }
                    } else {
                        th.setSrcIp(srcIpPort);
                        th.setSrcPort(0);
                    }
                    if (ThreatParser.isIPAddress(destIpPort) || ThreatParser.isMACAddress(destIpPort)) {
                        if (destIpPort.contains(":")) {
                            String[] destParts = destIpPort.split(":");
                            th.setDestIp(destParts[0].trim());
                            th.setDestPort(Integer.parseInt(destParts[1].trim()));
                        } else {
                            th.setDestIp(destIpPort);
                            th.setDestPort(0);
                        }
                    } else {
                        th.setDestIp(destIpPort);
                        th.setDestPort(0);
                    }
                }
                th.setAck_at("");
                th.setAck_by("");
            }
            threatList.add(th);
        } else {
            String[] components = logEntry.split("\\[\\*\\*\\]");
            Threats th = new Threats();
            for (int i = 0; i < components.length; ++i) {
                if (i == 0) {
                    th.setTimeStamp(components[i]);
                }
                if (i == 1) {
                    String[] id_msg = components[i].trim().split(" ");
                    th.setThreat_id(id_msg[0].replace("]", "").replace("[", ""));
                    th.setAlertMessage(String.join((CharSequence)" ", Arrays.copyOfRange(id_msg, 1, id_msg.length)));
                }
                if (i == 2) {
                    String[] pri_type_ips = components[i].trim().split(" ");
                    th.setPriority(pri_type_ips[1].replace("]", ""));
                    th.setProtocolType(pri_type_ips[2].replace("{", "").replace("}", ""));
                    boolean isSourceIP = ThreatParser.isIPAddress(pri_type_ips[3]);
                    boolean isSourceMAC = ThreatParser.isMACAddress(pri_type_ips[3]);
                    if (isSourceIP) {
                        if (pri_type_ips[3].contains(":")) {
                            String[] splitIpPort = pri_type_ips[3].split(":");
                            th.setSrcIp(splitIpPort[0]);
                            th.setSrcPort(Integer.parseInt(splitIpPort[1]));
                        } else {
                            th.setSrcIp(pri_type_ips[3]);
                            th.setSrcPort(Integer.parseInt("0"));
                        }
                    } else if (isSourceMAC) {
                        th.setSrcIp(pri_type_ips[3]);
                    } else {
                        th.setSrcIp(pri_type_ips[3]);
                    }
                    boolean isDestIP = ThreatParser.isIPAddress(pri_type_ips[5]);
                    boolean isDestMAC = ThreatParser.isMACAddress(pri_type_ips[5]);
                    if (isDestIP) {
                        if (pri_type_ips[5].contains(":")) {
                            String[] splitIpPort = pri_type_ips[5].split(":");
                            th.setDestIp(splitIpPort[0]);
                            th.setDestPort(Integer.parseInt(splitIpPort[1]));
                        } else {
                            th.setDestIp(pri_type_ips[5]);
                            th.setDestPort(0);
                        }
                    } else if (isDestMAC) {
                        th.setDestIp(pri_type_ips[5]);
                    } else {
                        th.setDestIp(pri_type_ips[5]);
                    }
                }
                th.setAck_at("");
                th.setAck_by("");
                th.setClassification("");
            }
            threatList.add(th);
        }
        return threatList;
    }
}

