/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.snort;

import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.led_script.LEDShellScript;
import com.tas.wp500.snort.ThreatParser;
import com.tas.wp500.snort.snortDBOperation.SnortSettings;
import com.tas.wp500.snort.snortDBOperation.Threats;
import java.util.ArrayList;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class SnortTimer
extends TimerTask {
    private static Logger logger = Logger.getLogger(SnortTimer.class);
    private SnortSettings snortSettings = SnortSettings.getInstance();
    private LEDShellScript led = LEDShellScript.getInstance();

    @Override
    public void run() {
        logger.debug("Timer excuting for snort.");
        ArrayList<Threats> threatList = ThreatParser.getInstance().executeTailCommandAndGetSnortResult();
        if (!threatList.isEmpty()) {
            try {
                for (int i = 0; i < threatList.size(); ++i) {
                    Threats threats = threatList.get(i);
                    String threat_id = threats.getThreat_id();
                    String timeStamp = threats.getTimeStamp();
                    String alertMessage = threats.getAlertMessage();
                    String priority = threats.getPriority();
                    String protocolType = threats.getProtocolType();
                    String srcIp = threats.getSrcIp();
                    int srcPort = threats.getSrcPort();
                    String destIp = threats.getDestIp();
                    int destPort = threats.getDestPort();
                    String ack_at = threats.getAck_at();
                    String ack_by = threats.getAck_by();
                    String classification = threats.getClassification();
                    this.snortSettings.insertOrUpdateData(threat_id, timeStamp, priority, alertMessage, protocolType, srcIp, String.valueOf(srcPort), destIp, String.valueOf(destPort), ack_at, ack_by, classification);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                FileBasedLogger.error("Security", "Error while getting snort threat : " + e.getLocalizedMessage(), "system");
            }
        }
    }
}

