/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.snort;

import com.tas.wp500.fileLogSetting.FileBasedLogger;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class ProcessListReader {
    private static ProcessListReader instance = null;
    static String processFilePath = "/usr/bin/process_command.json";
    private static Logger logger = Logger.getLogger(ProcessListReader.class);

    public static ProcessListReader getInstance() {
        if (instance == null) {
            instance = new ProcessListReader();
        }
        return instance;
    }

    public JSONObject getProcessList(JSONObject json, String user) throws JSONException {
        JSONObject jsonResult = new JSONObject();
        List<String> specificCommands = this.readSpecificCommandsFromConfig(processFilePath, user);
        String processType = "";
        try {
            processType = json.getString("process_type");
        }
        catch (JSONException e1) {
            e1.printStackTrace();
        }
        JSONArray availableProcesses = new JSONArray();
        JSONArray nonAvailableProcesses = new JSONArray();
        try {
            String line;
            ProcessBuilder processBuilder = new ProcessBuilder("ps", "aux");
            Process process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            ArrayList<String> headers = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                String command;
                String[] processInfo = line.trim().split("\\s+");
                if (headers.isEmpty()) {
                    headers.addAll(Arrays.asList(processInfo));
                    continue;
                }
                JSONObject processObject = new JSONObject();
                for (int i = 0; i < headers.size(); ++i) {
                    if (i < processInfo.length) {
                        if (((String)headers.get(i)).equals("COMMAND")) {
                            StringBuilder command2 = new StringBuilder();
                            for (int j = i; j < processInfo.length; ++j) {
                                command2.append(processInfo[j]).append(" ");
                            }
                            processObject.put("COMMAND", command2.toString().trim());
                            break;
                        }
                        processObject.put((String)headers.get(i), processInfo[i]);
                        continue;
                    }
                    processObject.put((String)headers.get(i), "");
                }
                if (specificCommands.contains(command = processObject.optString("COMMAND", ""))) {
                    availableProcesses.put(processObject);
                    continue;
                }
                nonAvailableProcesses.put(processObject);
            }
            if ("process_list".equals(processType)) {
                jsonResult.put("white_list_process", availableProcesses);
                jsonResult.put("black_list_process", nonAvailableProcesses);
                jsonResult.put("status", "success");
                jsonResult.put("msg", "Successfully fetched process list.");
                logger.info("Successfully fetched process list.");
                return jsonResult;
            }
            if ("process_count".equals(processType)) {
                jsonResult.put("black_list_process", nonAvailableProcesses.length());
            }
            int exitCode = process.waitFor();
            jsonResult.put("exitCode", exitCode);
            jsonResult.put("status", "success");
            jsonResult.put("msg", "Successfully fetched process list.");
        }
        catch (IOException | InterruptedException | JSONException e) {
            e.printStackTrace();
            jsonResult.put("status", "fail");
            jsonResult.put("msg", "Failed to fetch process list.");
            logger.error("Failed to fetch process list.");
            FileBasedLogger.error("Security", "Failed to fetch process list." + e, user);
        }
        return jsonResult;
    }

    private List<String> readSpecificCommandsFromConfig(String configFile, String user) {
        ArrayList<String> specificCommands = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(configFile));){
            JSONObject jsonConfig = new JSONObject(new JSONTokener(reader));
            JSONArray commandsArray = jsonConfig.getJSONArray("specificCommands");
            for (int i = 0; i < commandsArray.length(); ++i) {
                specificCommands.add(commandsArray.getString(i));
            }
        }
        catch (IOException | JSONException e) {
            logger.error("Error occurred while reading specific commands from config file: " + configFile);
            FileBasedLogger.error("Security", "Error occurred while reading specific commands from config file: " + configFile, user);
            e.printStackTrace();
        }
        return specificCommands;
    }
}

