/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.snort;

import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.linx_command.FileReaderUtil;
import com.tas.wp500.smtpSettings.SmtpDemo;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class ActiveThreats
extends Thread {
    private SmtpDemo smptSetting = SmtpDemo.getInstance();
    private static Logger logger = Logger.getLogger(ActiveThreats.class);
    private String threatId;
    private String timeStamp;
    private String priority;
    private String alertMessage;
    private String protocolType;
    private String srcIp;
    private String srcPort;
    private String destIp;
    private String destPort;
    private String ackAt;
    private String ackBy;

    public ActiveThreats(String threatId, String timeStamp, String priority, String alertMessage, String protocolType, String srcIp, String srcPort, String destIp, String destPort, String ackAt, String ackBy) {
        this.threatId = threatId;
        this.timeStamp = timeStamp;
        this.priority = priority;
        this.alertMessage = alertMessage;
        this.protocolType = protocolType;
        this.srcIp = srcIp;
        this.srcPort = srcPort;
        this.destIp = destIp;
        this.destPort = destPort;
        this.ackAt = ackAt;
        this.ackBy = ackBy;
    }

    @Override
    public void run() {
        try {
            JSONObject resultObj = FileReaderUtil.getInstance().getOverviewInfo("wp500");
            String tasSerialNo = resultObj.getString("TAS_SERIAL_NO");
            String message = this.constructEmailMessage(tasSerialNo);
            if (message != null && !message.isEmpty()) {
                this.smptSetting.sendEmailMessage(message, "Threat Alert TAS Serial No: " + tasSerialNo);
            } else {
                logger.error("Error while sending Threat Alert mail.");
                FileBasedLogger.error("Security", "Error while sending Threat Alert mail.", "system");
            }
        }
        catch (Exception e) {
            logger.error("Error while sending Threat Alert mail : " + e.getMessage());
            FileBasedLogger.error("Security", "Error while sending Threat Alert mail : " + e.getMessage(), "system");
        }
    }

    private String constructEmailMessage(String tasSerialNo) {
        StringBuilder emailContent = null;
        try {
            Date currentTime = new Date();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String formattedTime = dateFormat.format(currentTime);
            emailContent = new StringBuilder();
            emailContent.append("<html><body>");
            emailContent.append("<h2>Threat Details for TAS Serial No: ").append(tasSerialNo).append("</h2>");
            emailContent.append("<p><strong>Threat ID:</strong> ").append(this.threatId).append("</p>");
            emailContent.append("<p><strong>Time Stamp:</strong> ").append(this.timeStamp).append("</p>");
            String priorityColor = this.getPriorityColor(this.priority);
            emailContent.append("<p><strong>Priority:</strong> <span style=\"color:" + priorityColor + ";\">").append(this.getPriorityName(this.priority)).append("</span></p>");
            emailContent.append("<p><strong>Alert Message:</strong> ").append(this.alertMessage).append("</p>");
            emailContent.append("<p><strong>Protocol Type:</strong> ").append(this.protocolType).append("</p>");
            emailContent.append("<p><strong>Source IP:</strong> ").append(this.srcIp).append("</p>");
            emailContent.append("<p><strong>Source Port:</strong> ").append(this.srcPort).append("</p>");
            emailContent.append("<p><strong>Destination IP:</strong> ").append(this.destIp).append("</p>");
            emailContent.append("<p><strong>Destination Port:</strong> ").append(this.destPort).append("</p>");
            emailContent.append("<p><strong>Rtu Time: </strong>").append(formattedTime).append("</p>");
            emailContent.append("</body></html>");
        }
        catch (Exception e) {
            logger.error("Error occurred while constructing email message: " + e.getMessage());
            FileBasedLogger.error("Security", "Error occurred while constructing email message: " + e.getMessage(), "system");
        }
        return emailContent.toString();
    }

    private String getPriorityName(String priority) {
        switch (priority) {
            case "1": {
                return "High";
            }
            case "2": {
                return "Medium";
            }
            case "3": {
                return "Low";
            }
        }
        return "Unknown";
    }

    private String getPriorityColor(String priority) {
        switch (priority) {
            case "1": {
                return "red";
            }
            case "2": {
                return "orange";
            }
            case "3": {
                return "yellow";
            }
        }
        return "blue";
    }
}

