/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.smtpSettings;

import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.smtpSettings.SmtpDbOperation;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class SmtpDemo {
    private static Logger logger = Logger.getLogger(SmtpDemo.class);
    private static SmtpDemo instance = null;
    public static boolean emailFlag = false;

    public static SmtpDemo getInstance() {
        if (instance == null) {
            instance = new SmtpDemo();
        }
        return instance;
    }

    public JSONObject sentTestEmail() {
        JSONObject resultObj = new JSONObject();
        String testMessage = "Hello, this is a test message for the email sender.";
        String testSubject = "Test Email";
        try {
            this.sendEmailMessage(testMessage, testSubject);
            if (emailFlag) {
                resultObj.put("status", "success");
                resultObj.put("msg", "Email send successfuly.");
            } else {
                resultObj.put("status", "fail");
                resultObj.put("msg", "Error while sending email.");
            }
        }
        catch (MessagingException e) {
            resultObj.put("status", "fail");
            resultObj.put("msg", "Error while sending email.");
            logger.error("Error while sending test mail : " + e.getMessage());
            FileBasedLogger.error("Application", "Error while sending test mail : " + e.getMessage(), "system");
            e.printStackTrace();
        }
        return resultObj;
    }

    public void sendEmailMessage(String message, String subject) throws MessagingException {
        try {
            String cc = "";
            String bcc = "";
            String to_email_id = "";
            String[] ccEmails = null;
            String[] to_emails = null;
            String[] bccEmails = null;
            JSONObject smtpData = SmtpDbOperation.getSmtpDataForSmtp();
            String smtpStatus = smtpData.getString("status");
            if (smtpStatus.equalsIgnoreCase("success")) {
                String from;
                final String userName = from = smtpData.getString("from_email_id");
                final String password = smtpData.getString("password");
                String smtpType = smtpData.getString("smtp_type");
                if (smtpData.has("to_email_id")) {
                    to_email_id = smtpData.getString("to_email_id");
                    to_emails = to_email_id.split(",");
                }
                if (smtpData.has("cc") && !(cc = smtpData.getString("cc")).isEmpty()) {
                    ccEmails = cc.split(",");
                }
                if (smtpData.has("bcc") && !(bcc = smtpData.getString("bcc")).isEmpty()) {
                    bccEmails = bcc.split(",");
                }
                Properties props = new Properties();
                if ("ssl".equalsIgnoreCase(smtpType)) {
                    props.put("mail.smtp.auth", smtpData.getString("ssl_smtp_type"));
                    props.put("mail.smtp.starttls.enable", smtpData.getString("ssl_smtp_type"));
                    props.put("mail.smtp.host", smtpData.getString("host"));
                    props.put("mail.smtp.port", smtpData.getString("ssl_port"));
                    props.put("mail.smtp.socketFactory.port", smtpData.getString("ssl_socket_factory_port"));
                    props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                } else if ("tls".equalsIgnoreCase(smtpType)) {
                    props.put("mail.smtp.host", smtpData.getString("host"));
                    props.put("mail.smtp.port", smtpData.getString("tls_port"));
                    props.put("mail.smtp.auth", smtpData.getString("tls_auth"));
                    props.put("mail.smtp.starttls.enable", smtpData.getString("tls_enable"));
                }
                Session session = Session.getInstance(props, new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(userName, password);
                    }
                });
                for (String to : to_emails) {
                    SmtpDemo.sendEmail(session, message, subject, to.trim(), ccEmails, bccEmails, from);
                    Thread.sleep(1000L);
                }
            }
        }
        catch (InterruptedException e) {
            logger.error("Error while sending mail " + e);
            FileBasedLogger.error("Application", "Error while sending mail " + e, "system");
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            FileBasedLogger.error("Application", "Error while sending mail : " + e.getMessage(), "system");
            logger.error("Error while sending mail : " + e.getMessage());
        }
    }

    private static void sendEmail(Session session, String message, String subject, String to, String[] cc, String[] bcc, String from) {
        try {
            int i;
            MimeMessage m = new MimeMessage(session);
            m.setFrom(new InternetAddress(from));
            if (cc != null && cc.length > 0) {
                Address[] ccRecipients = new InternetAddress[cc.length];
                for (i = 0; i < cc.length; ++i) {
                    System.out.println("email_cc-->" + cc[i]);
                    ccRecipients[i] = new InternetAddress(cc[i].trim());
                }
                m.addRecipients(Message.RecipientType.CC, ccRecipients);
            }
            if (bcc != null && bcc.length > 0) {
                Address[] bccRecipients = new InternetAddress[bcc.length];
                for (i = 0; i < bcc.length; ++i) {
                    System.out.println("email_bcc-->" + bcc[i]);
                    bccRecipients[i] = new InternetAddress(bcc[i].trim());
                }
                m.addRecipients(Message.RecipientType.BCC, bccRecipients);
            }
            m.addRecipient(Message.RecipientType.TO, new InternetAddress(to));
            m.setSubject(subject);
            m.setContent(message, "text/html");
            Transport.send(m);
            emailFlag = true;
            logger.debug("Sent email to : " + to);
        }
        catch (MessagingException e) {
            logger.error("Error while sending mail : " + e.getMessage());
            FileBasedLogger.error("Application", "Error while sending mail : " + e.getMessage(), "system");
            e.printStackTrace();
        }
    }
}

