/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.smtpSettings;

import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.security.Security;
import com.tas.wp500.sql_lite_db.SQLiteConnector;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class SmtpDbOperation
extends Security {
    private static Logger logger = Logger.getLogger(SmtpDbOperation.class);
    public static final int ID = 1;
    private static SmtpDbOperation instance = null;
    private static final int SQLITE_BUSY = 5;
    private static final int RETRY_COUNT = 5;
    private static final int RETRY_DELAY = 10000;

    private SmtpDbOperation() {
        this.createSmtpTable();
    }

    public static SmtpDbOperation getInstance() {
        if (instance == null) {
            instance = new SmtpDbOperation();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSmtpTable() {
        Connection connection = SQLiteConnector.getConnection();
        try {
            String createTableSQL = "CREATE TABLE IF NOT EXISTS smtp_setting (id INTEGER PRIMARY KEY CHECK (id = 1),from_email_id TEXT,password TEXT,host TEXT,smtp_type TEXT,ssl_socket_factory_port TEXT,ssl_port TEXT,ssl_smtp_type TEXT,tls_port TEXT,tls_auth TEXT,tls_enable TEXT,cc TEXT,bcc TEXT,to_email_id TEXT)";
            PreparedStatement preparedStatement = connection.prepareStatement(createTableSQL);
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("Error creating SMTP setting table : " + e);
            FileBasedLogger.error("Application", "Error creating SMTP setting table : " + e, "system");
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject insertSmtpSetting(JSONObject json, String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = SQLiteConnector.getConnection();
            try {
                int sslSocketFactoryPort = 0;
                int sslPort = 0;
                String sslSmtpType = "";
                int tlsPort = 0;
                String tlsAuth = "";
                String tlsEnable = "";
                String cc = "";
                String bcc = "";
                String fromEmailId = json.getString("from_email_id");
                String password = json.getString("password");
                String host = json.getString("host");
                String smtpType = json.getString("smtp_type");
                cc = json.getString("email_cc");
                bcc = json.getString("email_bcc");
                String to_email_id = json.getString("to_email_id");
                if ("ssl".equalsIgnoreCase(smtpType)) {
                    sslSocketFactoryPort = json.getInt("ssl_socket_factory_port");
                    sslPort = json.getInt("ssl_port");
                    sslSmtpType = json.getString("ssl_smtp_type");
                } else if ("tls".equalsIgnoreCase(smtpType)) {
                    tlsPort = json.getInt("tls_port");
                    tlsAuth = json.getString("tls_auth");
                    tlsEnable = json.getString("tls_enable");
                }
                String insertSQL = "INSERT INTO smtp_setting (from_email_id, password, host, smtp_type, ssl_socket_factory_port, ssl_port, ssl_smtp_type, tls_port, tls_auth, tls_enable, cc, bcc, to_email_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                PreparedStatement statement = connection.prepareStatement(insertSQL);
                statement.setString(1, SmtpDbOperation.encrypt(fromEmailId));
                statement.setString(2, SmtpDbOperation.encrypt(password));
                statement.setString(3, SmtpDbOperation.encrypt(host));
                statement.setString(4, SmtpDbOperation.encrypt(smtpType));
                if ("ssl".equalsIgnoreCase(smtpType)) {
                    statement.setString(5, SmtpDbOperation.encrypt(String.valueOf(sslSocketFactoryPort)));
                    statement.setString(6, SmtpDbOperation.encrypt(String.valueOf(sslPort)));
                    statement.setString(7, SmtpDbOperation.encrypt(sslSmtpType));
                    statement.setString(8, SmtpDbOperation.encrypt(""));
                    statement.setString(9, SmtpDbOperation.encrypt(""));
                    statement.setString(10, SmtpDbOperation.encrypt(""));
                } else if ("tls".equalsIgnoreCase(smtpType)) {
                    statement.setString(5, SmtpDbOperation.encrypt(""));
                    statement.setString(6, SmtpDbOperation.encrypt(""));
                    statement.setString(7, SmtpDbOperation.encrypt(""));
                    statement.setString(8, SmtpDbOperation.encrypt(String.valueOf(tlsPort)));
                    statement.setString(9, SmtpDbOperation.encrypt(tlsAuth));
                    statement.setString(10, SmtpDbOperation.encrypt(tlsEnable));
                }
                if (cc.isEmpty()) {
                    statement.setString(11, SmtpDbOperation.encrypt(""));
                } else {
                    statement.setString(11, SmtpDbOperation.encrypt(cc));
                }
                if (bcc.isEmpty()) {
                    statement.setString(12, SmtpDbOperation.encrypt(""));
                } else {
                    statement.setString(12, SmtpDbOperation.encrypt(bcc));
                }
                statement.setString(13, SmtpDbOperation.encrypt(to_email_id));
                statement.executeUpdate();
                statement.close();
                resultObj.put("status", "success");
                resultObj.put("msg", "SMTP setting has been saved successfully.");
                FileBasedLogger.info("Audit", "SMTP setting has been saved successfully.", user);
                logger.info("Inserted SMTP setting successfully.");
                break;
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (e.getErrorCode() != 5 || attempt == 4) {
                    e.printStackTrace();
                    resultObj.put("status", "fail");
                    resultObj.put("msg", "Error while saving SMTP settings.");
                    logger.error("Error while inserting SMTP setting data : " + e);
                    FileBasedLogger.error("Audit", "Error while inserting SMTP setting data : " + e, user);
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject updateSmtpSetting(JSONObject json, String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = SQLiteConnector.getConnection();
            try {
                int sslSocketFactoryPort = 0;
                int sslPort = 0;
                String sslSmtpType = "";
                int tlsPort = 0;
                String tlsAuth = "";
                String tlsEnable = "";
                String cc = "";
                String bcc = "";
                String fromEmailId = json.getString("from_email_id");
                String password = json.getString("password");
                String host = json.getString("host");
                String smtpType = json.getString("smtp_type");
                cc = json.getString("email_cc");
                bcc = json.getString("email_bcc");
                String to_email_id = json.getString("to_email_id");
                if ("ssl".equalsIgnoreCase(smtpType)) {
                    sslSocketFactoryPort = json.getInt("ssl_socket_factory_port");
                    sslPort = json.getInt("ssl_port");
                    sslSmtpType = json.getString("ssl_smtp_type");
                } else if ("tls".equalsIgnoreCase(smtpType)) {
                    tlsPort = json.getInt("tls_port");
                    tlsAuth = json.getString("tls_auth");
                    tlsEnable = json.getString("tls_enable");
                }
                String sql = "UPDATE smtp_setting SET from_email_id=?, password=?, host=?, smtp_type=?, ssl_socket_factory_port=?, ssl_port=?, ssl_smtp_type=?, tls_port=?, tls_auth=?, tls_enable=?, cc=?, bcc=?, to_email_id=? WHERE id=?";
                PreparedStatement statement = connection.prepareStatement(sql);
                statement.setInt(14, 1);
                statement.setString(1, SmtpDbOperation.encrypt(fromEmailId));
                statement.setString(2, SmtpDbOperation.encrypt(password));
                statement.setString(3, SmtpDbOperation.encrypt(host));
                statement.setString(4, SmtpDbOperation.encrypt(smtpType));
                if ("ssl".equalsIgnoreCase(smtpType)) {
                    statement.setString(5, SmtpDbOperation.encrypt(String.valueOf(sslSocketFactoryPort)));
                    statement.setString(6, SmtpDbOperation.encrypt(String.valueOf(sslPort)));
                    statement.setString(7, SmtpDbOperation.encrypt(sslSmtpType));
                    statement.setString(8, SmtpDbOperation.encrypt(""));
                    statement.setString(9, SmtpDbOperation.encrypt(""));
                    statement.setString(10, SmtpDbOperation.encrypt(""));
                } else if ("tls".equalsIgnoreCase(smtpType)) {
                    statement.setString(5, SmtpDbOperation.encrypt(""));
                    statement.setString(6, SmtpDbOperation.encrypt(""));
                    statement.setString(7, SmtpDbOperation.encrypt(""));
                    statement.setString(8, SmtpDbOperation.encrypt(String.valueOf(tlsPort)));
                    statement.setString(9, SmtpDbOperation.encrypt(tlsAuth));
                    statement.setString(10, SmtpDbOperation.encrypt(tlsEnable));
                }
                if (cc.isEmpty()) {
                    statement.setString(11, SmtpDbOperation.encrypt(""));
                } else {
                    statement.setString(11, SmtpDbOperation.encrypt(cc));
                }
                if (bcc.isEmpty()) {
                    statement.setString(12, SmtpDbOperation.encrypt(""));
                } else {
                    statement.setString(12, SmtpDbOperation.encrypt(bcc));
                }
                statement.setString(13, SmtpDbOperation.encrypt(to_email_id));
                int updatedRows = statement.executeUpdate();
                statement.close();
                if (updatedRows > 0) {
                    resultObj.put("status", "success");
                    resultObj.put("msg", "SMTP setting updated successfully.");
                    logger.info("Updated SMTP setting successfully.");
                    FileBasedLogger.info("Audit", "Updated SMTP setting successfully.", user);
                    break;
                }
                resultObj.put("status", "fail");
                resultObj.put("msg", "SMTP setting not found or not updated.");
                logger.info("Not found SMTP settings.");
                FileBasedLogger.info("Audit", "SMTP setting not found or not updated.", user);
                break;
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (e.getErrorCode() != 5 || attempt == 4) {
                    e.printStackTrace();
                    resultObj.put("status", "fail");
                    resultObj.put("msg", "Error while saving or updating smtp setting.");
                    logger.error("Error occurred while updating SMTP setting data : " + e);
                    FileBasedLogger.error("Audit", "Error occurred while updating SMTP setting data : " + e, user);
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject deleteSmtpSetting(String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        Connection connection = null;
        try {
            connection = SQLiteConnector.getConnection();
            String sql = "DELETE FROM smtp_setting WHERE id = ?";
            PreparedStatement statement = connection.prepareStatement(sql);
            statement.setInt(1, 1);
            int deletedRows = statement.executeUpdate();
            statement.close();
            if (deletedRows > 0) {
                resultObj.put("status", "success");
                resultObj.put("msg", "All SMTP settings deleted successfully.");
                logger.info("Deleted All SMTP settings successfully.");
                FileBasedLogger.info("Audit", "All SMTP settings deleted successfully.", user);
            } else {
                logger.info("Failed To delete all SMTP settings.");
                resultObj.put("status", "fail");
                resultObj.put("msg", "Failed to delete all smtp settings.");
                FileBasedLogger.error("Audit", "Failed To delete all SMTP settings.", user);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            resultObj.put("status", "fail");
            resultObj.put("msg", "Error while deleting SMTP settings.");
            logger.error(" Error occurred while deleting SMTP settings : " + e);
            FileBasedLogger.error("Audit", "Error occurred while deleting SMTP settings : " + e, user);
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getSmtpSetting() throws JSONException {
        JSONObject resultObj = new JSONObject();
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = SQLiteConnector.getConnection();
            try {
                String sql = "SELECT * FROM smtp_setting";
                PreparedStatement statement = connection.prepareStatement(sql);
                ResultSet resultSet = statement.executeQuery();
                if (resultSet.next()) {
                    String fromEmailId = resultSet.getString("from_email_id");
                    String password = resultSet.getString("password");
                    String host = resultSet.getString("host");
                    String smtpType = resultSet.getString("smtp_type");
                    String sslSocketFactoryPort = resultSet.getString("ssl_socket_factory_port");
                    String sslPort = resultSet.getString("ssl_port");
                    String sslSmtpType = resultSet.getString("ssl_smtp_type");
                    String tlsPort = resultSet.getString("tls_port");
                    String tlsAuth = resultSet.getString("tls_auth");
                    String tlsEnable = resultSet.getString("tls_enable");
                    String cc = resultSet.getString("cc");
                    String bcc = resultSet.getString("bcc");
                    String to_email_id = resultSet.getString("to_email_id");
                    resultObj.put("from_email_id", SmtpDbOperation.decrypt(fromEmailId));
                    resultObj.put("password", SmtpDbOperation.decrypt(password));
                    resultObj.put("host", SmtpDbOperation.decrypt(host));
                    resultObj.put("smtp_type", SmtpDbOperation.decrypt(smtpType));
                    if (!SmtpDbOperation.decrypt(sslSocketFactoryPort).equals("")) {
                        resultObj.put("ssl_socket_factory_port", Integer.parseInt(SmtpDbOperation.decrypt(sslSocketFactoryPort)));
                    } else {
                        resultObj.put("ssl_socket_factory_port", SmtpDbOperation.decrypt(sslSocketFactoryPort));
                    }
                    if (!SmtpDbOperation.decrypt(sslPort).equals("")) {
                        resultObj.put("ssl_port", Integer.parseInt(SmtpDbOperation.decrypt(sslPort)));
                    } else {
                        resultObj.put("ssl_port", SmtpDbOperation.decrypt(sslPort));
                    }
                    resultObj.put("ssl_smtp_type", SmtpDbOperation.decrypt(sslSmtpType));
                    if (!SmtpDbOperation.decrypt(tlsPort).equals("")) {
                        resultObj.put("tls_port", Integer.parseInt(SmtpDbOperation.decrypt(tlsPort)));
                    } else {
                        resultObj.put("tls_port", SmtpDbOperation.decrypt(tlsPort));
                    }
                    resultObj.put("tls_auth", SmtpDbOperation.decrypt(tlsAuth));
                    resultObj.put("tls_enable", SmtpDbOperation.decrypt(tlsEnable));
                    resultObj.put("cc", SmtpDbOperation.decrypt(cc));
                    resultObj.put("bcc", SmtpDbOperation.decrypt(bcc));
                    resultObj.put("to_email_id", SmtpDbOperation.decrypt(to_email_id));
                    resultObj.put("status", "success");
                    resultObj.put("msg", "SMTP settings fetched successfully.");
                    logger.info("Fetched SMTP settings successfully.");
                } else {
                    resultObj.put("status", "success");
                    resultObj.put("msg", "No SMTP setting data found.");
                    resultObj.put("from_email_id", "");
                    logger.info("SMTP setting data not found.");
                }
                statement.close();
                break;
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (e.getErrorCode() != 5 || attempt == 4) {
                    e.printStackTrace();
                    resultObj.put("status", "fail");
                    resultObj.put("msg", "Error while retrieving SMTP setting.");
                    logger.error("Error occurred while retrieving SMTP setting data : " + e);
                    FileBasedLogger.error("Application", "Error occurred while retrieving SMTP setting data : " + e, "system");
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject getSmtpData() throws JSONException {
        JSONObject resultObj = new JSONObject();
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = SQLiteConnector.getConnection();
            try {
                String sql = "SELECT * FROM smtp_setting";
                PreparedStatement statement = connection.prepareStatement(sql);
                ResultSet resultSet = statement.executeQuery();
                if (resultSet.next()) {
                    String fromEmailId = resultSet.getString("from_email_id");
                    String password = resultSet.getString("password");
                    String host = resultSet.getString("host");
                    String smtpType = resultSet.getString("smtp_type");
                    String sslSocketFactoryPort = resultSet.getString("ssl_socket_factory_port");
                    String sslPort = resultSet.getString("ssl_port");
                    String sslSmtpType = resultSet.getString("ssl_smtp_type");
                    String tlsPort = resultSet.getString("tls_port");
                    String tlsAuth = resultSet.getString("tls_auth");
                    String tlsEnable = resultSet.getString("tls_enable");
                    String cc = resultSet.getString("cc");
                    String bcc = resultSet.getString("bcc");
                    String to_email_id = resultSet.getString("to_email_id");
                    resultObj.put("from_email_id", SmtpDbOperation.decrypt(fromEmailId));
                    resultObj.put("password", SmtpDbOperation.decrypt(password));
                    resultObj.put("host", SmtpDbOperation.decrypt(host));
                    resultObj.put("smtp_type", SmtpDbOperation.decrypt(smtpType));
                    resultObj.put("ssl_socket_factory_port", Integer.parseInt(SmtpDbOperation.decrypt(sslSocketFactoryPort)));
                    resultObj.put("ssl_port", Integer.parseInt(SmtpDbOperation.decrypt(sslPort)));
                    resultObj.put("ssl_smtp_type", SmtpDbOperation.decrypt(sslSmtpType));
                    resultObj.put("tls_port", Integer.parseInt(SmtpDbOperation.decrypt(tlsPort)));
                    resultObj.put("tls_auth", SmtpDbOperation.decrypt(tlsAuth));
                    resultObj.put("tls_enable", SmtpDbOperation.decrypt(tlsEnable));
                    resultObj.put("cc", SmtpDbOperation.decrypt(cc));
                    resultObj.put("bcc", SmtpDbOperation.decrypt(bcc));
                    resultObj.put("to_email_id", SmtpDbOperation.decrypt(to_email_id));
                    resultObj.put("status", "success");
                } else {
                    resultObj.put("status", "fail");
                    resultObj.put("msg", "No SMTP setting data found.");
                }
                statement.close();
                break;
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (e.getErrorCode() != 5 || attempt == 4) {
                    e.printStackTrace();
                    resultObj.put("status", "fail");
                    resultObj.put("msg", "Error while retrieving SMTP setting data.");
                    logger.error("Error while retrieving SMTP setting data : " + e);
                    FileBasedLogger.error("Application", "Error while retrieving SMTP setting data : " + e, "system");
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject getSmtpDataForSmtp() throws JSONException {
        JSONObject resultObj = new JSONObject();
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = SQLiteConnector.getConnection();
            try {
                String sql = "SELECT * FROM smtp_setting";
                PreparedStatement statement = connection.prepareStatement(sql);
                ResultSet resultSet = statement.executeQuery();
                if (resultSet.next()) {
                    String fromEmailId = resultSet.getString("from_email_id");
                    String password = resultSet.getString("password");
                    String host = resultSet.getString("host");
                    String smtpType = resultSet.getString("smtp_type");
                    String sslSocketFactoryPort = resultSet.getString("ssl_socket_factory_port");
                    String sslPort = resultSet.getString("ssl_port");
                    String sslSmtpType = resultSet.getString("ssl_smtp_type");
                    String tlsPort = resultSet.getString("tls_port");
                    String tlsAuth = resultSet.getString("tls_auth");
                    String tlsEnable = resultSet.getString("tls_enable");
                    String cc = resultSet.getString("cc");
                    String bcc = resultSet.getString("bcc");
                    String to_email_id = resultSet.getString("to_email_id");
                    System.out.println("fromEmailId ::  " + fromEmailId);
                    resultObj.put("from_email_id", SmtpDbOperation.decrypt(fromEmailId));
                    resultObj.put("password", SmtpDbOperation.decrypt(password));
                    resultObj.put("host", SmtpDbOperation.decrypt(host));
                    resultObj.put("smtp_type", SmtpDbOperation.decrypt(smtpType));
                    if (!SmtpDbOperation.decrypt(sslSocketFactoryPort).equals("")) {
                        resultObj.put("ssl_socket_factory_port", SmtpDbOperation.decrypt(sslSocketFactoryPort));
                    } else {
                        resultObj.put("ssl_socket_factory_port", SmtpDbOperation.decrypt(sslSocketFactoryPort));
                    }
                    if (!SmtpDbOperation.decrypt(sslPort).equals("")) {
                        resultObj.put("ssl_port", SmtpDbOperation.decrypt(sslPort));
                    } else {
                        resultObj.put("ssl_port", SmtpDbOperation.decrypt(sslPort));
                    }
                    resultObj.put("ssl_smtp_type", SmtpDbOperation.decrypt(sslSmtpType));
                    if (!SmtpDbOperation.decrypt(tlsPort).equals("")) {
                        resultObj.put("tls_port", SmtpDbOperation.decrypt(tlsPort));
                    } else {
                        resultObj.put("tls_port", SmtpDbOperation.decrypt(tlsPort));
                    }
                    resultObj.put("tls_auth", SmtpDbOperation.decrypt(tlsAuth));
                    resultObj.put("tls_enable", SmtpDbOperation.decrypt(tlsEnable));
                    resultObj.put("cc", SmtpDbOperation.decrypt(cc));
                    resultObj.put("bcc", SmtpDbOperation.decrypt(bcc));
                    resultObj.put("to_email_id", SmtpDbOperation.decrypt(to_email_id));
                    resultObj.put("status", "success");
                    resultObj.put("msg", "SMTP settings fetched successfully.");
                } else {
                    resultObj.put("status", "fail");
                    resultObj.put("msg", "SMTP setting data not found.");
                    logger.info("No SMTP setting data found.");
                }
                statement.close();
                break;
            }
            catch (SQLException e) {
                logger.error("Error while retrieving SMTP setting data : " + e);
                FileBasedLogger.error("Application", "Error while retrieving SMTP setting data : " + e, "system");
                e.printStackTrace();
                if (e.getErrorCode() != 5 || attempt == 4) {
                    e.printStackTrace();
                    resultObj.put("status", "fail");
                    resultObj.put("msg", "Error while retrieving SMTP setting.");
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
        return resultObj;
    }
}

