/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.smtpSettings;

import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.passwordSetting.PasswordPolicyDbOperation;
import com.tas.wp500.services.Service;
import com.tas.wp500.smtpSettings.SmtpDbOperation;
import com.tas.wp500.sql_lite_db.Db_opertions;
import com.tas.wp500.sql_lite_db.SQLiteConnector;
import com.tas.wp500.totpSetting.QRCodeGenerator;
import com.tas.wp500.user_token.TokenManager;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.Properties;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.codec.binary.Base32;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class SmptSetting2fa {
    private static Logger logger = Logger.getLogger(SmptSetting2fa.class);
    private static SmptSetting2fa instance = null;

    public static SmptSetting2fa getInstance() {
        if (instance == null) {
            instance = new SmptSetting2fa();
        }
        return instance;
    }

    public JSONObject sendOTPEmail(JSONObject json) throws JSONException {
        JSONObject resultObj = new JSONObject();
        String user = json.getString("user");
        try {
            long timeStep = 300L;
            int otpLength = 6;
            String serverOTP = null;
            String to_email = json.getString("to_email_id");
            String userEmail = Db_opertions.getInstance().getEmailByUsername(user);
            if (userEmail == null || !userEmail.equals(to_email)) {
                resultObj.put("status", "fail");
                resultObj.put("msg", "Email address does not match the registered email.");
                logger.info("Email address does not match the registered email.");
                FileBasedLogger.info("Security", "Email address does not match the registered email.", user);
                return resultObj;
            }
            JSONObject smtpData = SmtpDbOperation.getSmtpDataForSmtp();
            JSONObject result2fa = QRCodeGenerator.getTOTPKeyByUsername(json, user);
            String smptStatus = smtpData.getString("status");
            String result2faStatus = result2fa.getString("status");
            if (smptStatus.equals("success")) {
                if (result2faStatus.equals("success")) {
                    String totpUserKey = result2fa.getString("totp_key");
                    serverOTP = SmptSetting2fa.generateOTP(totpUserKey, timeStep, otpLength);
                    logger.debug("Generated OTP: " + serverOTP);
                    logger.debug("Recipient Email: " + to_email);
                    boolean emailSendStatus = SmptSetting2fa.sendOtpEmail(serverOTP, to_email.trim(), smtpData, user);
                    if (emailSendStatus) {
                        resultObj.put("status", "success");
                        resultObj.put("msg", "OTP successfully sent on email.");
                        logger.info("OTP sent successfully on email.");
                        FileBasedLogger.info("Audit", "OTP sent successfully on email.", user);
                    } else {
                        resultObj.put("status", "fail");
                        resultObj.put("msg", "Failed to send OTP on email.");
                        logger.info("Failed to send OTP on email.");
                        FileBasedLogger.info("Audit", "Failed to send OTP on email.", user);
                    }
                    return resultObj;
                }
                logger.debug("result 2fa Status is not success : " + result2fa);
                return result2fa;
            }
            logger.debug(" SMTP status is not success : " + smtpData);
            return smtpData;
        }
        catch (Exception e) {
            logger.error("Exception occurred while sending email: " + e.getMessage());
            FileBasedLogger.error("Audit", "Exception occurred while sending otp email: " + e.getMessage(), user);
            e.printStackTrace();
            return resultObj;
        }
    }

    public static boolean sendOtpEmail(String otp, String to, JSONObject smtpData, String user) throws JSONException {
        String from;
        String subject = "WP500 RTU 2fa (OTP)";
        String message = "<html><body><p>Dear User,</p><p>You are receiving this email because you requested to log in to your account on WP500 Rtu.</p><p>Please use the following OTP (One-Time Password) to authenticate your 2fa login:</p><h2>OTP: " + otp + "</h2><p>This OTP is valid for 5 minutes. Please do not share this OTP with anyone for security reasons.</p><p>If you did not request this OTP or are not trying to log in, please disregard this email.</p><p>Thank you,<br>WP500 Team</p></body></html>";
        boolean emailSent = false;
        final String userName = from = smtpData.getString("from_email_id");
        final String password = smtpData.getString("password");
        String smtpType = smtpData.getString("smtp_type");
        Properties props = new Properties();
        if ("ssl".equalsIgnoreCase(smtpType)) {
            props.put("mail.smtp.auth", smtpData.getString("ssl_smtp_type"));
            props.put("mail.smtp.starttls.enable", smtpData.getString("ssl_smtp_type"));
            props.put("mail.smtp.host", smtpData.getString("host"));
            props.put("mail.smtp.port", smtpData.getString("ssl_port"));
            props.put("mail.smtp.socketFactory.port", smtpData.getString("ssl_socket_factory_port"));
            props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        } else if ("tls".equalsIgnoreCase(smtpType)) {
            props.put("mail.smtp.host", smtpData.getString("host"));
            props.put("mail.smtp.port", smtpData.getString("tls_port"));
            props.put("mail.smtp.auth", smtpData.getString("tls_auth"));
            props.put("mail.smtp.starttls.enable", smtpData.getString("tls_enable"));
        }
        Session session = Session.getInstance(props, new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(userName, password);
            }
        });
        try {
            MimeMessage mimeMessage = new MimeMessage(session);
            mimeMessage.setFrom(new InternetAddress(from));
            mimeMessage.addRecipient(Message.RecipientType.TO, new InternetAddress(to));
            mimeMessage.setSubject(subject);
            mimeMessage.setContent(message, "text/html; charset=utf-8");
            Transport.send(mimeMessage);
            emailSent = true;
        }
        catch (MessagingException e) {
            logger.error("Error while sending otp email : " + e.getMessage());
            FileBasedLogger.error("", message, userName);
            emailSent = false;
        }
        return emailSent;
    }

    public JSONObject checkEmailOtp(JSONObject json) {
        JSONObject resultObject = new JSONObject();
        String totpUserKey = null;
        long timeStep = 300L;
        int otpLength = 6;
        String otp = null;
        String user = json.getString("username");
        try {
            JSONObject result2fa = QRCodeGenerator.getTOTPKeyByUsername(json, user);
            totpUserKey = result2fa.getString("totp_key");
            otp = json.getString("email_otp");
            boolean isValid = SmptSetting2fa.validateOTP(totpUserKey, timeStep, otpLength, otp, user);
            if (isValid) {
                resultObject.put("status", "success");
                resultObject.put("msg", "Email OTP is valid.");
                logger.info("Email OTP is valid.");
                FileBasedLogger.info("Audit", "Email OTP is valid.", user);
                try {
                    String token = TokenManager.generateToken(user);
                    Service.USER_WISE_TOKEN.put(user, token);
                    resultObject.put("token", token);
                    resultObject.put("token_status", "success");
                    resultObject.put("session_timeout", PasswordPolicyDbOperation.getInstance().getSessionTimeout(SQLiteConnector.getConnection(), user));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                resultObject.put("status", "fail");
                resultObject.put("msg", "Email OTP is invalid.");
                resultObject.put("token_status", "fail");
                logger.info("Email OTP is invalid.");
                FileBasedLogger.info("Audit", "Email OTP is Invalid.", user);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            resultObject.put("status", "fail");
            resultObject.put("msg", " Error occurred while checking email otp.");
            logger.error("Error occurred while checking email otp : " + e);
            FileBasedLogger.error("Audit", "Error occurred while checking email otp : " + e, user);
        }
        return resultObject;
    }

    public static String generateOTP(String secretKey, long timeStep, int otpLength) {
        long currentTime = Instant.now().getEpochSecond();
        long timeCounter = currentTime / timeStep;
        Base32 base32 = new Base32();
        byte[] keyBytes = base32.decode(secretKey);
        SecretKeySpec keySpec = new SecretKeySpec(keyBytes, "HmacSHA1");
        try {
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(keySpec);
            byte[] timeCounterBytes = new byte[8];
            for (int i = 7; i >= 0; --i) {
                timeCounterBytes[i] = (byte)(timeCounter & 0xFFL);
                timeCounter >>= 8;
            }
            byte[] hash = mac.doFinal(timeCounterBytes);
            int offset = hash[hash.length - 1] & 0xF;
            int binary = (hash[offset] & 0x7F) << 24 | (hash[offset + 1] & 0xFF) << 16 | (hash[offset + 2] & 0xFF) << 8 | hash[offset + 3] & 0xFF;
            int otpValue = binary % (int)Math.pow(10.0, otpLength);
            String otp = Integer.toString(otpValue);
            while (otp.length() < otpLength) {
                otp = "0" + otp;
            }
            return otp;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean validateOTP(String secretKey, long timeStep, int otpLength, String userOTP, String user) {
        try {
            String serverOTP = SmptSetting2fa.generateOTP(secretKey, timeStep, otpLength);
            logger.debug("Server OTP: " + serverOTP + ", User OTP: " + userOTP);
            return serverOTP != null && serverOTP.equals(userOTP);
        }
        catch (Exception e) {
            logger.error("Error occurred during OTP validation : ", e);
            FileBasedLogger.error("Audit", "Error occurred during OTP validation : " + e, user);
            return false;
        }
    }
}

