/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.services;

import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.liveValueTrigger.TriggerCheckExecutor;
import com.tas.wp500.opc_ua_client.OpcClientExecutorClass;
import com.tas.wp500.protocol.alarm.AlarmExecutor;
import com.tas.wp500.protocol.command.CommandExecutor;
import com.tas.wp500.protocol.dispensor_trigger.DispensorExecutor;
import com.tas.wp500.protocol.jsonbuillder.JSONBuilderExecutor;
import com.tas.wp500.protocol.mqtt.MqttExecutor;
import com.tas.wp500.protocol.opc.ThirdPartyExecutor;
import com.tas.wp500.protocol.startan.StartanExecutor;
import com.tas.wp500.protocol.startan.Tag;
import com.tas.wp500.protocol.startanWebSocket.StartanWebExecutor;
import com.tas.wp500.snort.SnortExecutor;
import com.tas.wp500.store_and_forword.StoreAndForwordExecutor;
import com.tas.wp500.tag.TagMappingTimer;
import com.tas.wp500.util.ConfigClass;
import com.tas.wp500.util.OldDataRemoval;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import startanSubscribeWebSocket.StartanSubscribeWebExecutor;

public class Service
implements Runnable {
    private static Logger logger = Logger.getLogger(Service.class);
    private boolean service_flag = false;
    public static ConcurrentHashMap<String, Tag> variableTagMap = new ConcurrentHashMap();
    public static HashMap<String, String> USER_WISE_TOKEN = new HashMap();
    private static ConfigClass configInstance = ConfigClass.getInstance();
    public static String webSocketUrl = "ws://127.0.0.1:11231/";
    private MqttExecutor mqttExecutor;
    private StartanExecutor startanExecutor;
    private JSONBuilderExecutor jSONBuilderExecutor;
    private DispensorExecutor dispensorExecutor;
    private AlarmExecutor alarmExecutor;
    private CommandExecutor commandExecutor;
    private StoreAndForwordExecutor storeAndForwordExecutor;
    private OldDataRemoval oldDataRemoval;
    private ThirdPartyExecutor opcExecutor;
    private TagMappingTimer tagTimer;
    private Timer tagTimertask;
    private TriggerCheckExecutor triggerCheckExecutor;
    private SnortExecutor snortExecutor;
    private StartanWebExecutor startanWebExecutor;
    private StartanSubscribeWebExecutor startanSubscribeWebExecutor;
    private static String stratonProtocol;

    public boolean isService_flag() {
        return this.service_flag;
    }

    public void setService_flag(boolean service_flag) {
        this.service_flag = service_flag;
    }

    @Override
    public void run() {
        logger.info("Service Starting !!!");
        Thread startServiceThread = new Thread(new ServiceTask());
        startServiceThread.setName("start service Thread !!");
        startServiceThread.start();
    }

    public void startService(String user) {
        logger.info("All service has been started.");
        try {
            try {
                Thread startonThread;
                stratonProtocol = configInstance.readConfigName("straton_protocol");
                if (stratonProtocol.equalsIgnoreCase("cgi")) {
                    this.startanExecutor = new StartanExecutor();
                    startonThread = new Thread(this.startanExecutor);
                    startonThread.setName("STARTON Cgi MODULE");
                    startonThread.start();
                    logger.info("Starton CGI executor module started.");
                    FileBasedLogger.info("Application", "Starton CGI executor module started.", user);
                } else if (stratonProtocol.equalsIgnoreCase("ws_read")) {
                    this.startanWebExecutor = new StartanWebExecutor();
                    startonThread = new Thread(this.startanWebExecutor);
                    startonThread.setName("STARTON Web MODULE");
                    startonThread.start();
                    logger.info("Starton WEB executor module started.");
                    FileBasedLogger.info("Application", "Starton WEB executor module started.", user);
                } else if (stratonProtocol.equalsIgnoreCase("ws_sub")) {
                    this.startanSubscribeWebExecutor = new StartanSubscribeWebExecutor();
                    startonThread = new Thread(this.startanSubscribeWebExecutor);
                    startonThread.setName("STARTON Web Sub MODULE");
                    startonThread.start();
                    logger.info("Starton WEB sub executor module started.");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                FileBasedLogger.error("Application", "Error while starting startan module : " + e, user);
                logger.error("Error while starting startan module : " + e);
            }
            try {
                this.tagTimer = new TagMappingTimer();
                this.tagTimertask = new Timer("Tag Mapping Timer");
                this.tagTimertask.scheduleAtFixedRate((TimerTask)this.tagTimer, 30000L, 10000L);
                logger.info("Tag Mapping module started.");
                FileBasedLogger.info("Application", "Tag Mapping module started.", user);
            }
            catch (Exception e) {
                e.printStackTrace();
                FileBasedLogger.error("Application", "Error while starting tag module : " + e, user);
                logger.error("Error while starting tag module : " + e);
            }
            try {
                this.mqttExecutor = new MqttExecutor();
                Thread mqttThread = new Thread(this.mqttExecutor);
                mqttThread.setName("MQTT MODULE");
                mqttThread.start();
                logger.info("Mqtt module started.");
                FileBasedLogger.info("Application", "Mqtt module started.", user);
            }
            catch (Exception e) {
                e.printStackTrace();
                FileBasedLogger.error("Application", "Error while starting mqtt module : " + e, user);
                logger.error("Error while starting mqtt module : " + e);
            }
            try {
                this.jSONBuilderExecutor = new JSONBuilderExecutor();
                Thread jsonThread = new Thread(this.jSONBuilderExecutor);
                jsonThread.setName("JSON BUILDER MODULE");
                jsonThread.start();
                logger.info("Json builder module started.");
                FileBasedLogger.info("Application", "Json builder module started.", user);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("Error while starting json builder module :" + e);
                FileBasedLogger.error("Application", "Error while starting json builder module :" + e, user);
            }
            try {
                this.alarmExecutor = new AlarmExecutor();
                Thread alarmThread = new Thread(this.alarmExecutor);
                alarmThread.setName("ALARM MODULE");
                alarmThread.start();
                logger.info("Alarm module started.");
                FileBasedLogger.info("Application", "Alarm module started.", user);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("Error while starting alarm module : " + e);
                FileBasedLogger.error("Application", "Error while starting alarm module : " + e, user);
            }
            try {
                this.commandExecutor = new CommandExecutor();
                Thread commandThread = new Thread(this.commandExecutor);
                commandThread.setName("COMMAND MODULE");
                commandThread.start();
                logger.info("Command module started.");
                FileBasedLogger.info("Application", "Command module started", user);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("Error while  starting Command module  : " + e);
                FileBasedLogger.error("Application", "Error while  starting Command module  : " + e, user);
            }
            try {
                this.dispensorExecutor = new DispensorExecutor();
                Thread dispThread = new Thread(this.dispensorExecutor);
                dispThread.setName("DISP TRIGGER MODULE");
                dispThread.start();
                logger.info("Dispensor trigger module started.");
                FileBasedLogger.info("Application", "Dispensor trigger module started.", user);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("Error while starting dispensor trigger  module :" + e);
                FileBasedLogger.error("Application", "Error while starting dispensor trigger  module :" + e, user);
            }
            try {
                this.storeAndForwordExecutor = new StoreAndForwordExecutor();
                Thread safThread = new Thread(this.storeAndForwordExecutor);
                safThread.setName("Store and forword Timer ");
                safThread.start();
                logger.info("Store and forword module started.");
                FileBasedLogger.info("Application", "Store and forword module started.", user);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("Error while starting store and forword module : " + e);
                FileBasedLogger.error("Application", "Error while starting store and forword module : " + e, user);
            }
            try {
                this.oldDataRemoval = new OldDataRemoval();
                Thread oldDataRemovalThread = new Thread(this.oldDataRemoval);
                oldDataRemovalThread.setName("Old data removal");
                oldDataRemovalThread.start();
                logger.info("Old data removal module started.");
                FileBasedLogger.info("Application", "Old data removal module started.", user);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("Error while starting timer of old data remove : ");
                FileBasedLogger.info("Application", "Error while starting timer of old data remove : " + e.getMessage(), user);
            }
            try {
                this.opcExecutor = new ThirdPartyExecutor();
                Thread opcExecutorThread = new Thread(this.opcExecutor);
                opcExecutorThread.start();
            }
            catch (Exception e) {
                e.printStackTrace();
                FileBasedLogger.error("Application", "Error while starting timer of ThirdPartyOpcuaExecutor : " + e.getMessage(), user);
            }
            try {
                this.triggerCheckExecutor = new TriggerCheckExecutor();
                Thread triggerCheckExecutorThread = new Thread(this.triggerCheckExecutor);
                triggerCheckExecutorThread.start();
            }
            catch (Exception e) {
                e.printStackTrace();
                FileBasedLogger.error("Application", "Error while starting timer of triggerCheckExecutor : " + e.getMessage(), user);
            }
            try {
                this.snortExecutor = new SnortExecutor();
                Thread snortThread = new Thread(this.snortExecutor);
                snortThread.start();
            }
            catch (Exception e) {
                e.printStackTrace();
                FileBasedLogger.error("Application", "Error while starting timer of snortExecutor : " + e.getMessage(), user);
            }
            this.setService_flag(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error start service : " + e);
            FileBasedLogger.error("Application", "Erro whiler start service : " + e, user);
        }
    }

    public boolean stopService(String user) {
        logger.info("All service stopting.");
        try {
            this.setService_flag(false);
            try {
                if (this.startanExecutor != null) {
                    this.startanExecutor.cancelStartonTimers(user);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (this.startanWebExecutor != null) {
                    this.startanWebExecutor.cancelStartonWebSocketTasks(user);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (this.startanSubscribeWebExecutor != null) {
                    this.startanSubscribeWebExecutor.disconnectAllClients();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (this.mqttExecutor != null) {
                    this.mqttExecutor.cancelConnection(user);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (this.jSONBuilderExecutor != null) {
                    this.jSONBuilderExecutor.cancelAllJSONBuilderTimers(user);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (this.dispensorExecutor != null) {
                    this.dispensorExecutor.cancelDispTriggerTimers(user);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (this.alarmExecutor != null) {
                    this.alarmExecutor.cancelAlarmTimer(user);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (this.commandExecutor != null) {
                    this.commandExecutor.cancelCommandTimers(user);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (this.storeAndForwordExecutor != null) {
                    this.storeAndForwordExecutor.cancelStoreAndForwordTimers(user);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (this.oldDataRemoval != null) {
                    this.oldDataRemoval.cancelTimerOfOldRemoval(user);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (this.snortExecutor != null) {
                    this.snortExecutor.cancelSnortTimer(user);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (this.opcExecutor != null) {
                    this.opcExecutor.cancelOPCTimers(user);
                    OpcClientExecutorClass.cancelConnection(user);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (this.tagTimertask != null) {
                    this.tagTimertask.cancel();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (this.triggerCheckExecutor != null) {
                    this.triggerCheckExecutor.cancelAlarmTimer(user);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                variableTagMap.clear();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error stop service : " + e);
            return false;
        }
    }

    public class ServiceTask
    implements Runnable {
        @Override
        public void run() {
            try {
                if (Service.this.isService_flag()) {
                    Service.this.stopService("system");
                } else if (!Service.this.isService_flag()) {
                    Service.this.startService("system");
                }
            }
            catch (Exception e) {
                logger.info("Error while starting service timertask : " + e);
            }
        }
    }
}

