/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.security;

import com.tas.wp500.fileLogSetting.FileBasedLogger;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class CaptchaSetting {
    private static Logger logger = Logger.getLogger(CaptchaSetting.class);
    private final Map<String, String> captchaStore = new HashMap<String, String>();
    private static final String CHARACTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    private static final int CAPTCHA_LENGTH = 6;
    private static CaptchaSetting instance = null;

    public static CaptchaSetting getInstance() {
        if (instance == null) {
            instance = new CaptchaSetting();
        }
        return instance;
    }

    public String generateCaptchaText() {
        Random random = new Random();
        StringBuilder captchaText = new StringBuilder(6);
        for (int i = 0; i < 6; ++i) {
            captchaText.append(CHARACTERS.charAt(random.nextInt(CHARACTERS.length())));
        }
        return captchaText.toString();
    }

    public JSONObject getCaptcha(JSONObject json) {
        JSONObject resulObj = new JSONObject();
        try {
            if (!json.has("captcha_token")) {
                resulObj.put("status", "fail");
                resulObj.put("msg", "captcha token missing.");
                return resulObj;
            }
            String captcha_token = json.getString("captcha_token");
            String captchaText = this.generateCaptchaText();
            this.captchaStore.put(captcha_token, captchaText);
            resulObj.put("status", "success");
            resulObj.put("msg", "Captcha generated successfully.");
            resulObj.put("captcha", captchaText);
        }
        catch (Exception e) {
            logger.error("Error while generating captcha: " + e.getLocalizedMessage());
            resulObj.put("status", "error");
            resulObj.put("msg", "Error while generating captcha. Please try again.");
        }
        return resulObj;
    }

    public boolean verifyCaptcha(JSONObject json) {
        try {
            if (!json.has("captcha")) {
                logger.error("Captcha text not provided in the request.");
                return false;
            }
            if (!json.has("captcha_token")) {
                logger.error("Captcha_token not provided in the request.");
                return false;
            }
            String userCaptchaText = json.getString("captcha");
            String captcha_token = json.getString("captcha_token");
            String storedCaptcha = this.captchaStore.get(captcha_token);
            if (storedCaptcha != null && storedCaptcha.equals(userCaptchaText)) {
                this.captchaStore.remove(captcha_token);
                return true;
            }
            logger.debug("Captcha verification failed for token: " + captcha_token);
            return false;
        }
        catch (Exception e) {
            FileBasedLogger.error("Audit", "Error while verifying captcha " + e.getLocalizedMessage(), json.getString("username"));
            logger.error("Error while verifying captcha " + e.getLocalizedMessage());
            return false;
        }
    }

    public JSONObject generateToken() {
        JSONObject resultObj = new JSONObject();
        try {
            SecureRandom random = new SecureRandom();
            String token = new BigInteger(130, random).toString(32);
            resultObj.put("captcha_token", token);
            resultObj.put("status", "success");
            resultObj.put("msg", "Token generated successfully");
        }
        catch (Exception e) {
            logger.error("Error generating token", e);
            resultObj.put("status", "fail");
            resultObj.put("msg", "Error while generating token. Please try again.");
        }
        return resultObj;
    }
}

