/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.rsyslogSettings;

import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.security.Security;
import com.tas.wp500.sql_lite_db.SQLiteConnector;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class Rsyslog
extends Security {
    private static Logger logger = Logger.getLogger(Rsyslog.class);
    private static Rsyslog instance = null;
    private static String configFile = "/etc/rsyslog.conf";
    private static final int SQLITE_BUSY = 5;
    private static final int RETRY_COUNT = 5;
    private static final int RETRY_DELAY = 10000;

    public static Rsyslog getInstance() {
        if (instance == null) {
            instance = new Rsyslog();
        }
        return instance;
    }

    private Rsyslog() {
        this.createRsyslogTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createRsyslogTable() {
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = SQLiteConnector.getConnection();
            try {
                Statement statement = connection.createStatement();
                String createTableSql = "CREATE TABLE IF NOT EXISTS rsyslog_info (id INTEGER PRIMARY KEY CHECK (id = 1) , ip TEXT, port TEXT, rsyslog_status TEXT )";
                statement.execute(createTableSql);
                String insertDataSql = "INSERT INTO rsyslog_info (id, rsyslog_status) VALUES (?, ?)";
                PreparedStatement preparedStatement = connection.prepareStatement(insertDataSql);
                preparedStatement.setInt(1, 1);
                preparedStatement.setString(2, Rsyslog.encrypt("disable"));
                preparedStatement.executeUpdate();
                preparedStatement.close();
                statement.close();
                break;
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (e.getErrorCode() != 5 || attempt == 4) {
                    e.printStackTrace();
                    logger.error("Error while creating table rsyslog_info and inserting data : " + e.getMessage());
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRsyslogTable(String ip, String port, String user) {
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = SQLiteConnector.getConnection();
            try {
                PreparedStatement preparedStatement = connection.prepareStatement("UPDATE rsyslog_info SET ip = ?, port = ? WHERE id = 1");
                preparedStatement.setString(1, Rsyslog.encrypt(ip));
                preparedStatement.setString(2, Rsyslog.encrypt(port));
                int rowsUpdated = preparedStatement.executeUpdate();
                preparedStatement.close();
                if (rowsUpdated <= 0) break;
                break;
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (e.getErrorCode() != 5 || attempt == 4) {
                    e.printStackTrace();
                    logger.error("Error while updating ip and port in rsyslog_info table : " + e);
                    FileBasedLogger.error("Audit", "Error while updating ip and port in rsyslog_info table : " + e, user);
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject updateRsyslogStatus(String newStatus) {
        JSONObject resultObj = new JSONObject();
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = SQLiteConnector.getConnection();
            try {
                PreparedStatement preparedStatement = connection.prepareStatement("UPDATE rsyslog_info SET rsyslog_status = ? WHERE id = 1");
                preparedStatement.setString(1, Rsyslog.encrypt(newStatus));
                int rowsUpdated = preparedStatement.executeUpdate();
                preparedStatement.close();
                if (rowsUpdated > 0) {
                    resultObj.put("status", "success");
                    resultObj.put("msg", "rsyslog_status updated successfully.");
                    break;
                }
                resultObj.put("status", "faile");
                resultObj.put("msg", "Error while updating rsyslog_status.");
                break;
            }
            catch (SQLException | JSONException e) {
                e.printStackTrace();
                if (((SQLException)e).getErrorCode() != 5 || attempt == 4) {
                    e.printStackTrace();
                    try {
                        resultObj.put("status", "error");
                        resultObj.put("msg", "Error while updating rsyslog_status.");
                    }
                    catch (JSONException jsonException) {
                        jsonException.printStackTrace();
                    }
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getRsyslogStatus(String user) {
        Connection connection = SQLiteConnector.getConnection();
        JSONObject resultObj = new JSONObject();
        String rsyslogStatus = null;
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT rsyslog_status FROM rsyslog_info WHERE id = ?");
            preparedStatement.setInt(1, 1);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                rsyslogStatus = resultSet.getString("rsyslog_status");
                resultObj.put("status", "success");
                resultObj.put("rsyslog_status", Rsyslog.decrypt(rsyslogStatus).toUpperCase());
                resultObj.put("msg", "Rsyslog status retrieved successfully.");
            } else {
                resultObj.put("status", "fail");
                resultObj.put("msg", "No rsyslog_status found.");
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (SQLException | JSONException e) {
            e.printStackTrace();
            logger.error("Error occurred while fetching Rsyslog Status : " + e.getMessage());
            FileBasedLogger.error("Audit", "Error occurred while fetching Rsyslog Status : " + e.getMessage(), user);
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getIpAndPort() {
        Connection connection = SQLiteConnector.getConnection();
        JSONObject resultObj = new JSONObject();
        String ipAddress = null;
        String port = null;
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT ip, port FROM rsyslog_info WHERE id = ?");
            preparedStatement.setInt(1, 1);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                ipAddress = resultSet.getString("ip");
                port = resultSet.getString("port");
                resultObj.put("status", "success");
                resultObj.put("rsyslog_ip", Rsyslog.decrypt(ipAddress));
                resultObj.put("rsyslog_port", Rsyslog.decrypt(port));
                resultObj.put("msg", "Successfully fetched ip and port.");
            } else {
                resultObj.put("status", "error");
                resultObj.put("msg", "Failed to fetch ip and port.");
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (SQLException | JSONException e) {
            e.printStackTrace();
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return resultObj;
    }

    public JSONObject rsyslogManger(JSONObject json, String user, String userRole) throws JSONException {
        JSONObject resultObj = new JSONObject();
        if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
            if (json.has("operation_type")) {
                String operationType = json.getString("operation_type");
                if (userRole.equalsIgnoreCase("operator") && !operationType.equals("get_rsyslog") && !operationType.equals("get_rsyslog_status")) {
                    resultObj.put("status", "success");
                    resultObj.put("msg", "Permission denied for this operation.");
                    return resultObj;
                }
                if (operationType.equals("update_rsyslog")) {
                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("engineer")) {
                        try {
                            String ip = json.getString("rsyslog_ip");
                            String port = json.getString("rsyslog_port");
                            Rsyslog.updateRsyslogFile(ip, port, user);
                            this.updateRsyslogTable(ip, port, user);
                            resultObj.put("status", "success");
                            resultObj.put("msg", "Successfully updated IP and port in rsyslog file.");
                            logger.info("Successfully updated IP and port in rsyslog file.");
                            FileBasedLogger.info("Audit", "Successfully updated IP and port in rsyslog file.", user);
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                            resultObj.put("status", "fail");
                            resultObj.put("msg", "Failed to update IP and port in rsyslog file.");
                            logger.error("Error occurred while updating rsyslog file: " + e);
                            FileBasedLogger.error("Audit", "Error occurred while updating rsyslog file: " + e, user);
                        }
                    } else {
                        resultObj.put("status", "fail");
                        resultObj.put("msg", "Permission denied for this operation.");
                    }
                } else {
                    if (operationType.equals("get_rsyslog")) {
                        JSONObject resultIpPort = this.readFileIpPort(user);
                        return resultIpPort;
                    }
                    if (operationType.equals("get_rsyslog_status")) {
                        JSONObject resultStatus = this.getRsyslogStatus(user);
                        return resultStatus;
                    }
                    if (operationType.equals("update_rsyslog_status")) {
                        if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("engineer")) {
                            String newStatus = json.getString("rsyslog_status");
                            if (newStatus.equalsIgnoreCase("enable")) {
                                Rsyslog.enableRsyslog();
                                Rsyslog.restartRsyslog();
                            } else if (newStatus.equalsIgnoreCase("disable")) {
                                Rsyslog.disableRsyslog();
                            }
                            JSONObject resultStatus = this.updateRsyslogStatus(newStatus);
                            return resultStatus;
                        }
                        resultObj.put("status", "success");
                        resultObj.put("msg", "Permission denied for this operation.");
                    }
                }
            }
        } else {
            resultObj.put("status", "fail");
            resultObj.put("msg", "Invalid user role.");
        }
        return resultObj;
    }

    public static void restartRsyslog() {
        String command = "systemctl restart rsyslog";
        try {
            ProcessBuilder processBuilder = new ProcessBuilder("bash", "-c", command);
            Process process = processBuilder.start();
            int exitCode = process.waitFor();
            if (exitCode == 0) {
                logger.info("Rsyslog service restarted successfully.");
            } else {
                logger.error("Error restarting rsyslog service. Exit code: " + exitCode);
            }
        }
        catch (IOException | InterruptedException e) {
            logger.error("Exception while restarting rsyslog service: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static void updateRsyslogFile(String newIP, String newPort, String user) {
        try {
            String line;
            File file = new File(configFile);
            BufferedReader fileReader = new BufferedReader(new FileReader(configFile));
            StringBuilder content = new StringBuilder();
            while ((line = fileReader.readLine()) != null) {
                if (line.contains("*.*")) {
                    line = line.replaceAll("(.*@@)\\d+\\.\\d+\\.\\d+\\.\\d+:(\\d+)(.*)", "$1" + newIP + ":" + newPort + "$3");
                }
                content.append(line).append("\n");
            }
            fileReader.close();
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            writer.write(content.toString());
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error("Error occurred while updating rsyslog file : " + e);
            FileBasedLogger.error("Audit", "Error occurred while updating rsyslog file : " + e, user);
        }
    }

    public static String extractIP(Pattern pattern, String line) {
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    public static int extractPort(Pattern pattern, String line) {
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(2));
        }
        return 0;
    }

    public JSONObject readFileIpPort(String user) {
        JSONObject resultObj = new JSONObject();
        Pattern pattern = Pattern.compile("@@(\\d+\\.\\d+\\.\\d+\\.\\d+):(\\d+)");
        try (BufferedReader br = new BufferedReader(new FileReader(configFile));){
            String line;
            while ((line = br.readLine()) != null) {
                if (!line.contains("*.*") && !line.contains("@@")) continue;
                String extractedIP = Rsyslog.extractIP(pattern, line);
                int extractedPort = Rsyslog.extractPort(pattern, line);
                if (!extractedIP.isEmpty()) {
                    resultObj.put("rsyslog_ip", extractedIP);
                    resultObj.put("rsyslog_port", extractedPort);
                    logger.debug("rsyslog_ip: " + extractedIP + " rsyslog_port: " + extractedPort);
                    resultObj.put("status", "success");
                    resultObj.put("msg", "Successfully read IP and port from rsyslog file.");
                    continue;
                }
                resultObj.put("status", "failed");
                resultObj.put("msg", "Failed to extract IP and port from rsyslog file.");
            }
        }
        catch (IOException | JSONException e) {
            try {
                resultObj.put("status", "faile");
                resultObj.put("msg", "Failed to read text from rsyslog file. ");
                logger.error("Error while reading rsyslog file : " + e.getMessage());
                FileBasedLogger.error("Audit", "Error while reading rsyslog file : " + e.getMessage(), user);
            }
            catch (JSONException e1) {
                e1.printStackTrace();
            }
        }
        return resultObj;
    }

    public static void disableRsyslog() {
        try {
            String line;
            File file = new File(configFile);
            BufferedReader reader = new BufferedReader(new FileReader(file));
            StringBuilder stringBuilder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if (line.trim().startsWith("*.* @@")) {
                    line = "#" + line;
                }
                stringBuilder.append(line).append("\n");
            }
            reader.close();
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            writer.write(stringBuilder.toString());
            writer.close();
            logger.debug("Modified .conf file successfully.");
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error("Error while disable rsyslog : " + e);
        }
    }

    public static void enableRsyslog() {
        try {
            String line;
            File file = new File(configFile);
            BufferedReader reader = new BufferedReader(new FileReader(file));
            StringBuilder stringBuilder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if (line.trim().startsWith("#*.* @@")) {
                    line = line.substring(1);
                }
                stringBuilder.append(line).append("\n");
            }
            reader.close();
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            writer.write(stringBuilder.toString());
            writer.close();
            logger.debug("Modified .conf file successfully.");
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error("Error while enable rsyslog : " + e);
        }
    }
}

