/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.query_sort;

import com.tas.wp500.IptablesSetting.GenralSettingsOperation;
import com.tas.wp500.IptablesSetting.IptablesManager;
import com.tas.wp500.IptablesSetting.Rule;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ConfigTraficRule {
    private static ConfigTraficRule instance = null;
    private Logger logger = Logger.getLogger(ConfigTraficRule.class);
    private IptablesManager iptableManger = IptablesManager.getInstance();
    private GenralSettingsOperation gen = GenralSettingsOperation.getInstance();

    public static ConfigTraficRule getInstance() {
        if (instance == null) {
            instance = new ConfigTraficRule();
        }
        return instance;
    }

    public JSONObject getALLDataOFFirewallSettings(String user) throws JSONException {
        JSONObject result = new JSONObject();
        try {
            JSONArray ipRuleArray = new JSONArray();
            ArrayList<Rule> fetchRules = this.iptableManger.fetchRules(user);
            if (!fetchRules.isEmpty()) {
                fetchRules.forEach(e -> {
                    try {
                        JSONObject jsonRule = new JSONObject();
                        jsonRule.put("name", e.getName());
                        jsonRule.put("iface", e.getIface());
                        jsonRule.put("protocol", e.getProtocol());
                        jsonRule.put("fromIp", e.getFromIp());
                        jsonRule.put("fromPort", e.getFromPort());
                        jsonRule.put("toIp", e.getToIp());
                        jsonRule.put("toPort", e.getToPort());
                        jsonRule.put("action", e.getAction());
                        ipRuleArray.put(jsonRule);
                    }
                    catch (Exception e1) {
                        this.logger.error("Failed To fetch firewall settings." + e);
                        e1.printStackTrace();
                    }
                });
            }
            result.put("ip_tables", ipRuleArray);
            result.put("status", "success");
            result.put("msg", "Firewall settings fetched successfully !");
        }
        catch (Exception e2) {
            e2.printStackTrace();
            result.put("status", "Fail");
            result.put("msg", "Failed to fetch Firewall settings ");
            this.logger.error("Failed To fetch firewall settings.");
        }
        return result;
    }

    public JSONObject sortQueryUingTraficRule(JSONObject json, String user) throws JSONException {
        JSONObject ack_res = new JSONObject();
        if (json.has("operation_type")) {
            String operation_type;
            switch (operation_type = json.getString("operation_type")) {
                case "add_ip": {
                    ack_res = this.iptableManger.insertRuleFromJson(json, user);
                    break;
                }
                case "update_ip": {
                    ack_res = this.iptableManger.upsertRuleFromJson(json, user);
                    break;
                }
                case "delete_ip": {
                    ack_res = this.iptableManger.deleteRuleByName(json.getString("name"), user);
                    break;
                }
                case "apply_command": {
                    ack_res = this.iptableManger.applyButtonAction(user);
                    JSONObject iptableJsonResult = this.iptableManger.saveIptablesRules(user);
                    break;
                }
            }
        }
        return ack_res;
    }

    public JSONObject sortQueryUingTraficRuleByGenralSetting(JSONObject json, String user, String userRole) throws JSONException {
        JSONObject ack_res = new JSONObject();
        if (json.has("operation_type")) {
            String operation_type;
            switch (operation_type = json.getString("operation_type")) {
                case "get": {
                    if (this.isAdminOrOperator(userRole)) {
                        ack_res = this.gen.getGeneralSettingByInterface(json.getString("interface"));
                        break;
                    }
                    this.accessDeniedResponse(ack_res);
                    break;
                }
                case "add": {
                    if (this.isAdmin(userRole) || userRole.equalsIgnoreCase("engineer")) {
                        ack_res = this.insertOrUpdateGeneralSetting(json, "insert");
                        break;
                    }
                    this.accessDeniedResponse1(ack_res);
                    break;
                }
                case "update": {
                    if (this.isAdmin(userRole) || userRole.equalsIgnoreCase("engineer")) {
                        ack_res = this.insertOrUpdateGeneralSetting(json, "update");
                        break;
                    }
                    this.accessDeniedResponse1(ack_res);
                    break;
                }
                case "delete": {
                    if (this.isAdmin(userRole) || userRole.equalsIgnoreCase("engineer")) {
                        ack_res = this.gen.deleteGeneralSetting("wp500");
                        break;
                    }
                    this.accessDeniedResponse1(ack_res);
                    break;
                }
                case "apply": {
                    if (this.isAdminOrOperator(userRole) || userRole.equalsIgnoreCase("engineer")) {
                        ack_res = this.iptableManger.executeGenralSettingCommand(user);
                        break;
                    }
                    this.accessDeniedResponse1(ack_res);
                    break;
                }
            }
        }
        return ack_res;
    }

    private boolean isAdminOrOperator(String userRole) {
        return userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer");
    }

    private boolean isAdmin(String userRole) {
        return userRole.equalsIgnoreCase("admin");
    }

    private void accessDeniedResponse(JSONObject ack_res) throws JSONException {
        ack_res.put("status", "fail");
        ack_res.put("msg", "Access denied. Only Administrators and Engineer and Operators can perform this operation.");
    }

    private void accessDeniedResponse1(JSONObject ack_res) throws JSONException {
        ack_res.put("status", "fail");
        ack_res.put("msg", "Access denied. Only Administrators and Engineer can perform this operation.");
    }

    private JSONObject insertOrUpdateGeneralSetting(JSONObject json, String operationType) throws JSONException {
        String interfaceValue = json.getString("interface");
        int index = this.getIndexForInterface(interfaceValue);
        if (index > 0) {
            if ("insert".equals(operationType)) {
                return this.gen.insertGeneralSetting(json, index, "wp500");
            }
            if ("update".equals(operationType)) {
                return this.gen.updateGeneralSetting(json, index, "wp500");
            }
        }
        JSONObject response = new JSONObject();
        response.put("status", "fail");
        response.put("msg", "Invalid interface specified.");
        return response;
    }

    private int getIndexForInterface(String interfaceValue) {
        switch (interfaceValue) {
            case "lan0": {
                return 1;
            }
            case "lan1": {
                return 2;
            }
            case "lan2": {
                return 3;
            }
        }
        return -1;
    }
}

