/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.query_sort;

import com.tas.wp500.alarmSettings.AlarmDbOperation;
import com.tas.wp500.commandSettings.CommandDbOperations;
import com.tas.wp500.dispensorSettings.DispensorTriggerDb_Operations;
import com.tas.wp500.jsonBuilderSettings.JsonBuilder_operation;
import com.tas.wp500.mqttSettings.MQTT_opertions;
import com.tas.wp500.smtpSettings.SmtpDbOperation;
import org.json.JSONException;
import org.json.JSONObject;

public class ConfigQueries {
    private static ConfigQueries instance = null;
    private MQTT_opertions mqtt = MQTT_opertions.getInstance();
    private JsonBuilder_operation jsonbuilder = JsonBuilder_operation.getInstance();
    private DispensorTriggerDb_Operations dispensor = DispensorTriggerDb_Operations.getInstance();
    private AlarmDbOperation alarm = AlarmDbOperation.getInstance();
    private CommandDbOperations command = CommandDbOperations.getInstance();
    private SmtpDbOperation smtp = SmtpDbOperation.getInstance();

    public static ConfigQueries getInstance() {
        if (instance == null) {
            instance = new ConfigQueries();
        }
        return instance;
    }

    public JSONObject sortQueryUingProtocol(JSONObject json, String user, String userRole) throws JSONException {
        JSONObject ack_res = new JSONObject();
        if (json.has("protocol_type")) {
            String protocol_type;
            block8 : switch (protocol_type = json.getString("protocol_type")) {
                case "mqtt": {
                    String operation_type;
                    if (!json.has("operation_type")) break;
                    switch (operation_type = json.getString("operation_type")) {
                        case "add_query": {
                            if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("engineer")) {
                                ack_res = this.mqtt.insertMqttData(json, user);
                                break block8;
                            }
                            this.setAccessDeniedResponse(ack_res, "Access denied. Only Administrators and Engineers can perform operation.");
                            break block8;
                        }
                        case "update_query": {
                            if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("engineer")) {
                                ack_res = this.mqtt.updateMqttData(json, user);
                                break block8;
                            }
                            this.setAccessDeniedResponse(ack_res, "Access denied. Only Administrators and Engineers can perform operation.");
                            break block8;
                        }
                        case "delete_query": {
                            if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("engineer")) {
                                ack_res = this.mqtt.deleteMqttData(json, user);
                                break block8;
                            }
                            this.setAccessDeniedResponse(ack_res, "Access denied. Only Administrators and Engineers can perform operation.");
                            break block8;
                        }
                        case "get_query": {
                            if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                ack_res = this.mqtt.getAllMqttData(json);
                                break block8;
                            }
                            this.setAccessDeniedResponse(ack_res, "Access denied. Only Administrators and Engineers and Viewer can perform operation.");
                            break block8;
                        }
                        case "get_crt_files": {
                            if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                ack_res = this.mqtt.getCrtCertificatesFromfolers(json);
                                break block8;
                            }
                            this.setAccessDeniedResponse(ack_res, "Access denied. Only Administrators and Engineers and Viewer can perform operation.");
                            break block8;
                        }
                    }
                    break;
                }
                case "json_builder": {
                    String operation_type;
                    if (!json.has("operation_type")) break;
                    switch (operation_type = json.getString("operation_type")) {
                        case "add_query": {
                            if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("engineer")) {
                                ack_res = this.jsonbuilder.insertJSONBuilderData(json, user);
                                break block8;
                            }
                            this.setAccessDeniedResponse(ack_res, "Access denied. Only Administrators and Engineers can perform operation.");
                            break block8;
                        }
                        case "update_query": {
                            if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("engineer")) {
                                ack_res = this.jsonbuilder.updateJsonBuilderData(json, user);
                                break block8;
                            }
                            this.setAccessDeniedResponse(ack_res, "Access denied. Only Administrators and Engineers can perform operation.");
                            break block8;
                        }
                        case "delete_query": {
                            if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("engineer")) {
                                ack_res = this.jsonbuilder.deleteJsonBuilderData(json, user);
                                break block8;
                            }
                            this.setAccessDeniedResponse(ack_res, "Access denied. Only Administrators and Engineers can perform operation.");
                            break block8;
                        }
                        case "get_query": {
                            if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                ack_res = this.jsonbuilder.getAllJsonBuilderData(json, user);
                                break block8;
                            }
                            this.setAccessDeniedResponse(ack_res, "Access denied. Only Administrators and Engineers and Viewer can perform operation.");
                            break block8;
                        }
                        case "get_broker_ip": {
                            if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                ack_res = this.jsonbuilder.getBrokerIpDetailsFromMqtt(json);
                                break block8;
                            }
                            this.setAccessDeniedResponse(ack_res, "Access denied. Only Administrators and Engineers and Viewer can perform operation.");
                            break block8;
                        }
                    }
                    break;
                }
                case "dispenser": {
                    String operation_type;
                    if (!json.has("operation_type")) break;
                    switch (operation_type = json.getString("operation_type")) {
                        case "add_query": {
                            if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("engineer")) {
                                ack_res = this.dispensor.insertDispenserData(json, user);
                                break block8;
                            }
                            this.setAccessDeniedResponse(ack_res, "Access denied. Only Administrators and Engineers can perform operation.");
                            break block8;
                        }
                        case "update_query": {
                            if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("engineer")) {
                                ack_res = this.dispensor.updateDispenserData(json, user);
                                break block8;
                            }
                            this.setAccessDeniedResponse(ack_res, "Access denied. Only Administrators and Engineers can perform operation.");
                            break block8;
                        }
                        case "delete_query": {
                            if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("engineer")) {
                                ack_res = this.dispensor.deleteDispenserData(json, user);
                                break block8;
                            }
                            this.setAccessDeniedResponse(ack_res, "Access denied. Only Administrators and Engineers can perform operation.");
                            break block8;
                        }
                        case "get_query": {
                            if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                ack_res = this.dispensor.getAllDispenserData(json, user);
                                break block8;
                            }
                            this.setAccessDeniedResponse(ack_res, "Access denied. Only Administrators and Engineers and Viewer can perform operation.");
                            break block8;
                        }
                    }
                    break;
                }
                case "alarm": {
                    String operation_type;
                    if (!json.has("operation_type")) break;
                    switch (operation_type = json.getString("operation_type")) {
                        case "add_query": {
                            if (userRole.equalsIgnoreCase("admin")) {
                                ack_res = this.alarm.insertAlarmData(json, user);
                                break block8;
                            }
                            this.setAccessDeniedResponse(ack_res, "Access denied. Only Administrators and Engineers can perform operation.");
                            break block8;
                        }
                        case "update_query": {
                            if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("engineer")) {
                                ack_res = this.alarm.updateAlarmData(json, user);
                                break block8;
                            }
                            this.setAccessDeniedResponse(ack_res, "Access denied. Only Administrators and Engineers can perform operation.");
                            break block8;
                        }
                        case "delete_query": {
                            if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("engineer")) {
                                ack_res = this.alarm.deleteAlarmData(json, user);
                                break block8;
                            }
                            this.setAccessDeniedResponse(ack_res, "Access denied. Only Administrators and Engineers can perform operation.");
                            break block8;
                        }
                        case "get_query": {
                            if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                ack_res = this.alarm.getAllAlarmData(json, user);
                                break block8;
                            }
                            this.setAccessDeniedResponse(ack_res, "Access denied. Only Administrators and Engineers and Viewer can perform operation.");
                            break block8;
                        }
                    }
                    break;
                }
                case "command": {
                    String operation_type;
                    if (!json.has("operation_type")) break;
                    switch (operation_type = json.getString("operation_type")) {
                        case "add_query": {
                            if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("engineer")) {
                                ack_res = this.command.insertCommandData(json, user);
                                break block8;
                            }
                            this.setAccessDeniedResponse(ack_res, "Access denied. Only Administrators and Engineers can perform operation.");
                            break block8;
                        }
                        case "update_query": {
                            if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("engineer")) {
                                ack_res = this.command.updateCommandData(json, user);
                                break block8;
                            }
                            this.setAccessDeniedResponse(ack_res, "Access denied. Only Administrators and Engineers can perform operation.");
                            break block8;
                        }
                        case "delete_query": {
                            if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("engineer")) {
                                ack_res = this.command.deleteCommandData(json, user);
                                break block8;
                            }
                            this.setAccessDeniedResponse(ack_res, "Access denied. Only Administrators and Engineers can perform operation.");
                            break block8;
                        }
                        case "get_query": {
                            if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                ack_res = this.command.getAllCommandData(json, user);
                                break block8;
                            }
                            this.setAccessDeniedResponse(ack_res, "Access denied. Only Administrators and Engineers and Viewer can perform operation.");
                            break block8;
                        }
                    }
                    break;
                }
                case "smtp": {
                    String operation_type;
                    if (!json.has("operation_type")) break;
                    switch (operation_type = json.getString("operation_type")) {
                        case "add_query": {
                            if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("engineer")) {
                                ack_res = this.smtp.insertSmtpSetting(json, user);
                                break block8;
                            }
                            this.setAccessDeniedResponse(ack_res, "Access denied. Only Administrators and Engineers can perform operation.");
                            break block8;
                        }
                        case "update_query": {
                            if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("engineer")) {
                                ack_res = this.smtp.updateSmtpSetting(json, user);
                                break block8;
                            }
                            this.setAccessDeniedResponse(ack_res, "Access denied. Only Administrators and Engineers can perform operation.");
                            break block8;
                        }
                        case "delete_query": {
                            if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("engineer")) {
                                ack_res = this.smtp.deleteSmtpSetting(user);
                                break block8;
                            }
                            this.setAccessDeniedResponse(ack_res, "Access denied. Only Administrators and Engineers can perform operation.");
                            break block8;
                        }
                        case "get_query": {
                            if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                ack_res = this.smtp.getSmtpSetting();
                                break block8;
                            }
                            this.setAccessDeniedResponse(ack_res, "Access denied. Only Administrators and Engineers and Viewer can perform operation.");
                            break block8;
                        }
                    }
                    break;
                }
            }
        }
        return ack_res;
    }

    private void setAccessDeniedResponse(JSONObject ackRes, String message) throws JSONException {
        ackRes.put("status", "success");
        ackRes.put("msg", message);
    }
}

