/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.protocol.startanWebSocket;

import com.tas.wp500.App;
import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.protocol.startanWebSocket.CommandProcessorTask;
import com.tas.wp500.services.Service;
import com.tas.wp500.util.ConfigUtils;
import com.tas.wp500.webSocket.FcgiCommand;
import com.tas.wp500.webSocket.WebSocketMessageProcessor;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import startanSubscribeWebSocket.StartanSubscribeWebExecutor;

public class StartanWebExecutor
implements Runnable {
    private static Logger logger = Logger.getLogger(StartanWebExecutor.class);
    private static final FcgiCommand fcgi = FcgiCommand.getInstance();
    private static ArrayList<Timer> startonTimerList = new ArrayList();
    private static final Map<String, JSONArray> jsonArrayMap = new HashMap<String, JSONArray>();
    private static final int MAX_RETRIES = 5;
    private static final long RETRY_INTERVAL = 5000L;

    @Override
    public void run() {
        int retryCount = 0;
        while (retryCount < 5) {
            try {
                JSONObject fcgiGetListResponse = fcgi.executeFCGIgetListCommand();
                if (fcgiGetListResponse.has("status") && fcgiGetListResponse.has("result")) {
                    if ("Success".equals(fcgiGetListResponse.getString("status"))) {
                        jsonArrayMap.clear();
                        JSONArray jsonArray = fcgiGetListResponse.getJSONArray("result");
                        jsonArrayMap.put("resultArray", jsonArray);
                        StartanWebExecutor.retrieveAndProcessJSONArray();
                        break;
                    }
                    logger.debug("Status is Fail, retrying...");
                    ++retryCount;
                    TimeUnit.MILLISECONDS.sleep(5000L);
                    continue;
                }
                logger.info("Status or result not found in the response, retrying...");
                ++retryCount;
                TimeUnit.MILLISECONDS.sleep(5000L);
            }
            catch (Exception e) {
                logger.error("Error while executing startan webSocket: " + e.getMessage(), e);
                ++retryCount;
                try {
                    TimeUnit.MILLISECONDS.sleep(5000L);
                }
                catch (InterruptedException ie) {
                    logger.error("Interrupted during sleep: " + ie.getMessage(), ie);
                    Thread.currentThread().interrupt();
                }
            }
        }
        if (retryCount >= 5) {
            logger.error("Max retries reached. Unable to get a successful response from FcgiCommand.");
        }
    }

    private static List<JSONArray> divideJSONArray(JSONArray jsonArray, int chunkSize) {
        ArrayList<JSONArray> chunks = new ArrayList<JSONArray>();
        for (int i = 0; i < jsonArray.length(); i += chunkSize) {
            JSONArray chunk = new JSONArray();
            for (int j = i; j < i + chunkSize && j < jsonArray.length(); ++j) {
                chunk.put(jsonArray.get(j));
            }
            chunks.add(chunk);
        }
        return chunks;
    }

    private static JSONObject buildCommandObject(JSONArray chunk) throws JSONException {
        JSONObject commandObj = new JSONObject();
        commandObj.put("cmd", "read2");
        JSONArray dataArray = new JSONArray();
        for (int i = 0; i < chunk.length(); ++i) {
            String item = chunk.getString(i);
            JSONObject obj = new JSONObject();
            obj.put("name", "app." + item);
            dataArray.put(obj);
        }
        commandObj.put("data", dataArray);
        return commandObj;
    }

    public void cancelStartonWebSocketTasks(String user) {
        try {
            ArrayList<Timer> timersCopy = new ArrayList<Timer>(startonTimerList);
            for (Timer t : timersCopy) {
                if (t == null) continue;
                t.cancel();
            }
            startonTimerList.clear();
            StartanSubscribeWebExecutor.restartService();
            App.simpleServer.getName_space().removeNodes("Starton");
            logger.info("All StartonWebSocketTimer canceled successfully.");
            FileBasedLogger.info("Application", "All StartonWebSocketTimer canceled successfully.", user);
        }
        catch (ConcurrentModificationException cme) {
            logger.warn("ConcurrentModificationException occurred while canceling timers. This might be due to simultaneous modification of the list.", cme);
            FileBasedLogger.error("Application", "ConcurrentModificationException occurred while canceling timers. This might be due to simultaneous modification of the list : " + cme, user);
        }
        catch (Exception e) {
            logger.error("Error while canceling StartonWebSocketTime : ", e);
            FileBasedLogger.error("Application", "Error while canceling StartonWebSocketTime : " + e, user);
        }
    }

    public static void processJSONArray(JSONArray jsonArray) {
        try {
            Service.variableTagMap.clear();
            logger.info("Cleared the variableTagMap.");
            logger.info("Added " + jsonArray.length() + " items to variableTagMap.");
            int chunkSize = 500;
            List<JSONArray> chunks = StartanWebExecutor.divideJSONArray(jsonArray, chunkSize);
            logger.debug("Divided JSON array into " + chunks.size() + " chunks.");
            WebSocketMessageProcessor messageProcessor = new WebSocketMessageProcessor();
            Thread processorThread = new Thread(messageProcessor);
            processorThread.start();
            Integer startonInterval = ConfigUtils.getStratonInterval();
            boolean chunkCount = false;
            for (JSONArray chunk : chunks) {
                try {
                    JSONObject commandObj = StartanWebExecutor.buildCommandObject(chunk);
                    Timer timer = new Timer();
                    timer.schedule((TimerTask)new CommandProcessorTask(commandObj), 1000L, (long)(startonInterval * 1000));
                    Thread.sleep(500L);
                    startonTimerList.add(timer);
                    logger.debug("Scheduled task for chunk with size " + chunk.length());
                }
                catch (JSONException e) {
                    logger.error("Error while building command object or scheduling task: " + e.getMessage(), e);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error occurred while processing JSON array: " + e.getMessage(), e);
        }
    }

    public static void retrieveAndProcessJSONArray() {
        try {
            JSONArray jsonArray = jsonArrayMap.get("resultArray");
            if (jsonArray != null) {
                StartanWebExecutor.processJSONArray(jsonArray);
                logger.debug("JSONArray processed successfully.");
            } else {
                logger.warn("JSONArray with key 'resultArray' not found in HashMap.");
            }
        }
        catch (Exception e) {
            logger.error("Error occurred while retrieving and processing JSONArray: " + e.getMessage(), e);
        }
    }

    public static void main(String[] args) {
        StartanWebExecutor startanWebExecutor = new StartanWebExecutor();
        Thread startonThread = new Thread(startanWebExecutor);
        startonThread.setName("STARTON Web MODULE");
        startonThread.start();
        logger.info("Starton WEB executor module started.");
        try {
            Thread.sleep(180000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            e.printStackTrace();
        }
        startanWebExecutor.cancelStartonWebSocketTasks("system");
    }
}

