/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.protocol.startan;

import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.security.Security;
import com.tas.wp500.sql_lite_db.SQLiteConnector;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class StratonStatusFetcher
extends Security {
    private static StratonStatusFetcher instance = null;
    private static Logger logger = Logger.getLogger(StratonStatusFetcher.class);
    private static final int SQLITE_BUSY = 5;
    private static final int RETRY_COUNT = 5;
    private static final int RETRY_DELAY = 10000;

    public static StratonStatusFetcher getInstance() {
        if (instance == null) {
            instance = new StratonStatusFetcher();
        }
        return instance;
    }

    private StratonStatusFetcher() {
        this.createStratonDetailsTable();
    }

    public JSONObject getStratonStatus(String user) throws JSONException {
        String QUERY_STRING = "t5wcmd=status";
        JSONObject resultObj = new JSONObject();
        try {
            String line;
            boolean isNewDataInserted = false;
            ProcessBuilder processBuilder = new ProcessBuilder("bash", "-c", "QUERY_STRING=\"" + QUERY_STRING + "\" t5cgi");
            Process process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null && !line.isEmpty()) {
            }
            StringBuilder jsonBuilder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                jsonBuilder.append(line);
            }
            String jsonString = jsonBuilder.toString();
            JSONObject jsonObject = new JSONObject(jsonString);
            String cmd = jsonObject.getString("cmd");
            int error = jsonObject.getInt("error");
            String errorTxt = jsonObject.getString("errorTxt");
            if (error == 200 && "OK".equals(errorTxt)) {
                JSONArray dataArray = jsonObject.getJSONArray("data");
                for (int i = 0; i < dataArray.length(); ++i) {
                    JSONObject dataObject = dataArray.getJSONObject(i);
                    String name = dataObject.getString("name");
                    String value = dataObject.getString("value");
                    int access = dataObject.getInt("access");
                    int dataError = dataObject.getInt("error");
                    int extError = dataObject.getInt("extError");
                    resultObj.put(name, value);
                }
                String appName = resultObj.getString("sys.appname");
                String appVersion = resultObj.getString("sys.appversion");
                if (!(appName == null || appName.isEmpty() || appName.equals("?") || appVersion == null || appVersion.isEmpty() || appVersion.equals("?"))) {
                    if (!this.checkStratonDetailsExist(appName, appVersion)) {
                        this.insertStratonDetails(appName, appVersion);
                        isNewDataInserted = true;
                    }
                    if (isNewDataInserted) {
                        logger.info("New Straton details inserted : App Name - " + appName + ", App Version - " + appVersion);
                        FileBasedLogger.info("Application", "New Straton details inserted : App Name - " + appName + ", App Version - " + appVersion, user);
                    } else if (!this.checkStratonDetailsMatch(appName, appVersion)) {
                        logger.info("Straton details changed : App Name - " + appName + ", App Version - " + appVersion);
                        FileBasedLogger.info("Application", "Straton details changed : App Name - " + appName + ", App Version - " + appVersion, user);
                        this.updateStratonDetails(appName, appVersion);
                    }
                }
                resultObj.put("status", "success");
                resultObj.put("msg", "Straton details fetched successfully.");
                resultObj.put("status", true);
                resultObj.put("message", "Straton is connected successfully.");
            } else {
                resultObj.put("status", false);
                resultObj.put("message", "Straton is disconnected.");
            }
        }
        catch (IOException | JSONException e) {
            e.printStackTrace();
            resultObj.put("status", "fail");
            resultObj.put("msg", "Error while fetching Straton details.");
            logger.error(" Error occurred while fetching Straton details : " + e);
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkStratonDetailsExist(String appName, String appVersion) {
        Connection connection = null;
        try {
            connection = SQLiteConnector.getConnection();
            String sql = "SELECT COUNT(*) FROM straton_details";
            try (PreparedStatement preparedStatement = connection.prepareStatement(sql);
                 ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    int count = resultSet.getInt(1);
                    boolean bl = count > 0;
                    return bl;
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("Error while checking Straton details: " + e.getMessage());
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkStratonDetailsMatch(String appName, String appVersion) {
        Connection connection = SQLiteConnector.getConnection();
        try {
            String sql = "SELECT COUNT(*) FROM straton_details WHERE app_name = ? AND app_version = ?";
            try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
                String encryptedAppName = StratonStatusFetcher.encrypt(appName);
                String encryptedAppVersion = StratonStatusFetcher.encrypt(appVersion);
                preparedStatement.setString(1, encryptedAppName);
                preparedStatement.setString(2, encryptedAppVersion);
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    if (resultSet.next()) {
                        int count = resultSet.getInt(1);
                        boolean bl = count > 0;
                        return bl;
                    }
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("SQL Error: " + e.getMessage());
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createStratonDetailsTable() {
        Connection connection = SQLiteConnector.getConnection();
        try {
            Statement statement = connection.createStatement();
            String sql = "CREATE TABLE IF NOT EXISTS straton_details (id INTEGER PRIMARY KEY CHECK (id = 1), app_name TEXT, app_version TEXT)";
            statement.execute(sql);
            statement.close();
            logger.info("Straton details table created successfully.");
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("Error while creating Straton details table : " + e);
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertStratonDetails(String appName, String appVersion) {
        for (int attempt = 0; attempt < 5; ++attempt) {
            String sql = "INSERT INTO straton_details (app_name, app_version) VALUES (?, ?)";
            Connection connection = null;
            try {
                connection = SQLiteConnector.getConnection();
                PreparedStatement preparedStatement = connection.prepareStatement(sql);
                preparedStatement.setString(1, StratonStatusFetcher.encrypt(appName));
                preparedStatement.setString(2, StratonStatusFetcher.encrypt(appVersion));
                int rowsAffected = preparedStatement.executeUpdate();
                if (rowsAffected <= 0) break;
                logger.info("Straton details inserted successfully.");
                break;
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (e.getErrorCode() != 5 || attempt == 4) {
                    logger.error("Error while inserting Straton details : " + e);
                    e.printStackTrace();
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStratonDetails(String appName, String appVersion) {
        Connection connection = null;
        for (int attempt = 0; attempt < 5; ++attempt) {
            try {
                connection = SQLiteConnector.getConnection();
                String updateSql = "UPDATE straton_details SET app_name = ?, app_version = ? WHERE id = 1";
                PreparedStatement updateStatement = connection.prepareStatement(updateSql);
                updateStatement.setString(1, StratonStatusFetcher.encrypt(appName));
                updateStatement.setString(2, StratonStatusFetcher.encrypt(appVersion));
                int rowsAffected = updateStatement.executeUpdate();
                updateStatement.close();
                if (rowsAffected <= 0) break;
                logger.info("Straton details changed : App Name - " + appName + ", App Version - " + appVersion);
                break;
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (e.getErrorCode() != 5 || attempt == 4) {
                    e.printStackTrace();
                    logger.error("Error while updating Straton details : " + e);
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
    }
}

