/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.protocol.startan;

import com.tas.wp500.App;
import com.tas.wp500.cgi_command.CGI_Command;
import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.protocol.startan.Tag;
import com.tas.wp500.services.Service;
import java.util.TimerTask;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class StartonQueryDataFetcher
extends TimerTask {
    private static Logger logger = Logger.getLogger(StartonQueryDataFetcher.class);
    private CGI_Command cgi = CGI_Command.getInstance();
    private String query;

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    @Override
    public void run() {
        try {
            JSONObject readMultiplevariableUsingCGICommand;
            if (!this.query.isEmpty() && (readMultiplevariableUsingCGICommand = this.cgi.readMultiplevariableUsingCGICommand(new JSONObject().put("commandString", this.query))) != null && readMultiplevariableUsingCGICommand.has("status") && readMultiplevariableUsingCGICommand.getString("status").equalsIgnoreCase("Success") && readMultiplevariableUsingCGICommand.has("result")) {
                String resultString = readMultiplevariableUsingCGICommand.get("result").toString();
                JSONArray jsonArray = new JSONArray(resultString);
                for (int i = 0; i < jsonArray.length(); ++i) {
                    try {
                        JSONObject jsonObject = jsonArray.getJSONObject(i);
                        String name = jsonObject.getString("name");
                        String value = jsonObject.getString("value");
                        int access = jsonObject.getInt("access");
                        int error = jsonObject.getInt("error");
                        int extError = jsonObject.getInt("extError");
                        Tag tag = new Tag(name, value, access, error, extError);
                        Service.variableTagMap.put(name.split("\\.")[1], tag);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error("Error while creating JSON object array : " + e);
                        FileBasedLogger.error("Application", "Error while creating JSON object array : " + e, "system");
                    }
                }
                App.simpleServer.getName_space().addStartonDataOnOpcUaServer(Service.variableTagMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while reading data from query : " + e);
            FileBasedLogger.error("Application", "Error while reading data from query : " + e, "system");
        }
    }
}

