/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.protocol.startan;

import com.tas.wp500.App;
import com.tas.wp500.cgi_command.CGI_Command;
import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.protocol.startan.StartonQueryDataFetcher;
import com.tas.wp500.protocol.startan.Tag;
import com.tas.wp500.util.ConfigUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class StartanExecutor
implements Runnable {
    private static Logger logger = Logger.getLogger(StartanExecutor.class);
    private CGI_Command cgi = CGI_Command.getInstance();
    public static HashMap<String, Tag> tagMap = new HashMap();
    private ArrayList<Timer> startonTimerList = new ArrayList();

    @Override
    public void run() {
        try {
            JSONObject cgiListResponse = this.cgi.executeCGIgetListCommand(new JSONObject());
            if (cgiListResponse.has("status") && cgiListResponse.has("result")) {
                tagMap.clear();
                Object object = cgiListResponse.get("result");
                JSONArray jsonArray = new JSONArray(object.toString());
                for (int i = 0; i < jsonArray.length(); ++i) {
                    String item = jsonArray.getString(i);
                    tagMap.put(item, null);
                }
                if (!tagMap.isEmpty()) {
                    Set<String> keySet = tagMap.keySet();
                    StringBuilder queryStringBuilder = new StringBuilder();
                    for (String name : keySet) {
                        if (queryStringBuilder.length() > 0) {
                            queryStringBuilder.append("&");
                        } else {
                            queryStringBuilder.append("t5wcmd=read&");
                        }
                        queryStringBuilder.append("name=app.").append(name);
                    }
                    String commandString = "QUERY_STRING=\"" + queryStringBuilder.toString() + "\" t5cgi";
                    Integer startonInterval = ConfigUtils.getStratonInterval();
                    Timer startonTimer = new Timer();
                    StartonQueryDataFetcher query = new StartonQueryDataFetcher();
                    query.setQuery(commandString);
                    startonTimer.scheduleAtFixedRate((TimerTask)query, 100L, (long)(startonInterval * 1000));
                    this.startonTimerList.add(startonTimer);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while executing startan : " + e);
            FileBasedLogger.error("Application", "Error while executing startan : " + e, "system");
        }
    }

    public void cancelStartonTimers(String user) {
        try {
            if (!this.startonTimerList.isEmpty()) {
                this.startonTimerList.forEach(new Consumer<Timer>(){

                    @Override
                    public void accept(Timer t) {
                        if (t != null) {
                            t.cancel();
                        }
                    }
                });
            }
            this.startonTimerList.clear();
            App.simpleServer.getName_space().removeNodes("Starton");
        }
        catch (Exception e) {
            logger.error("Error while cancel timer for starton : " + e);
            FileBasedLogger.error("Application", "Error while cancel timer for starton : " + e, user);
            e.printStackTrace();
        }
    }
}

