/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.protocol.opc;

import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.opc_Settings.OpcClientSettingsOperations;
import com.tas.wp500.opc_ua_apis.Browse;
import com.tas.wp500.opc_ua_client.ClientClass;
import com.tas.wp500.opc_ua_client.OpcClientExecutorClass;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class ThirdPartyExecutor
implements Runnable {
    private static Logger logger = Logger.getLogger(ThirdPartyExecutor.class);
    private OpcClientSettingsOperations opc = OpcClientSettingsOperations.getInstance();
    private ArrayList<Timer> opcTimerList = new ArrayList();

    @Override
    public void run() {
        try {
            JSONObject allOpcClientSettings = this.opc.getAllOpcClientSettings("wp500");
            JSONArray data = allOpcClientSettings.getJSONArray("data");
            for (int i = 0; i < data.length(); ++i) {
                JSONObject eachOpc = data.getJSONObject(i);
                final String endUrl = eachOpc.getString("endUrl");
                final String username = eachOpc.getString("Username");
                final String password = eachOpc.getString("Password");
                final String security = eachOpc.getString("Security");
                final String actionType = eachOpc.getString("ActionType");
                final String prefix = eachOpc.getString("prefix");
                Timer opcTimer = new Timer(prefix);
                opcTimer.scheduleAtFixedRate(new TimerTask(){

                    @Override
                    public void run() {
                        if (actionType.equalsIgnoreCase("Enable")) {
                            if (!OpcClientExecutorClass.connections.containsKey(prefix)) {
                                ClientClass clientClass = new ClientClass(endUrl, username, password, security, prefix);
                                if (clientClass.setThirdPartyOpcClient()) {
                                    logger.info("Conneted to server : " + endUrl);
                                    FileBasedLogger.info("Application", " Conneted to server : " + endUrl, "system");
                                    OpcClientExecutorClass.connections.put(prefix, clientClass);
                                } else {
                                    logger.info("Not Conneted to server : " + endUrl);
                                    FileBasedLogger.info("Application", "Not Conneted to server : " + endUrl, "system");
                                }
                            } else {
                                boolean connected = Browse.isConnected(OpcClientExecutorClass.connections.get(prefix));
                                if (connected) {
                                    logger.info(endUrl + " - already connected.");
                                    FileBasedLogger.info("Application", endUrl + " - already connected.", "system");
                                } else {
                                    logger.info(endUrl + " - server not connected.");
                                    FileBasedLogger.info("Application", endUrl + " - server not connected.", "system");
                                    OpcClientExecutorClass.connections.remove(prefix);
                                }
                            }
                        }
                    }
                }, 5000L, 120000L);
                this.opcTimerList.add(opcTimer);
            }
        }
        catch (Exception e) {
            logger.error("Error while conneting thirdparty opc ua client.");
            FileBasedLogger.error("Application", "Error while conneting thirdparty opc ua client.", "system");
            e.printStackTrace();
        }
    }

    public void cancelOPCTimers(String user) {
        try {
            if (!this.opcTimerList.isEmpty()) {
                this.opcTimerList.forEach(timer -> {
                    if (timer != null) {
                        timer.cancel();
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            FileBasedLogger.error("Application", "Error while cancel opcua timer : " + e, user);
        }
    }
}

