/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.protocol.mqtt;

import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.led_script.LEDShellScript;
import com.tas.wp500.mqttSettings.MQTT;
import com.tas.wp500.mqttSettings.MQTT_opertions;
import com.tas.wp500.protocol.mqtt.MQTTService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttException;

public class MqttExecutor
implements Runnable {
    private static Logger logger = Logger.getLogger(MqttExecutor.class);
    private MQTT_opertions mqtt_opertions = MQTT_opertions.getInstance();
    public static HashMap<String, MqttClient> serverlistMap = new HashMap();
    private ArrayList<Timer> mqttTimerList = new ArrayList();
    private LEDShellScript led = LEDShellScript.getInstance();

    @Override
    public void run() {
        final ArrayList<MQTT> allMqttData = this.mqtt_opertions.getAllMqttData();
        if (!allMqttData.isEmpty()) {
            logger.info("Total query of MQTT are  : " + allMqttData.size());
            Timer mqttTimer = new Timer();
            mqttTimer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    for (int i = 0; i < allMqttData.size(); ++i) {
                        try {
                            MQTT mqtt = (MQTT)allMqttData.get(i);
                            if (mqtt == null || mqtt.getBroker_ip_address() == null || mqtt.getEnable() == null) {
                                logger.error("MQTT data or required fields are null for index: " + i);
                                continue;
                            }
                            if (!serverlistMap.containsKey(mqtt.getBroker_ip_address())) {
                                if (mqtt.getEnable().equalsIgnoreCase("Enable")) {
                                    MQTTService mqttService = new MQTTService();
                                    mqttService.setMqttData(mqtt);
                                    mqttService.doConnection();
                                }
                            } else {
                                logger.info("Connected MQTT broker size : " + serverlistMap.size());
                                if (!serverlistMap.get(mqtt.getBroker_ip_address()).isConnected()) {
                                    serverlistMap.remove(mqtt.getBroker_ip_address());
                                    logger.info("ipAddress is removed----->" + mqtt.getBroker_ip_address());
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            logger.error("Error while connecting broker : " + e);
                        }
                        try {
                            Thread.sleep(5000L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }, 1000L, 120000L);
            this.mqttTimerList.add(mqttTimer);
        }
        Timer connectionCheckTimer = new Timer();
        connectionCheckTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                serverlistMap.forEach((ip, client) -> {
                    if (client != null && !client.isConnected()) {
                        logger.info("MQTT client " + ip + " is not connected. Attempting to reconnect...");
                        serverlistMap.remove(ip);
                        logger.info("ipAddress is removed----->" + ip);
                        LEDShellScript.getInstance().runMqttShellScript("-1", "0");
                    }
                });
            }
        }, 0L, 30000L);
        this.mqttTimerList.add(connectionCheckTimer);
    }

    public void cancelConnection(String user) {
        try {
            serverlistMap.forEach((x, y) -> {
                try {
                    if (y != null && y.isConnected()) {
                        y.disconnect();
                        logger.info("Mqtt Client " + y.getServerURI() + " diconnected successfully.");
                    }
                }
                catch (MqttException e) {
                    e.printStackTrace();
                }
            });
            serverlistMap.clear();
            this.cancelMqttTimer();
        }
        catch (Exception e) {
            FileBasedLogger.error("Application", "Error while cancel Mqtt Timers : " + e, user);
            logger.error("Error while cancel Timers : ", e);
        }
    }

    private void cancelMqttTimer() {
        try {
            if (!this.mqttTimerList.isEmpty()) {
                this.mqttTimerList.forEach(new Consumer<Timer>(){

                    @Override
                    public void accept(Timer t) {
                        if (t != null) {
                            t.cancel();
                        }
                    }
                });
            }
            this.mqttTimerList.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while canceling Mqtt Timers : " + e);
        }
    }
}

