/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.protocol.mqtt;

import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.led_script.LEDShellScript;
import com.tas.wp500.mqttSettings.MQTT;
import com.tas.wp500.protocol.command.CommandWriteExecutor;
import com.tas.wp500.protocol.mqtt.MqttExecutor;
import com.tas.wp500.store_and_forword.StoreAndForwordDbOperations;
import com.tas.wp500.store_and_forword.StoreAndForwordExecutor;
import com.tas.wp500.store_and_forword.StoreForword;
import com.tas.wp500.util.Util;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.KeyStore;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.log4j.Logger;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.eclipse.paho.client.mqttv3.persist.MqttDefaultFilePersistence;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

public class MQTTService
implements MqttCallback {
    private static Logger logger = Logger.getLogger(MQTTService.class);
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private StoreAndForwordDbOperations saf = StoreAndForwordDbOperations.getInstance();
    private LEDShellScript led = LEDShellScript.getInstance();
    private MQTT mqttData;
    public MqttClient client;
    private String ipAdddress;
    private String port;
    private String userName;
    private String Password;
    private String topicList;
    private String type;
    private String publish_topic;
    private String clientId;
    private String file_name;
    private String time_format;

    public MQTT getMqttData() {
        return this.mqttData;
    }

    public void setMqttData(MQTT mqttData) {
        this.mqttData = mqttData;
        this.ipAdddress = mqttData.getBroker_ip_address();
        this.port = String.valueOf(mqttData.getPort_number());
        this.userName = mqttData.getUsername();
        this.Password = mqttData.getPassword();
        this.type = mqttData.getFile_type();
        this.topicList = mqttData.getSubscribe_topic().trim();
        this.publish_topic = mqttData.getPublish_topic();
        this.clientId = mqttData.getClient_id().equals("") || mqttData.getClient_id().isEmpty() ? this.userName + System.currentTimeMillis() : mqttData.getClient_id();
        this.file_name = mqttData.getFile_name();
        this.time_format = mqttData.getTime_format();
    }

    @Override
    public void connectionLost(Throwable cause) {
        if (MqttExecutor.serverlistMap.containsKey(this.ipAdddress)) {
            MqttExecutor.serverlistMap.remove(this.ipAdddress);
            StoreAndForwordDbOperations.storeForwardDataFlag = false;
            if (cause != null) {
                logger.error("Connection lost due to: " + cause.toString());
                logger.error("Cause message: " + cause.getMessage());
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                cause.printStackTrace(pw);
                logger.error("Stack trace: " + sw.toString());
                FileBasedLogger.error("Application", "Connection lost due to: " + cause.getMessage(), "system");
            } else {
                logger.warn("Connection lost, but no cause was provided.");
                FileBasedLogger.warn("Application", "Connection lost with no cause provided.", "system");
            }
            this.led.runMqttShellScript("-1", "0");
        }
    }

    @Override
    public void messageArrived(String topic, MqttMessage message) {
        try {
            String payload = new String(message.getPayload());
            Object json = new JSONTokener(payload).nextValue();
            if (!(json instanceof JSONObject) && json instanceof JSONArray) {
                logger.info("MSG Received From topic :  " + topic + "  msg : " + payload);
                CommandWriteExecutor cmd = new CommandWriteExecutor();
                cmd.setWriteResp(payload);
                new Thread(cmd).start();
            }
        }
        catch (Exception e) {
            FileBasedLogger.error("Application", "Error while processing message from topic: " + topic + ". Message: " + message + ". Error: " + e.getMessage(), "system");
        }
    }

    @Override
    public void deliveryComplete(IMqttDeliveryToken token) {
        try {
            String messageDataFromToken;
            if (!(token != null && token.isComplete() || (messageDataFromToken = MQTTService.getMessageDataFromToken(token)) == null)) {
                this.insertRecordIntoDB(messageDataFromToken);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void insertRecordIntoDB(String msg) {
        StoreForword s = new StoreForword();
        s.setDate_time(Util.checkISToUTC(this.time_format));
        s.setData_string(msg);
        s.setBroker_ip_address(this.ipAdddress);
        s.setPublish_topic(this.publish_topic);
        this.saf.addStoreForwordData(s);
        logger.info("Msg not Published so inserting into db : " + s);
    }

    private static String getMessageDataFromToken(IMqttDeliveryToken token) {
        try {
            MqttMessage message = token.getMessage();
            if (message != null) {
                return new String(message.getPayload());
            }
        }
        catch (MqttException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void doConnection() {
        block21: {
            if (this.type.equalsIgnoreCase("TCP")) {
                MemoryPersistence persistence = new MemoryPersistence();
                try {
                    this.client = this.clientId.equals("") || this.clientId.isEmpty() ? new MqttClient("tcp://" + this.ipAdddress + ":" + Integer.parseInt(this.port), MqttClient.generateClientId(), persistence) : new MqttClient("tcp://" + this.ipAdddress + ":" + Integer.parseInt(this.port), this.clientId, persistence);
                }
                catch (MqttException e1) {
                    e1.printStackTrace();
                    logger.error("Failed to create MQTT client for TCP connection. IP: " + this.ipAdddress + ", Port: " + this.port + ". Error: " + e1.getMessage());
                    FileBasedLogger.error("Application", "Failed to create MQTT client for TCP connection. IP: " + this.ipAdddress + ", Port: " + this.port + ". Error: " + e1.getMessage(), "system");
                    this.led.runMqttShellScript("-1", "0");
                }
                MqttConnectOptions connectOptions = new MqttConnectOptions();
                connectOptions.setCleanSession(false);
                connectOptions.setMaxInflight(3000);
                connectOptions.setUserName(this.userName);
                connectOptions.setPassword(this.Password.toCharArray());
                connectOptions.setConnectionTimeout(15);
                connectOptions.setKeepAliveInterval(20);
                this.client.setCallback(this);
                try {
                    IMqttToken mqttConnectionToken = this.client.connectWithResult(connectOptions);
                    boolean status = this.client.isConnected();
                    if (status) {
                        try {
                            logger.info(String.format("Connection Status : %s", status));
                            MqttExecutor.serverlistMap.put(this.ipAdddress, this.client);
                            StoreAndForwordExecutor.storeForwardPublishedFlag = false;
                            this.client.subscribe(this.topicList);
                            this.led.runMqttShellScript("1", "0");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        break block21;
                    }
                    if (MqttExecutor.serverlistMap.size() > 0 && MqttExecutor.serverlistMap.containsKey(this.ipAdddress)) {
                        MqttExecutor.serverlistMap.remove(this.ipAdddress);
                        logger.info("MqttServerCall removeMQTTClient : " + this.ipAdddress);
                    }
                    this.led.runMqttShellScript("-1", "0");
                }
                catch (MqttException e) {
                    e.printStackTrace();
                    logger.error("Error while connecting MQTT client for TCP. IP: " + this.ipAdddress + ", Port: " + this.port + ". Error: " + e.getMessage());
                    FileBasedLogger.error("Application", "Error while connecting MQTT client for TCP. IP: " + this.ipAdddress + ", Port: " + this.port + ". Error: " + e.getMessage(), "system");
                    this.led.runMqttShellScript("-1", "0");
                }
            } else if (this.type.equalsIgnoreCase("SSl")) {
                try {
                    String filePath = null;
                    filePath = !this.file_name.isEmpty() ? (this.file_name.contains("crt") ? "/usr/bin/crt_files/" + this.file_name : (this.file_name.contains("pem") ? "/usr/bin/crt_files/" + this.file_name : "/usr/bin/crt_files/" + this.file_name + ".crt")) : "ca.crt";
                    logger.debug("FilePath : " + filePath);
                    if (filePath != null) {
                        logger.info("SSL connection Establishing.");
                        String tmpDir = System.getProperty("java.io.tmpdir");
                        MqttConnectOptions options = new MqttConnectOptions();
                        options.setCleanSession(false);
                        options.setMaxInflight(3000);
                        options.setConnectionTimeout(15);
                        options.setKeepAliveInterval(20);
                        if (!this.userName.equalsIgnoreCase("")) {
                            options.setUserName(this.userName);
                        }
                        if (!this.Password.equalsIgnoreCase("")) {
                            options.setPassword(this.Password.toCharArray());
                        }
                        this.client = this.clientId.equals("") || this.clientId.isEmpty() ? new MqttClient("ssl://" + this.ipAdddress + ":" + this.port, MqttClient.generateClientId(), new MqttDefaultFilePersistence(tmpDir)) : new MqttClient("ssl://" + this.ipAdddress + ":" + this.port, this.clientId, new MqttDefaultFilePersistence(tmpDir));
                        SSLContext sslContext = SSLContext.getInstance("SSL");
                        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                        KeyStore keyStore = this.readKeyStore(filePath.trim());
                        trustManagerFactory.init(keyStore);
                        sslContext.init(null, trustManagerFactory.getTrustManagers(), null);
                        options.setSocketFactory(sslContext.getSocketFactory());
                        this.client.connect(options);
                        if (this.client.isConnected()) {
                            try {
                                MqttExecutor.serverlistMap.put(this.ipAdddress, this.client);
                                StoreAndForwordExecutor.storeForwardPublishedFlag = false;
                                this.client.setCallback(this);
                                logger.info(String.format("SSL connection established. Subscribed to topics: %s on server: %s", this.topicList, this.ipAdddress));
                                this.client.subscribe(this.topicList, 2);
                                this.led.runMqttShellScript("1", "0");
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                logger.error("Error while connecting mqtt : " + e);
                                FileBasedLogger.error("Application", "Error during SSL connection setup for IP: " + this.ipAdddress + ". Error: " + e.getMessage(), "system");
                            }
                        } else {
                            if (MqttExecutor.serverlistMap.size() > 0 && MqttExecutor.serverlistMap.containsKey(this.ipAdddress)) {
                                MqttExecutor.serverlistMap.remove(this.ipAdddress);
                                logger.info("MqttServerCall removeMQTTClient " + this.ipAdddress);
                            }
                            logger.warn("SSL connection failed for IP " + this.ipAdddress);
                            FileBasedLogger.warn("Application", "SSL connection failed for IP " + this.ipAdddress, "system");
                            this.led.runMqttShellScript("-1", "0");
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.led.runMqttShellScript("-1", "0");
                    logger.error("Error during SSL connection setup for IP: " + this.ipAdddress + ". Error: " + e.getMessage());
                    FileBasedLogger.error("Application", "Error during SSL connection setup for IP: " + this.ipAdddress + ". Error: " + e.getMessage(), "system");
                }
            }
        }
    }

    public void publish(String topicSuffix, String content) {
        MqttMessage message = new MqttMessage();
        message.setPayload(content.getBytes());
        message.setQos(2);
        try {
            String topic = "";
            if (this.client.isConnected()) {
                logger.info("Connection Status :" + this.client.isConnected());
            }
            this.client.publish(topic, message);
        }
        catch (MqttPersistenceException e) {
            e.printStackTrace();
        }
        catch (MqttException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public KeyStore readKeyStore(String filepath) {
        try {
            FileInputStream is = new FileInputStream(filepath);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate caCert = (X509Certificate)cf.generateCertificate(is);
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(null);
            ks.setCertificateEntry("caCert", caCert);
            return ks;
        }
        catch (Exception e) {
            logger.error("Unexpected error while reading KeyStore from file: " + filepath, e);
            FileBasedLogger.info("Application", "Unexpected error while reading KeyStore from file: " + filepath + " Error : " + e.getMessage(), "system");
            return null;
        }
    }
}

