/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.protocol.modbusClient;

import com.ghgande.j2mod.modbus.net.TCPMasterConnection;
import com.tas.wp500.modBusClientSettings.ModbusQueriessDbOperation;
import com.tas.wp500.protocol.modbusClient.ModbusClass;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class TcpModbusExecuter
implements Runnable {
    static final Logger logger = Logger.getLogger(TcpModbusExecuter.class.getName());
    private JSONArray queryList;
    private String query_string;
    public static ArrayList<Timer> conn_timers = new ArrayList();
    public static HashMap<String, TCPMasterConnection> ModbusConnections = new HashMap();
    public static ConcurrentHashMap<String, Double> tagHashmap = new ConcurrentHashMap();

    public void cancelTimers() {
        try {
            conn_timers.forEach(new Consumer<Timer>(){

                @Override
                public void accept(Timer timer) {
                    timer.cancel();
                }
            });
            conn_timers.clear();
            logger.info("TCP Modbus timer cancelled");
        }
        catch (Exception e) {
            logger.error("problem to cancel TCP Modbus timer", e);
        }
    }

    @Override
    public void run() {
        try {
            JSONArray array = ModbusQueriessDbOperation.getInstance().getAllModbusQueriesAsJsonArray();
            if (array != null) {
                int i;
                logger.info("Total Modbus tcp Query Count :" + array.length());
                JSONObject query_list_resp_device_name = new JSONObject();
                if (array != null) {
                    for (i = 0; i < array.length(); ++i) {
                        if (array.getJSONObject(i) == null) continue;
                        if (query_list_resp_device_name.has(array.getJSONObject(i).getString("device_name").trim())) {
                            query_list_resp_device_name.getJSONArray(array.getJSONObject(i).getString("device_name")).put(array.getJSONObject(i));
                            continue;
                        }
                        query_list_resp_device_name.put(array.getJSONObject(i).getString("device_name").trim(), new JSONArray().put(array.getJSONObject(i)));
                    }
                }
                if (query_list_resp_device_name.length() != 0) {
                    for (i = 0; i < query_list_resp_device_name.names().length(); ++i) {
                        logger.info("Modbus_TCP_#########" + query_list_resp_device_name.names().getString(i));
                        Timer timer2 = new Timer("Modbus_TCP_" + query_list_resp_device_name.names().getString(i));
                        conn_timers.add(timer2);
                        String conn_per = "true";
                        ModbusClass mod = new ModbusClass(query_list_resp_device_name.getJSONArray(query_list_resp_device_name.names().getString(i)), conn_per);
                        timer2.scheduleAtFixedRate((TimerTask)mod, 500L, 5000L);
                    }
                }
            } else {
                logger.info("modQuery getAll Response is NUll");
            }
            logger.info("TCP Modbus loaded successfully");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info("TCP Modbus not loaded Successfully please check configured mod queries: " + e);
        }
    }
}

