/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.protocol.modbusClient;

import com.ghgande.j2mod.modbus.net.TCPMasterConnection;
import com.tas.wp500.modBusClientSettings.ModbusClientsDbOperation;
import com.tas.wp500.protocol.modbusClient.ModbusClient;
import com.tas.wp500.protocol.modbusClient.TcpModbusExecuter;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ModbusClientExecutor
implements Runnable {
    private static Logger logger = Logger.getLogger(ModbusClientExecutor.class);
    private ModbusClientsDbOperation modbusClientsDbOperation = ModbusClientsDbOperation.getInstance();
    public static List<ModbusClient> connectionArryList = new ArrayList<ModbusClient>();
    private static TCPMasterConnection connection;
    public static boolean flag;

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        while (true) {
            try {
                block4: while (true) {
                    if (ModbusClientExecutor.flag) {
                        this.updateConnectionList();
                        ModbusClientExecutor.flag = false;
                    }
                    if (ModbusClientExecutor.connectionArryList.isEmpty()) continue;
                    var1_1 = ModbusClientExecutor.connectionArryList.iterator();
                    while (true) {
                        if (var1_1.hasNext()) ** break;
                        continue block4;
                        client = var1_1.next();
                        if (TcpModbusExecuter.ModbusConnections.containsKey(client.getDeviceName()) && ModbusClientExecutor.connection.isConnected()) {
                            Thread.sleep(10000L);
                            continue;
                        }
                        ModbusClientExecutor.logger.info(client.getHostIp() + " Modbus connection is not connected and retrying..");
                        if (client.getStatus().equalsIgnoreCase("enable")) {
                            this.setConection(client.getHostIp(), client.getDeviceName(), client.getPortNo());
                            Thread.sleep(2000L);
                        } else {
                            ModbusClientExecutor.logger.info("Client name :" + client.getClientId() + " status :" + client.getStatus());
                        }
                        ModbusClientExecutor.logger.info("Is connected or Not >>>>" + (ModbusClientExecutor.connection != null && ModbusClientExecutor.connection.isConnected() != false));
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                ModbusClientExecutor.logger.error("Thread interrupted while sleeping: " + e.getMessage(), e);
                continue;
            }
            catch (Exception e) {
                ModbusClientExecutor.logger.error("Error occurred: " + e.getMessage(), e);
                continue;
            }
            break;
        }
    }

    private void updateConnectionList() {
        connectionArryList.clear();
        try {
            ArrayList<ModbusClient> allModbusClientData = this.modbusClientsDbOperation.getAllModbusClients();
            if (!allModbusClientData.isEmpty()) {
                for (int i = 0; i < allModbusClientData.size(); ++i) {
                    ModbusClient modbusClient = allModbusClientData.get(i);
                    connectionArryList.add(modbusClient);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error occurred while updating connection list: " + e.getMessage(), e);
        }
    }

    public void setConection(String ipAddress, String clientName, String port) {
        logger.info("Setting TCP MODBUS connection for IP:" + ipAddress);
        try {
            InetAddress addr = InetAddress.getByName(ipAddress.trim());
            connection = new TCPMasterConnection(addr);
            connection.setPort(Integer.parseInt(port));
            connection.setTimeout(10000);
            connection.connect();
            logger.info("TCP MODBUS for " + ipAddress + " is Connected: " + connection.isConnected());
            TcpModbusExecuter.ModbusConnections.put(clientName, connection);
        }
        catch (Exception e) {
            logger.error("Error occurred while establishing connection: " + e.getLocalizedMessage());
        }
    }

    static {
        flag = true;
    }
}

