/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.protocol.modbusClient;

import com.ghgande.j2mod.modbus.ModbusException;
import com.ghgande.j2mod.modbus.io.ModbusTCPTransaction;
import com.ghgande.j2mod.modbus.msg.ReadCoilsRequest;
import com.ghgande.j2mod.modbus.msg.ReadCoilsResponse;
import com.ghgande.j2mod.modbus.msg.ReadInputDiscretesRequest;
import com.ghgande.j2mod.modbus.msg.ReadInputDiscretesResponse;
import com.ghgande.j2mod.modbus.msg.ReadInputRegistersRequest;
import com.ghgande.j2mod.modbus.msg.ReadInputRegistersResponse;
import com.ghgande.j2mod.modbus.msg.ReadMultipleRegistersRequest;
import com.ghgande.j2mod.modbus.msg.ReadMultipleRegistersResponse;
import com.ghgande.j2mod.modbus.msg.WriteCoilRequest;
import com.ghgande.j2mod.modbus.msg.WriteMultipleCoilsRequest;
import com.ghgande.j2mod.modbus.msg.WriteMultipleCoilsResponse;
import com.ghgande.j2mod.modbus.msg.WriteMultipleRegistersRequest;
import com.ghgande.j2mod.modbus.msg.WriteMultipleRegistersResponse;
import com.ghgande.j2mod.modbus.msg.WriteSingleRegisterRequest;
import com.ghgande.j2mod.modbus.net.TCPMasterConnection;
import com.ghgande.j2mod.modbus.procimg.Register;
import com.ghgande.j2mod.modbus.procimg.SimpleRegister;
import com.ghgande.j2mod.modbus.util.BitVector;
import com.tas.wp500.protocol.modbusClient.TcpModbusExecuter;
import com.tas.wp500.protocol.startan.Tag;
import com.tas.wp500.services.Service;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.TimerTask;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ModbusClass
extends TimerTask {
    static final Logger logger = Logger.getLogger(ModbusClass.class.getName());
    public JSONArray array;
    public String conn_persistane = "";

    public ModbusClass() {
    }

    public ModbusClass(JSONArray arr, String con_persistane) {
        this.conn_persistane = con_persistane;
        this.array = arr;
        logger.info("array ---> " + this.array.toString());
        for (int i = 0; i < arr.length(); ++i) {
            try {
                JSONObject query = arr.getJSONObject(i);
                JSONObject json = new JSONObject();
                if (query.has("slave_id")) {
                    json.put("slave_id", query.getString("slave_id"));
                }
                if (query.has("function_code")) {
                    json.put("function_code", query.getString("function_code"));
                }
                if (query.has("start address")) {
                    json.put("start address", query.getString("start_address"));
                }
                if (query.has("device_name")) {
                    json.put("device_name", query.getString("device_name"));
                }
                if (query.has("data_type")) {
                    json.put("data_type", query.getString("data_type"));
                }
                if (query.has("no_of_registerister")) {
                    json.put("no_of_register", query.getString("no_of_register"));
                }
                if (!query.has("queries_name")) continue;
                json.put("queries_name", query.getString("queries_name"));
                continue;
            }
            catch (Exception e) {
                logger.error("ModbusTimerTask" + e);
            }
        }
    }

    @Override
    public void run() {
        JSONObject query;
        int i;
        JSONArray data = new JSONArray();
        for (i = 0; i < this.array.length(); ++i) {
            try {
                query = this.array.getJSONObject(i);
                if (TcpModbusExecuter.ModbusConnections.containsKey(query.getString("device_name"))) {
                    Object key_name;
                    JSONObject outputJsonObj = new JSONObject();
                    switch (query.getString("function_code")) {
                        case "read_coil_status": {
                            data = this.readBooleanListFromCoilStatus(query.getString("device_name"), query, this.conn_persistane);
                            if (data.length() == 0) {
                                outputJsonObj.put("status", "fail");
                                System.out.println(query.getString("device_name") + " of read_coil_status query failed..");
                                break;
                            }
                            outputJsonObj.put("status", "success");
                            outputJsonObj.put("queries_name", query.get("queries_name"));
                            outputJsonObj.put("data", data);
                            break;
                        }
                        case "read_input_status": {
                            data = this.readBooleanListFromInputDiscretes(query.getString("device_name"), query, this.conn_persistane);
                            if (data.length() == 0) {
                                outputJsonObj.put("status", "fail");
                                logger.info(query.getString("device_name") + " of read_input_status query failed..");
                                break;
                            }
                            outputJsonObj.put("status", "success");
                            outputJsonObj.put("queries_name", query.get("queries_name"));
                            outputJsonObj.put("data", data);
                            break;
                        }
                        case "read_holding_registers": {
                            if (query.getString("data_type").equals("non_swap_float")) {
                                data = this.readFloatNonSwapListFromHoldingRegisters(query.getString("device_name"), query, this.conn_persistane);
                                if (data.length() == 0) {
                                    outputJsonObj.put("status", "fail");
                                    logger.info(query.getString("device_name") + " of read_holding_registers non_swap_float query failed..");
                                    break;
                                }
                                outputJsonObj.put("status", "success");
                                outputJsonObj.put("queries_name", query.get("queries_name"));
                                outputJsonObj.put("data", data);
                                break;
                            }
                            if (query.getString("data_type").equals("swap_float")) {
                                data = this.readFloatSwapListFromHoldingRegisters(query.getString("device_name"), query, this.conn_persistane);
                                if (data.length() == 0) {
                                    outputJsonObj.put("status", "fail");
                                    logger.info(query.getString("device_name") + " of read_holding_registers swap_float query failed..");
                                    break;
                                }
                                outputJsonObj.put("status", "success");
                                outputJsonObj.put("queries_name", query.get("queries_name"));
                                outputJsonObj.put("data", data);
                                break;
                            }
                            if (query.getString("data_type").equals("integer")) {
                                data = this.readIntegerListFromHoldingRegisters(query.getString("device_name"), query, this.conn_persistane);
                                if (data.length() == 0) {
                                    outputJsonObj.put("status", "fail");
                                    logger.info(query.getString("device_name") + " of read_holding_registers integer query failed..");
                                    break;
                                }
                                outputJsonObj.put("status", "success");
                                outputJsonObj.put("queries_name", query.get("queries_name"));
                                outputJsonObj.put("data", data);
                                break;
                            }
                            if (query.getString("data_type").equalsIgnoreCase("non_swap_long")) {
                                data = this.readLongListFromHoldingRegisters(query.getString("device_name"), query, this.conn_persistane);
                                if (data.length() == 0) {
                                    outputJsonObj.put("status", "fail");
                                    logger.info(query.getString("device_name") + " of read_holding_registers non_swap_long query failed..");
                                    break;
                                }
                                outputJsonObj.put("status", "success");
                                outputJsonObj.put("queries_name", query.get("queries_name"));
                                outputJsonObj.put("data", data);
                                break;
                            }
                            if (query.getString("data_type").equalsIgnoreCase("swap_long")) {
                                data = this.readSwapLongListFromHoldingRegisters(query.getString("device_name"), query, this.conn_persistane);
                                if (data.length() == 0) {
                                    outputJsonObj.put("status", "fail");
                                    logger.info(query.getString("device_name") + " of read_holding_registers swap_long query failed..");
                                    break;
                                }
                                outputJsonObj.put("status", "success");
                                outputJsonObj.put("queries_name", query.get("queries_name"));
                                outputJsonObj.put("data", data);
                                break;
                            }
                            if (!query.getString("data_type").equalsIgnoreCase("string")) break;
                            data = this.readStringFromHoldingRegisters(query.getString("device_name"), query, this.conn_persistane);
                            if (data.length() == 0) {
                                outputJsonObj.put("status", "fail");
                                logger.info(query.getString("device_name") + " of read_holding_registers string query failed..");
                                break;
                            }
                            outputJsonObj.put("status", "success");
                            outputJsonObj.put("queries_name", query.get("queries_name"));
                            outputJsonObj.put("data", data);
                            break;
                        }
                        case "read_input_registers": {
                            if (query.getString("data_type").equals("non_swap_float")) {
                                data = this.readFloatNonSwapListFromInputRegisters(query.getString("device_name"), query, this.conn_persistane);
                                if (data.length() == 0) {
                                    outputJsonObj.put("status", "fail");
                                    logger.info(query.getString("device_name") + " of read_input_registers non_swap_float query failed..");
                                } else {
                                    outputJsonObj.put("status", "success");
                                    outputJsonObj.put("queries_name", query.get("queries_name"));
                                }
                                outputJsonObj.put("data", data);
                                break;
                            }
                            if (query.getString("data_type").equals("swap_float")) {
                                data = this.readFloatSwapListFromInputRegisters(query.getString("device_name"), query, this.conn_persistane);
                                if (data.length() == 0) {
                                    outputJsonObj.put("status", "fail");
                                    logger.info(query.getString("device_name") + " of read_input_registers swap_float query failed..");
                                    break;
                                }
                                outputJsonObj.put("status", "success");
                                outputJsonObj.put("queries_name", query.get("queries_name"));
                                outputJsonObj.put("data", data);
                                break;
                            }
                            if (query.getString("data_type").equals("integer")) {
                                data = this.readIntegerListFromInputRegisters(query.getString("device_name"), query, this.conn_persistane);
                                if (data.length() == 0) {
                                    outputJsonObj.put("status", "fail");
                                    logger.info(query.getString("device_name") + " of read_input_registers integer query failed..");
                                    break;
                                }
                                outputJsonObj.put("status", "success");
                                outputJsonObj.put("queries_name", query.get("queries_name"));
                                outputJsonObj.put("data", data);
                                break;
                            }
                            if (query.getString("data_type").equalsIgnoreCase("non_swap_long")) {
                                data = this.readLongListFromInputRegisters(query.getString("device_name"), query, this.conn_persistane);
                                if (data.length() == 0) {
                                    outputJsonObj.put("status", "fail");
                                    logger.info(query.getString("device_name") + " of read_input_registers non_swap_long query failed..");
                                    break;
                                }
                                outputJsonObj.put("status", "success");
                                outputJsonObj.put("queries_name", query.get("queries_name"));
                                outputJsonObj.put("data", data);
                                break;
                            }
                            if (!query.getString("data_type").equalsIgnoreCase("swap_long")) break;
                            data = this.readSwapLongListFromInputRegisters(query.getString("device_name"), query, this.conn_persistane);
                            if (data.length() == 0) {
                                outputJsonObj.put("status", "fail");
                                logger.info(query.getString("device_name") + " of read_input_registers swap_long query failed..");
                                break;
                            }
                            outputJsonObj.put("status", "success");
                            outputJsonObj.put("queries_name", query.get("queries_name"));
                            outputJsonObj.put("data", data);
                            break;
                        }
                        default: {
                            logger.warn("no any fun. code");
                        }
                    }
                    Thread.sleep(100L);
                    JSONArray arry = outputJsonObj.getJSONArray("data");
                    for (int j = 0; j < arry.length(); ++j) {
                        JSONObject result = arry.getJSONObject(j);
                        key_name = query.getString("device_name") + "_" + outputJsonObj.getString("queries_name") + "_" + result.get("address");
                        TcpModbusExecuter.tagHashmap.put((String)key_name, result.getDouble("value"));
                        Tag tag = new Tag((String)key_name, result.getDouble("value"), 0, 200, 0);
                        Service.variableTagMap.put(((String)key_name).split("\\.")[1], tag);
                    }
                    for (String s : TcpModbusExecuter.tagHashmap.keySet()) {
                        try {
                            key_name = TcpModbusExecuter.tagHashmap.get(s);
                        }
                        catch (Exception e) {
                            logger.error(e);
                        }
                    }
                    continue;
                }
                logger.error("Hashmap does not conatain key");
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("ModbusTimerTask:" + e);
            }
        }
        for (i = 0; i < this.array.length(); ++i) {
            try {
                query = this.array.getJSONObject(i);
                if (!this.conn_persistane.equalsIgnoreCase("false") || !TcpModbusExecuter.ModbusConnections.containsKey(query.getString("device_name")) || !TcpModbusExecuter.ModbusConnections.get(query.getString("device_name")).isConnected()) continue;
                logger.error("connection closed " + query.getString("device_name"));
                TcpModbusExecuter.ModbusConnections.get(query.getString("device_name")).close();
                TcpModbusExecuter.ModbusConnections.remove(query.getString("device_name"));
                continue;
            }
            catch (Exception e) {
                logger.error("while close  onnections.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray readFloatNonSwapListFromHoldingRegisters(String device_name, JSONObject query, String con_per) {
        JSONArray address_value_obj;
        block16: {
            int count = 0;
            ModbusTCPTransaction trans = null;
            TCPMasterConnection con = null;
            ReadMultipleRegistersRequest hr_req = null;
            ReadMultipleRegistersResponse hr_res = null;
            address_value_obj = null;
            try {
                count = Integer.parseInt(query.getString("no_of_register"));
                int start_addr = Integer.parseInt(query.getString("start_address"));
                if (!TcpModbusExecuter.ModbusConnections.containsKey(device_name)) break block16;
                con = TcpModbusExecuter.ModbusConnections.get(device_name);
                if (con != null && con.isConnected()) {
                    try {
                        hr_req = new ReadMultipleRegistersRequest(start_addr - 1, count);
                        hr_req.setUnitID(Integer.parseInt(query.getString("slave_id")));
                        trans = new ModbusTCPTransaction(con);
                        trans.setRequest(hr_req);
                        address_value_obj = new JSONArray();
                        try {
                            if (con.isConnected()) {
                                trans.execute();
                                hr_res = (ReadMultipleRegistersResponse)trans.getResponse();
                            }
                        }
                        catch (Exception e) {
                            hr_res = null;
                            TcpModbusExecuter.ModbusConnections.remove(device_name);
                            logger.error(device_name + ": modbus connection loss:readFloatNonSwapListFromHoldingRegisters:: " + e);
                        }
                        if (hr_res == null) break block16;
                        int index = 0;
                        while (index + 1 < hr_res.getWordCount()) {
                            try {
                                int lsb = hr_res.getRegisterValue(index);
                                int msb = hr_res.getRegisterValue(index + 1);
                                float value = Float.intBitsToFloat(msb << 16 | lsb);
                                if (Float.isFinite(value)) {
                                    address_value_obj.put(new JSONObject().put("address", "" + (start_addr + index)).put("value", value));
                                } else {
                                    address_value_obj.put(new JSONObject().put("address", "" + (start_addr + index)).put("value", 0));
                                }
                            }
                            catch (Exception e) {
                                address_value_obj.put(new JSONObject().put("address", "" + (start_addr + index)).put("value", 0));
                                logger.error(e);
                            }
                            index += 2;
                        }
                        break block16;
                    }
                    catch (Exception e) {
                        logger.error("readFloatNonSwapListFromHoldingRegisters>>" + query.getString("device_name") + " " + e);
                        break block16;
                    }
                    finally {
                        hr_req = null;
                        hr_res = null;
                    }
                }
                logger.warn("please check Modbus connection this ip_address:>>" + device_name);
            }
            catch (Exception e) {
                logger.error(device_name + " query of readFloatNonSwapListFromHoldingRegisters>>" + e);
            }
        }
        return address_value_obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray readLongListFromHoldingRegisters(String device_name, JSONObject query, String con_per) {
        JSONArray address_value_obj;
        block14: {
            int count = 0;
            ModbusTCPTransaction trans = null;
            TCPMasterConnection con = null;
            ReadMultipleRegistersRequest hr_req = null;
            ReadMultipleRegistersResponse hr_res = null;
            address_value_obj = new JSONArray();
            try {
                count = Integer.parseInt(query.getString("no_of_register"));
                int start_addr = Integer.parseInt(query.getString("start_address"));
                if (!TcpModbusExecuter.ModbusConnections.containsKey(device_name)) break block14;
                con = TcpModbusExecuter.ModbusConnections.get(device_name);
                if (con != null && con.isConnected()) {
                    try {
                        hr_req = new ReadMultipleRegistersRequest(start_addr - 1, count);
                        hr_req.setUnitID(Integer.parseInt(query.getString("slave_id")));
                        trans = new ModbusTCPTransaction(con);
                        trans.setRequest(hr_req);
                        try {
                            if (con.isConnected()) {
                                trans.execute();
                                hr_res = (ReadMultipleRegistersResponse)trans.getResponse();
                            }
                        }
                        catch (Exception e) {
                            hr_res = null;
                            TcpModbusExecuter.ModbusConnections.remove(device_name);
                            logger.error(device_name + ": modbus connection loss:readLongListFromHoldingRegisters:: " + e);
                        }
                        if (hr_res == null) break block14;
                        int index = 0;
                        while (index + 1 < hr_res.getWordCount()) {
                            try {
                                int lsb = hr_res.getRegisterValue(index);
                                int msb = hr_res.getRegisterValue(index + 1);
                                long value = msb << 16 | lsb;
                                address_value_obj.put(new JSONObject().put("address", "" + (start_addr + index)).put("value", value));
                            }
                            catch (Exception e) {
                                logger.error("readLongListFromHoldingRegisters>>", e);
                            }
                            index += 2;
                        }
                        break block14;
                    }
                    catch (Exception e) {
                        logger.error("readLongListFromHoldingRegisters>>" + query.getString("device_name") + " " + e);
                        break block14;
                    }
                    finally {
                        hr_req = null;
                        hr_res = null;
                    }
                }
                logger.warn("please check Modbus connection this device_name:>>" + device_name);
            }
            catch (Exception e) {
                logger.error("readLongListFromHoldingRegisters>>" + e);
            }
        }
        return address_value_obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray readSwapLongListFromHoldingRegisters(String device_name, JSONObject query, String con_per) {
        JSONArray address_value_obj;
        block14: {
            int count = 0;
            ModbusTCPTransaction trans = null;
            TCPMasterConnection con = null;
            ReadMultipleRegistersRequest hr_req = null;
            ReadMultipleRegistersResponse hr_res = null;
            address_value_obj = new JSONArray();
            try {
                count = Integer.parseInt(query.getString("no_of_register"));
                int start_addr = Integer.parseInt(query.getString("start_address"));
                if (!TcpModbusExecuter.ModbusConnections.containsKey(device_name)) break block14;
                con = TcpModbusExecuter.ModbusConnections.get(device_name);
                if (con != null && con.isConnected()) {
                    try {
                        hr_req = new ReadMultipleRegistersRequest(start_addr - 1, count);
                        hr_req.setUnitID(Integer.parseInt(query.getString("slave_id")));
                        trans = new ModbusTCPTransaction(con);
                        trans.setRequest(hr_req);
                        try {
                            if (con.isConnected()) {
                                trans.execute();
                                hr_res = (ReadMultipleRegistersResponse)trans.getResponse();
                            }
                        }
                        catch (Exception e) {
                            hr_res = null;
                            TcpModbusExecuter.ModbusConnections.remove(device_name);
                            logger.error(device_name + ": modbus connection loss:readLongListFromHoldingRegisters:: " + e);
                        }
                        if (hr_res == null) break block14;
                        int index = 0;
                        while (index + 1 < hr_res.getWordCount()) {
                            try {
                                int lsb = hr_res.getRegisterValue(index);
                                int msb = hr_res.getRegisterValue(index + 1);
                                long value = lsb << 16 | msb;
                                address_value_obj.put(new JSONObject().put("address", "" + (start_addr + index)).put("value", value));
                            }
                            catch (Exception e) {
                                logger.error("readLongListFromHoldingRegisters>>", e);
                            }
                            index += 2;
                        }
                        break block14;
                    }
                    catch (Exception e) {
                        logger.error("readLongListFromHoldingRegisters>>" + query.getString("device_name") + " " + e);
                        break block14;
                    }
                    finally {
                        hr_req = null;
                        hr_res = null;
                    }
                }
                logger.warn("please check Modbus connection this device_name:>>" + device_name);
            }
            catch (Exception e) {
                logger.error("readLongListFromHoldingRegisters>>" + e);
            }
        }
        return address_value_obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray readFloatSwapListFromHoldingRegisters(String device_name, JSONObject query, String con_per) {
        JSONArray address_value_obj;
        block17: {
            int count = 0;
            ModbusTCPTransaction trans = null;
            TCPMasterConnection con = null;
            ReadMultipleRegistersRequest hr_req = null;
            ReadMultipleRegistersResponse hr_res = null;
            address_value_obj = new JSONArray();
            try {
                count = Integer.parseInt(query.getString("no_of_register"));
                int start_addr = Integer.parseInt(query.getString("start_address"));
                if (!TcpModbusExecuter.ModbusConnections.containsKey(device_name)) break block17;
                con = TcpModbusExecuter.ModbusConnections.get(device_name);
                if (con != null && con.isConnected()) {
                    try {
                        hr_req = new ReadMultipleRegistersRequest(start_addr - 1, count);
                        hr_req.setUnitID(Integer.parseInt(query.getString("slave_id")));
                        trans = new ModbusTCPTransaction(con);
                        trans.setRequest(hr_req);
                        try {
                            if (con.isConnected()) {
                                trans.execute();
                                hr_res = (ReadMultipleRegistersResponse)trans.getResponse();
                            }
                        }
                        catch (Exception e) {
                            hr_res = null;
                            TcpModbusExecuter.ModbusConnections.remove(device_name);
                            logger.error(device_name + ": modbus connection loss:readFloatSwapListFromHoldingRegisters:: " + e);
                        }
                        if (hr_res != null) {
                            int index = 0;
                            while (index + 1 < hr_res.getWordCount()) {
                                try {
                                    int lsb = hr_res.getRegisterValue(index);
                                    int msb = hr_res.getRegisterValue(index + 1);
                                    float value = Float.intBitsToFloat(lsb << 16 | msb);
                                    if (Float.isFinite(value)) {
                                        address_value_obj.put(new JSONObject().put("address", "" + (start_addr + index)).put("value", value));
                                    } else {
                                        address_value_obj.put(new JSONObject().put("address", "" + (start_addr + index)).put("value", value));
                                    }
                                }
                                catch (Exception e) {
                                    logger.error("readFloatSwapListFromHoldingRegisters>>", e);
                                }
                                index += 2;
                            }
                        }
                        hr_req = null;
                        hr_res = null;
                        break block17;
                    }
                    catch (Exception e) {
                        logger.error("readFloatSwapListFromHoldingRegisters>>>>>", e);
                        break block17;
                    }
                    finally {
                        hr_req = null;
                        hr_res = null;
                    }
                }
                logger.warn("please check Modbus connection this ip_address:>>" + device_name);
            }
            catch (Exception e) {
                logger.error("ModbusClass", e);
            }
        }
        return address_value_obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray readIntegerListFromHoldingRegisters(String device_name, JSONObject query, String con_per) {
        JSONArray address_value_obj;
        block15: {
            int count = 0;
            ModbusTCPTransaction trans = null;
            TCPMasterConnection con = null;
            ReadMultipleRegistersRequest hr_req = null;
            ReadMultipleRegistersResponse hr_res = null;
            address_value_obj = new JSONArray();
            try {
                count = Integer.parseInt(query.getString("no_of_register"));
                int start_addr = Integer.parseInt(query.getString("start_address"));
                if (!TcpModbusExecuter.ModbusConnections.containsKey(device_name)) break block15;
                con = TcpModbusExecuter.ModbusConnections.get(device_name);
                if (con != null && con.isConnected()) {
                    try {
                        hr_req = new ReadMultipleRegistersRequest(start_addr - 1, count);
                        hr_req.setUnitID(Integer.parseInt(query.getString("slave_id")));
                        trans = new ModbusTCPTransaction(con);
                        trans.setRequest(hr_req);
                        try {
                            if (con.isConnected()) {
                                trans.execute();
                                hr_res = (ReadMultipleRegistersResponse)trans.getResponse();
                            }
                        }
                        catch (Exception e) {
                            hr_res = null;
                            TcpModbusExecuter.ModbusConnections.remove(device_name);
                            logger.error(device_name + ": modbus connection loss:readIntegerListFromHoldingRegisters:: " + e);
                        }
                        if (hr_res != null) {
                            for (int index = 0; index < count; ++index) {
                                try {
                                    int value = hr_res.getRegisterValue(index);
                                    if (!Float.isFinite(value)) continue;
                                    address_value_obj.put(new JSONObject().put("address", "" + (start_addr + index)).put("value", (short)value));
                                    continue;
                                }
                                catch (Exception e) {
                                    logger.error(e);
                                }
                            }
                        }
                        break block15;
                    }
                    catch (Exception e) {
                        logger.error("ModbusClass", e);
                        break block15;
                    }
                    finally {
                        hr_req = null;
                        hr_res = null;
                    }
                }
                logger.warn("please check Modbus connection this device_name:>>" + device_name);
            }
            catch (Exception e) {
                logger.error("ModbusClass", e);
            }
        }
        return address_value_obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Short readIntegerFromHoldingRegister(String device_name, int slave_id, int reg_address, String con_per) {
        ModbusTCPTransaction trans = null;
        TCPMasterConnection con = null;
        ReadMultipleRegistersRequest hr_req = null;
        ReadMultipleRegistersResponse hr_res = null;
        try {
            con = TcpModbusExecuter.ModbusConnections.get(device_name);
            if (con != null && con.isConnected()) {
                hr_req = new ReadMultipleRegistersRequest(reg_address - 1, 1);
                hr_req.setUnitID(slave_id);
                trans = new ModbusTCPTransaction(con);
                trans.setRequest(hr_req);
                if (con != null && con.isConnected()) {
                    try {
                        trans.execute();
                        hr_res = (ReadMultipleRegistersResponse)trans.getResponse();
                    }
                    catch (ModbusException | NullPointerException e) {
                        hr_res = null;
                        logger.error("readIntegerFromHoldingRegister>>", e);
                    }
                }
            }
            if (hr_res != null) {
                Short e = (short)hr_res.getRegisterValue(0);
                return e;
            }
        }
        catch (Exception e) {
            logger.error("readIntegerFromHoldingRegister>>", e);
        }
        finally {
            hr_req = null;
            hr_res = null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray readFloatNonSwapListFromInputRegisters(String device_name, JSONObject query, String con_per) {
        JSONArray address_value_obj;
        block16: {
            int count = 0;
            ModbusTCPTransaction trans = null;
            TCPMasterConnection con = null;
            ReadInputRegistersRequest hr_req = null;
            ReadInputRegistersResponse hr_res = null;
            address_value_obj = new JSONArray();
            try {
                count = Integer.parseInt(query.getString("no_of_register"));
                int start_addr = Integer.parseInt(query.getString("start_address"));
                if (!TcpModbusExecuter.ModbusConnections.containsKey(device_name)) break block16;
                con = TcpModbusExecuter.ModbusConnections.get(device_name);
                if (con != null && con.isConnected()) {
                    try {
                        hr_req = new ReadInputRegistersRequest(start_addr - 1, count);
                        hr_req.setUnitID(Integer.parseInt(query.getString("slave_id")));
                        trans = new ModbusTCPTransaction(con);
                        trans.setRequest(hr_req);
                        try {
                            if (con.isConnected()) {
                                trans.execute();
                                hr_res = (ReadInputRegistersResponse)trans.getResponse();
                            }
                        }
                        catch (Exception e) {
                            hr_res = null;
                            TcpModbusExecuter.ModbusConnections.remove(device_name);
                            logger.error(device_name + ": modbus connection loss:readFloatNonSwapListFromInputRegisters:: " + e);
                        }
                        if (hr_res == null) break block16;
                        int index = 0;
                        while (index + 1 < hr_res.getWordCount()) {
                            try {
                                int lsb = hr_res.getRegisterValue(index);
                                int msb = hr_res.getRegisterValue(index + 1);
                                float value = Float.intBitsToFloat(msb << 16 | lsb);
                                if (Float.isFinite(value)) {
                                    address_value_obj.put(new JSONObject().put("address", "" + (start_addr + index)).put("value", value));
                                } else {
                                    address_value_obj.put(new JSONObject().put("address", "" + (start_addr + index)).put("value", value));
                                }
                            }
                            catch (Exception e) {
                                logger.error(e);
                            }
                            index += 2;
                        }
                        break block16;
                    }
                    catch (Exception e) {
                        logger.error("readFloatNonSwapListFromInputRegisters>>", e);
                        break block16;
                    }
                    finally {
                        hr_req = null;
                        hr_res = null;
                    }
                }
                logger.warn("please check Modbus connection this ip_address:>>" + device_name);
            }
            catch (Exception e) {
                logger.error("ModbusClass", e);
            }
        }
        return address_value_obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray readLongListFromInputRegisters(String device_name, JSONObject query, String con_per) {
        JSONArray address_value_obj;
        block16: {
            int count = 0;
            ModbusTCPTransaction trans = null;
            TCPMasterConnection con = null;
            ReadInputRegistersRequest hr_req = null;
            ReadInputRegistersResponse hr_res = null;
            address_value_obj = new JSONArray();
            try {
                count = Integer.parseInt(query.getString("no_of_register"));
                int start_addr = Integer.parseInt(query.getString("start_address"));
                if (!TcpModbusExecuter.ModbusConnections.containsKey(device_name)) break block16;
                con = TcpModbusExecuter.ModbusConnections.get(device_name);
                if (con != null && con.isConnected()) {
                    try {
                        hr_req = new ReadInputRegistersRequest(start_addr - 1, count);
                        hr_req.setUnitID(Integer.parseInt(query.getString("slave_id")));
                        trans = new ModbusTCPTransaction(con);
                        trans.setRequest(hr_req);
                        try {
                            if (con.isConnected()) {
                                trans.execute();
                                hr_res = (ReadInputRegistersResponse)trans.getResponse();
                            }
                        }
                        catch (Exception e) {
                            hr_res = null;
                            TcpModbusExecuter.ModbusConnections.remove(device_name);
                            logger.error(device_name + ": modbus connection loss:readLongListFromInputRegisters:: " + e);
                        }
                        if (hr_res == null) break block16;
                        int index = 0;
                        while (index + 1 < hr_res.getWordCount()) {
                            try {
                                int lsb = hr_res.getRegisterValue(index);
                                int msb = hr_res.getRegisterValue(index + 1);
                                long value = msb << 16 | lsb;
                                if (Float.isFinite(value)) {
                                    address_value_obj.put(new JSONObject().put("address", "" + (start_addr + index)).put("value", value));
                                } else {
                                    address_value_obj.put(new JSONObject().put("address", "" + (start_addr + index)).put("value", value));
                                }
                            }
                            catch (Exception e) {
                                logger.error(e);
                            }
                            index += 2;
                        }
                        break block16;
                    }
                    catch (Exception e) {
                        logger.error("ModbusClass", e);
                        break block16;
                    }
                    finally {
                        hr_req = null;
                        hr_res = null;
                    }
                }
                logger.warn("please check Modbus connection this ip_address:>>" + device_name);
            }
            catch (Exception e) {
                logger.error("ModbusClass", e);
            }
        }
        return address_value_obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray readSwapLongListFromInputRegisters(String device_name, JSONObject query, String con_per) {
        JSONArray address_value_obj;
        block16: {
            int count = 0;
            ModbusTCPTransaction trans = null;
            TCPMasterConnection con = null;
            ReadInputRegistersRequest hr_req = null;
            ReadInputRegistersResponse hr_res = null;
            address_value_obj = new JSONArray();
            try {
                count = Integer.parseInt(query.getString("no_of_register"));
                int start_addr = Integer.parseInt(query.getString("start_address"));
                if (!TcpModbusExecuter.ModbusConnections.containsKey(device_name)) break block16;
                con = TcpModbusExecuter.ModbusConnections.get(device_name);
                if (con != null && con.isConnected()) {
                    try {
                        hr_req = new ReadInputRegistersRequest(start_addr - 1, count);
                        hr_req.setUnitID(Integer.parseInt(query.getString("slave_id")));
                        trans = new ModbusTCPTransaction(con);
                        trans.setRequest(hr_req);
                        try {
                            if (con.isConnected()) {
                                trans.execute();
                                hr_res = (ReadInputRegistersResponse)trans.getResponse();
                            }
                        }
                        catch (Exception e) {
                            hr_res = null;
                            TcpModbusExecuter.ModbusConnections.remove(device_name);
                            logger.error(device_name + ": modbus connection loss:readSwapLongListFromInputRegisters:: " + e);
                        }
                        if (hr_res == null) break block16;
                        int index = 0;
                        while (index + 1 < hr_res.getWordCount()) {
                            try {
                                int lsb = hr_res.getRegisterValue(index);
                                int msb = hr_res.getRegisterValue(index + 1);
                                long value = lsb << 16 | msb;
                                if (Float.isFinite(value)) {
                                    address_value_obj.put(new JSONObject().put("address", "" + (start_addr + index)).put("value", value));
                                } else {
                                    address_value_obj.put(new JSONObject().put("address", "" + (start_addr + index)).put("value", value));
                                }
                            }
                            catch (Exception e) {
                                logger.error(e);
                            }
                            index += 2;
                        }
                        break block16;
                    }
                    catch (Exception e) {
                        logger.error("ModbusClass", e);
                        break block16;
                    }
                    finally {
                        hr_req = null;
                        hr_res = null;
                    }
                }
                logger.warn("please check Modbus connection this device_name:>>" + device_name);
            }
            catch (Exception e) {
                logger.error("ModbusClass", e);
            }
        }
        return address_value_obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray readFloatSwapListFromInputRegisters(String device_name, JSONObject query, String con_per) {
        JSONArray address_value_obj;
        block17: {
            int count = 0;
            ModbusTCPTransaction trans = null;
            TCPMasterConnection con = null;
            ReadInputRegistersRequest hr_req = null;
            ReadInputRegistersResponse hr_res = null;
            address_value_obj = new JSONArray();
            try {
                count = Integer.parseInt(query.getString("no_of_register"));
                int start_addr = Integer.parseInt(query.getString("start_address"));
                if (!TcpModbusExecuter.ModbusConnections.containsKey(device_name)) break block17;
                con = TcpModbusExecuter.ModbusConnections.get(device_name);
                if (con != null && con.isConnected()) {
                    try {
                        hr_req = new ReadInputRegistersRequest(start_addr - 1, count);
                        hr_req.setUnitID(Integer.parseInt(query.getString("slave_id")));
                        trans = new ModbusTCPTransaction(con);
                        trans.setRequest(hr_req);
                        try {
                            if (con.isConnected()) {
                                trans.execute();
                                hr_res = (ReadInputRegistersResponse)trans.getResponse();
                            }
                        }
                        catch (Exception e) {
                            hr_res = null;
                            TcpModbusExecuter.ModbusConnections.remove(device_name);
                            logger.error(device_name + ": modbus connection loss:readFloatSwapListFromInputRegisters:: " + e);
                        }
                        if (hr_res != null) {
                            int index = 0;
                            while (index + 1 < hr_res.getWordCount()) {
                                try {
                                    int lsb = hr_res.getRegisterValue(index);
                                    int msb = hr_res.getRegisterValue(index + 1);
                                    float value = Float.intBitsToFloat(lsb << 16 | msb);
                                    if (Float.isFinite(value)) {
                                        address_value_obj.put(new JSONObject().put("address", "" + (start_addr + index)).put("value", value));
                                    } else {
                                        address_value_obj.put(new JSONObject().put("address", "" + (start_addr + index)).put("value", value));
                                    }
                                }
                                catch (Exception e) {
                                    logger.error(e);
                                }
                                index += 2;
                            }
                        }
                        hr_req = null;
                        hr_res = null;
                        break block17;
                    }
                    catch (Exception e) {
                        logger.error("ModbusClass", e);
                        break block17;
                    }
                    finally {
                        hr_req = null;
                        hr_res = null;
                    }
                }
                logger.warn("please check Modbus connection this device_name:>>" + device_name);
            }
            catch (Exception e) {
                logger.error("ModbusClass", e);
            }
        }
        return address_value_obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray readIntegerListFromInputRegisters(String device_name, JSONObject query, String con_per) {
        JSONArray address_value_obj;
        block16: {
            int count = 0;
            ModbusTCPTransaction trans = null;
            TCPMasterConnection con = null;
            ReadInputRegistersRequest hr_req = null;
            ReadInputRegistersResponse hr_res = null;
            address_value_obj = new JSONArray();
            try {
                count = Integer.parseInt(query.getString("no_of_register"));
                int start_addr = Integer.parseInt(query.getString("start_address"));
                if (!TcpModbusExecuter.ModbusConnections.containsKey(device_name)) break block16;
                con = TcpModbusExecuter.ModbusConnections.get(device_name);
                if (con != null && con.isConnected()) {
                    try {
                        hr_req = new ReadInputRegistersRequest(start_addr - 1, count);
                        hr_req.setUnitID(Integer.parseInt(query.getString("slave_id")));
                        trans = new ModbusTCPTransaction(con);
                        trans.setRequest(hr_req);
                        try {
                            if (con.isConnected()) {
                                trans.execute();
                                hr_res = (ReadInputRegistersResponse)trans.getResponse();
                            }
                        }
                        catch (Exception e) {
                            hr_res = null;
                            TcpModbusExecuter.ModbusConnections.remove(device_name);
                            logger.error(device_name + ": modbus connection loss:readIntegerListFromInputRegisters:: " + e);
                        }
                        if (hr_res != null) {
                            for (int index = 0; index < hr_res.getWordCount(); ++index) {
                                try {
                                    int value = hr_res.getRegisterValue(index);
                                    if (Float.isFinite(value)) {
                                        address_value_obj.put(new JSONObject().put("address", "" + (start_addr + index)).put("value", (short)value));
                                        continue;
                                    }
                                    address_value_obj.put(new JSONObject().put("address", "" + (start_addr + index)).put("value", (short)value));
                                    continue;
                                }
                                catch (Exception e) {
                                    logger.error(e);
                                }
                            }
                        }
                        hr_req = null;
                        hr_res = null;
                        break block16;
                    }
                    catch (Exception e) {
                        logger.error("ModbusClass", e);
                        break block16;
                    }
                    finally {
                        hr_req = null;
                        hr_res = null;
                    }
                }
                logger.warn("please check Modbus connection this device_name:>>" + device_name);
            }
            catch (Exception e) {
                logger.error("ModbusClass", e);
            }
        }
        return address_value_obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Short readIntegerFromInputRegister(String device_name, int slave_id, int reg_address, String con_per) {
        block9: {
            ModbusTCPTransaction trans = null;
            TCPMasterConnection con = null;
            ReadInputRegistersRequest hr_req = null;
            ReadInputRegistersResponse hr_res = null;
            try {
                con = TcpModbusExecuter.ModbusConnections.get(device_name);
                if (con == null || !con.isConnected()) break block9;
                hr_req = new ReadInputRegistersRequest(reg_address - 1, 1);
                hr_req.setUnitID(slave_id);
                trans = new ModbusTCPTransaction(con);
                trans.setRequest(hr_req);
                if (con != null && con.isConnected()) {
                    try {
                        trans.execute();
                        hr_res = (ReadInputRegistersResponse)trans.getResponse();
                    }
                    catch (ModbusException | NullPointerException e) {
                        hr_res = null;
                        logger.error(device_name + " readIntegerFromInputRegister>>", e);
                        e.printStackTrace();
                    }
                }
                if (hr_res != null) {
                    Short e = (short)hr_res.getRegisterValue(0);
                    return e;
                }
            }
            catch (Exception e) {
                logger.error(device_name + " readIntegerFromInputRegister>>>", e);
            }
            finally {
                hr_req = null;
                hr_res = null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray readBooleanListFromCoilStatus(String device_name, JSONObject query, String con_per) {
        JSONArray address_value_obj;
        block16: {
            int count = 0;
            ModbusTCPTransaction trans = null;
            TCPMasterConnection con = null;
            ReadCoilsRequest cs_req = null;
            ReadCoilsResponse cs_res = null;
            address_value_obj = new JSONArray();
            try {
                count = Integer.parseInt(query.getString("no_of_register"));
                int start_addr = Integer.parseInt(query.getString("start_address"));
                if (!TcpModbusExecuter.ModbusConnections.containsKey(device_name)) break block16;
                con = TcpModbusExecuter.ModbusConnections.get(device_name);
                if (con != null && con.isConnected()) {
                    try {
                        cs_req = new ReadCoilsRequest(start_addr - 1, count);
                        cs_req.setUnitID(Integer.parseInt(query.getString("slave_id")));
                        trans = new ModbusTCPTransaction(con);
                        trans.setRequest(cs_req);
                        try {
                            if (con.isConnected()) {
                                trans.execute();
                                cs_res = (ReadCoilsResponse)trans.getResponse();
                            }
                        }
                        catch (Exception e) {
                            TcpModbusExecuter.ModbusConnections.remove(device_name);
                            cs_res = null;
                            logger.error(device_name + ": modbus connection loss:readBooleanListFromCoilStatus:: " + e);
                        }
                        if (cs_res != null) {
                            for (int index = 0; index < count; ++index) {
                                try {
                                    if (!cs_res.getCoilStatus(index)) {
                                        address_value_obj.put(new JSONObject().put("address", "" + (start_addr + index)).put("value", 0));
                                    }
                                    if (!cs_res.getCoilStatus(index)) continue;
                                    address_value_obj.put(new JSONObject().put("address", "" + (start_addr + index)).put("value", 1));
                                    continue;
                                }
                                catch (Exception e) {
                                    logger.error(query.getString("device_name") + ">>readBooleanListFromCoilStatus>>", e);
                                }
                            }
                        }
                        break block16;
                    }
                    catch (Exception e) {
                        logger.error("readBooleanListFromCoilStatus:" + query.getString("device_name") + e);
                        break block16;
                    }
                    finally {
                        cs_req = null;
                        cs_res = null;
                    }
                }
                logger.warn("please check Modbus connection this device_name:>>" + device_name);
            }
            catch (Exception e) {
                logger.error("readBooleanListFromCoilStatus>> " + e);
            }
        }
        return address_value_obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String readBooleanFromCoilStatus(String device_name, int slave_id, int reg_address, String con_per) {
        try {
            ModbusTCPTransaction trans = null;
            TCPMasterConnection con = null;
            ReadCoilsRequest cs_req = null;
            ReadCoilsResponse cs_res = null;
            try {
                try {
                    con = TcpModbusExecuter.ModbusConnections.get(device_name);
                    if (con != null && con.isConnected()) {
                        cs_req = new ReadCoilsRequest(reg_address - 1, 1);
                        cs_req.setUnitID(slave_id);
                        trans = new ModbusTCPTransaction(con);
                        trans.setRequest(cs_req);
                        if (con != null && con.isConnected()) {
                            try {
                                trans.execute();
                                cs_res = (ReadCoilsResponse)trans.getResponse();
                            }
                            catch (ModbusException | NullPointerException e) {
                                cs_res = null;
                                logger.error(device_name + ">>readBooleanFromCoilStatus>>", e);
                            }
                        }
                        if (cs_res != null) {
                            if (cs_res.getCoilStatus(0)) {
                                String e = "1";
                                return e;
                            }
                            if (!cs_res.getCoilStatus(0)) {
                                String e = "0";
                                return e;
                            }
                        }
                    }
                    cs_req = null;
                    cs_res = null;
                    return null;
                }
                catch (Exception e) {
                    logger.error(device_name + "<<readBooleanFromCoilStatus>>", e);
                    return null;
                }
            }
            finally {
                cs_req = null;
                cs_res = null;
            }
        }
        catch (Exception e) {
            logger.error("ModbusClass", e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray readBooleanListFromInputDiscretes(String device_name, JSONObject query, String con_per) {
        JSONArray address_value_obj;
        block16: {
            int count = 0;
            ModbusTCPTransaction trans = null;
            TCPMasterConnection con = null;
            ReadInputDiscretesRequest cs_req = null;
            ReadInputDiscretesResponse cs_res = null;
            address_value_obj = new JSONArray();
            try {
                count = Integer.parseInt(query.getString("no_of_register"));
                int start_addr = Integer.parseInt(query.getString("start_address"));
                if (!TcpModbusExecuter.ModbusConnections.containsKey(device_name)) break block16;
                con = TcpModbusExecuter.ModbusConnections.get(device_name);
                if (con != null && con.isConnected()) {
                    try {
                        cs_req = new ReadInputDiscretesRequest(start_addr - 1, count);
                        cs_req.setUnitID(Integer.parseInt(query.getString("slave_id")));
                        trans = new ModbusTCPTransaction(con);
                        trans.setRequest(cs_req);
                        try {
                            if (con.isConnected()) {
                                trans.execute();
                                cs_res = (ReadInputDiscretesResponse)trans.getResponse();
                            }
                        }
                        catch (Exception e) {
                            cs_res = null;
                            TcpModbusExecuter.ModbusConnections.remove(device_name);
                            logger.error(device_name + ": modbus connection loss:readBooleanListFromInputDiscretes:: " + e);
                        }
                        if (cs_res != null) {
                            for (int index = 0; index < count; ++index) {
                                try {
                                    if (!cs_res.getDiscreteStatus(index)) {
                                        address_value_obj.put(new JSONObject().put("address", "" + (start_addr + index)).put("value", 0));
                                    }
                                    if (!cs_res.getDiscreteStatus(index)) continue;
                                    address_value_obj.put(new JSONObject().put("address", "" + (start_addr + index)).put("value", 1));
                                    continue;
                                }
                                catch (Exception e) {
                                    logger.error(e);
                                }
                            }
                        }
                        break block16;
                    }
                    catch (Exception e) {
                        logger.error("ModbusClass", e);
                        break block16;
                    }
                    finally {
                        cs_req = null;
                        cs_res = null;
                    }
                }
                logger.warn("please check Modbus connection this ip_address:>>" + device_name);
            }
            catch (Exception e) {
                logger.error("ModbusClass", e);
            }
        }
        return address_value_obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String readBooleanFromInputDiscretes(String device_name, int slave_id, int reg_address, String con_per) {
        try {
            ModbusTCPTransaction trans = null;
            TCPMasterConnection con = null;
            ReadInputDiscretesRequest cs_req = null;
            ReadInputDiscretesResponse cs_res = null;
            try {
                try {
                    con = TcpModbusExecuter.ModbusConnections.get(device_name);
                    if (con != null && con.isConnected()) {
                        cs_req = new ReadInputDiscretesRequest(reg_address - 1, 1);
                        cs_req.setUnitID(slave_id);
                        trans = new ModbusTCPTransaction(con);
                        trans.setRequest(cs_req);
                        if (con != null && con.isConnected()) {
                            try {
                                trans.execute();
                                cs_res = (ReadInputDiscretesResponse)trans.getResponse();
                            }
                            catch (ModbusException | NullPointerException e) {
                                cs_res = null;
                                logger.error(device_name + ">>readBooleanFromInputDiscretes>>", e);
                            }
                        }
                        if (cs_res != null) {
                            if (cs_res.getDiscreteStatus(0)) {
                                String e = "1";
                                return e;
                            }
                            if (!cs_res.getDiscreteStatus(0)) {
                                String e = "0";
                                return e;
                            }
                        }
                    }
                    cs_req = null;
                    cs_res = null;
                    return null;
                }
                catch (Exception e) {
                    logger.error(device_name + "<<readBooleanFromInputDiscretes>>", e);
                    return null;
                }
            }
            finally {
                cs_req = null;
                cs_res = null;
            }
        }
        catch (Exception e) {
            logger.error("ModbusClass", e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int WriteIntegerOnHoldingRegister(String device_name, int slave_id, int register_adress, int value, String con_per) {
        int x = 0;
        try {
            ModbusTCPTransaction trans = null;
            TCPMasterConnection con = null;
            WriteSingleRegisterRequest wsr_req = new WriteSingleRegisterRequest();
            Object wsr_res = null;
            SimpleRegister Reg = new SimpleRegister(1);
            try {
                con = TcpModbusExecuter.ModbusConnections.get(device_name);
                if (con != null && con.isConnected()) {
                    wsr_req.setUnitID(slave_id);
                    wsr_req.setReference(register_adress - 1);
                    Reg.setValue(value);
                    wsr_req.setRegister(Reg);
                    trans = new ModbusTCPTransaction(con);
                    trans.setRequest(wsr_req);
                    if (con != null && con.isConnected()) {
                        try {
                            trans.execute();
                            x = 1;
                        }
                        catch (ModbusException | NullPointerException e) {
                            wsr_res = null;
                            logger.error(device_name + "<<WriteIntegerOnHoldingRegister>>", e);
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error(device_name + ">>WriteIntegerOnHoldingRegister>>", e);
            }
            finally {
                Reg = null;
                wsr_req = null;
                wsr_res = null;
            }
        }
        catch (Exception e) {
            logger.error("ModbusClass", e);
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBoolean(String device_name, int slave_id, int register_adress, boolean bool, String con_per) {
        try {
            ModbusTCPTransaction trans = null;
            TCPMasterConnection con = null;
            WriteCoilRequest cw_req = null;
            Object cw_res = null;
            try {
                logger.info("Weite");
                con = TcpModbusExecuter.ModbusConnections.get(device_name);
                if (con != null && con.isConnected()) {
                    cw_req = new WriteCoilRequest(register_adress - 1, bool);
                    cw_req.setUnitID(slave_id);
                    trans = new ModbusTCPTransaction(con);
                    trans.setRequest(cw_req);
                    if (con != null && con.isConnected()) {
                        try {
                            trans.execute();
                        }
                        catch (ModbusException | NullPointerException e) {
                            cw_res = null;
                            logger.error(device_name + "<<writeBoolean>>", e);
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error(device_name + "<<writeBoolean>>", e);
                e.printStackTrace();
            }
            finally {
                cw_req = null;
                cw_res = null;
            }
        }
        catch (Exception e) {
            logger.error("writeBoolean>>", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void WriteIntegerListOnHoldingRegister(String device_name, int register_adress, int[] value, String con_per) {
        System.out.println("WriteIntegerListOnHoldingRegister");
        try {
            ModbusTCPTransaction trans = null;
            Register[] Reg = null;
            TCPMasterConnection con = null;
            WriteMultipleRegistersRequest wsr_req = null;
            Object wsr_res = null;
            try {
                if (value.length != 0) {
                    Reg = new SimpleRegister[value.length];
                }
                for (int i = 0; i < Reg.length; ++i) {
                    Reg[i] = new SimpleRegister(value[i]);
                }
                con = TcpModbusExecuter.ModbusConnections.get(device_name);
                if (con != null && con.isConnected()) {
                    wsr_req = new WriteMultipleRegistersRequest(register_adress - 1, Reg);
                    trans = new ModbusTCPTransaction(con);
                    trans.setRequest(wsr_req);
                    try {
                        trans.execute();
                    }
                    catch (ModbusException | NullPointerException e) {
                        wsr_res = null;
                        logger.error("WriteIntegerListOnHoldingRegister>>", e);
                    }
                }
            }
            catch (Exception e) {
                logger.error("WriteIntegerListOnHoldingRegister>>", e);
            }
            finally {
                Reg = null;
                wsr_req = null;
                wsr_res = null;
            }
        }
        catch (Exception e) {
            logger.error("WriteIntegerListOnHoldingRegister>>", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int WriteNonSwapFloatListOnHoldingRegister(String device_name, int register_address, float[] value, String con_per) {
        int x = 0;
        try {
            ModbusTCPTransaction trans = null;
            Register[] Reg = null;
            TCPMasterConnection con = null;
            WriteMultipleRegistersRequest wsr_req = null;
            Object wsr_res = null;
            try {
                if (value.length != 0) {
                    Reg = new SimpleRegister[value.length * 2];
                }
                int i = 0;
                int j = 0;
                while (i < value.length && j + 1 < Reg.length) {
                    byte[] bt = ByteBuffer.allocate(4).putFloat(value[i]).array();
                    Reg[j + 1] = new SimpleRegister(bt[0], bt[1]);
                    Reg[j] = new SimpleRegister(bt[2], bt[3]);
                    ++i;
                    j += 2;
                }
                con = TcpModbusExecuter.ModbusConnections.get(device_name);
                if (con != null && con.isConnected()) {
                    wsr_req = new WriteMultipleRegistersRequest(register_address - 1, Reg);
                    trans = new ModbusTCPTransaction(con);
                    trans.setRequest(wsr_req);
                    try {
                        trans.execute();
                        x = 1;
                    }
                    catch (ModbusException | NullPointerException e) {
                        wsr_res = null;
                        logger.error("WriteNonSwapFloatListOnHoldingRegister>>", e);
                    }
                }
            }
            catch (Exception e) {
                logger.error("WriteNonSwapFloatListOnHoldingRegister>>", e);
                e.printStackTrace();
            }
            finally {
                Reg = null;
                wsr_req = null;
                wsr_res = null;
            }
        }
        catch (Exception e) {
            logger.error("WriteNonSwapFloatListOnHoldingRegister>>", e);
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int WriteLongListOnHoldingRegister(String device_name, int register_address, long[] value, String con_per) {
        int x = 0;
        try {
            ModbusTCPTransaction trans = null;
            Register[] Reg = null;
            TCPMasterConnection con = null;
            WriteMultipleRegistersRequest wsr_req = null;
            Object wsr_res = null;
            try {
                if (value.length != 0) {
                    Reg = new SimpleRegister[value.length * 2];
                }
                int i = 0;
                int j = 0;
                while (i < value.length && j + 1 < Reg.length) {
                    byte[] bt = ByteBuffer.allocate(8).putLong(value[i]).array();
                    Reg[j + 1] = new SimpleRegister(bt[4], bt[5]);
                    Reg[j] = new SimpleRegister(bt[6], bt[7]);
                    ++i;
                    j += 2;
                }
                con = TcpModbusExecuter.ModbusConnections.get(device_name);
                if (con != null && con.isConnected()) {
                    wsr_req = new WriteMultipleRegistersRequest(register_address - 1, Reg);
                    trans = new ModbusTCPTransaction(con);
                    trans.setRequest(wsr_req);
                    try {
                        trans.execute();
                        x = 1;
                    }
                    catch (ModbusException | NullPointerException e) {
                        wsr_res = null;
                        logger.error("WriteLongListOnHoldingRegister>>", e);
                    }
                }
            }
            catch (Exception e) {
                logger.error("WriteLongListOnHoldingRegister>>", e);
                e.printStackTrace();
            }
            finally {
                Reg = null;
                wsr_req = null;
                wsr_res = null;
            }
        }
        catch (Exception e) {
            logger.error("WriteLongListOnHoldingRegister>>", e);
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int WriteSwapLongListOnHoldingRegister(String device_name, int register_address, long[] value, String con_per) {
        int x;
        block12: {
            x = 0;
            try {
                ModbusTCPTransaction trans = null;
                Register[] Reg = null;
                TCPMasterConnection con = null;
                WriteMultipleRegistersRequest wsr_req = null;
                WriteMultipleRegistersResponse wsr_res = null;
                try {
                    if (value.length != 0) {
                        Reg = new SimpleRegister[value.length * 2];
                    }
                    int i = 0;
                    int j = 0;
                    while (i < value.length && j + 1 < Reg.length) {
                        byte[] bt = ByteBuffer.allocate(8).putLong(value[i]).array();
                        Reg[j + 1] = new SimpleRegister(bt[6], bt[7]);
                        Reg[j] = new SimpleRegister(bt[4], bt[5]);
                        ++i;
                        j += 2;
                    }
                    con = TcpModbusExecuter.ModbusConnections.get(device_name);
                    if (con == null || !con.isConnected()) break block12;
                    wsr_req = new WriteMultipleRegistersRequest(register_address - 1, Reg);
                    trans = new ModbusTCPTransaction(con);
                    trans.setRequest(wsr_req);
                    try {
                        trans.execute();
                        wsr_res = (WriteMultipleRegistersResponse)trans.getResponse();
                        x = 1;
                    }
                    catch (ModbusException | NullPointerException e) {
                        wsr_res = null;
                        logger.error("WriteLongListOnHoldingRegister>>", e);
                    }
                    if (wsr_res != null) {
                        // empty if block
                    }
                }
                catch (Exception e) {
                    logger.error("WriteLongListOnHoldingRegister>>", e);
                }
                finally {
                    Reg = null;
                    wsr_req = null;
                    wsr_res = null;
                }
            }
            catch (Exception e) {
                logger.error("WriteLongListOnHoldingRegister>>", e);
            }
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int WriteSwapFloatListOnHoldingRegister(String device_name, int register_adress, float[] value, String con_per) {
        int x = 0;
        try {
            ModbusTCPTransaction trans = null;
            Register[] Reg = null;
            TCPMasterConnection con = null;
            WriteMultipleRegistersRequest wsr_req = null;
            Object wsr_res = null;
            try {
                if (value.length != 0) {
                    Reg = new SimpleRegister[value.length * 2];
                }
                int i = 0;
                int j = 0;
                while (i < value.length && j + 1 < Reg.length) {
                    byte[] bt = ByteBuffer.allocate(4).putFloat(value[i]).array();
                    Reg[j] = new SimpleRegister(bt[0], bt[1]);
                    Reg[j + 1] = new SimpleRegister(bt[2], bt[3]);
                    ++i;
                    j += 2;
                }
                con = TcpModbusExecuter.ModbusConnections.get(device_name);
                if (con != null && con.isConnected()) {
                    wsr_req = new WriteMultipleRegistersRequest(register_adress - 1, Reg);
                    trans = new ModbusTCPTransaction(con);
                    trans.setRequest(wsr_req);
                    try {
                        trans.execute();
                        x = 1;
                    }
                    catch (ModbusException | NullPointerException e) {
                        wsr_res = null;
                        logger.error("WriteSwapFloatListOnHoldingRegister>>", e);
                    }
                }
            }
            catch (Exception e) {
                logger.error("WriteSwapFloatListOnHoldingRegister>>", e);
            }
            finally {
                Reg = null;
                wsr_req = null;
                wsr_res = null;
            }
        }
        catch (Exception e) {
            logger.error("WriteSwapFloatListOnHoldingRegister>>", e);
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int writeBooleanListOnCoilStatus(String device_name, int register_adress, boolean[] bools, String con_per) {
        int x = 0;
        try {
            ModbusTCPTransaction trans = null;
            TCPMasterConnection con = null;
            WriteMultipleCoilsRequest cw_req = null;
            WriteMultipleCoilsResponse cw_res = null;
            BitVector bit_vector = null;
            try {
                try {
                    if (bools.length != 0) {
                        bit_vector = new BitVector(bools.length);
                    }
                    for (int i = 0; i < bools.length; ++i) {
                        bit_vector.setBit(i, bools[i]);
                    }
                    con = TcpModbusExecuter.ModbusConnections.get(device_name);
                    if (con != null && con.isConnected()) {
                        cw_req = new WriteMultipleCoilsRequest(register_adress - 1, bit_vector);
                        trans = new ModbusTCPTransaction(con);
                        trans.setRequest(cw_req);
                        try {
                            trans.execute();
                            cw_res = (WriteMultipleCoilsResponse)trans.getResponse();
                            x = 1;
                        }
                        catch (ModbusException | NullPointerException e) {
                            cw_res = null;
                            logger.error("writeBooleanListOnCoilStatus>>", e);
                        }
                        if (cw_res != null) {
                            int e = cw_res.getBitCount();
                            return e;
                        }
                    }
                    cw_req = null;
                    cw_res = null;
                    return x;
                }
                catch (Exception e) {
                    logger.error("writeBooleanListOnCoilStatus>>", e);
                    e.printStackTrace();
                    return x;
                }
            }
            finally {
                cw_req = null;
                cw_res = null;
            }
        }
        catch (Exception e) {
            logger.error("writeBooleanListOnCoilStatus>>", e);
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray readStringFromHoldingRegisters(String device_name, JSONObject query, String con_per) {
        StringBuffer opStr;
        JSONArray address_value_obj;
        block19: {
            int count = 0;
            ModbusTCPTransaction trans = null;
            TCPMasterConnection con = null;
            ReadMultipleRegistersRequest hr_req = null;
            ReadMultipleRegistersResponse hr_res = null;
            address_value_obj = new JSONArray();
            opStr = new StringBuffer();
            try {
                ArrayList bunch_list = new ArrayList();
                count = Integer.parseInt(query.getString("no_of_register"));
                int start_addr = Integer.parseInt(query.getString("start_address"));
                if (!TcpModbusExecuter.ModbusConnections.containsKey(device_name)) break block19;
                con = TcpModbusExecuter.ModbusConnections.get(device_name);
                if (con != null && con.isConnected()) {
                    try {
                        hr_req = new ReadMultipleRegistersRequest(start_addr - 1, 1);
                        hr_req.setUnitID(Integer.parseInt(query.getString("slave_id")));
                        trans = new ModbusTCPTransaction(con);
                        trans.setRequest(hr_req);
                        try {
                            trans.execute();
                            hr_res = (ReadMultipleRegistersResponse)trans.getResponse();
                        }
                        catch (ModbusException e) {
                            hr_res = null;
                            TcpModbusExecuter.ModbusConnections.remove(device_name);
                            logger.error(device_name + ": modbus connection readStringFromHoldingRegisters:: " + e);
                        }
                        if (hr_res != null) {
                            for (int index = 0; index < hr_res.getWordCount(); ++index) {
                                try {
                                    int value = hr_res.getRegisterValue(index);
                                    if (!Float.isFinite(value)) continue;
                                    if (value >= 65 && value <= 90 || value >= 48 && value <= 57 || value == 32 || value == 46) {
                                        opStr.append((char)value);
                                        continue;
                                    }
                                    if (value >= 97 && value <= 122) {
                                        opStr.append((char)value);
                                        continue;
                                    }
                                    if (value == 13) {
                                        opStr.append((char)value);
                                        continue;
                                    }
                                    opStr.append(value);
                                    continue;
                                }
                                catch (Exception e) {
                                    logger.error("readStringFromHoldingRegisters>>", e);
                                }
                            }
                        }
                        hr_req = null;
                        hr_res = null;
                        break block19;
                    }
                    catch (Exception e) {
                        logger.error("readStringFromHoldingRegisters>>", e);
                        break block19;
                    }
                    finally {
                        hr_req = null;
                        hr_res = null;
                    }
                }
                logger.warn("please check Modbus connection this device_name:>>" + device_name);
            }
            catch (Exception e) {
                logger.error("readStringFromHoldingRegisters>>", e);
            }
        }
        try {
            address_value_obj.put(new JSONObject().put("address", query.getString("start_address")).put("value", opStr.toString()));
        }
        catch (JSONException e) {
            logger.error("readStringFromHoldingRegisters>>", e);
        }
        return address_value_obj;
    }
}

