/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.protocol.jsonbuillder;

import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.protocol.mqtt.MqttExecutor;
import com.tas.wp500.protocol.startan.Tag;
import com.tas.wp500.services.Service;
import com.tas.wp500.store_and_forword.StoreAndForwordDbOperations;
import com.tas.wp500.store_and_forword.StoreForword;
import com.tas.wp500.util.Util;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.TimerTask;
import org.apache.log4j.Logger;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONExecuteTask
extends TimerTask {
    private static Logger logger = Logger.getLogger(JSONExecuteTask.class);
    private SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
    private JSONArray jsonStringArray;
    private String broker_ip;
    private String publish_topic_name;
    private String publishing_format;
    private String time_format;

    public void setBroker_ip(String broker_ip) {
        this.broker_ip = broker_ip;
    }

    public void setPublish_topic_name(String publish_topic_name) {
        this.publish_topic_name = publish_topic_name;
        System.out.println(publish_topic_name);
    }

    public void setPublishing_format(String publishing_format) {
        this.publishing_format = publishing_format;
        System.out.println(publishing_format);
    }

    public void setTime_format(String time_format) {
        this.time_format = time_format;
        System.out.println(time_format);
    }

    public JSONArray getJsonStringArray() {
        return this.jsonStringArray;
    }

    public void setJsonStringArray(JSONArray jsonStringArray) {
        this.jsonStringArray = jsonStringArray;
    }

    @Override
    public void run() {
        try {
            if (this.publishing_format.equalsIgnoreCase("array")) {
                JSONArray finalSendArray = new JSONArray();
                for (int i = 0; i < this.jsonStringArray.length(); ++i) {
                    JSONObject eachJsonObject = new JSONObject(this.jsonStringArray.getString(i));
                    JSONObject eachStringAndForamtString = this.getEachStringAndForamtString(eachJsonObject);
                    if (eachStringAndForamtString.length() <= 0) continue;
                    finalSendArray.put(eachStringAndForamtString);
                }
                if (finalSendArray.length() > 0) {
                    if (MqttExecutor.serverlistMap.containsKey(this.broker_ip) && MqttExecutor.serverlistMap.get(this.broker_ip).isConnected()) {
                        this.publish(MqttExecutor.serverlistMap.get(this.broker_ip), this.publish_topic_name, finalSendArray.toString(), this.broker_ip);
                    } else {
                        StoreForword s = new StoreForword();
                        s.setDate_time(Util.checkISToUTC(this.time_format));
                        s.setData_string(finalSendArray.toString());
                        s.setBroker_ip_address(this.broker_ip);
                        s.setPublish_topic(this.publish_topic_name);
                        logger.debug("Live data Msg not Published deu to Client Disconnected  : " + s);
                        StoreAndForwordDbOperations.getInstance().addStoreForwordData(s);
                    }
                }
            } else if (this.publishing_format.equalsIgnoreCase("single")) {
                for (int i = 0; i < this.jsonStringArray.length(); ++i) {
                    JSONObject singleObj = new JSONObject(this.jsonStringArray.getString(i));
                    JSONObject eachJsonObject = this.getEachStringAndForamtString(singleObj);
                    if (eachJsonObject.length() <= 0) continue;
                    if (MqttExecutor.serverlistMap.containsKey(this.broker_ip) && MqttExecutor.serverlistMap.get(this.broker_ip).isConnected()) {
                        this.publish(MqttExecutor.serverlistMap.get(this.broker_ip), this.publish_topic_name, eachJsonObject.toString(), this.broker_ip);
                        continue;
                    }
                    StoreForword s = new StoreForword();
                    s.setDate_time(Util.checkISToUTC(this.time_format));
                    s.setData_string(eachJsonObject.toString());
                    s.setBroker_ip_address(this.broker_ip);
                    s.setPublish_topic(this.publish_topic_name);
                    logger.debug("Live data Msg not Published deu to Client Disconnected : " + s);
                    StoreAndForwordDbOperations.getInstance().addStoreForwordData(s);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error While publishing JSON String : " + e);
            FileBasedLogger.error("Application", "Error While publishing JSON String : " + e, "system");
        }
    }

    private void publish(MqttClient client, String topic, String content, String ip) {
        MqttMessage message = new MqttMessage();
        message.setPayload(content.getBytes());
        message.setQos(2);
        try {
            if (client.isConnected()) {
                client.publish(topic, message);
            } else {
                StoreForword s = new StoreForword();
                s.setDate_time(Util.checkISToUTC(this.time_format));
                s.setData_string(content);
                s.setBroker_ip_address(ip);
                s.setPublish_topic(topic);
                logger.debug(" live data Msg not Published deu to Client Disconnected so inserting into db : " + s);
                StoreAndForwordDbOperations.getInstance().addStoreForwordData(s);
            }
        }
        catch (MqttPersistenceException e) {
            e.printStackTrace();
            FileBasedLogger.error("Application", "Error while publishing jsonString : " + e, "system");
        }
        catch (MqttException e) {
            e.printStackTrace();
            FileBasedLogger.error("Application", "Error while publishing jsonString : " + e, "system");
        }
        catch (Exception e) {
            e.printStackTrace();
            FileBasedLogger.error("Application", "Error while publishing jsonString : " + e, "system");
        }
    }

    private JSONObject getEachStringAndForamtString(JSONObject eachJsonObject) {
        JSONObject finalEachObj = new JSONObject();
        try {
            JSONObject eachObj = new JSONObject();
            List<String> dynamicKeys = Arrays.asList("unit_id", "asset_id", "EQUIPID", "MSGTYP", "CUSTID");
            if (eachJsonObject.has("unit_id") && eachJsonObject.has("asset_id")) {
                Iterator<String> keys = eachJsonObject.keys();
                while (keys.hasNext()) {
                    String key = keys.next();
                    Object keyValue = eachJsonObject.get(key);
                    if (dynamicKeys.contains(key.toLowerCase())) continue;
                    if (keyValue instanceof JSONArray) {
                        JSONArray jsonArray = (JSONArray)keyValue;
                        JSONArray resultArray = new JSONArray();
                        for (int i = 0; i < jsonArray.length(); ++i) {
                            JSONObject arrayElement = jsonArray.getJSONObject(i);
                            JSONObject processedObj = this.processArrayElement(arrayElement);
                            if (processedObj.length() <= 0) continue;
                            resultArray.put(processedObj);
                        }
                        eachObj.put(key, resultArray);
                        continue;
                    }
                    if (!(keyValue instanceof String)) continue;
                    String keyValueStr = (String)keyValue;
                    if (Service.variableTagMap.containsKey(keyValueStr)) {
                        try {
                            Tag tag = Service.variableTagMap.get(keyValueStr);
                            eachObj.put(key, tag.getValue());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    logger.debug(keyValueStr + " - key not found in TagMap.");
                }
                for (String dynamicKey : dynamicKeys) {
                    if (!eachJsonObject.has(dynamicKey)) continue;
                    eachObj.put(dynamicKey, eachJsonObject.getString(dynamicKey));
                }
                if (eachObj.length() > 0) {
                    eachObj.put("date_time", Util.checkISToUTC(this.time_format));
                }
            } else {
                logger.info("unit_id and asset_id not found.");
            }
            if (eachObj.length() > 0) {
                finalEachObj.put("read_ver", eachObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while parsing each String : " + e);
            FileBasedLogger.error("Application", "Error while parsing each String : " + e, "system");
        }
        return finalEachObj;
    }

    private JSONObject processArrayElement(JSONObject arrayElement) {
        JSONObject processedObj = new JSONObject();
        try {
            Iterator<String> keys = arrayElement.keys();
            while (keys.hasNext()) {
                String key = keys.next();
                String keyValue = arrayElement.getString(key);
                if (Service.variableTagMap.containsKey(keyValue)) {
                    try {
                        Tag tag = Service.variableTagMap.get(keyValue);
                        processedObj.put(key, tag.getValue());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                logger.debug(keyValue + " - key not found in TagMap.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while processing array element: " + e);
            FileBasedLogger.error("Application", "Error while processing array element: " + e, "system");
        }
        return processedObj;
    }
}

