/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.protocol.jsonbuillder;

import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.jsonBuilderSettings.JsonBuilder_operation;
import com.tas.wp500.mqttSettings.MQTT_opertions;
import com.tas.wp500.protocol.jsonbuillder.JSONBuilder;
import com.tas.wp500.protocol.jsonbuillder.JSONExecuteTask;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONBuilderExecutor
implements Runnable {
    private static Logger logger = Logger.getLogger(JSONBuilderExecutor.class);
    private JsonBuilder_operation jsonbuilder = JsonBuilder_operation.getInstance();
    private ArrayList<Timer> jsonTimerList = new ArrayList();
    private String jsonBuilderInterval;

    @Override
    public void run() {
        block13: {
            try {
                JSONObject ip_wise_json = new JSONObject();
                ArrayList<JSONBuilder> jsonBuilderDataList = this.jsonbuilder.getAllJsonBuilderData();
                if (jsonBuilderDataList.isEmpty()) break block13;
                for (int i = 0; i < jsonBuilderDataList.size(); ++i) {
                    try {
                        JSONBuilder json = jsonBuilderDataList.get(i);
                        String broker_ip_address = json.getBroker_ip_address();
                        if (i == 0) {
                            this.jsonBuilderInterval = json.getJson_interval();
                        }
                        if (!json.getPublishing_status().equalsIgnoreCase("enable")) continue;
                        if (ip_wise_json.has(broker_ip_address.trim())) {
                            ip_wise_json.getJSONArray(broker_ip_address).put(json.getJson_string());
                            continue;
                        }
                        ip_wise_json.put(broker_ip_address, new JSONArray().put(json.getJson_string()));
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error("Error while starting timer of json : " + e);
                        FileBasedLogger.error("Application", "Error while starting timer of json : " + e, "system");
                    }
                }
                logger.debug(" Size of broker : " + ip_wise_json.length());
                if (ip_wise_json.length() <= 0) break block13;
                List<String> brokerIpAddresses = MQTT_opertions.getInstance().getBrokerIpAddresses();
                for (int i = 0; i < brokerIpAddresses.size(); ++i) {
                    String ip = brokerIpAddresses.get(i);
                    try {
                        if (MQTT_opertions.getInstance().getmqttStatus(ip.trim()).equalsIgnoreCase("enable")) {
                            int interval;
                            JSONArray jsonStringArray = ip_wise_json.getJSONArray(ip);
                            JSONExecuteTask jsonTask = new JSONExecuteTask();
                            jsonTask.setBroker_ip(ip);
                            jsonTask.setPublish_topic_name(MQTT_opertions.getInstance().getPublishTopicName(ip.trim()));
                            jsonTask.setPublishing_format(MQTT_opertions.getInstance().getpublishingFormat(ip.trim()));
                            jsonTask.setTime_format(MQTT_opertions.getInstance().getTimeFormat(ip.trim()));
                            jsonTask.setJsonStringArray(jsonStringArray);
                            if (this.jsonBuilderInterval.isEmpty()) continue;
                            try {
                                interval = Integer.parseInt(this.jsonBuilderInterval);
                                logger.debug("JsonBuilder String interval :" + interval);
                            }
                            catch (NumberFormatException e) {
                                interval = 60;
                                e.printStackTrace();
                                logger.error(" Unable to parse json interval time " + this.jsonBuilderInterval);
                                FileBasedLogger.error("Application", " Unable to parse json interval time " + this.jsonBuilderInterval, "system");
                            }
                            Timer jsonTimer = new Timer();
                            jsonTimer.scheduleAtFixedRate((TimerTask)jsonTask, i * 1000, (long)(interval * 1000));
                            this.jsonTimerList.add(jsonTimer);
                            continue;
                        }
                        logger.debug("Status of ip" + ip + " is :" + MQTT_opertions.getInstance().getmqttStatus(ip.trim()));
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                logger.error("Error in Json builder Thread : " + e);
                FileBasedLogger.error("Application", "Error in Json builder Thread : " + e, "system");
            }
        }
    }

    public void cancelAllJSONBuilderTimers(String user) {
        try {
            ArrayList<Timer> timersCopy = new ArrayList<Timer>(this.jsonTimerList);
            for (Timer t : timersCopy) {
                if (t == null) continue;
                t.cancel();
                logger.info("JsonBuilder timer canceled.");
                FileBasedLogger.info("Application", "All JSON builder timers canceled successfully.", user);
            }
            this.jsonTimerList.clear();
            logger.info("All JSON builder timers canceled successfully.");
        }
        catch (ConcurrentModificationException cme) {
            logger.warn("ConcurrentModificationException occurred while canceling timers. This might be due to simultaneous modification of the list.", cme);
            FileBasedLogger.error("Application", "ConcurrentModificationException occurred while canceling timers. This might be due to simultaneous modification of the list : " + cme, user);
        }
        catch (Exception e) {
            logger.error("Error while canceling JSON builder timers : ", e);
            FileBasedLogger.error("Application", "Error while canceling JSON builder timers : " + e, user);
        }
    }
}

