/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.protocol.dispensor_trigger;

import com.tas.wp500.dispensorSettings.Dispensor;
import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.protocol.mqtt.MqttExecutor;
import com.tas.wp500.services.Service;
import com.tas.wp500.store_and_forword.StoreAndForwordDbOperations;
import com.tas.wp500.store_and_forword.StoreForword;
import com.tas.wp500.util.Util;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.TimerTask;
import org.apache.log4j.Logger;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.json.JSONObject;

public class EachDispExecuteTask
extends TimerTask {
    private static Logger logger = Logger.getLogger(EachDispExecuteTask.class);
    private SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
    private Dispensor eachDisp;
    private String publish_topic;
    private String time_format;
    private LocalDateTime start_date;
    private LocalDateTime end_date;
    private int start_date_count = 0;
    private int total_fill_time;
    private double amount;

    public String getPublish_topic() {
        return this.publish_topic;
    }

    public void setTimeFormat(String time_format) {
        this.time_format = time_format;
    }

    public void setPublish_topic(String publish_topic) {
        this.publish_topic = publish_topic;
    }

    public Dispensor getEachDisp() {
        return this.eachDisp;
    }

    public void setEachDisp(Dispensor eachDisp) {
        this.eachDisp = eachDisp;
    }

    @Override
    public void run() {
        block25: {
            try {
                Thread.currentThread().setName(this.eachDisp.getSerial_number());
                if (Service.variableTagMap != null && Service.variableTagMap.get(this.eachDisp.getTrigger_tag()) != null && Service.variableTagMap.get(this.eachDisp.getTrigger_tag()).getValue() != null && String.valueOf(Service.variableTagMap.get(this.eachDisp.getTrigger_tag()).getValue()).equalsIgnoreCase(this.eachDisp.getTrigger_value()) && this.start_date_count != 0) {
                    if (this.start_date == null) break block25;
                    try {
                        this.start_date_count = 0;
                        JSONObject trigger = new JSONObject();
                        this.end_date = Util.getCurrentISTDateTime();
                        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                        Duration duration = Duration.between(this.start_date, this.end_date);
                        int fill_time = this.total_fill_time = (int)Math.abs(duration.getSeconds());
                        int seconds = fill_time % 60;
                        int hours = 0;
                        int minutes = fill_time / 60;
                        if (minutes >= 60) {
                            hours = minutes / 60;
                            minutes %= 60;
                        }
                        String fill_min_sec = String.format("%02d:%02d:%02d", hours % 24, minutes, seconds);
                        try {
                            trigger.put("start_date_time", this.start_date.format(formatter));
                            trigger.put("end_date_time", this.end_date.format(formatter));
                            trigger.put("station_name", this.eachDisp.getStation_name());
                            trigger.put("serial_number", this.eachDisp.getSerial_number());
                            trigger.put("side", this.eachDisp.getSide());
                            trigger.put("trigger_tag", this.eachDisp.getTrigger_tag());
                            trigger.put("trigger_value", this.eachDisp.getTrigger_value());
                            trigger.put("unit_id", this.eachDisp.getUnit_id());
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            logger.error("Error while excuting DISP setting : " + e);
                            FileBasedLogger.error("Application", "Error while excuting DISP setting : " + e, "system");
                        }
                        Object start_pressure = 0.0;
                        Object end_pressure = 0.0;
                        Object temp = 0.0;
                        Object total = 0.0;
                        Object unit_price = 0.0;
                        Object quantity = 0.0;
                        try {
                            start_pressure = Service.variableTagMap.get(this.eachDisp.getStart_pressesure()).getValue();
                        }
                        catch (Exception e) {
                            logger.error("Failed to retrieve start_pressure value", e);
                            FileBasedLogger.error("Application", "start_pressure tag :" + Service.variableTagMap.get(this.eachDisp.getStart_pressesure()).getValue() + " please check its value : " + e, "system");
                        }
                        try {
                            end_pressure = Service.variableTagMap.get(this.eachDisp.getEnd_pressure()).getValue();
                        }
                        catch (Exception e) {
                            logger.error("Failed to retrieve end_pressure value", e);
                            FileBasedLogger.error("Application", "end_pressure tag : " + Service.variableTagMap.get(this.eachDisp.getEnd_pressure()).getValue() + " please check its value : " + e, "system");
                        }
                        try {
                            temp = Service.variableTagMap.get(this.eachDisp.getTempreture()).getValue();
                        }
                        catch (Exception e) {
                            logger.error("Failed to retrieve temperature value", e);
                            FileBasedLogger.error("Application", "temp tag : " + Service.variableTagMap.get(this.eachDisp.getTempreture()).getValue() + " please check its value : " + e, "system");
                        }
                        try {
                            total = Service.variableTagMap.get(this.eachDisp.getTotal()).getValue();
                        }
                        catch (Exception e) {
                            logger.error("Failed to retrieve total value", e);
                            FileBasedLogger.error("Application", "total tag : " + Service.variableTagMap.get(this.eachDisp.getTotal()).getValue() + " please check its value : " + e, "system");
                        }
                        try {
                            unit_price = Service.variableTagMap.get(this.eachDisp.getUnit_price()).getValue();
                        }
                        catch (Exception e) {
                            logger.error("Failed to retrieve unit_price value", e);
                            FileBasedLogger.error("Application", "unit_price tag : " + Service.variableTagMap.get(this.eachDisp.getUnit_price()).getValue() + " please check its value : " + e, "system");
                        }
                        try {
                            quantity = Service.variableTagMap.get(this.eachDisp.getQuantity()).getValue();
                        }
                        catch (Exception e) {
                            logger.error("Failed to retrieve quantity value", e);
                            FileBasedLogger.error("Application", "quantity tag : " + Service.variableTagMap.get(this.eachDisp.getQuantity()).getValue() + " please check its value : " + e, "system");
                        }
                        logger.debug("trigger_tag name : " + this.eachDisp.getStart_pressesure() + "start_pressure : " + start_pressure + " end_pressure :" + end_pressure + " temp : " + temp + " total : " + total + " unit_price : " + unit_price + " quantity : " + quantity + " fill_min_sec : " + fill_min_sec);
                        trigger.put("start_pressure", String.valueOf(start_pressure));
                        trigger.put("end_pressure", String.valueOf(end_pressure));
                        trigger.put("temp", temp);
                        trigger.put("total", total);
                        trigger.put("unit_price", String.valueOf(unit_price));
                        trigger.put("quantity", String.valueOf(quantity));
                        try {
                            this.amount = Double.parseDouble(String.valueOf(unit_price)) * Double.parseDouble(String.valueOf(quantity));
                        }
                        catch (NumberFormatException e) {
                            logger.error("Failed to parse unit_price or quantity as double values", e);
                            FileBasedLogger.error("Application", "Error parsing values. unit_price: " + unit_price + ", quantity: " + quantity + ", error: " + e, "system");
                        }
                        catch (Exception e) {
                            logger.error("Unexpected error during amount calculation", e);
                            FileBasedLogger.error("Application", "Unexpected error occurred. unit_price: " + unit_price + ", quantity: " + quantity + ", error: " + e, "system");
                        }
                        trigger.put("amount", this.amount);
                        trigger.put("fill_time", this.total_fill_time);
                        trigger.put("fill_time_min_sec", fill_min_sec);
                        trigger.put("date_time", EachDispExecuteTask.formatDate(Util.checkISToUTC(this.time_format)));
                        this.start_date = null;
                        JSONObject triggerObj = new JSONObject();
                        if (MqttExecutor.serverlistMap.containsKey(this.eachDisp.getBroker_ip_address()) && MqttExecutor.serverlistMap.get(this.eachDisp.getBroker_ip_address()).isConnected()) {
                            MqttClient mqttClient = MqttExecutor.serverlistMap.get(this.eachDisp.getBroker_ip_address());
                            triggerObj.put("disp_ver", trigger);
                            this.publish(mqttClient, this.publish_topic, triggerObj.toString(), this.eachDisp.getBroker_ip_address());
                            logger.debug("Succeefully published disp trigger msg : " + triggerObj.toString());
                            break block25;
                        }
                        triggerObj.put("disp_ver", trigger);
                        StoreForword s = new StoreForword();
                        s.setDate_time(this.sdf.format(new Date()));
                        s.setData_string(triggerObj.toString());
                        s.setBroker_ip_address(this.eachDisp.getBroker_ip_address());
                        s.setPublish_topic(this.publish_topic);
                        logger.debug(" Disp Trigger  Msg not Published deu to Client Disconnected so inserting into db : " + s);
                        StoreAndForwordDbOperations.getInstance().addStoreForwordData(s);
                    }
                    catch (Exception e) {
                        logger.error("Error disp trigger : " + e);
                        FileBasedLogger.error("Application", "Error disp trigger : " + e, "system");
                    }
                    break block25;
                }
                if (this.start_date_count == 0 && Service.variableTagMap != null && Service.variableTagMap.get(this.eachDisp.getTrigger_tag()) != null && Service.variableTagMap.get(this.eachDisp.getTrigger_tag()).getValue() != null && !String.valueOf(Service.variableTagMap.get(this.eachDisp.getTrigger_tag()).getValue()).equalsIgnoreCase(String.valueOf(this.eachDisp.getTrigger_value()))) {
                    this.start_date = Util.getCurrentISTDateTime();
                    this.start_date_count = 1;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("Error while disp trigger timer : " + e);
                FileBasedLogger.error("Application", "Error while disp trigger timer : " + e, "system");
            }
        }
    }

    private void publish(MqttClient client, String topic, String content, String ip) {
        MqttMessage message = new MqttMessage();
        message.setPayload(content.getBytes());
        message.setQos(2);
        try {
            if (client.isConnected()) {
                client.publish(topic, message);
            } else {
                StoreForword s = new StoreForword();
                s.setDate_time(this.sdf.format(new Date()));
                s.setData_string(content);
                s.setBroker_ip_address(ip);
                s.setPublish_topic(topic);
                StoreAndForwordDbOperations.getInstance().addStoreForwordData(s);
            }
        }
        catch (MqttPersistenceException e) {
            e.printStackTrace();
            FileBasedLogger.error("Application", "Error while disp trigger publishing : " + e, "system");
        }
        catch (MqttException e) {
            e.printStackTrace();
            FileBasedLogger.error("Application", "Error while disp trigger publishing : " + e, "system");
        }
        catch (Exception e) {
            e.printStackTrace();
            FileBasedLogger.error("Application", "Error while disp trigger publishing : " + e, "system");
        }
    }

    public static String formatDate(String dateTime) {
        try {
            SimpleDateFormat inputFormat = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
            SimpleDateFormat outputFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = inputFormat.parse(dateTime);
            return outputFormat.format(date);
        }
        catch (Exception e) {
            e.printStackTrace();
            FileBasedLogger.error("Application", "Error while formating date : " + e, "system");
            return dateTime;
        }
    }
}

