/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.protocol.dispensor_trigger;

import com.tas.wp500.dispensorSettings.Dispensor;
import com.tas.wp500.dispensorSettings.DispensorTriggerDb_Operations;
import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.mqttSettings.MQTT_opertions;
import com.tas.wp500.protocol.dispensor_trigger.EachDispExecuteTask;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Consumer;
import org.apache.log4j.Logger;

public class DispensorExecutor
implements Runnable {
    private static Logger logger = Logger.getLogger(DispensorExecutor.class);
    private DispensorTriggerDb_Operations disp = DispensorTriggerDb_Operations.getInstance();
    private MQTT_opertions mqtt = MQTT_opertions.getInstance();
    private ArrayList<Timer> dispTimerList = new ArrayList();

    @Override
    public void run() {
        try {
            ArrayList<Dispensor> allDispenserData = this.disp.getAllDispenserData();
            if (!allDispenserData.isEmpty()) {
                for (int i = 0; i < allDispenserData.size(); ++i) {
                    try {
                        EachDispExecuteTask dispTask = new EachDispExecuteTask();
                        Dispensor dispensor = allDispenserData.get(i);
                        if (MQTT_opertions.getInstance().getmqttStatus(dispensor.getBroker_ip_address().trim()).equalsIgnoreCase("enable")) {
                            if (!dispensor.getStatus().equalsIgnoreCase("Enable")) continue;
                            String broker_ip_address = dispensor.getBroker_ip_address();
                            dispTask.setPublish_topic(this.mqtt.getPublishTopicName(broker_ip_address));
                            dispTask.setEachDisp(dispensor);
                            dispTask.setTimeFormat(MQTT_opertions.getInstance().getTimeFormat(broker_ip_address).trim());
                            Timer dispTimer = new Timer();
                            dispTimer.scheduleAtFixedRate((TimerTask)dispTask, i * 1000, 3000L);
                            this.dispTimerList.add(dispTimer);
                            logger.debug("Each Disp Execute Task Data : " + dispensor);
                            continue;
                        }
                        logger.debug("Status of ip" + dispensor.getBroker_ip_address() + " is :" + MQTT_opertions.getInstance().getmqttStatus(dispensor.getBroker_ip_address().trim()));
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error("Error while Starting Each DISP Task : " + e);
                        FileBasedLogger.error("Application", "Error while Starting Each DISP Task : " + e, "system");
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while Starting Each Disp Task : " + e);
            FileBasedLogger.error("Application", "Error while Starting Each Disp Task : " + e, "system");
        }
    }

    public void cancelDispTriggerTimers(String user) {
        try {
            if (!this.dispTimerList.isEmpty()) {
                this.dispTimerList.forEach(new Consumer<Timer>(){

                    @Override
                    public void accept(Timer t) {
                        if (t != null) {
                            t.cancel();
                            logger.info("Dispensor timer cancel.");
                        }
                    }
                });
            }
            this.dispTimerList.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
            FileBasedLogger.error("Application", "Error while canceling Dispensor Trigger Timers : " + e, user);
            logger.error("Error while canceling Dispensor Trigger Timers : " + e);
        }
    }
}

