/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.protocol.command;

import com.tas.wp500.cgi_command.CGI_Command;
import com.tas.wp500.commandSettings.Command;
import com.tas.wp500.commandSettings.CommandDbOperations;
import com.tas.wp500.events.EventsDbOperation;
import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.mqttSettings.MQTT_opertions;
import com.tas.wp500.protocol.mqtt.MqttExecutor;
import com.tas.wp500.protocol.startanWebSocket.StartanWebExecutor;
import com.tas.wp500.services.Service;
import com.tas.wp500.util.ConfigClass;
import com.tas.wp500.webSocket.WebSocketClient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.json.JSONArray;
import org.json.JSONObject;

public class CommandWriteExecutor
implements Runnable {
    private static Logger logger = Logger.getLogger(CommandWriteExecutor.class);
    private CGI_Command cgi = CGI_Command.getInstance();
    private static ConfigClass configInstance = ConfigClass.getInstance();
    private EventsDbOperation event = EventsDbOperation.getInstance();
    private CommandDbOperations commandDB = CommandDbOperations.getInstance();
    private MQTT_opertions mqtt = MQTT_opertions.getInstance();
    private static String stratonProtocol;
    private String writeResp;

    public String getWriteResp() {
        return this.writeResp;
    }

    public void setWriteResp(String writeResp) {
        this.writeResp = writeResp;
    }

    @Override
    public void run() {
        if (!this.writeResp.isEmpty()) {
            try {
                JSONArray writeResponseArray = new JSONArray(this.writeResp.toString());
                HashMap<String, String> storeWriteTag = new HashMap<String, String>();
                for (int i = 0; i < writeResponseArray.length(); ++i) {
                    JSONObject jsonObject = writeResponseArray.getJSONObject(i);
                    storeWriteTag.put(jsonObject.getString("tag_name"), jsonObject.getString("value"));
                }
                stratonProtocol = configInstance.readConfigName("straton_protocol");
                if (stratonProtocol.equalsIgnoreCase("cgi")) {
                    this.processEachWriteRequestCgi(storeWriteTag);
                } else if (stratonProtocol.equalsIgnoreCase("ws") || stratonProtocol.equalsIgnoreCase("ws_read") || stratonProtocol.equalsIgnoreCase("ws_sub")) {
                    this.processEachWriteRequestFcgi(storeWriteTag);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("Error while Processing write request : " + e);
                FileBasedLogger.error("Application", "Error while Processing write request : " + e, "system");
            }
        } else {
            FileBasedLogger.info("Application", "Empty write request", "system");
            logger.info("Empty write request.");
        }
    }

    public void processEachWriteRequestCgi(HashMap<String, String> storeWriteTag) {
        try {
            if (storeWriteTag.size() > 0) {
                String QUERY_STRING = "QUERY_STRING=\"t5wcmd=write";
                boolean allKeysPresent = true;
                if (storeWriteTag.containsKey("Price")) {
                    if (Service.variableTagMap.containsKey("Price") || Service.variableTagMap.containsKey("PRICE")) {
                        QUERY_STRING = QUERY_STRING + "&app.PRICE=" + storeWriteTag.get("Price");
                    } else {
                        allKeysPresent = false;
                        this.publishMissingKeyMessage("Price");
                    }
                    storeWriteTag.remove("Price");
                }
                if (storeWriteTag.containsKey("Year")) {
                    if (Service.variableTagMap.containsKey("Year") || Service.variableTagMap.containsKey("YEAR")) {
                        QUERY_STRING = QUERY_STRING + "&app.YEAR=" + storeWriteTag.get("Year");
                    } else {
                        allKeysPresent = false;
                        this.publishMissingKeyMessage("Year");
                    }
                    storeWriteTag.remove("Year");
                }
                if (storeWriteTag.containsKey("Month")) {
                    if (Service.variableTagMap.containsKey("Month") || Service.variableTagMap.containsKey("MONTH")) {
                        QUERY_STRING = QUERY_STRING + "&app.MONTH=" + storeWriteTag.get("Month");
                    } else {
                        allKeysPresent = false;
                        this.publishMissingKeyMessage("Month");
                    }
                    storeWriteTag.remove("Month");
                }
                if (storeWriteTag.containsKey("Day")) {
                    if (Service.variableTagMap.containsKey("Day") || Service.variableTagMap.containsKey("DAY")) {
                        QUERY_STRING = QUERY_STRING + "&app.DAY=" + storeWriteTag.get("Day");
                    } else {
                        allKeysPresent = false;
                        this.publishMissingKeyMessage("Day");
                    }
                    storeWriteTag.remove("Day");
                }
                if (storeWriteTag.containsKey("Hour")) {
                    if (Service.variableTagMap.containsKey("Hour") || Service.variableTagMap.containsKey("HOUR")) {
                        QUERY_STRING = QUERY_STRING + "&app.HOUR=" + storeWriteTag.get("Hour");
                    } else {
                        allKeysPresent = false;
                        this.publishMissingKeyMessage("Hour");
                    }
                    storeWriteTag.remove("Hour");
                }
                if (storeWriteTag.containsKey("Min")) {
                    if (Service.variableTagMap.containsKey("Min") || Service.variableTagMap.containsKey("MINUTES")) {
                        QUERY_STRING = QUERY_STRING + "&app.MINUTES=" + storeWriteTag.get("Min");
                    } else {
                        allKeysPresent = false;
                        this.publishMissingKeyMessage("Min");
                    }
                    storeWriteTag.remove("Min");
                }
                for (Map.Entry<String, String> entry : storeWriteTag.entrySet()) {
                    String key = entry.getKey();
                    if (Service.variableTagMap.containsKey(key)) {
                        QUERY_STRING = QUERY_STRING + "&app." + key + "=" + entry.getValue();
                        continue;
                    }
                    if (Service.variableTagMap.containsKey(key.toUpperCase())) {
                        QUERY_STRING = QUERY_STRING + "&app." + key.toUpperCase() + "=" + entry.getValue();
                        continue;
                    }
                    if (Service.variableTagMap.containsKey(key.toLowerCase())) {
                        QUERY_STRING = QUERY_STRING + "&app." + key.toLowerCase() + "=" + entry.getValue();
                        continue;
                    }
                    allKeysPresent = false;
                    this.publishMissingKeyMessage(key);
                }
                QUERY_STRING = QUERY_STRING + "\" t5cgi";
                logger.debug("Updated QUERY_STRING: " + QUERY_STRING);
                FileBasedLogger.info("Application", "Updated QUERY_STRING: " + QUERY_STRING, "system");
                if (allKeysPresent) {
                    boolean result = this.cgi.writeOnVariableUsingCommand(QUERY_STRING);
                    logger.debug("result-->" + result);
                    if (result) {
                        Command command;
                        String broker_ip;
                        String publishTopicName;
                        logger.info("Write successfully for request: " + this.writeResp);
                        FileBasedLogger.info("Application", "Write successfully for request: " + this.writeResp, "system");
                        JSONObject ackResponse = new JSONObject();
                        ackResponse.put("ack", "Yes");
                        ackResponse.put("data", this.writeResp);
                        logger.info("Acknowledge message: " + ackResponse.toString());
                        FileBasedLogger.info("Application", "Acknowledge message: " + ackResponse.toString(), "system");
                        ArrayList<Command> allCommandData = this.commandDB.getAllCommandData();
                        if (!allCommandData.isEmpty() && !(publishTopicName = this.mqtt.getPublishTopicName(broker_ip = (command = allCommandData.get(0)).getBroker_ip())).equals("")) {
                            this.publish(MqttExecutor.serverlistMap.get(broker_ip), publishTopicName, ackResponse.toString());
                            logger.info("Acknowledge msg published Successfully to topic: " + publishTopicName + " msg: " + ackResponse.toString());
                            FileBasedLogger.info("Application", "Acknowledge msg published Successfully to topic: " + publishTopicName + " msg: " + ackResponse.toString(), "system");
                        }
                    } else {
                        FileBasedLogger.info("Application", "Failed to write Command request: " + this.writeResp.toString(), "system");
                        logger.info("Failed to write Command request: " + this.writeResp.toString());
                    }
                } else {
                    FileBasedLogger.info("Application", "Not all keys are present, check logs for missing keys.", "system");
                    logger.info("Not all keys are present, check logs for missing keys.");
                }
            } else {
                FileBasedLogger.info("Application", "Empty write tag list.", "system");
                logger.info("Empty write tag list.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            FileBasedLogger.error("Application", "Error while processing Each write request: " + e, "system");
            logger.error("Error while processing Each write request: " + e);
        }
    }

    private void publishMissingKeyMessage(String key) {
        Command command;
        String broker_ip;
        String publishTopicName;
        logger.error("Key not found in write string : " + key);
        FileBasedLogger.warn("Application", "Key not found in write string : " + key, "system");
        JSONObject errorMessage = new JSONObject();
        errorMessage.put("error", "Key not found");
        errorMessage.put("missing_key", key);
        ArrayList<Command> allCommandData = this.commandDB.getAllCommandData();
        if (!allCommandData.isEmpty() && !(publishTopicName = this.mqtt.getPublishTopicName(broker_ip = (command = allCommandData.get(0)).getBroker_ip())).equals("")) {
            this.publish(MqttExecutor.serverlistMap.get(broker_ip), publishTopicName, errorMessage.toString());
            logger.info("Error msg published Successfully to topic: " + publishTopicName + " msg: " + errorMessage.toString());
            FileBasedLogger.info("Application", "Error msg published Successfully to topic: " + publishTopicName + " msg: " + errorMessage.toString(), "system");
        }
    }

    private void publish(MqttClient client, String topic, String content) {
        MqttMessage message = new MqttMessage();
        message.setPayload(content.getBytes());
        message.setQos(2);
        try {
            if (client.isConnected()) {
                client.publish(topic, message);
            }
        }
        catch (MqttPersistenceException e) {
            e.printStackTrace();
            logger.error("Error publish function of command : " + e);
            FileBasedLogger.error("Application", "Error publish function of command : " + e, "system");
        }
        catch (MqttException e) {
            e.printStackTrace();
            logger.error("Error publish function of command  : " + e);
            FileBasedLogger.error("Application", "Error publish function of command : " + e, "system");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error publish function of command  : " + e);
            FileBasedLogger.error("Application", "Error publish function of command : " + e, "system");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEachWriteRequestFcgi(HashMap<String, String> storeWriteTag) {
        try {
            if (storeWriteTag.size() > 0) {
                Object dataObject;
                JSONObject json = new JSONObject();
                json.put("cmd", "write2");
                JSONArray dataArray = new JSONArray();
                boolean allKeysPresent = true;
                if (storeWriteTag.containsKey("Price")) {
                    if (Service.variableTagMap.containsKey("Price")) {
                        dataObject = new JSONObject();
                        ((JSONObject)dataObject).put("name", "app.PRICE");
                        ((JSONObject)dataObject).put("value", storeWriteTag.get("Price"));
                        dataArray.put(dataObject);
                    } else {
                        allKeysPresent = false;
                        this.publishMissingKeyMessage("Price");
                    }
                    storeWriteTag.remove("Price");
                }
                if (storeWriteTag.containsKey("Year")) {
                    if (Service.variableTagMap.containsKey("Year")) {
                        dataObject = new JSONObject();
                        ((JSONObject)dataObject).put("name", "app.YEAR");
                        ((JSONObject)dataObject).put("value", storeWriteTag.get("Year"));
                        dataArray.put(dataObject);
                    } else {
                        allKeysPresent = false;
                        this.publishMissingKeyMessage("Year");
                    }
                    storeWriteTag.remove("Year");
                }
                if (storeWriteTag.containsKey("Month")) {
                    if (Service.variableTagMap.containsKey("Month")) {
                        dataObject = new JSONObject();
                        ((JSONObject)dataObject).put("name", "app.MONTH");
                        ((JSONObject)dataObject).put("value", storeWriteTag.get("Month"));
                        dataArray.put(dataObject);
                    } else {
                        allKeysPresent = false;
                        this.publishMissingKeyMessage("Month");
                    }
                    storeWriteTag.remove("Month");
                }
                if (storeWriteTag.containsKey("Day")) {
                    if (Service.variableTagMap.containsKey("Day")) {
                        dataObject = new JSONObject();
                        ((JSONObject)dataObject).put("name", "app.DAY");
                        ((JSONObject)dataObject).put("value", storeWriteTag.get("Day"));
                        dataArray.put(dataObject);
                    } else {
                        allKeysPresent = false;
                        this.publishMissingKeyMessage("Day");
                    }
                    storeWriteTag.remove("Day");
                }
                if (storeWriteTag.containsKey("Hour")) {
                    if (Service.variableTagMap.containsKey("Hour")) {
                        dataObject = new JSONObject();
                        ((JSONObject)dataObject).put("name", "app.HOUR");
                        ((JSONObject)dataObject).put("value", storeWriteTag.get("Hour"));
                        dataArray.put(dataObject);
                    } else {
                        allKeysPresent = false;
                        this.publishMissingKeyMessage("Hour");
                    }
                    storeWriteTag.remove("Hour");
                }
                if (storeWriteTag.containsKey("Min")) {
                    if (Service.variableTagMap.containsKey("Min")) {
                        dataObject = new JSONObject();
                        ((JSONObject)dataObject).put("name", "app.MINUTES");
                        ((JSONObject)dataObject).put("value", storeWriteTag.get("Min"));
                        dataArray.put(dataObject);
                    } else {
                        allKeysPresent = false;
                        this.publishMissingKeyMessage("Min");
                    }
                    storeWriteTag.remove("Min");
                }
                for (Map.Entry entry : storeWriteTag.entrySet()) {
                    JSONObject dataObject2;
                    String key = (String)entry.getKey();
                    if (Service.variableTagMap.containsKey(key)) {
                        JSONObject dataObject22 = new JSONObject();
                        dataObject22.put("name", "app." + key);
                        dataObject22.put("value", entry.getValue());
                        dataArray.put(dataObject22);
                        continue;
                    }
                    if (Service.variableTagMap.containsKey(key.toUpperCase())) {
                        dataObject2 = new JSONObject();
                        dataObject2.put("name", "app." + key.toUpperCase());
                        dataObject2.put("value", entry.getValue());
                        dataArray.put(dataObject2);
                        continue;
                    }
                    if (Service.variableTagMap.containsKey(key.toLowerCase())) {
                        dataObject2 = new JSONObject();
                        dataObject2.put("name", "app." + key.toLowerCase());
                        dataObject2.put("value", entry.getValue());
                        dataArray.put(dataObject2);
                        continue;
                    }
                    allKeysPresent = false;
                    this.publishMissingKeyMessage(key);
                }
                json.put("data", dataArray);
                String jsonString = json.toString();
                logger.debug("Updated JSON string: " + jsonString);
                if (allKeysPresent) {
                    String string = WebSocketClient.sendJsonAndGetResponse(Service.webSocketUrl, jsonString);
                    if (string != null) {
                        JSONObject responseJson = new JSONObject(string);
                        if (responseJson.getInt("error") == 200) {
                            Command command;
                            String broker_ip;
                            String publishTopicName;
                            logger.info("Write successfully for request: " + this.writeResp);
                            FileBasedLogger.info("Application", "Write successfully for request: " + this.writeResp, "system");
                            JSONObject ackResponse = new JSONObject();
                            ackResponse.put("ack", "Yes");
                            ackResponse.put("data", this.writeResp);
                            logger.info("Acknowledge message: " + ackResponse.toString());
                            ArrayList<Command> allCommandData = this.commandDB.getAllCommandData();
                            if (!allCommandData.isEmpty() && !(publishTopicName = this.mqtt.getPublishTopicName(broker_ip = (command = allCommandData.get(0)).getBroker_ip())).equals("")) {
                                this.publish(MqttExecutor.serverlistMap.get(broker_ip), publishTopicName, ackResponse.toString());
                                logger.info("Acknowledge msg published Successfully to topic: " + publishTopicName + " msg: " + ackResponse.toString());
                                FileBasedLogger.info("Application", "Acknowledge msg published Successfully to topic: " + publishTopicName + " msg: " + ackResponse.toString(), "system");
                            }
                        }
                    } else {
                        logger.info("Failed to write Command request: " + this.writeResp.toString());
                        FileBasedLogger.info("Application", "Failed to write Command request: " + this.writeResp.toString(), "system");
                    }
                } else {
                    logger.info("Not all keys are present, check logs for missing keys.");
                    FileBasedLogger.info("Application", "Not all keys are present, check logs for missing keys.", "system");
                }
            } else {
                logger.info("Empty write tag list.");
                FileBasedLogger.info("Application", "Empty write tag list.", "system");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while processing Each write request: " + e);
            FileBasedLogger.error("Application", "Error while processing Each write request: " + e, "system");
        }
        finally {
            StartanWebExecutor.retrieveAndProcessJSONArray();
        }
    }
}

