/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.protocol.command;

import com.tas.wp500.commandSettings.Command;
import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.protocol.mqtt.MqttExecutor;
import com.tas.wp500.protocol.startan.Tag;
import com.tas.wp500.services.Service;
import com.tas.wp500.util.Util;
import java.text.SimpleDateFormat;
import java.util.TimerTask;
import org.apache.log4j.Logger;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.json.JSONArray;
import org.json.JSONObject;

public class CommandTimerExecutor
extends TimerTask {
    private static Logger logger = Logger.getLogger(CommandTimerExecutor.class);
    private SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
    private Command commandData;
    private String publishTopicName;
    private String subcribeTopicName;
    private String time_format;

    public Command getCommandData() {
        return this.commandData;
    }

    public void setCommandData(Command commandData) {
        this.commandData = commandData;
    }

    public String getPublishTopicName() {
        return this.publishTopicName;
    }

    public void setPublishTopicName(String publishTopicName) {
        this.publishTopicName = publishTopicName;
    }

    public void setTimeFormat(String time_format) {
        this.time_format = time_format;
    }

    public void setSubcribeTopicName(String subcribeTopicName) {
        this.subcribeTopicName = subcribeTopicName;
    }

    @Override
    public void run() {
        try {
            String commandStatus = this.commandData.getCommand_status();
            if (commandStatus.equalsIgnoreCase("enable")) {
                JSONObject commandObj = new JSONObject();
                JSONObject finalSendObj = new JSONObject();
                JSONArray commandTag = this.commandData.getCommand_tag();
                for (int i = 0; i < commandTag.length(); ++i) {
                    String key = commandTag.getString(i).trim();
                    if (Service.variableTagMap.containsKey(key)) {
                        try {
                            Tag tag = Service.variableTagMap.get(key);
                            finalSendObj.put(key, tag.getValue());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    logger.debug(key + " - not found in TagMap.");
                }
                if (finalSendObj.length() > 0) {
                    finalSendObj.put("unit_id", this.commandData.getUnit_id());
                    finalSendObj.put("asset_id", this.commandData.getAsset_id());
                    finalSendObj.put("date_time", Util.checkISToUTC(this.time_format));
                    finalSendObj.put("topic", this.subcribeTopicName);
                    finalSendObj.put("ip_address", this.commandData.getBroker_ip());
                    commandObj.put("write_ver", finalSendObj);
                    if (MqttExecutor.serverlistMap.containsKey(this.commandData.getBroker_ip()) && MqttExecutor.serverlistMap.get(this.commandData.getBroker_ip()).isConnected()) {
                        this.publish(MqttExecutor.serverlistMap.get(this.commandData.getBroker_ip()), this.publishTopicName, commandObj.toString());
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            FileBasedLogger.error("Application", "Error while command timer: " + e, "system");
        }
    }

    private void publish(MqttClient client, String topic, String content) {
        MqttMessage message = new MqttMessage();
        message.setPayload(content.getBytes());
        message.setQos(2);
        try {
            if (client.isConnected()) {
                client.publish(topic, message);
            }
        }
        catch (MqttPersistenceException e) {
            e.printStackTrace();
            logger.error("Error publish function of command : " + e);
            FileBasedLogger.error("Application", "Error publish function of command : " + e, "system");
        }
        catch (MqttException e) {
            e.printStackTrace();
            logger.error("Error publish function of command : " + e);
            FileBasedLogger.error("Application", "Error publish function of command : " + e, "system");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error publish function of command : " + e);
            FileBasedLogger.error("Application", "Error publish function of command : " + e, "system");
        }
    }
}

