/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.protocol.command;

import com.tas.wp500.commandSettings.Command;
import com.tas.wp500.commandSettings.CommandDbOperations;
import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.mqttSettings.MQTT_opertions;
import com.tas.wp500.protocol.command.CommandTimerExecutor;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class CommandExecutor
implements Runnable {
    private static Logger logger = Logger.getLogger(CommandExecutor.class);
    private CommandDbOperations commandDB = CommandDbOperations.getInstance();
    private MQTT_opertions mqtt = MQTT_opertions.getInstance();
    private ArrayList<Timer> commandTimerList = new ArrayList();

    @Override
    public void run() {
        try {
            ArrayList<Command> allCommandData = this.commandDB.getAllCommandData();
            if (!allCommandData.isEmpty()) {
                Command command = allCommandData.get(0);
                if (MQTT_opertions.getInstance().getmqttStatus(command.getBroker_ip().trim()).equalsIgnoreCase("enable")) {
                    String broker_ip = command.getBroker_ip();
                    String publishTopicName = this.mqtt.getPublishTopicName(broker_ip);
                    String subcribeTopicName = this.mqtt.getSubcribeTopicName(broker_ip);
                    if (!publishTopicName.equals("") && !subcribeTopicName.equals("")) {
                        CommandTimerExecutor com = new CommandTimerExecutor();
                        com.setCommandData(command);
                        com.setPublishTopicName(publishTopicName);
                        com.setSubcribeTopicName(subcribeTopicName);
                        com.setTimeFormat(MQTT_opertions.getInstance().getTimeFormat(broker_ip.trim()));
                        Timer commandTimer = new Timer();
                        commandTimer.scheduleAtFixedRate((TimerTask)com, 5000L, (long)(command.getInterval() * 1000));
                        this.commandTimerList.add(commandTimer);
                        logger.debug("Command timer started successfully.");
                    } else {
                        logger.info(String.format("Publish topic name not found for broker IP: %s", command.getBroker_ip()));
                    }
                } else {
                    logger.debug("Status of ip" + command.getBroker_ip() + " is :" + MQTT_opertions.getInstance().getmqttStatus(command.getBroker_ip().trim()));
                }
            } else {
                logger.info("Command Configuration Not Found.");
            }
        }
        catch (Exception e) {
            logger.debug("Error while starting command timer: ", e);
            FileBasedLogger.error("Application", "Error while starting command timer: " + e.getMessage(), "system");
        }
    }

    public void cancelCommandTimers(String user) {
        try {
            if (!this.commandTimerList.isEmpty()) {
                ArrayList<Timer> timersCopy = new ArrayList<Timer>(this.commandTimerList);
                for (Timer t : timersCopy) {
                    if (t == null) continue;
                    t.cancel();
                    logger.info("CommandTimer timer is canceled.");
                }
            }
            this.commandTimerList.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
            FileBasedLogger.error("Application", "Error while canceling Command Timer : " + e, user);
            logger.error("Error while canceling Command Timer : " + e);
        }
    }
}

