/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.protocol.alarm;

import com.tas.wp500.alarmSettings.Alaram;
import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.protocol.mqtt.MqttExecutor;
import com.tas.wp500.protocol.startan.Tag;
import com.tas.wp500.services.Service;
import com.tas.wp500.util.Util;
import java.text.SimpleDateFormat;
import java.util.TimerTask;
import org.apache.log4j.Logger;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.json.JSONArray;
import org.json.JSONObject;

public class AlarmTimerExecutor
extends TimerTask {
    private static Logger logger = Logger.getLogger(AlarmTimerExecutor.class);
    private SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
    private Alaram alarmData;
    private String publish_topic_name;
    private String time_format;

    public String getPublish_topic_name() {
        return this.publish_topic_name;
    }

    public void setPublish_topic_name(String publish_topic_name) {
        this.publish_topic_name = publish_topic_name;
    }

    public void setTimeFormat(String time_format) {
        this.time_format = time_format;
    }

    public Alaram getAlarmData() {
        return this.alarmData;
    }

    public void setAlarmData(Alaram alarmData) {
        this.alarmData = alarmData;
    }

    @Override
    public void run() {
        try {
            String alarmStatus = this.alarmData.getAlarm_status();
            if (alarmStatus.equalsIgnoreCase("enable")) {
                JSONObject alarmObj = new JSONObject();
                JSONObject finalSendObj = new JSONObject();
                JSONArray alarmTag = this.alarmData.getAlarmTag();
                for (int i = 0; i < alarmTag.length(); ++i) {
                    String key = alarmTag.getString(i).trim();
                    if (Service.variableTagMap.containsKey(key)) {
                        try {
                            Tag tag = Service.variableTagMap.get(key);
                            finalSendObj.put(key, tag.getValue());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    logger.debug(key + " - not found in TagMap.");
                }
                if (finalSendObj.length() > 0) {
                    finalSendObj.put("unit_id", this.alarmData.getUnit_id());
                    finalSendObj.put("asset_id", this.alarmData.getAsset_id());
                    finalSendObj.put("date_time", Util.checkISToUTC(this.time_format));
                    alarmObj.put("alarm_ver", finalSendObj);
                    if (MqttExecutor.serverlistMap.containsKey(this.alarmData.getBroker_ip()) && MqttExecutor.serverlistMap.get(this.alarmData.getBroker_ip()).isConnected()) {
                        this.publish(MqttExecutor.serverlistMap.get(this.alarmData.getBroker_ip()), this.publish_topic_name, alarmObj.toString());
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            FileBasedLogger.error("Application", "Error while publishing alarm massages :  " + e, "system");
            logger.error("Error while publishing alarm massages :  " + e);
        }
    }

    private void publish(MqttClient client, String topic, String content) {
        MqttMessage message = new MqttMessage();
        message.setPayload(content.getBytes());
        message.setQos(1);
        try {
            if (client.isConnected()) {
                client.publish(topic, message);
            }
        }
        catch (MqttPersistenceException e) {
            e.printStackTrace();
            logger.error("Error publish function of alarm : " + e);
            FileBasedLogger.error("Application", "Error publish function of alarm : " + e, "system");
        }
        catch (MqttException e) {
            e.printStackTrace();
            logger.error("Error publish function of alarm : " + e);
            FileBasedLogger.error("Application", "Error publish function of alarm : " + e, "system");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error publish function of alarm : " + e);
            FileBasedLogger.error("Application", "Error publish function of alarm : " + e, "system");
        }
    }
}

