/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.protocol.alarm;

import com.tas.wp500.alarmSettings.Alaram;
import com.tas.wp500.alarmSettings.AlarmDbOperation;
import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.mqttSettings.MQTT_opertions;
import com.tas.wp500.protocol.alarm.AlarmTimerExecutor;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class AlarmExecutor
implements Runnable {
    private static Logger logger = Logger.getLogger(AlarmExecutor.class);
    private AlarmDbOperation almDb = AlarmDbOperation.getInstance();
    private ArrayList<Timer> alarmTimerList = new ArrayList();
    private MQTT_opertions mqtt = MQTT_opertions.getInstance();

    @Override
    public void run() {
        try {
            ArrayList<Alaram> allAlarmData = this.almDb.getAllAlarmData();
            if (!allAlarmData.isEmpty()) {
                Alaram alaram = allAlarmData.get(0);
                if (MQTT_opertions.getInstance().getmqttStatus(alaram.getBroker_ip().trim()).equalsIgnoreCase("enable")) {
                    int interval = alaram.getInterval();
                    String publishTopicName = this.mqtt.getPublishTopicName(alaram.getBroker_ip());
                    if (!publishTopicName.equals("")) {
                        AlarmTimerExecutor alm = new AlarmTimerExecutor();
                        alm.setAlarmData(alaram);
                        alm.setPublish_topic_name(publishTopicName);
                        alm.setTimeFormat(MQTT_opertions.getInstance().getTimeFormat(alaram.getBroker_ip().trim()));
                        Timer alramTimer = new Timer();
                        alramTimer.scheduleAtFixedRate((TimerTask)alm, 5000L, (long)(interval * 1000));
                        this.alarmTimerList.add(alramTimer);
                        logger.debug("Alarm timer started successfully.");
                    } else {
                        logger.info(String.format("Publish topic name not found for broker IP: %s", alaram.getBroker_ip()));
                        FileBasedLogger.info("Application", String.format("Publish topic name not found for broker IP: %s", alaram.getBroker_ip()), "system");
                    }
                } else {
                    logger.debug("Status of ip" + alaram.getBroker_ip() + " is :" + MQTT_opertions.getInstance().getmqttStatus(alaram.getBroker_ip().trim()));
                }
            } else {
                logger.info("No alarm configuration data found.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            FileBasedLogger.error("Application", "Error while starting alarm Timer : " + e, "system");
            logger.error("Error while starting alarm Timer : " + e);
        }
    }

    public void cancelAlarmTimer(String user) {
        try {
            if (!this.alarmTimerList.isEmpty()) {
                ArrayList<Timer> timersCopy = new ArrayList<Timer>(this.alarmTimerList);
                for (Timer t : timersCopy) {
                    if (t == null) continue;
                    t.cancel();
                    logger.info("alarmTimer timer canceled.");
                }
            }
            this.alarmTimerList.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
            FileBasedLogger.error("Application", "Error while canceling alarm timer : " + e, user);
            logger.error("Error while canceling alarm timer : " + e);
        }
    }
}

