/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.projectSetting;

import com.tas.wp500.sql_lite_db.SQLiteConnector;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class ProjectNameSetting {
    private static final Logger logger = Logger.getLogger(ProjectNameSetting.class);
    private static ProjectNameSetting instance = null;
    public static HashMap<String, String> projectNameMap = new HashMap();
    private static final String DEFAULT_PROJECT_NAME = "WP500";

    public static ProjectNameSetting getInstance() {
        if (instance == null) {
            instance = new ProjectNameSetting();
        }
        return instance;
    }

    private ProjectNameSetting() {
        this.createProjectNameSettingTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createProjectNameSettingTable() {
        Connection connection = SQLiteConnector.getConnection();
        try {
            String createTableSQL = "CREATE TABLE IF NOT EXISTS project_name_setting (id INTEGER PRIMARY KEY CHECK (id = 1), project_name TEXT)";
            PreparedStatement preparedStatement = connection.prepareStatement(createTableSQL);
            preparedStatement.executeUpdate();
            preparedStatement.close();
            if (!this.isProjectNamePresent(connection)) {
                this.insertDefaultProjectName(connection);
            }
            logger.info("ProjectSetting table created or already exists, default name set if necessary.");
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("Error creating ProjectSetting table : " + e);
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
    }

    private boolean isProjectNamePresent(Connection connection) throws SQLException {
        String querySQL = "SELECT COUNT(*) FROM project_name_setting";
        PreparedStatement preparedStatement = connection.prepareStatement(querySQL);
        ResultSet resultSet = preparedStatement.executeQuery();
        boolean isPresent = resultSet.next() && resultSet.getInt(1) > 0;
        resultSet.close();
        preparedStatement.close();
        return isPresent;
    }

    private void insertDefaultProjectName(Connection connection) throws SQLException {
        String insertSQL = "INSERT INTO project_name_setting (id, project_name) VALUES (1, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(insertSQL);
        preparedStatement.setString(1, DEFAULT_PROJECT_NAME);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        logger.info("Inserted default project name: WP500");
        projectNameMap.put("project_name", DEFAULT_PROJECT_NAME);
    }

    public String getProjectName() {
        return projectNameMap.getOrDefault("project_name", DEFAULT_PROJECT_NAME);
    }

    public void addProjectNameToMap(String projectName) {
        projectNameMap.put("project_name", projectName);
    }

    public JSONObject updateProjectName(JSONObject jsonObject) {
        JSONObject resultObj = new JSONObject();
        String newProjectName = jsonObject.optString("project_name", null);
        if (newProjectName == null || newProjectName.isEmpty()) {
            logger.error("Invalid project name in JSON object.");
            resultObj.put("status", "error");
            resultObj.put("message", "Invalid project name.");
            return resultObj;
        }
        if (this.updateProjectNameInDatabase(newProjectName)) {
            resultObj.put("status", "success");
            resultObj.put("message", "Project name successfully updated to: " + newProjectName);
        } else {
            logger.error("Failed to update project name :" + newProjectName);
            resultObj.put("status", "error");
            resultObj.put("message", "Failed to rename project folder.");
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateProjectNameInDatabase(String newProjectName) {
        Connection connection = SQLiteConnector.getConnection();
        boolean result = false;
        try {
            String updateSQL = "UPDATE project_name_setting SET project_name = ? WHERE id = 1";
            PreparedStatement preparedStatement = connection.prepareStatement(updateSQL);
            preparedStatement.setString(1, newProjectName);
            int rowsUpdated = preparedStatement.executeUpdate();
            if (rowsUpdated > 0) {
                logger.info("Project name successfully updated in the database.");
                result = true;
            } else {
                logger.error("Failed to update project name in the database.");
            }
            preparedStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("Error updating project name in the database: " + e.getMessage());
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getProjectNameAsJson() {
        Connection connection = SQLiteConnector.getConnection();
        JSONObject response = new JSONObject();
        try {
            String querySQL = "SELECT project_name FROM project_name_setting WHERE id = 1";
            PreparedStatement preparedStatement = connection.prepareStatement(querySQL);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                String projectName = resultSet.getString("project_name");
                if (projectName != null && !projectName.isEmpty()) {
                    response.put("status", "success");
                    response.put("project_name", projectName);
                    logger.info("Project name fetched from DB: " + projectName);
                } else {
                    response.put("status", "error");
                    response.put("message", "Project name is empty in the database.");
                    logger.warn("Project name in DB is empty.");
                }
            } else {
                response.put("status", "error");
                response.put("message", "Project name not found.");
                logger.warn("No project name found in DB.");
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (SQLException e) {
            response.put("status", "error");
            response.put("message", "Error reading project name from DB: " + e.getMessage());
            logger.error("Error reading project name from DB: " + e);
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return response;
    }

    public JSONObject sortQueryDbOperation(JSONObject json) throws JSONException {
        JSONObject ack_res = new JSONObject();
        if (json.has("operation_type")) {
            String operation_type;
            switch (operation_type = json.getString("operation_type")) {
                case "get_project_name": {
                    ack_res = this.getProjectNameAsJson();
                    ack_res = ack_res.put("operation_type", "get_project_name");
                    break;
                }
                case "update_project_name": {
                    ack_res = this.updateProjectName(json);
                    ack_res = ack_res.put("operation_type", "update_calculation_data");
                    break;
                }
            }
        }
        return ack_res;
    }
}

