/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.passwordSetting;

import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.security.Security;
import com.tas.wp500.sql_lite_db.SQLiteConnector;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PasswordPolicyDbOperation
extends Security {
    private static Logger logger = Logger.getLogger(PasswordPolicyDbOperation.class);
    private static PasswordPolicyDbOperation instance = null;
    private static final int SQLITE_BUSY = 5;
    private static final int RETRY_COUNT = 5;
    private static final int RETRY_DELAY = 10000;

    private PasswordPolicyDbOperation() {
        this.createPasswordPolicyTable();
        this.resetDefaultPasswordPolicy();
    }

    public static PasswordPolicyDbOperation getInstance() {
        if (instance == null) {
            instance = new PasswordPolicyDbOperation();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createPasswordPolicyTable() {
        Connection connection = SQLiteConnector.getConnection();
        try {
            Statement statement = connection.createStatement();
            String sql = "CREATE TABLE IF NOT EXISTS password_policy_details (id INTEGER PRIMARY KEY CHECK (id = 1), ascii_ch_count INTEGER, mixed_ch_count INTEGER, number_count INTEGER, special_ch_count INTEGER, allowed_special_ch TEXT, characters_count INTEGER, password_attempts TEXT, password_blocked_time TEXT, password_blocked_list TEXT, session_timeout TEXT)";
            statement.execute(sql);
            statement.close();
            logger.debug("Password policy table created successfully.");
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.debug("Error while creating Password policy table : " + e);
            FileBasedLogger.error("Application", "Error while creating Password policy table : " + e, "system");
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject insertPasswordPolicy(JSONObject json) {
        JSONObject resultObj = new JSONObject();
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = SQLiteConnector.getConnection();
            try {
                String sql = "INSERT INTO password_policy_details (id, ascii_ch_count, mixed_ch_count, number_count, special_ch_count, allowed_special_ch, characters_count, password_attempts, password_blocked_time, password_blocked_list, session_timeout) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                PreparedStatement preparedStatement = connection.prepareStatement(sql);
                preparedStatement.setInt(1, 1);
                preparedStatement.setString(2, PasswordPolicyDbOperation.encrypt(json.getString("ascii_ch_count")));
                preparedStatement.setString(3, PasswordPolicyDbOperation.encrypt(json.getString("mixed_ch_count")));
                preparedStatement.setString(4, PasswordPolicyDbOperation.encrypt(json.getString("number_count")));
                preparedStatement.setString(5, PasswordPolicyDbOperation.encrypt(json.getString("special_ch_count")));
                preparedStatement.setString(6, PasswordPolicyDbOperation.encrypt(json.getString("allowed_special_ch")));
                preparedStatement.setString(7, PasswordPolicyDbOperation.encrypt(json.getString("characters_count")));
                preparedStatement.setString(8, PasswordPolicyDbOperation.encrypt(json.getString("password_attempts")));
                preparedStatement.setString(9, PasswordPolicyDbOperation.encrypt(json.getString("password_blocked_time")));
                preparedStatement.setString(10, PasswordPolicyDbOperation.encrypt(json.getJSONArray("password_blocked_list").toString()));
                preparedStatement.setString(11, PasswordPolicyDbOperation.encrypt(json.getString("session_timeout")));
                preparedStatement.executeUpdate();
                preparedStatement.close();
                logger.info("Password policy inserted successfully.");
                FileBasedLogger.info("Audit", "Password policy inserted successfully.", json.getString("user"));
                resultObj.put("status", "true");
                resultObj.put("message", "Password policy added successfully.");
                break;
            }
            catch (SQLException | JSONException e) {
                e.printStackTrace();
                if (((SQLException)e).getErrorCode() != 5 || attempt == 4) {
                    e.printStackTrace();
                    logger.error("Error while inserting password policy : " + e);
                    FileBasedLogger.error("Audit", "Error while inserting password policy : " + e, json.getString("user"));
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkIfPolicyExists() {
        Connection connection = SQLiteConnector.getConnection();
        try {
            String sql = "SELECT COUNT(*) as count FROM password_policy_details WHERE id = ?";
            PreparedStatement statement = connection.prepareStatement(sql);
            statement.setInt(1, 1);
            ResultSet resultSet = statement.executeQuery();
            if (resultSet.next()) {
                int count = resultSet.getInt("count");
                boolean bl = count > 0;
                return bl;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("Error while checking if Policy exists : " + e);
            FileBasedLogger.error("Application", "Error while checking if Policy exists : " + e, "system");
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetDefaultPasswordPolicy() {
        for (int attempt = 0; attempt < 5; ++attempt) {
            if (this.checkIfPolicyExists()) continue;
            Connection connection = SQLiteConnector.getConnection();
            try {
                String ascii_ch_count = "4";
                String mixed_ch_count = "1";
                String number_count = "2";
                String special_ch_count = "1";
                String allowed_special_ch = "!@#$%^&*()_+[]{}|;:',.<>?";
                String characters_count = "8";
                String password_blocked_time = "5";
                String password_attempts = "2";
                String session_timeout = "60";
                String[] blockedPasswords = new String[]{"password123", "12345678", "password", "1234567890", "admin@123", "root"};
                JSONArray passwordBlockListArray = new JSONArray(blockedPasswords);
                String passwordBlockedList = passwordBlockListArray.toString();
                String sql = "INSERT INTO password_policy_details (id, ascii_ch_count, mixed_ch_count, number_count, special_ch_count, allowed_special_ch, characters_count,password_attempts, password_blocked_time,password_blocked_list,session_timeout) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?,? ,?)";
                PreparedStatement preparedStatement = connection.prepareStatement(sql);
                preparedStatement.setInt(1, 1);
                preparedStatement.setString(2, PasswordPolicyDbOperation.encrypt(ascii_ch_count));
                preparedStatement.setString(3, PasswordPolicyDbOperation.encrypt(mixed_ch_count));
                preparedStatement.setString(4, PasswordPolicyDbOperation.encrypt(number_count));
                preparedStatement.setString(5, PasswordPolicyDbOperation.encrypt(special_ch_count));
                preparedStatement.setString(6, PasswordPolicyDbOperation.encrypt(allowed_special_ch));
                preparedStatement.setString(7, PasswordPolicyDbOperation.encrypt(characters_count));
                preparedStatement.setString(8, PasswordPolicyDbOperation.encrypt(password_attempts));
                preparedStatement.setString(9, PasswordPolicyDbOperation.encrypt(password_blocked_time));
                preparedStatement.setString(10, PasswordPolicyDbOperation.encrypt(passwordBlockedList));
                preparedStatement.setString(11, PasswordPolicyDbOperation.encrypt(session_timeout));
                preparedStatement.executeUpdate();
                preparedStatement.close();
                logger.info("Default password policy reset successfully.");
                FileBasedLogger.info("Application", "Default password policy reset successfully.", "system");
                break;
            }
            catch (SQLException | JSONException e) {
                e.printStackTrace();
                if (((SQLException)e).getErrorCode() != 5 || attempt == 4) {
                    e.printStackTrace();
                    logger.error("Error while resetting default password policy : " + e);
                    FileBasedLogger.error("Application", "Error while resetting default password policy : " + e, "system");
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject resetDefaultPasswordPolicy1(String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = SQLiteConnector.getConnection();
            try {
                String ascii_ch_count = "4";
                String mixed_ch_count = "1";
                String number_count = "2";
                String special_ch_count = "1";
                String allowed_special_ch = "!@#$%^&*()_+[]{}|;:',.<>?";
                String characters_count = "8";
                String password_blocked_time = "5";
                String password_attempts = "2";
                String[] blockedPasswords = new String[]{"password123", "12345678", "password", "1234567890", "admin@123", "root"};
                String session_timeout = "60";
                JSONArray passwordBlockListArray = new JSONArray(blockedPasswords);
                String passwordBlockedList = passwordBlockListArray.toString();
                String sql = "UPDATE password_policy_details SET ascii_ch_count=?, mixed_ch_count=?, number_count=?, special_ch_count=?, allowed_special_ch=?, characters_count=?,password_attempts=?,password_blocked_time=?, password_blocked_list=? , session_timeout=? WHERE id=1";
                PreparedStatement preparedStatement = connection.prepareStatement(sql);
                preparedStatement.setString(1, PasswordPolicyDbOperation.encrypt(ascii_ch_count));
                preparedStatement.setString(2, PasswordPolicyDbOperation.encrypt(mixed_ch_count));
                preparedStatement.setString(3, PasswordPolicyDbOperation.encrypt(number_count));
                preparedStatement.setString(4, PasswordPolicyDbOperation.encrypt(special_ch_count));
                preparedStatement.setString(5, PasswordPolicyDbOperation.encrypt(allowed_special_ch));
                preparedStatement.setString(6, PasswordPolicyDbOperation.encrypt(characters_count));
                preparedStatement.setString(7, PasswordPolicyDbOperation.encrypt(password_attempts));
                preparedStatement.setString(8, PasswordPolicyDbOperation.encrypt(password_blocked_time));
                preparedStatement.setString(9, PasswordPolicyDbOperation.encrypt(passwordBlockedList));
                preparedStatement.setString(10, PasswordPolicyDbOperation.encrypt(session_timeout));
                preparedStatement.executeUpdate();
                preparedStatement.close();
                logger.info("Default password policy updated successfully.");
                FileBasedLogger.info("Audit", "Default password policy updated successfully.", user);
                resultObj.put("message", "Default password policy updated successfully.");
                resultObj.put("status", "success");
                break;
            }
            catch (SQLException | JSONException e) {
                e.printStackTrace();
                if (((SQLException)e).getErrorCode() != 5 || attempt == 4) {
                    e.printStackTrace();
                    logger.error("Error occurred while updating default password policy : " + e);
                    FileBasedLogger.error("Audit", "Error occurred while updating default password policy : " + e, user);
                    resultObj.put("message", "Error while updating default password policy.");
                    resultObj.put("status", "error");
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject updatePasswordPolicy(JSONObject json, String user) {
        JSONObject resultObj = new JSONObject();
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = SQLiteConnector.getConnection();
            try {
                String sql = "UPDATE password_policy_details SET ascii_ch_count=?, mixed_ch_count=?, number_count=?, special_ch_count=?, allowed_special_ch=?, characters_count=?, password_attempts=?, password_blocked_time=?, password_blocked_list=?, session_timeout=? WHERE id=1";
                PreparedStatement preparedStatement = connection.prepareStatement(sql);
                preparedStatement.setString(1, PasswordPolicyDbOperation.encrypt(json.getString("ascii_ch_count")));
                preparedStatement.setString(2, PasswordPolicyDbOperation.encrypt(json.getString("mixed_ch_count")));
                preparedStatement.setString(3, PasswordPolicyDbOperation.encrypt(json.getString("number_count")));
                preparedStatement.setString(4, PasswordPolicyDbOperation.encrypt(json.getString("special_ch_count")));
                preparedStatement.setString(5, PasswordPolicyDbOperation.encrypt(json.getString("allowed_special_ch")));
                preparedStatement.setString(6, PasswordPolicyDbOperation.encrypt(json.getString("characters_count")));
                preparedStatement.setString(7, PasswordPolicyDbOperation.encrypt(json.getString("password_attempts")));
                preparedStatement.setString(8, PasswordPolicyDbOperation.encrypt(json.getString("password_blocked_time")));
                preparedStatement.setString(9, PasswordPolicyDbOperation.encrypt(json.getJSONArray("password_blocked_list").toString()));
                preparedStatement.setString(10, PasswordPolicyDbOperation.encrypt(json.getString("session_timeout")));
                preparedStatement.executeUpdate();
                logger.info("Password policy updated successfully.");
                FileBasedLogger.info("Audit", "Password policy updated successfully.", user);
                resultObj.put("status", "success");
                resultObj.put("message", "Password policy updated successfully.");
                break;
            }
            catch (SQLException | JSONException e) {
                e.printStackTrace();
                if (((SQLException)e).getErrorCode() != 5 || attempt == 4) {
                    e.printStackTrace();
                    logger.error("Error occurred while updating password policy : " + e);
                    FileBasedLogger.error("Audit", "Error occurred while updating password policy : " + e, user);
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getPasswordPolicy(String user) {
        JSONObject resultObj = new JSONObject();
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = SQLiteConnector.getConnection();
            try {
                String sql = "SELECT * FROM password_policy_details WHERE id = 1";
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery(sql);
                if (resultSet.next()) {
                    resultObj.put("id", resultSet.getInt("id"));
                    resultObj.put("ascii_ch_count", PasswordPolicyDbOperation.decrypt(resultSet.getString("ascii_ch_count")));
                    resultObj.put("mixed_ch_count", PasswordPolicyDbOperation.decrypt(resultSet.getString("mixed_ch_count")));
                    resultObj.put("number_count", PasswordPolicyDbOperation.decrypt(resultSet.getString("number_count")));
                    resultObj.put("special_ch_count", PasswordPolicyDbOperation.decrypt(resultSet.getString("special_ch_count")));
                    resultObj.put("allowed_special_ch", PasswordPolicyDbOperation.decrypt(resultSet.getString("allowed_special_ch")));
                    resultObj.put("characters_count", PasswordPolicyDbOperation.decrypt(resultSet.getString("characters_count")));
                    resultObj.put("characters_count", PasswordPolicyDbOperation.decrypt(resultSet.getString("password_attempts")));
                    resultObj.put("password_blocked_time", PasswordPolicyDbOperation.decrypt(resultSet.getString("password_blocked_time")));
                    resultObj.put("session_timeout", PasswordPolicyDbOperation.decrypt(resultSet.getString("session_timeout")));
                    resultObj.put("password_attempts", PasswordPolicyDbOperation.decrypt(resultSet.getString("password_attempts")));
                    String passwordBlockedListString = PasswordPolicyDbOperation.decrypt(resultSet.getString("password_blocked_list"));
                    JSONArray passwordBlockedList = new JSONArray(passwordBlockedListString);
                    resultObj.put("password_blocked_list", passwordBlockedList);
                }
                resultSet.close();
                statement.close();
                break;
            }
            catch (SQLException | JSONException e) {
                e.printStackTrace();
                if (((SQLException)e).getErrorCode() != 5 || attempt == 4) {
                    e.printStackTrace();
                    FileBasedLogger.error("Application", "Error occurred while retrieving password policy : " + e, user);
                    logger.error("Error occurred while retrieving password policy : " + e);
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getPasswordPolicyJson(String user) {
        JSONObject resultObj = new JSONObject();
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = SQLiteConnector.getConnection();
            try {
                String sql = "SELECT * FROM password_policy_details WHERE id = 1";
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery(sql);
                if (resultSet.next()) {
                    resultObj.put("id", resultSet.getInt("id"));
                    resultObj.put("ascii_ch_count", Integer.parseInt(PasswordPolicyDbOperation.decrypt(resultSet.getString("ascii_ch_count"))));
                    resultObj.put("mixed_ch_count", Integer.parseInt(PasswordPolicyDbOperation.decrypt(resultSet.getString("mixed_ch_count"))));
                    resultObj.put("number_count", Integer.parseInt(PasswordPolicyDbOperation.decrypt(resultSet.getString("number_count"))));
                    resultObj.put("special_ch_count", Integer.parseInt(PasswordPolicyDbOperation.decrypt(resultSet.getString("special_ch_count"))));
                    resultObj.put("allowed_special_ch", PasswordPolicyDbOperation.decrypt(resultSet.getString("allowed_special_ch")));
                    resultObj.put("characters_count", Integer.parseInt(PasswordPolicyDbOperation.decrypt(resultSet.getString("characters_count"))));
                    resultObj.put("password_blocked_time", Integer.parseInt(PasswordPolicyDbOperation.decrypt(resultSet.getString("password_blocked_time"))));
                    String passwordBlockedListString = PasswordPolicyDbOperation.decrypt(resultSet.getString("password_blocked_list"));
                    JSONArray passwordBlockedList = new JSONArray(passwordBlockedListString);
                    resultObj.put("password_blocked_list", passwordBlockedList);
                }
                resultSet.close();
                statement.close();
                break;
            }
            catch (SQLException | JSONException e) {
                e.printStackTrace();
                if (((SQLException)e).getErrorCode() != 5 || attempt == 4) {
                    e.printStackTrace();
                    FileBasedLogger.error("Application", "Error occurred while retrieving password policy : " + e, user);
                    logger.error("Error occurred while retrieving password policy : " + e);
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject deletePasswordPolicy(String user) throws JSONException {
        Connection connection = SQLiteConnector.getConnection();
        JSONObject resultObj = new JSONObject();
        try {
            String sql = "DELETE FROM password_policy_details WHERE id = ?";
            PreparedStatement preparedStatement = connection.prepareStatement(sql);
            preparedStatement.setInt(1, 1);
            int rowsDeleted = preparedStatement.executeUpdate();
            if (rowsDeleted > 0) {
                resultObj.put("status", "success");
                resultObj.put("message", "Password policy deleted successfully.");
                logger.info(user + " - Deleted Password policy successfully.");
            } else {
                resultObj.put("status", "error");
                resultObj.put("message", "No password policy found with id=1.");
                logger.info(user + " - Not found password policy with id=1.");
            }
            preparedStatement.close();
        }
        catch (SQLException | JSONException e) {
            e.printStackTrace();
            logger.error("Error occurred while deleting password policy : " + e);
            resultObj.put("status", "error");
            resultObj.put("message", "Error while deleting password policy.");
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getPasswordPolicyInfo(String user) {
        JSONObject resultObj = new JSONObject();
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = SQLiteConnector.getConnection();
            try {
                String sql = "SELECT * FROM password_policy_details WHERE id = 1";
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery(sql);
                if (resultSet.next()) {
                    resultObj.put("ascii_ch_count", PasswordPolicyDbOperation.decrypt(resultSet.getString("ascii_ch_count")));
                    resultObj.put("mixed_ch_count", PasswordPolicyDbOperation.decrypt(resultSet.getString("mixed_ch_count")));
                    resultObj.put("number_count", PasswordPolicyDbOperation.decrypt(resultSet.getString("number_count")));
                    resultObj.put("special_ch_count", PasswordPolicyDbOperation.decrypt(resultSet.getString("special_ch_count")));
                    resultObj.put("allowed_special_ch", PasswordPolicyDbOperation.decrypt(resultSet.getString("allowed_special_ch")));
                    resultObj.put("characters_count", PasswordPolicyDbOperation.decrypt(resultSet.getString("characters_count")));
                }
                resultSet.close();
                statement.close();
                break;
            }
            catch (SQLException | JSONException e) {
                e.printStackTrace();
                if (((SQLException)e).getErrorCode() != 5 || attempt == 4) {
                    e.printStackTrace();
                    FileBasedLogger.error("Application", "Error occurred while retrieving password policy : " + e, user);
                    logger.error("Error occurred while retrieving password policy : " + e);
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
        return resultObj;
    }

    public String getPasswordBlockedTime(Connection connection) {
        String passwordBlockedTime = "";
        try {
            String sql = "SELECT password_blocked_time FROM password_policy_details WHERE id = 1";
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(sql);
            if (resultSet.next()) {
                passwordBlockedTime = PasswordPolicyDbOperation.decrypt(resultSet.getString("password_blocked_time"));
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            FileBasedLogger.error("Application", "Error occurred while retrieving password blocked time: " + e, "system");
            logger.error("Error occurred while retrieving password blocked time: " + e);
        }
        return passwordBlockedTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSessionTimeout(Connection connection, String user) {
        String sessionTimeout = "";
        try {
            String sql = "SELECT session_timeout FROM password_policy_details WHERE id = 1";
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(sql);
            if (resultSet.next()) {
                sessionTimeout = PasswordPolicyDbOperation.decrypt(resultSet.getString("session_timeout"));
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException e) {
            sessionTimeout = "60";
            e.printStackTrace();
            logger.error("Error occurred while retrieving allowed password attempts: " + e);
            FileBasedLogger.error("Audit", "Error occurred while retrieving session_timeout : " + e.getMessage(), user);
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return sessionTimeout;
    }

    public int getAllowedPasswordAttempts(Connection connection) {
        int allowedAttempts = 0;
        try {
            String sql = "SELECT password_attempts FROM password_policy_details WHERE id = 1";
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(sql);
            if (resultSet.next()) {
                allowedAttempts = Integer.parseInt(PasswordPolicyDbOperation.decrypt(resultSet.getString("password_attempts")));
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            FileBasedLogger.error("Application", "Error occurred while retrieving allowed password attempts: " + e, "system");
            logger.error("Error occurred while retrieving allowed password attempts: " + e);
        }
        return allowedAttempts;
    }

    public JSONObject sortQueryUsingPasswordPolicy(JSONObject json, String user, String userRole) throws JSONException {
        JSONObject ack_res = new JSONObject();
        if (json.has("operation_type")) {
            String operation_type;
            switch (operation_type = json.getString("operation_type")) {
                case "reset_password": {
                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("engineer")) {
                        ack_res = this.resetDefaultPasswordPolicy1(user);
                        break;
                    }
                    ack_res.put("status", "fail");
                    ack_res.put("msg", " Access denied. Only Administrators and engineer can perform operation.");
                    break;
                }
                case "update_password": {
                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("engineer")) {
                        ack_res = this.updatePasswordPolicy(json, user);
                        break;
                    }
                    ack_res.put("status", "fail");
                    ack_res.put("msg", " Access denied. Only Administrators and engineer can perform operation.");
                    break;
                }
                case "delete_password": {
                    if (userRole.equalsIgnoreCase("admin")) {
                        ack_res = this.deletePasswordPolicy(user);
                        break;
                    }
                    ack_res.put("status", "fail");
                    ack_res.put("msg", " Access denied. Only Administrators can perform operation.");
                    break;
                }
                case "get_password": {
                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                        ack_res = this.getPasswordPolicy(user);
                        break;
                    }
                    ack_res.put("status", "fail");
                    ack_res.put("msg", " Access denied. Only Administrators and operator and engineer can perform operation.");
                    break;
                }
                case "get_password_json": {
                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                        ack_res = this.getPasswordPolicyJson(user);
                        break;
                    }
                    ack_res.put("status", "fail");
                    ack_res.put("msg", " Access denied. Only Administrators and operator and engineer can perform operation.");
                    break;
                }
                case "get_password_info": {
                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                        ack_res = this.getPasswordPolicyInfo(user);
                        break;
                    }
                    ack_res.put("status", "fail");
                    ack_res.put("msg", " Access denied. Only Administrators and operator and engineer can perform operation.");
                    break;
                }
            }
        }
        return ack_res;
    }
}

