/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.passwordSetting;

import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.passwordSetting.PasswordPolicyDbOperation;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PasswordPolicyChecker {
    private static Logger logger = Logger.getLogger(PasswordPolicyChecker.class);

    public static boolean checkASCIICharacter(String password, int asciiChCount) {
        String asciiPattern = "^[\\x00-\\x7F]+$";
        return Pattern.matches(asciiPattern, password) && password.length() >= asciiChCount;
    }

    public static boolean checkMixedCharacters(String password, int mixedChCount) {
        int uppercaseCount = 0;
        int lowercaseCount = 0;
        for (char ch : password.toCharArray()) {
            if (Character.isUpperCase(ch)) {
                ++uppercaseCount;
                continue;
            }
            if (!Character.isLowerCase(ch)) continue;
            ++lowercaseCount;
        }
        return uppercaseCount >= mixedChCount && lowercaseCount >= mixedChCount;
    }

    public static boolean checkNumberCount(String password, int requiredCount) {
        int numberCount = 0;
        for (char ch : password.toCharArray()) {
            if (!Character.isDigit(ch) || ++numberCount < requiredCount) continue;
            return true;
        }
        return false;
    }

    public static boolean specialCharactersCount(String password, int requiredCount, String allowedSpecialChars) {
        int specialCharCount = 0;
        for (char ch : password.toCharArray()) {
            if (!allowedSpecialChars.contains(String.valueOf(ch)) || ++specialCharCount < requiredCount) continue;
            return true;
        }
        return false;
    }

    public static boolean characterCount(String password, int minLength) {
        String regex = "^(?=.*[a-z])(?=.*[A-Z])(?=.*\\d)(?=.*[@$!%*?&])[A-Za-z\\d@$!%*?&]{8,}$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(password);
        return password.length() >= minLength;
    }

    public static boolean isPasswordBlocked(String password, JSONArray passwordBlockedList) {
        for (int i = 0; i < passwordBlockedList.length(); ++i) {
            String blockedPassword = null;
            try {
                blockedPassword = passwordBlockedList.getString(i);
                if (!blockedPassword.equals(password)) continue;
                return true;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static JSONObject passwordPolicyCheck(String password, String user) {
        JSONObject resultObj = new JSONObject();
        try {
            JSONObject passwordPolicyData = PasswordPolicyDbOperation.getInstance().getPasswordPolicyJson(user);
            boolean isAsciiValid = PasswordPolicyChecker.checkASCIICharacter(password, passwordPolicyData.getInt("ascii_ch_count"));
            boolean isMixedValid = PasswordPolicyChecker.checkMixedCharacters(password, passwordPolicyData.getInt("mixed_ch_count"));
            boolean isNumberValid = PasswordPolicyChecker.checkNumberCount(password, passwordPolicyData.getInt("number_count"));
            boolean isSpecialValid = PasswordPolicyChecker.specialCharactersCount(password, passwordPolicyData.getInt("special_ch_count"), passwordPolicyData.getString("allowed_special_ch"));
            boolean isCharacterValid = PasswordPolicyChecker.characterCount(password, passwordPolicyData.getInt("characters_count"));
            boolean isBlocked = PasswordPolicyChecker.isPasswordBlocked(password, passwordPolicyData.getJSONArray("password_blocked_list"));
            if (isBlocked) {
                resultObj.put("status", "fail");
                resultObj.put("msg", "This password is already blocked, please enter a valid password.");
                FileBasedLogger.error("Audit", "This password is already blocked.", user);
            } else if (isAsciiValid && isMixedValid && isNumberValid && isSpecialValid && isCharacterValid) {
                resultObj.put("status", "success");
                resultObj.put("msg", "Password meets all requirements. You can Proceed.");
                FileBasedLogger.info("Audit", "Password meets all requirements according password policy.", user);
            } else {
                resultObj.put("status", "fail");
                resultObj.put("msg", "Password does not match with password policy. Please check again.");
                FileBasedLogger.error("Audit", "Password does not meet the password policy requirements.", user);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while checking password policy : " + e.getMessage());
            FileBasedLogger.error("Audit", "Error while checking password policy: " + e.getMessage(), user);
        }
        return resultObj;
    }
}

