/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.passwordSetting;

import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.passwordSetting.PasswordPolicyDbOperation;
import com.tas.wp500.sql_lite_db.SQLiteConnector;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class PasswordAttemptsManger {
    private static Logger logger = Logger.getLogger(PasswordAttemptsManger.class);
    private static PasswordAttemptsManger instance = null;
    private PasswordPolicyDbOperation passwordPolicyDbOperation = PasswordPolicyDbOperation.getInstance();

    private PasswordAttemptsManger() {
        this.createLoginAttemptsTable();
    }

    public static PasswordAttemptsManger getInstance() {
        if (instance == null) {
            instance = new PasswordAttemptsManger();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createLoginAttemptsTable() {
        Connection connection = SQLiteConnector.getConnection();
        try {
            Statement statement = connection.createStatement();
            String sql = "CREATE TABLE IF NOT EXISTS login_attempts (username TEXT PRIMARY KEY, failed_attempts INTEGER DEFAULT 0, lock_time TIMESTAMP)";
            statement.execute(sql);
            statement.close();
            logger.debug("Login attempts table created successfully.");
        }
        catch (SQLException e) {
            e.printStackTrace();
            FileBasedLogger.error("Application", "Login attempts table created successfully.", "system");
            logger.debug("Error while creating login attempts table : " + e);
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementFailedAttempts(Connection connection, String username) {
        try {
            int allowedAttempts = this.passwordPolicyDbOperation.getAllowedPasswordAttempts(connection);
            int failedAttempts = this.getFailedAttempts(connection, username);
            if (failedAttempts >= allowedAttempts) {
                logger.info("User has exceeded allowed password attempts. Locking the account : " + username);
                FileBasedLogger.info("Audit", "User has exceeded allowed password attempts. Locking the account : " + username, username);
                this.lockUser(connection, username);
            } else {
                this.updateFailedAttempts(connection, username, failedAttempts + 1);
                logger.info("Incremented failed login attempts for user: " + (failedAttempts + 1) + "  Current attempts: " + allowedAttempts);
                FileBasedLogger.info("Audit", "Incremented failed login attempts for user: " + (failedAttempts + 1) + "  Current attempts: " + allowedAttempts, username);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("Error while incrementing failed attempts", e);
            FileBasedLogger.info("Audit", "Error while incrementing failed attempts" + e.getLocalizedMessage(), username);
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
    }

    public boolean isUserLocked(Connection connection, String username) {
        try {
            Timestamp lockTime = this.getLockTime(connection, username);
            return lockTime != null && lockTime.after(new Timestamp(System.currentTimeMillis()));
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new RuntimeException("Error while checking if user is locked or not.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetFailedAttempts(Connection connection, String username) {
        try {
            if (this.isUsernamePresent(connection, username)) {
                this.updateFailedAttemptsAndUnlockUser(connection, username);
            } else {
                logger.debug("Username not found: " + username);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while resetting failed attempts", e);
            FileBasedLogger.error("Audit", "Error while resetting failed attempts : " + e.getLocalizedMessage(), username);
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean isUsernamePresent(Connection connection, String username) {
        String sql = "SELECT 1 FROM login_attempts WHERE username = ?";
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            boolean bl;
            block14: {
                statement.setString(1, username);
                ResultSet resultSet = statement.executeQuery();
                try {
                    bl = resultSet.next();
                    if (resultSet == null) break block14;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("Error while checking if username is present", e);
            FileBasedLogger.error("Application", "Error while checking if username is present : " + e, "system");
            return false;
        }
    }

    private void updateFailedAttemptsAndUnlockUser(Connection connection, String username) {
        String sql = "INSERT INTO login_attempts (username, failed_attempts, lock_time) VALUES (?, 0, NULL) ON CONFLICT(username) DO UPDATE SET failed_attempts = 1, lock_time = NULL";
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setString(1, username);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("Error while updating failed attempts and unlocking user", e);
            FileBasedLogger.error("Audit", "Error while updating failed attempts and unlocking user" + e, "system");
        }
    }

    private int getFailedAttempts(Connection connection, String username) throws SQLException {
        String sql = "SELECT failed_attempts FROM login_attempts WHERE username = ?";
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            int n;
            block16: {
                ResultSet resultSet;
                block14: {
                    int n2;
                    block15: {
                        statement.setString(1, username);
                        resultSet = statement.executeQuery();
                        try {
                            if (!resultSet.next()) break block14;
                            n2 = resultSet.getInt("failed_attempts");
                            if (resultSet == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    return n2;
                }
                n = 1;
                if (resultSet == null) break block16;
                resultSet.close();
            }
            return n;
        }
    }

    private void updateFailedAttempts(Connection connection, String username, int failedAttempts) throws SQLException {
        String sql = "INSERT INTO login_attempts (username, failed_attempts) VALUES (?, ?) ON CONFLICT(username) DO UPDATE SET failed_attempts = ?";
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setString(1, username);
            statement.setInt(2, failedAttempts);
            statement.setInt(3, failedAttempts);
            statement.executeUpdate();
        }
    }

    private Timestamp getLockTime(Connection connection, String username) throws SQLException {
        String sql = "SELECT lock_time FROM login_attempts WHERE username = ?";
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            Timestamp timestamp;
            block16: {
                ResultSet resultSet;
                block14: {
                    Timestamp timestamp2;
                    block15: {
                        statement.setString(1, username);
                        resultSet = statement.executeQuery();
                        try {
                            if (!resultSet.next()) break block14;
                            timestamp2 = resultSet.getTimestamp("lock_time");
                            if (resultSet == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    return timestamp2;
                }
                timestamp = null;
                if (resultSet == null) break block16;
                resultSet.close();
            }
            return timestamp;
        }
    }

    private void lockUser1(Connection connection, String username) throws SQLException {
        String passwordBlockedTimeStr = this.passwordPolicyDbOperation.getPasswordBlockedTime(connection);
        long passwordBlockedTimeMillis = 0L;
        try {
            passwordBlockedTimeMillis = Long.parseLong(passwordBlockedTimeStr) * 60L * 1000L;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            logger.error("Error occurred while parsing password blocked time: " + e);
        }
        if (passwordBlockedTimeMillis > 0L) {
            Timestamp lockTime = new Timestamp(System.currentTimeMillis() + passwordBlockedTimeMillis);
            String sql = "UPDATE login_attempts SET lock_time = ? WHERE username = ?";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setTimestamp(1, lockTime);
                statement.setString(2, username);
                statement.executeUpdate();
            }
        }
    }

    private void lockUser(Connection connection, String username) {
        String passwordBlockedTimeStr = null;
        long passwordBlockedTimeMillis = 0L;
        try {
            passwordBlockedTimeStr = this.passwordPolicyDbOperation.getPasswordBlockedTime(connection);
            passwordBlockedTimeMillis = Long.parseLong(passwordBlockedTimeStr) * 60L * 1000L;
        }
        catch (NumberFormatException e) {
            logger.debug("Invalid format for password blocked time: " + passwordBlockedTimeStr + e.getLocalizedMessage());
        }
        if (passwordBlockedTimeMillis > 0L) {
            Timestamp lockTime = new Timestamp(System.currentTimeMillis() + passwordBlockedTimeMillis);
            String sql = "UPDATE login_attempts SET lock_time = ? WHERE username = ?";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setTimestamp(1, lockTime);
                statement.setString(2, username);
                statement.executeUpdate();
                logger.info("User has been locked until :" + lockTime);
                FileBasedLogger.info("Audit", "User has been locked until :" + lockTime, username);
            }
            catch (SQLException e) {
                FileBasedLogger.error("Audit", "Error while locking user : " + e.getLocalizedMessage(), username);
                logger.debug("Error updating lock time for user :" + username + e.getMessage());
            }
        } else {
            logger.debug("Password blocked time is not set or invalid :");
        }
    }

    public void unlockUser(Connection connection, String username) throws SQLException {
        String sql = "UPDATE login_attempts SET lock_time = NULL, failed_attempts = 1 WHERE username = ?";
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setString(1, username);
            statement.executeUpdate();
        }
    }

    /*
     * Exception decompiling
     */
    public long unlockUserIfNeeded(Connection connection, String username) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

