/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.opc_ua_server;

import org.eclipse.milo.opcua.sdk.server.api.methods.AbstractMethodInvocationHandler;
import org.eclipse.milo.opcua.sdk.server.nodes.UaMethodNode;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.structured.Argument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqrtMethod
extends AbstractMethodInvocationHandler {
    public static final Argument X = new Argument("x", Identifiers.Double, -1, null, new LocalizedText("The argument to the square root function."));
    public static final Argument X_SQRT = new Argument("x_sqrt", Identifiers.Double, -1, null, new LocalizedText("The square root of the input argument."));
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public SqrtMethod(UaMethodNode node) {
        super(node);
    }

    @Override
    public Argument[] getInputArguments() {
        return new Argument[]{X};
    }

    @Override
    public Argument[] getOutputArguments() {
        return new Argument[]{X_SQRT};
    }

    @Override
    protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext invocationContext, Variant[] inputValues) {
        this.logger.debug("Invoking sqrt() method of objectId={}", (Object)invocationContext.getObjectId());
        double x = (Double)inputValues[0].getValue();
        double xSqrt = Math.sqrt(x);
        return new Variant[]{new Variant(xSqrt)};
    }
}

